/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.FilterType;
import org.jetbrains.letsPlot.util.pngj.IImageLine;
import org.jetbrains.letsPlot.util.pngj.IImageLineSet;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.ImageLineInt;
import org.jetbrains.letsPlot.util.pngj.OutputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjOutputException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkCopyBehaviour;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkPredicate;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunksList;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunksListForWrite;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkIEND;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkIHDR;
import org.jetbrains.letsPlot.util.pngj.chunks.PngMetadata;
import org.jetbrains.letsPlot.util.pngj.pixels.PixelsWriter;
import org.jetbrains.letsPlot.util.pngj.pixels.PixelsWriterDefault;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010 \u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\"\u001a\u00020\u000eH\u0007J\u001c\u0010 \u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\n2\b\u0010#\u001a\u0004\u0018\u00010\fH\u0002J\u0006\u0010$\u001a\u00020\u001dJ\u0006\u0010%\u001a\u00020\bJ\u0006\u0010&\u001a\u00020\u0014J\b\u0010'\u001a\u00020\u001dH\u0002J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020\u001dH\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u000eH\u0002J\u000e\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001bJ\u000e\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u00104\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u00105\u001a\u00020\u001dH\u0002J\b\u00106\u001a\u00020\u001dH\u0002J\b\u00107\u001a\u00020\u001dH\u0002J\u000e\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020:J\u0016\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000eJ\u0010\u0010<\u001a\u00020\u001d2\b\u0010=\u001a\u0004\u0018\u00010>J\u0016\u0010?\u001a\u00020\u001d2\u000e\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0AJ\b\u0010B\u001a\u00020\u001dH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/PngWriter;", "", "outputStream", "Lorg/jetbrains/letsPlot/util/pngj/OutputPngStream;", "imgInfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/OutputPngStream;Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "chunksList", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksListForWrite;", "copyFromList", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksList;", "copyFromPredicate", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkPredicate;", "currentChunkGroup", "", "currentpass", "idatMaxSize", "getImgInfo", "()Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "metadata", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngMetadata;", "os", "passes", "pixelsWriter", "Lorg/jetbrains/letsPlot/util/pngj/pixels/PixelsWriter;", "rowNum", "shouldCloseStream", "", "close", "", "computeCompressionRatio", "", "copyChunksFrom", "chunks", "copyMask", "predicate", "end", "getChunksList", "getMetadata", "initIdat", "queueChunk", "chunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk;", "queueChunksFromOther", "setCompLevel", "complevel", "setFilterPreserve", "filterPreserve", "setFilterType", "filterType", "Lorg/jetbrains/letsPlot/util/pngj/FilterType;", "setIdatMaxSize", "setShouldCloseStream", "writeEndChunk", "writeFirstChunks", "writeLastChunks", "writeRow", "imgline", "Lorg/jetbrains/letsPlot/util/pngj/IImageLine;", "rownumber", "writeRowInt", "buf", "", "writeRows", "imglines", "Lorg/jetbrains/letsPlot/util/pngj/IImageLineSet;", "writeSignatureAndIHDR", "plot-api"})
public class PngWriter {
    @NotNull
    private final ImageInfo imgInfo;
    private int rowNum;
    @NotNull
    private final ChunksListForWrite chunksList;
    @NotNull
    private final PngMetadata metadata;
    private int currentChunkGroup;
    private final int passes;
    private int currentpass;
    private boolean shouldCloseStream;
    private int idatMaxSize;
    @NotNull
    private PixelsWriter pixelsWriter;
    @NotNull
    private final OutputPngStream os;
    @Nullable
    private ChunkPredicate copyFromPredicate;
    @Nullable
    private ChunksList copyFromList;

    public PngWriter(@NotNull OutputPngStream outputStream, @NotNull ImageInfo imgInfo) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)imgInfo, (String)"imgInfo");
        this.rowNum = -1;
        this.currentChunkGroup = -1;
        this.passes = 1;
        this.shouldCloseStream = true;
        this.os = outputStream;
        this.imgInfo = imgInfo;
        this.chunksList = new ChunksListForWrite(imgInfo);
        this.metadata = new PngMetadata(this.chunksList);
        this.pixelsWriter = new PixelsWriterDefault(imgInfo);
        this.setCompLevel(9);
    }

    @NotNull
    public final ImageInfo getImgInfo() {
        return this.imgInfo;
    }

    private final void initIdat() {
        this.pixelsWriter.setOs(this.os);
        this.pixelsWriter.setIdatMaxSize(this.idatMaxSize);
        this.writeSignatureAndIHDR();
        this.writeFirstChunks();
    }

    private final void writeEndChunk() {
        this.currentChunkGroup = 6;
        PngChunkIEND c = new PngChunkIEND(this.imgInfo);
        c.createRawChunk().writeChunk(this.os);
        this.chunksList.getChunks().add(c);
    }

    private final void writeFirstChunks() {
        if (this.currentChunkGroup >= 4) {
            return;
        }
        this.currentChunkGroup = 1;
        this.queueChunksFromOther();
        this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 2;
        int nw = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        if (nw > 0 && this.imgInfo.getGreyscale()) {
            throw new PngjOutputException("cannot write palette for this format");
        }
        if (nw == 0 && this.imgInfo.getIndexed()) {
            throw new PngjOutputException("missing palette");
        }
        this.currentChunkGroup = 3;
        this.chunksList.writeChunks(this.os, this.currentChunkGroup);
    }

    private final void writeLastChunks() {
        this.currentChunkGroup = 5;
        this.queueChunksFromOther();
        this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        List<PngChunk> pending = this.chunksList.getQueuedChunks();
        if (!((Collection)pending).isEmpty()) {
            throw new PngjOutputException(pending.size() + " chunks were not written! Eg: " + pending.get(0));
        }
    }

    private final void writeSignatureAndIHDR() {
        PngHelperInternal.INSTANCE.writeBytes(this.os, PngHelperInternal.INSTANCE.getPngIdSignature());
        this.currentChunkGroup = 0;
        PngChunkIHDR ihdr = new PngChunkIHDR(this.imgInfo);
        ihdr.createRawChunk().writeChunk(this.os);
        this.chunksList.getChunks().add(ihdr);
    }

    private final void queueChunksFromOther() {
        if (this.copyFromList == null || this.copyFromPredicate == null) {
            return;
        }
        boolean idatDone = this.currentChunkGroup >= 4;
        ChunksList chunksList = this.copyFromList;
        Intrinsics.checkNotNull((Object)chunksList);
        for (PngChunk chunk : chunksList.getChunks()) {
            int groupOri;
            ChunkRaw chunkRaw = chunk.getRaw();
            Intrinsics.checkNotNull((Object)chunkRaw);
            if (chunkRaw.getData() == null || (groupOri = chunk.getChunkGroup()) <= 4 && idatDone || groupOri >= 4 && !idatDone || chunk.getCrit() && !Intrinsics.areEqual((Object)chunk.getId(), (Object)"PLTE")) continue;
            ChunkPredicate chunkPredicate = this.copyFromPredicate;
            Intrinsics.checkNotNull((Object)chunkPredicate);
            boolean copy = chunkPredicate.match(chunk);
            if (!copy || !this.chunksList.getEquivalent(chunk).isEmpty() || !this.chunksList.getQueuedEquivalent(chunk).isEmpty()) continue;
            this.chunksList.queue(chunk);
        }
    }

    public final void queueChunk(@NotNull PngChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        for (PngChunk other : this.chunksList.getQueuedEquivalent(chunk)) {
            this.getChunksList().removeChunk(other);
        }
        this.chunksList.queue(chunk);
    }

    @JvmOverloads
    public final void copyChunksFrom(@Nullable ChunksList chunks, int copyMask) {
        this.copyChunksFrom(chunks, ChunkCopyBehaviour.INSTANCE.createPredicate(copyMask, this.imgInfo));
    }

    public static /* synthetic */ void copyChunksFrom$default(PngWriter pngWriter, ChunksList chunksList, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyChunksFrom");
        }
        if ((n2 & 2) != 0) {
            n = 8;
        }
        pngWriter.copyChunksFrom(chunksList, n);
    }

    private final void copyChunksFrom(ChunksList chunks, ChunkPredicate predicate) {
        if (this.copyFromList != null && chunks != null) {
            System.out.println((Object)"copyChunksFrom should only be called once");
        }
        if (predicate == null) {
            throw new PngjOutputException("copyChunksFrom requires a predicate");
        }
        this.copyFromList = chunks;
        this.copyFromPredicate = predicate;
    }

    public final double computeCompressionRatio() {
        if (this.currentChunkGroup < 5) {
            throw new PngjOutputException("must be called after end()");
        }
        return this.pixelsWriter.getCompression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void end() {
        if (this.rowNum != this.imgInfo.getRows() - 1 || !this.pixelsWriter.isDone()) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            this.pixelsWriter.close();
            if (this.currentChunkGroup < 5) {
                this.writeLastChunks();
            }
            if (this.currentChunkGroup < 6) {
                this.writeEndChunk();
            }
        }
        finally {
            this.close();
        }
    }

    public final void close() {
        this.pixelsWriter.close();
        if (this.shouldCloseStream) {
            try {
                this.os.close();
            }
            catch (Exception e) {
                System.out.println((Object)("Error closing writer " + e));
            }
        }
    }

    @NotNull
    public final ChunksListForWrite getChunksList() {
        return this.chunksList;
    }

    @NotNull
    public final PngMetadata getMetadata() {
        return this.metadata;
    }

    public final void setFilterType(@NotNull FilterType filterType) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterType), (String)"filterType");
        this.pixelsWriter.setFilterType(filterType);
    }

    private final void setCompLevel(int complevel) {
        this.pixelsWriter.setDeflaterCompLevel(complevel);
    }

    public final void setFilterPreserve(boolean filterPreserve) {
        if (filterPreserve) {
            this.pixelsWriter.setFilterType(FilterType.FILTER_PRESERVE);
        }
    }

    public final void setIdatMaxSize(int idatMaxSize) {
        this.idatMaxSize = idatMaxSize;
    }

    public final void setShouldCloseStream(boolean shouldCloseStream) {
        this.shouldCloseStream = shouldCloseStream;
    }

    public final void writeRow(@NotNull IImageLine imgline) {
        Intrinsics.checkNotNullParameter((Object)imgline, (String)"imgline");
        this.writeRow(imgline, this.rowNum + 1);
    }

    public final void writeRows(@NotNull IImageLineSet<? extends IImageLine> imglines) {
        Intrinsics.checkNotNullParameter(imglines, (String)"imglines");
        int n = this.imgInfo.getRows();
        for (int i = 0; i < n; ++i) {
            this.writeRow(imglines.getImageLineRawNum(i));
        }
    }

    public final void writeRow(@NotNull IImageLine imgline, int rownumber) {
        Intrinsics.checkNotNullParameter((Object)imgline, (String)"imgline");
        int rownumber2 = rownumber;
        int n = this.rowNum;
        this.rowNum = n + 1;
        if (this.rowNum == this.imgInfo.getRows()) {
            this.rowNum = 0;
        }
        if (rownumber2 == this.imgInfo.getRows()) {
            rownumber2 = 0;
        }
        if (rownumber2 >= 0 && this.rowNum != rownumber2) {
            throw new PngjOutputException("rows must be written in order: expected:" + this.rowNum + " passed:" + rownumber2);
        }
        if (this.rowNum == 0) {
            n = this.currentpass;
            this.currentpass = n + 1;
        }
        if (rownumber2 == 0 && this.currentpass == this.passes) {
            this.initIdat();
            this.currentChunkGroup = 4;
        }
        byte[] rowb = this.pixelsWriter.getCurentRowb();
        imgline.writeToPngRaw(rowb);
        this.pixelsWriter.processRow(rowb);
    }

    public final void writeRowInt(@Nullable int[] buf) {
        this.writeRow(new ImageLineInt(this.imgInfo, buf));
    }

    @JvmOverloads
    public final void copyChunksFrom(@Nullable ChunksList chunks) {
        PngWriter.copyChunksFrom$default(this, chunks, 0, 2, null);
    }
}

