/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution;

import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bJ\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bH\u0002J\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterCodeWrapper;", "", "<init>", "()V", "wrapString", "", "text", "utf8encoded", "", "raisePythonException", "errorMessage", "generateCodeForDataFrame", "data", "generateCodeSetDataFrameToVariable", "variableName", "generateCodeConcatWithDataFrame", "addOrCreateTableDataFrame", "isTableCreated", "", "intellij.jupyter.core"})
public final class JupyterCodeWrapper {
    @NotNull
    public static final JupyterCodeWrapper INSTANCE = new JupyterCodeWrapper();

    private JupyterCodeWrapper() {
    }

    @NotNull
    public final String wrapString(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Base64.Encoder encoder = Base64.getEncoder();
        String string = text;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String encodedString = encoder.encodeToString(byArray);
        return "__import__('base64').b64decode('" + encodedString + "').decode('utf-8')";
    }

    @NotNull
    public final String wrapString(@NotNull byte[] utf8encoded) {
        Intrinsics.checkNotNullParameter((Object)utf8encoded, (String)"utf8encoded");
        String encodedString = Base64.getEncoder().encodeToString(utf8encoded);
        return "__import__('base64').b64decode('" + encodedString + "').decode('utf-8')";
    }

    @NotNull
    public final String raisePythonException(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return "raise Exception(" + this.wrapString(errorMessage) + ")";
    }

    @NotNull
    public final String generateCodeForDataFrame(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return "__import__('pandas').read_csv(__import__('io').StringIO(" + this.wrapString(data) + "), sep=\",\")";
    }

    private final String generateCodeSetDataFrameToVariable(String variableName, byte[] data) {
        return variableName + " = " + this.generateCodeForDataFrame(data);
    }

    private final String generateCodeConcatWithDataFrame(String variableName, byte[] data) {
        return variableName + "=__import__('pandas').concat([" + variableName + ", " + this.generateCodeForDataFrame(data) + "], ignore_index=True)";
    }

    @NotNull
    public final String addOrCreateTableDataFrame(@NotNull String variableName, @NotNull byte[] data, boolean isTableCreated) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return isTableCreated ? this.generateCodeSetDataFrameToVariable(variableName, data) : this.generateCodeConcatWithDataFrame(variableName, data);
    }
}

