import { PayloadType } from '../types';
import { PUBLISH_LABEL_DEFAULT_TEXT, RECEIVE_TEXT_LABEL_DEFAULT_TEXT, REPLIER_LABEL_DEFAULT_TEXT, REQUEST_LABEL_DEFAULT_TEXT, SEND_LABEL_DEFAULT_TEXT, SUBSCRIBE_LABEL_DEFAULT_TEXT, } from '../constants';
var CommonHelpers = (function () {
    function CommonHelpers() {
    }
    CommonHelpers.getIdentifier = function (id, config) {
        var schemaID = config === null || config === void 0 ? void 0 : config.schemaID;
        if (schemaID) {
            return "".concat(schemaID, "-").concat(id);
        }
        return id;
    };
    CommonHelpers.getOperationType = function (operation) {
        if (operation.isSend()) {
            if (operation.reply() !== undefined) {
                return PayloadType.REQUEST;
            }
            else {
                return PayloadType.SEND;
            }
        }
        if (operation.isReceive() && operation.reply() !== undefined) {
            return PayloadType.REPLY;
        }
        return PayloadType.RECEIVE;
    };
    CommonHelpers.getOperationIdentifier = function (_a) {
        var operation = _a.operation, config = _a.config;
        if (operation.isSend()) {
            if (operation.reply() !== undefined) {
                return CommonHelpers.getIdentifier("operation-".concat(PayloadType.REQUEST, "-").concat(operation.id()), config);
            }
            else {
                return CommonHelpers.getIdentifier("operation-".concat(PayloadType.SEND, "-").concat(operation.id()), config);
            }
        }
        if (operation.isReceive() && operation.reply() !== undefined) {
            return CommonHelpers.getIdentifier("operation-".concat(PayloadType.REPLY, "-").concat(operation.id()), config);
        }
        return CommonHelpers.getIdentifier("operation-".concat(PayloadType.RECEIVE, "-").concat(operation.id()), config);
    };
    CommonHelpers.getOperationDesignInformation = function (_a) {
        var _b, _c, _d, _e, _f, _g;
        var type = _a.type, config = _a.config, isAsyncAPIv2 = _a.isAsyncAPIv2;
        if (type === PayloadType.RECEIVE) {
            return {
                borderColor: 'border-green-600 text-green-600',
                backgroundColor: 'bg-green-600',
                typeLabel: !isAsyncAPIv2
                    ? (_b = config.receiveLabel) !== null && _b !== void 0 ? _b : RECEIVE_TEXT_LABEL_DEFAULT_TEXT
                    : (_c = config.publishLabel) !== null && _c !== void 0 ? _c : PUBLISH_LABEL_DEFAULT_TEXT,
            };
        }
        if (type === PayloadType.REPLY) {
            return {
                borderColor: 'border-orange-600 text-orange-600',
                backgroundColor: 'bg-orange-600',
                typeLabel: (_d = config.replyLabel) !== null && _d !== void 0 ? _d : REPLIER_LABEL_DEFAULT_TEXT,
            };
        }
        if (type === PayloadType.REQUEST) {
            return {
                borderColor: 'border-red-600 text-red-600',
                backgroundColor: 'bg-red-600',
                typeLabel: (_e = config.requestLabel) !== null && _e !== void 0 ? _e : REQUEST_LABEL_DEFAULT_TEXT,
            };
        }
        return {
            borderColor: 'border-blue-600 text-blue-500',
            backgroundColor: 'bg-blue-600',
            typeLabel: !isAsyncAPIv2
                ? (_f = config.sendLabel) !== null && _f !== void 0 ? _f : SEND_LABEL_DEFAULT_TEXT
                : (_g = config.subscribeLabel) !== null && _g !== void 0 ? _g : SUBSCRIBE_LABEL_DEFAULT_TEXT,
        };
    };
    return CommonHelpers;
}());
export { CommonHelpers };
//# sourceMappingURL=common.js.map