
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractAnimation.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractAnimation>
#include <QAnimationGroup>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractAnimation

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractAnimation::staticMetaObject);
}


// int QAbstractAnimation::currentLoop()


static void _init_f_currentLoop_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentLoop_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAnimation *)cls)->currentLoop ());
}


// int QAbstractAnimation::currentLoopTime()


static void _init_f_currentLoopTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentLoopTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAnimation *)cls)->currentLoopTime ());
}


// int QAbstractAnimation::currentTime()


static void _init_f_currentTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAnimation *)cls)->currentTime ());
}


// QAbstractAnimation::Direction QAbstractAnimation::direction()


static void _init_f_direction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractAnimation::Direction>::target_type > ();
}

static void _call_f_direction_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractAnimation::Direction>::target_type > ((qt_gsi::Converter<QAbstractAnimation::Direction>::target_type)qt_gsi::CppToQtAdaptor<QAbstractAnimation::Direction>(((QAbstractAnimation *)cls)->direction ()));
}


// int QAbstractAnimation::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAnimation *)cls)->duration ());
}


// QAnimationGroup *QAbstractAnimation::group()


static void _init_f_group_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAnimationGroup * > ();
}

static void _call_f_group_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAnimationGroup * > ((QAnimationGroup *)((QAbstractAnimation *)cls)->group ());
}


// int QAbstractAnimation::loopCount()


static void _init_f_loopCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_loopCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAnimation *)cls)->loopCount ());
}


// void QAbstractAnimation::pause()


static void _init_f_pause_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_pause_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation *)cls)->pause ();
}


// void QAbstractAnimation::resume()


static void _init_f_resume_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resume_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation *)cls)->resume ();
}


// void QAbstractAnimation::setCurrentTime(int msecs)


static void _init_f_setCurrentTime_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentTime_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation *)cls)->setCurrentTime (arg1);
}


// void QAbstractAnimation::setDirection(QAbstractAnimation::Direction direction)


static void _init_f_setDirection_3310 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirection_3310 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation *)cls)->setDirection (qt_gsi::QtToCppAdaptor<QAbstractAnimation::Direction>(arg1).cref());
}


// void QAbstractAnimation::setLoopCount(int loopCount)


static void _init_f_setLoopCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("loopCount");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLoopCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation *)cls)->setLoopCount (arg1);
}


// void QAbstractAnimation::setPaused(bool)


static void _init_f_setPaused_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaused_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation *)cls)->setPaused (arg1);
}


// void QAbstractAnimation::start(QAbstractAnimation::DeletionPolicy policy)


static void _init_f_start_3825 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy", true, "QAbstractAnimation::KeepWhenStopped");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::DeletionPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_start_3825 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::DeletionPolicy>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::DeletionPolicy>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractAnimation::DeletionPolicy>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractAnimation::DeletionPolicy>(heap, QAbstractAnimation::KeepWhenStopped), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation *)cls)->start (qt_gsi::QtToCppAdaptor<QAbstractAnimation::DeletionPolicy>(arg1).cref());
}


// QAbstractAnimation::State QAbstractAnimation::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractAnimation::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractAnimation::State>::target_type > ((qt_gsi::Converter<QAbstractAnimation::State>::target_type)qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(((QAbstractAnimation *)cls)->state ()));
}


// void QAbstractAnimation::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation *)cls)->stop ();
}


// int QAbstractAnimation::totalDuration()


static void _init_f_totalDuration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_totalDuration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAnimation *)cls)->totalDuration ());
}


// static QString QAbstractAnimation::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractAnimation::tr (arg1, arg2, arg3));
}


// static QString QAbstractAnimation::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractAnimation::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractAnimation () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":currentLoop", "@brief Method int QAbstractAnimation::currentLoop()\n", true, &_init_f_currentLoop_c0, &_call_f_currentLoop_c0);
  methods += new qt_gsi::GenericMethod ("currentLoopTime", "@brief Method int QAbstractAnimation::currentLoopTime()\n", true, &_init_f_currentLoopTime_c0, &_call_f_currentLoopTime_c0);
  methods += new qt_gsi::GenericMethod (":currentTime", "@brief Method int QAbstractAnimation::currentTime()\n", true, &_init_f_currentTime_c0, &_call_f_currentTime_c0);
  methods += new qt_gsi::GenericMethod (":direction", "@brief Method QAbstractAnimation::Direction QAbstractAnimation::direction()\n", true, &_init_f_direction_c0, &_call_f_direction_c0);
  methods += new qt_gsi::GenericMethod (":duration", "@brief Method int QAbstractAnimation::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod ("group", "@brief Method QAnimationGroup *QAbstractAnimation::group()\n", true, &_init_f_group_c0, &_call_f_group_c0);
  methods += new qt_gsi::GenericMethod (":loopCount", "@brief Method int QAbstractAnimation::loopCount()\n", true, &_init_f_loopCount_c0, &_call_f_loopCount_c0);
  methods += new qt_gsi::GenericMethod ("pause", "@brief Method void QAbstractAnimation::pause()\n", false, &_init_f_pause_0, &_call_f_pause_0);
  methods += new qt_gsi::GenericMethod ("resume", "@brief Method void QAbstractAnimation::resume()\n", false, &_init_f_resume_0, &_call_f_resume_0);
  methods += new qt_gsi::GenericMethod ("setCurrentTime|currentTime=", "@brief Method void QAbstractAnimation::setCurrentTime(int msecs)\n", false, &_init_f_setCurrentTime_767, &_call_f_setCurrentTime_767);
  methods += new qt_gsi::GenericMethod ("setDirection|direction=", "@brief Method void QAbstractAnimation::setDirection(QAbstractAnimation::Direction direction)\n", false, &_init_f_setDirection_3310, &_call_f_setDirection_3310);
  methods += new qt_gsi::GenericMethod ("setLoopCount|loopCount=", "@brief Method void QAbstractAnimation::setLoopCount(int loopCount)\n", false, &_init_f_setLoopCount_767, &_call_f_setLoopCount_767);
  methods += new qt_gsi::GenericMethod ("setPaused", "@brief Method void QAbstractAnimation::setPaused(bool)\n", false, &_init_f_setPaused_864, &_call_f_setPaused_864);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QAbstractAnimation::start(QAbstractAnimation::DeletionPolicy policy)\n", false, &_init_f_start_3825, &_call_f_start_3825);
  methods += new qt_gsi::GenericMethod (":state", "@brief Method QAbstractAnimation::State QAbstractAnimation::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QAbstractAnimation::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("totalDuration", "@brief Method int QAbstractAnimation::totalDuration()\n", true, &_init_f_totalDuration_c0, &_call_f_totalDuration_c0);
  methods += gsi::qt_signal<int > ("currentLoopChanged(int)", "currentLoopChanged", gsi::arg("currentLoop"), "@brief Signal declaration for QAbstractAnimation::currentLoopChanged(int currentLoop)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractAnimation::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > ("directionChanged(QAbstractAnimation::Direction)", "directionChanged", gsi::arg("arg1"), "@brief Signal declaration for QAbstractAnimation::directionChanged(QAbstractAnimation::Direction)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QAbstractAnimation::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QAbstractAnimation::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractAnimation::State>::target_type &, const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > ("stateChanged(QAbstractAnimation::State, QAbstractAnimation::State)", "stateChanged", gsi::arg("newState"), gsi::arg("oldState"), "@brief Signal declaration for QAbstractAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractAnimation::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractAnimation::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAbstractAnimation> decl_QAbstractAnimation (qtdecl_QObject (), "QtCore", "QAbstractAnimation_Native",
  methods_QAbstractAnimation (),
  "@hide\n@alias QAbstractAnimation");

GSI_QTCORE_PUBLIC gsi::Class<QAbstractAnimation> &qtdecl_QAbstractAnimation () { return decl_QAbstractAnimation; }

}


class QAbstractAnimation_Adaptor : public QAbstractAnimation, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractAnimation_Adaptor();

  //  [adaptor ctor] QAbstractAnimation::QAbstractAnimation(QObject *parent)
  QAbstractAnimation_Adaptor() : QAbstractAnimation()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractAnimation::QAbstractAnimation(QObject *parent)
  QAbstractAnimation_Adaptor(QObject *parent) : QAbstractAnimation(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAbstractAnimation::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractAnimation_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractAnimation::isSignalConnected(signal);
  }

  //  [expose] int QAbstractAnimation::receivers(const char *signal)
  int fp_QAbstractAnimation_receivers_c1731 (const char *signal) const {
    return QAbstractAnimation::receivers(signal);
  }

  //  [expose] QObject *QAbstractAnimation::sender()
  QObject * fp_QAbstractAnimation_sender_c0 () const {
    return QAbstractAnimation::sender();
  }

  //  [expose] int QAbstractAnimation::senderSignalIndex()
  int fp_QAbstractAnimation_senderSignalIndex_c0 () const {
    return QAbstractAnimation::senderSignalIndex();
  }

  //  [emitter impl] void QAbstractAnimation::currentLoopChanged(int currentLoop)
  void emitter_QAbstractAnimation_currentLoopChanged_767(int currentLoop)
  {
    emit QAbstractAnimation::currentLoopChanged(currentLoop);
  }

  //  [emitter impl] void QAbstractAnimation::destroyed(QObject *)
  void emitter_QAbstractAnimation_destroyed_1302(QObject *arg1)
  {
    emit QAbstractAnimation::destroyed(arg1);
  }

  //  [emitter impl] void QAbstractAnimation::directionChanged(QAbstractAnimation::Direction)
  void emitter_QAbstractAnimation_directionChanged_3310(QAbstractAnimation::Direction arg1)
  {
    emit QAbstractAnimation::directionChanged(arg1);
  }

  //  [adaptor impl] int QAbstractAnimation::duration()
  int cbs_duration_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("duration");
  }

  virtual int duration() const
  {
    if (cb_duration_c0_0.can_issue()) {
      return cb_duration_c0_0.issue<QAbstractAnimation_Adaptor, int>(&QAbstractAnimation_Adaptor::cbs_duration_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("duration");
    }
  }

  //  [adaptor impl] bool QAbstractAnimation::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QAbstractAnimation::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractAnimation_Adaptor, bool, QObject *, QEvent *>(&QAbstractAnimation_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QAbstractAnimation::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QAbstractAnimation::finished()
  void emitter_QAbstractAnimation_finished_0()
  {
    emit QAbstractAnimation::finished();
  }

  //  [emitter impl] void QAbstractAnimation::objectNameChanged(const QString &objectName)
  void emitter_QAbstractAnimation_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QAbstractAnimation::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QAbstractAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  void emitter_QAbstractAnimation_stateChanged_5680(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  {
    emit QAbstractAnimation::stateChanged(newState, oldState);
  }

  //  [adaptor impl] void QAbstractAnimation::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QAbstractAnimation::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractAnimation_Adaptor, QChildEvent *>(&QAbstractAnimation_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QAbstractAnimation::childEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractAnimation::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QAbstractAnimation::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractAnimation_Adaptor, QEvent *>(&QAbstractAnimation_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QAbstractAnimation::customEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractAnimation::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractAnimation::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractAnimation_Adaptor, const QMetaMethod &>(&QAbstractAnimation_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractAnimation::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QAbstractAnimation::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QAbstractAnimation::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractAnimation_Adaptor, bool, QEvent *>(&QAbstractAnimation_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QAbstractAnimation::event(_event);
    }
  }

  //  [adaptor impl] void QAbstractAnimation::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QAbstractAnimation::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractAnimation_Adaptor, QTimerEvent *>(&QAbstractAnimation_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QAbstractAnimation::timerEvent(event);
    }
  }

  //  [adaptor impl] void QAbstractAnimation::updateCurrentTime(int currentTime)
  void cbs_updateCurrentTime_767_0(int currentTime)
  {
    __SUPPRESS_UNUSED_WARNING (currentTime);
    throw qt_gsi::AbstractMethodCalledException("updateCurrentTime");
  }

  virtual void updateCurrentTime(int currentTime)
  {
    if (cb_updateCurrentTime_767_0.can_issue()) {
      cb_updateCurrentTime_767_0.issue<QAbstractAnimation_Adaptor, int>(&QAbstractAnimation_Adaptor::cbs_updateCurrentTime_767_0, currentTime);
    } else {
      throw qt_gsi::AbstractMethodCalledException("updateCurrentTime");
    }
  }

  //  [adaptor impl] void QAbstractAnimation::updateDirection(QAbstractAnimation::Direction direction)
  void cbs_updateDirection_3310_0(const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & direction)
  {
    QAbstractAnimation::updateDirection(qt_gsi::QtToCppAdaptor<QAbstractAnimation::Direction>(direction).cref());
  }

  virtual void updateDirection(QAbstractAnimation::Direction direction)
  {
    if (cb_updateDirection_3310_0.can_issue()) {
      cb_updateDirection_3310_0.issue<QAbstractAnimation_Adaptor, const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type &>(&QAbstractAnimation_Adaptor::cbs_updateDirection_3310_0, qt_gsi::CppToQtAdaptor<QAbstractAnimation::Direction>(direction));
    } else {
      QAbstractAnimation::updateDirection(direction);
    }
  }

  //  [adaptor impl] void QAbstractAnimation::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  void cbs_updateState_5680_0(const qt_gsi::Converter<QAbstractAnimation::State>::target_type & newState, const qt_gsi::Converter<QAbstractAnimation::State>::target_type & oldState)
  {
    QAbstractAnimation::updateState(qt_gsi::QtToCppAdaptor<QAbstractAnimation::State>(newState).cref(), qt_gsi::QtToCppAdaptor<QAbstractAnimation::State>(oldState).cref());
  }

  virtual void updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  {
    if (cb_updateState_5680_0.can_issue()) {
      cb_updateState_5680_0.issue<QAbstractAnimation_Adaptor, const qt_gsi::Converter<QAbstractAnimation::State>::target_type &, const qt_gsi::Converter<QAbstractAnimation::State>::target_type &>(&QAbstractAnimation_Adaptor::cbs_updateState_5680_0, qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(newState), qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(oldState));
    } else {
      QAbstractAnimation::updateState(newState, oldState);
    }
  }

  gsi::Callback cb_duration_c0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateCurrentTime_767_0;
  gsi::Callback cb_updateDirection_3310_0;
  gsi::Callback cb_updateState_5680_0;
};

QAbstractAnimation_Adaptor::~QAbstractAnimation_Adaptor() { }

//  Constructor QAbstractAnimation::QAbstractAnimation(QObject *parent) (adaptor class)

static void _init_ctor_QAbstractAnimation_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAbstractAnimation_Adaptor> ();
}

static void _call_ctor_QAbstractAnimation_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QAbstractAnimation_Adaptor *> (new QAbstractAnimation_Adaptor (arg1));
}


// void QAbstractAnimation::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAnimation_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QAbstractAnimation::currentLoopChanged(int currentLoop)

static void _init_emitter_currentLoopChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("currentLoop");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentLoopChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QAbstractAnimation_Adaptor *)cls)->emitter_QAbstractAnimation_currentLoopChanged_767 (arg1);
}


// void QAbstractAnimation::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAnimation_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QAbstractAnimation::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QAbstractAnimation_Adaptor *)cls)->emitter_QAbstractAnimation_destroyed_1302 (arg1);
}


// emitter void QAbstractAnimation::directionChanged(QAbstractAnimation::Direction)

static void _init_emitter_directionChanged_3310 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_directionChanged_3310 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & >() (args, heap);
  ((QAbstractAnimation_Adaptor *)cls)->emitter_QAbstractAnimation_directionChanged_3310 (arg1);
}


// void QAbstractAnimation::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAnimation_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// int QAbstractAnimation::duration()

static void _init_cbs_duration_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_duration_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAnimation_Adaptor *)cls)->cbs_duration_c0_0 ());
}

static void _set_callback_cbs_duration_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAnimation_Adaptor *)cls)->cb_duration_c0_0 = cb;
}


// bool QAbstractAnimation::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractAnimation_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAnimation_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractAnimation::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractAnimation_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAnimation_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QAbstractAnimation::finished()

static void _init_emitter_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAbstractAnimation_Adaptor *)cls)->emitter_QAbstractAnimation_finished_0 ();
}


// exposed bool QAbstractAnimation::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractAnimation_Adaptor *)cls)->fp_QAbstractAnimation_isSignalConnected_c2394 (arg1));
}


// emitter void QAbstractAnimation::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QAbstractAnimation_Adaptor *)cls)->emitter_QAbstractAnimation_objectNameChanged_4567 (arg1);
}


// exposed int QAbstractAnimation::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractAnimation_Adaptor *)cls)->fp_QAbstractAnimation_receivers_c1731 (arg1));
}


// exposed QObject *QAbstractAnimation::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractAnimation_Adaptor *)cls)->fp_QAbstractAnimation_sender_c0 ());
}


// exposed int QAbstractAnimation::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAnimation_Adaptor *)cls)->fp_QAbstractAnimation_senderSignalIndex_c0 ());
}


// emitter void QAbstractAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)

static void _init_emitter_stateChanged_5680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_5680 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & >() (args, heap);
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & >() (args, heap);
  ((QAbstractAnimation_Adaptor *)cls)->emitter_QAbstractAnimation_stateChanged_5680 (arg1, arg2);
}


// void QAbstractAnimation::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAnimation_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QAbstractAnimation::updateCurrentTime(int currentTime)

static void _init_cbs_updateCurrentTime_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("currentTime");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateCurrentTime_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation_Adaptor *)cls)->cbs_updateCurrentTime_767_0 (arg1);
}

static void _set_callback_cbs_updateCurrentTime_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAnimation_Adaptor *)cls)->cb_updateCurrentTime_767_0 = cb;
}


// void QAbstractAnimation::updateDirection(QAbstractAnimation::Direction direction)

static void _init_cbs_updateDirection_3310_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateDirection_3310_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation_Adaptor *)cls)->cbs_updateDirection_3310_0 (arg1);
}

static void _set_callback_cbs_updateDirection_3310_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAnimation_Adaptor *)cls)->cb_updateDirection_3310_0 = cb;
}


// void QAbstractAnimation::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)

static void _init_cbs_updateState_5680_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_updateState_5680_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (heap);
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAnimation_Adaptor *)cls)->cbs_updateState_5680_0 (arg1, arg2);
}

static void _set_callback_cbs_updateState_5680_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAnimation_Adaptor *)cls)->cb_updateState_5680_0 = cb;
}


namespace gsi
{

gsi::Class<QAbstractAnimation> &qtdecl_QAbstractAnimation ();

static gsi::Methods methods_QAbstractAnimation_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractAnimation::QAbstractAnimation(QObject *parent)\nThis method creates an object of class QAbstractAnimation.", &_init_ctor_QAbstractAnimation_Adaptor_1302, &_call_ctor_QAbstractAnimation_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractAnimation::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_currentLoopChanged", "@brief Emitter for signal void QAbstractAnimation::currentLoopChanged(int currentLoop)\nCall this method to emit this signal.", false, &_init_emitter_currentLoopChanged_767, &_call_emitter_currentLoopChanged_767);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractAnimation::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAbstractAnimation::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("emit_directionChanged", "@brief Emitter for signal void QAbstractAnimation::directionChanged(QAbstractAnimation::Direction)\nCall this method to emit this signal.", false, &_init_emitter_directionChanged_3310, &_call_emitter_directionChanged_3310);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractAnimation::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Virtual method int QAbstractAnimation::duration()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("duration", "@hide", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0, &_set_callback_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QAbstractAnimation::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractAnimation::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QAbstractAnimation::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_0, &_call_emitter_finished_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractAnimation::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QAbstractAnimation::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractAnimation::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractAnimation::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractAnimation::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QAbstractAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_5680, &_call_emitter_stateChanged_5680);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractAnimation::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentTime", "@brief Virtual method void QAbstractAnimation::updateCurrentTime(int currentTime)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateCurrentTime_767_0, &_call_cbs_updateCurrentTime_767_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentTime", "@hide", false, &_init_cbs_updateCurrentTime_767_0, &_call_cbs_updateCurrentTime_767_0, &_set_callback_cbs_updateCurrentTime_767_0);
  methods += new qt_gsi::GenericMethod ("*updateDirection", "@brief Virtual method void QAbstractAnimation::updateDirection(QAbstractAnimation::Direction direction)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateDirection_3310_0, &_call_cbs_updateDirection_3310_0);
  methods += new qt_gsi::GenericMethod ("*updateDirection", "@hide", false, &_init_cbs_updateDirection_3310_0, &_call_cbs_updateDirection_3310_0, &_set_callback_cbs_updateDirection_3310_0);
  methods += new qt_gsi::GenericMethod ("*updateState", "@brief Virtual method void QAbstractAnimation::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateState_5680_0, &_call_cbs_updateState_5680_0);
  methods += new qt_gsi::GenericMethod ("*updateState", "@hide", false, &_init_cbs_updateState_5680_0, &_call_cbs_updateState_5680_0, &_set_callback_cbs_updateState_5680_0);
  return methods;
}

gsi::Class<QAbstractAnimation_Adaptor> decl_QAbstractAnimation_Adaptor (qtdecl_QAbstractAnimation (), "QtCore", "QAbstractAnimation",
  methods_QAbstractAnimation_Adaptor (),
  "@qt\n@brief Binding of QAbstractAnimation");

}


//  Implementation of the enum wrapper class for QAbstractAnimation::DeletionPolicy
namespace qt_gsi
{

static gsi::Enum<QAbstractAnimation::DeletionPolicy> decl_QAbstractAnimation_DeletionPolicy_Enum ("QtCore", "QAbstractAnimation_DeletionPolicy",
    gsi::enum_const ("KeepWhenStopped", QAbstractAnimation::KeepWhenStopped, "@brief Enum constant QAbstractAnimation::KeepWhenStopped") +
    gsi::enum_const ("DeleteWhenStopped", QAbstractAnimation::DeleteWhenStopped, "@brief Enum constant QAbstractAnimation::DeleteWhenStopped"),
  "@qt\n@brief This class represents the QAbstractAnimation::DeletionPolicy enum");

static gsi::QFlagsClass<QAbstractAnimation::DeletionPolicy > decl_QAbstractAnimation_DeletionPolicy_Enums ("QtCore", "QAbstractAnimation_QFlags_DeletionPolicy",
  "@qt\n@brief This class represents the QFlags<QAbstractAnimation::DeletionPolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractAnimation> inject_QAbstractAnimation_DeletionPolicy_Enum_in_parent (decl_QAbstractAnimation_DeletionPolicy_Enum.defs ());
static gsi::ClassExt<QAbstractAnimation> decl_QAbstractAnimation_DeletionPolicy_Enum_as_child (decl_QAbstractAnimation_DeletionPolicy_Enum, "DeletionPolicy");
static gsi::ClassExt<QAbstractAnimation> decl_QAbstractAnimation_DeletionPolicy_Enums_as_child (decl_QAbstractAnimation_DeletionPolicy_Enums, "QFlags_DeletionPolicy");

}


//  Implementation of the enum wrapper class for QAbstractAnimation::Direction
namespace qt_gsi
{

static gsi::Enum<QAbstractAnimation::Direction> decl_QAbstractAnimation_Direction_Enum ("QtCore", "QAbstractAnimation_Direction",
    gsi::enum_const ("Forward", QAbstractAnimation::Forward, "@brief Enum constant QAbstractAnimation::Forward") +
    gsi::enum_const ("Backward", QAbstractAnimation::Backward, "@brief Enum constant QAbstractAnimation::Backward"),
  "@qt\n@brief This class represents the QAbstractAnimation::Direction enum");

static gsi::QFlagsClass<QAbstractAnimation::Direction > decl_QAbstractAnimation_Direction_Enums ("QtCore", "QAbstractAnimation_QFlags_Direction",
  "@qt\n@brief This class represents the QFlags<QAbstractAnimation::Direction> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractAnimation> inject_QAbstractAnimation_Direction_Enum_in_parent (decl_QAbstractAnimation_Direction_Enum.defs ());
static gsi::ClassExt<QAbstractAnimation> decl_QAbstractAnimation_Direction_Enum_as_child (decl_QAbstractAnimation_Direction_Enum, "Direction");
static gsi::ClassExt<QAbstractAnimation> decl_QAbstractAnimation_Direction_Enums_as_child (decl_QAbstractAnimation_Direction_Enums, "QFlags_Direction");

}


//  Implementation of the enum wrapper class for QAbstractAnimation::State
namespace qt_gsi
{

static gsi::Enum<QAbstractAnimation::State> decl_QAbstractAnimation_State_Enum ("QtCore", "QAbstractAnimation_State",
    gsi::enum_const ("Stopped", QAbstractAnimation::Stopped, "@brief Enum constant QAbstractAnimation::Stopped") +
    gsi::enum_const ("Paused", QAbstractAnimation::Paused, "@brief Enum constant QAbstractAnimation::Paused") +
    gsi::enum_const ("Running", QAbstractAnimation::Running, "@brief Enum constant QAbstractAnimation::Running"),
  "@qt\n@brief This class represents the QAbstractAnimation::State enum");

static gsi::QFlagsClass<QAbstractAnimation::State > decl_QAbstractAnimation_State_Enums ("QtCore", "QAbstractAnimation_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QAbstractAnimation::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractAnimation> inject_QAbstractAnimation_State_Enum_in_parent (decl_QAbstractAnimation_State_Enum.defs ());
static gsi::ClassExt<QAbstractAnimation> decl_QAbstractAnimation_State_Enum_as_child (decl_QAbstractAnimation_State_Enum, "State");
static gsi::ClassExt<QAbstractAnimation> decl_QAbstractAnimation_State_Enums_as_child (decl_QAbstractAnimation_State_Enums, "QFlags_State");

}

