// Package log provides the Chrome DevTools Protocol
// commands, types, and events for the Log domain.
//
// Provides access to log entries.
//
// Generated by the cdproto-gen command.
package log

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// ClearParams clears the log.
type ClearParams struct{}

// Clear clears the log.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Log#method-clear
func Clear() *ClearParams {
	return &ClearParams{}
}

// Do executes Log.clear against the provided context.
func (p *ClearParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandClear, nil, nil)
}

// DisableParams disables log domain, prevents further log entries from being
// reported to the client.
type DisableParams struct{}

// Disable disables log domain, prevents further log entries from being
// reported to the client.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Log#method-disable
func Disable() *DisableParams {
	return &DisableParams{}
}

// Do executes Log.disable against the provided context.
func (p *DisableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDisable, nil, nil)
}

// EnableParams enables log domain, sends the entries collected so far to the
// client by means of the entryAdded notification.
type EnableParams struct{}

// Enable enables log domain, sends the entries collected so far to the
// client by means of the entryAdded notification.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Log#method-enable
func Enable() *EnableParams {
	return &EnableParams{}
}

// Do executes Log.enable against the provided context.
func (p *EnableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnable, nil, nil)
}

// StartViolationsReportParams start violation reporting.
type StartViolationsReportParams struct {
	Config []*ViolationSetting `json:"config"` // Configuration for violations.
}

// StartViolationsReport start violation reporting.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Log#method-startViolationsReport
//
// parameters:
//
//	config - Configuration for violations.
func StartViolationsReport(config []*ViolationSetting) *StartViolationsReportParams {
	return &StartViolationsReportParams{
		Config: config,
	}
}

// Do executes Log.startViolationsReport against the provided context.
func (p *StartViolationsReportParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandStartViolationsReport, p, nil)
}

// StopViolationsReportParams stop violation reporting.
type StopViolationsReportParams struct{}

// StopViolationsReport stop violation reporting.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Log#method-stopViolationsReport
func StopViolationsReport() *StopViolationsReportParams {
	return &StopViolationsReportParams{}
}

// Do executes Log.stopViolationsReport against the provided context.
func (p *StopViolationsReportParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandStopViolationsReport, nil, nil)
}

// Command names.
const (
	CommandClear                 = "Log.clear"
	CommandDisable               = "Log.disable"
	CommandEnable                = "Log.enable"
	CommandStartViolationsReport = "Log.startViolationsReport"
	CommandStopViolationsReport  = "Log.stopViolationsReport"
)
