// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func (m *AnyValue) GetValue() any {
	if m != nil {
		return m.Value
	}
	return nil
}

type AnyValue_StringValue struct {
	StringValue string
}

func (m *AnyValue) GetStringValue() string {
	if v, ok := m.GetValue().(*AnyValue_StringValue); ok {
		return v.StringValue
	}
	return ""
}

type AnyValue_BoolValue struct {
	BoolValue bool
}

func (m *AnyValue) GetBoolValue() bool {
	if v, ok := m.GetValue().(*AnyValue_BoolValue); ok {
		return v.BoolValue
	}
	return false
}

type AnyValue_IntValue struct {
	IntValue int64
}

func (m *AnyValue) GetIntValue() int64 {
	if v, ok := m.GetValue().(*AnyValue_IntValue); ok {
		return v.IntValue
	}
	return int64(0)
}

type AnyValue_DoubleValue struct {
	DoubleValue float64
}

func (m *AnyValue) GetDoubleValue() float64 {
	if v, ok := m.GetValue().(*AnyValue_DoubleValue); ok {
		return v.DoubleValue
	}
	return float64(0)
}

type AnyValue_ArrayValue struct {
	ArrayValue *ArrayValue
}

func (m *AnyValue) GetArrayValue() *ArrayValue {
	if v, ok := m.GetValue().(*AnyValue_ArrayValue); ok {
		return v.ArrayValue
	}
	return nil
}

type AnyValue_KvlistValue struct {
	KvlistValue *KeyValueList
}

func (m *AnyValue) GetKvlistValue() *KeyValueList {
	if v, ok := m.GetValue().(*AnyValue_KvlistValue); ok {
		return v.KvlistValue
	}
	return nil
}

type AnyValue_BytesValue struct {
	BytesValue []byte
}

func (m *AnyValue) GetBytesValue() []byte {
	if v, ok := m.GetValue().(*AnyValue_BytesValue); ok {
		return v.BytesValue
	}
	return nil
}

type AnyValue struct {
	Value any
}

var (
	protoPoolAnyValue = sync.Pool{
		New: func() any {
			return &AnyValue{}
		},
	}

	ProtoPoolAnyValue_StringValue = sync.Pool{
		New: func() any {
			return &AnyValue_StringValue{}
		},
	}

	ProtoPoolAnyValue_BoolValue = sync.Pool{
		New: func() any {
			return &AnyValue_BoolValue{}
		},
	}

	ProtoPoolAnyValue_IntValue = sync.Pool{
		New: func() any {
			return &AnyValue_IntValue{}
		},
	}

	ProtoPoolAnyValue_DoubleValue = sync.Pool{
		New: func() any {
			return &AnyValue_DoubleValue{}
		},
	}

	ProtoPoolAnyValue_ArrayValue = sync.Pool{
		New: func() any {
			return &AnyValue_ArrayValue{}
		},
	}

	ProtoPoolAnyValue_KvlistValue = sync.Pool{
		New: func() any {
			return &AnyValue_KvlistValue{}
		},
	}

	ProtoPoolAnyValue_BytesValue = sync.Pool{
		New: func() any {
			return &AnyValue_BytesValue{}
		},
	}
)

func NewAnyValue() *AnyValue {
	if !UseProtoPooling.IsEnabled() {
		return &AnyValue{}
	}
	return protoPoolAnyValue.Get().(*AnyValue)
}

func DeleteAnyValue(orig *AnyValue, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	switch ov := orig.Value.(type) {
	case *AnyValue_StringValue:
		if UseProtoPooling.IsEnabled() {
			ov.StringValue = ""
			ProtoPoolAnyValue_StringValue.Put(ov)
		}
	case *AnyValue_BoolValue:
		if UseProtoPooling.IsEnabled() {
			ov.BoolValue = false
			ProtoPoolAnyValue_BoolValue.Put(ov)
		}
	case *AnyValue_IntValue:
		if UseProtoPooling.IsEnabled() {
			ov.IntValue = int64(0)
			ProtoPoolAnyValue_IntValue.Put(ov)
		}
	case *AnyValue_DoubleValue:
		if UseProtoPooling.IsEnabled() {
			ov.DoubleValue = float64(0)
			ProtoPoolAnyValue_DoubleValue.Put(ov)
		}
	case *AnyValue_ArrayValue:
		DeleteArrayValue(ov.ArrayValue, true)
		ov.ArrayValue = nil
		ProtoPoolAnyValue_ArrayValue.Put(ov)
	case *AnyValue_KvlistValue:
		DeleteKeyValueList(ov.KvlistValue, true)
		ov.KvlistValue = nil
		ProtoPoolAnyValue_KvlistValue.Put(ov)
	case *AnyValue_BytesValue:
		if UseProtoPooling.IsEnabled() {
			ov.BytesValue = nil
			ProtoPoolAnyValue_BytesValue.Put(ov)
		}
	}
	orig.Reset()
	if nullable {
		protoPoolAnyValue.Put(orig)
	}
}

func CopyAnyValue(dest, src *AnyValue) *AnyValue {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewAnyValue()
	}
	switch t := src.Value.(type) {
	case *AnyValue_StringValue:
		var ov *AnyValue_StringValue
		if !UseProtoPooling.IsEnabled() {
			ov = &AnyValue_StringValue{}
		} else {
			ov = ProtoPoolAnyValue_StringValue.Get().(*AnyValue_StringValue)
		}
		ov.StringValue = t.StringValue
		dest.Value = ov

	case *AnyValue_BoolValue:
		var ov *AnyValue_BoolValue
		if !UseProtoPooling.IsEnabled() {
			ov = &AnyValue_BoolValue{}
		} else {
			ov = ProtoPoolAnyValue_BoolValue.Get().(*AnyValue_BoolValue)
		}
		ov.BoolValue = t.BoolValue
		dest.Value = ov

	case *AnyValue_IntValue:
		var ov *AnyValue_IntValue
		if !UseProtoPooling.IsEnabled() {
			ov = &AnyValue_IntValue{}
		} else {
			ov = ProtoPoolAnyValue_IntValue.Get().(*AnyValue_IntValue)
		}
		ov.IntValue = t.IntValue
		dest.Value = ov

	case *AnyValue_DoubleValue:
		var ov *AnyValue_DoubleValue
		if !UseProtoPooling.IsEnabled() {
			ov = &AnyValue_DoubleValue{}
		} else {
			ov = ProtoPoolAnyValue_DoubleValue.Get().(*AnyValue_DoubleValue)
		}
		ov.DoubleValue = t.DoubleValue
		dest.Value = ov

	case *AnyValue_ArrayValue:
		var ov *AnyValue_ArrayValue
		if !UseProtoPooling.IsEnabled() {
			ov = &AnyValue_ArrayValue{}
		} else {
			ov = ProtoPoolAnyValue_ArrayValue.Get().(*AnyValue_ArrayValue)
		}
		ov.ArrayValue = NewArrayValue()
		CopyArrayValue(ov.ArrayValue, t.ArrayValue)
		dest.Value = ov

	case *AnyValue_KvlistValue:
		var ov *AnyValue_KvlistValue
		if !UseProtoPooling.IsEnabled() {
			ov = &AnyValue_KvlistValue{}
		} else {
			ov = ProtoPoolAnyValue_KvlistValue.Get().(*AnyValue_KvlistValue)
		}
		ov.KvlistValue = NewKeyValueList()
		CopyKeyValueList(ov.KvlistValue, t.KvlistValue)
		dest.Value = ov

	case *AnyValue_BytesValue:
		var ov *AnyValue_BytesValue
		if !UseProtoPooling.IsEnabled() {
			ov = &AnyValue_BytesValue{}
		} else {
			ov = ProtoPoolAnyValue_BytesValue.Get().(*AnyValue_BytesValue)
		}
		ov.BytesValue = t.BytesValue
		dest.Value = ov

	default:
		dest.Value = nil
	}

	return dest
}

func CopyAnyValueSlice(dest, src []AnyValue) []AnyValue {
	var newDest []AnyValue
	if cap(dest) < len(src) {
		newDest = make([]AnyValue, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteAnyValue(&dest[i], false)
		}
	}
	for i := range src {
		CopyAnyValue(&newDest[i], &src[i])
	}
	return newDest
}

func CopyAnyValuePtrSlice(dest, src []*AnyValue) []*AnyValue {
	var newDest []*AnyValue
	if cap(dest) < len(src) {
		newDest = make([]*AnyValue, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewAnyValue()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteAnyValue(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewAnyValue()
		}
	}
	for i := range src {
		CopyAnyValue(newDest[i], src[i])
	}
	return newDest
}

func (orig *AnyValue) Reset() {
	*orig = AnyValue{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *AnyValue) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	switch orig := orig.Value.(type) {
	case *AnyValue_StringValue:
		dest.WriteObjectField("stringValue")
		dest.WriteString(orig.StringValue)
	case *AnyValue_BoolValue:
		dest.WriteObjectField("boolValue")
		dest.WriteBool(orig.BoolValue)
	case *AnyValue_IntValue:
		dest.WriteObjectField("intValue")
		dest.WriteInt64(orig.IntValue)
	case *AnyValue_DoubleValue:
		dest.WriteObjectField("doubleValue")
		dest.WriteFloat64(orig.DoubleValue)
	case *AnyValue_ArrayValue:
		if orig.ArrayValue != nil {
			dest.WriteObjectField("arrayValue")
			orig.ArrayValue.MarshalJSON(dest)
		}
	case *AnyValue_KvlistValue:
		if orig.KvlistValue != nil {
			dest.WriteObjectField("kvlistValue")
			orig.KvlistValue.MarshalJSON(dest)
		}
	case *AnyValue_BytesValue:

		dest.WriteObjectField("bytesValue")
		dest.WriteBytes(orig.BytesValue)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *AnyValue) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {

		case "stringValue", "string_value":
			{
				var ov *AnyValue_StringValue
				if !UseProtoPooling.IsEnabled() {
					ov = &AnyValue_StringValue{}
				} else {
					ov = ProtoPoolAnyValue_StringValue.Get().(*AnyValue_StringValue)
				}
				ov.StringValue = iter.ReadString()
				orig.Value = ov
			}
		case "boolValue", "bool_value":
			{
				var ov *AnyValue_BoolValue
				if !UseProtoPooling.IsEnabled() {
					ov = &AnyValue_BoolValue{}
				} else {
					ov = ProtoPoolAnyValue_BoolValue.Get().(*AnyValue_BoolValue)
				}
				ov.BoolValue = iter.ReadBool()
				orig.Value = ov
			}
		case "intValue", "int_value":
			{
				var ov *AnyValue_IntValue
				if !UseProtoPooling.IsEnabled() {
					ov = &AnyValue_IntValue{}
				} else {
					ov = ProtoPoolAnyValue_IntValue.Get().(*AnyValue_IntValue)
				}
				ov.IntValue = iter.ReadInt64()
				orig.Value = ov
			}
		case "doubleValue", "double_value":
			{
				var ov *AnyValue_DoubleValue
				if !UseProtoPooling.IsEnabled() {
					ov = &AnyValue_DoubleValue{}
				} else {
					ov = ProtoPoolAnyValue_DoubleValue.Get().(*AnyValue_DoubleValue)
				}
				ov.DoubleValue = iter.ReadFloat64()
				orig.Value = ov
			}
		case "arrayValue", "array_value":
			{
				var ov *AnyValue_ArrayValue
				if !UseProtoPooling.IsEnabled() {
					ov = &AnyValue_ArrayValue{}
				} else {
					ov = ProtoPoolAnyValue_ArrayValue.Get().(*AnyValue_ArrayValue)
				}
				ov.ArrayValue = NewArrayValue()
				ov.ArrayValue.UnmarshalJSON(iter)
				orig.Value = ov
			}
		case "kvlistValue", "kvlist_value":
			{
				var ov *AnyValue_KvlistValue
				if !UseProtoPooling.IsEnabled() {
					ov = &AnyValue_KvlistValue{}
				} else {
					ov = ProtoPoolAnyValue_KvlistValue.Get().(*AnyValue_KvlistValue)
				}
				ov.KvlistValue = NewKeyValueList()
				ov.KvlistValue.UnmarshalJSON(iter)
				orig.Value = ov
			}
		case "bytesValue", "bytes_value":
			{
				var ov *AnyValue_BytesValue
				if !UseProtoPooling.IsEnabled() {
					ov = &AnyValue_BytesValue{}
				} else {
					ov = ProtoPoolAnyValue_BytesValue.Get().(*AnyValue_BytesValue)
				}
				ov.BytesValue = iter.ReadBytes()
				orig.Value = ov
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *AnyValue) SizeProto() int {
	var n int
	var l int
	_ = l
	switch orig := orig.Value.(type) {
	case nil:
		_ = orig
		break
	case *AnyValue_StringValue:
		l = len(orig.StringValue)
		n += 1 + proto.Sov(uint64(l)) + l
	case *AnyValue_BoolValue:

		n += 2
	case *AnyValue_IntValue:

		n += 1 + proto.Sov(uint64(orig.IntValue))
	case *AnyValue_DoubleValue:

		n += 9
	case *AnyValue_ArrayValue:
		if orig.ArrayValue != nil {
			l = orig.ArrayValue.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	case *AnyValue_KvlistValue:
		if orig.KvlistValue != nil {
			l = orig.KvlistValue.SizeProto()
			n += 1 + proto.Sov(uint64(l)) + l
		}
	case *AnyValue_BytesValue:
		l = len(orig.BytesValue)
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *AnyValue) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	switch orig := orig.Value.(type) {
	case *AnyValue_StringValue:
		l = len(orig.StringValue)
		pos -= l
		copy(buf[pos:], orig.StringValue)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa

	case *AnyValue_BoolValue:
		pos--
		if orig.BoolValue {
			buf[pos] = 1
		} else {
			buf[pos] = 0
		}
		pos--
		buf[pos] = 0x10

	case *AnyValue_IntValue:
		pos = proto.EncodeVarint(buf, pos, uint64(orig.IntValue))
		pos--
		buf[pos] = 0x18

	case *AnyValue_DoubleValue:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.DoubleValue))
		pos--
		buf[pos] = 0x21

	case *AnyValue_ArrayValue:
		if orig.ArrayValue != nil {
			l = orig.ArrayValue.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x2a
		}
	case *AnyValue_KvlistValue:
		if orig.KvlistValue != nil {
			l = orig.KvlistValue.MarshalProto(buf[:pos])
			pos -= l
			pos = proto.EncodeVarint(buf, pos, uint64(l))
			pos--
			buf[pos] = 0x32
		}
	case *AnyValue_BytesValue:
		l = len(orig.BytesValue)
		pos -= l
		copy(buf[pos:], orig.BytesValue)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a

	}
	return len(buf) - pos
}

func (orig *AnyValue) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *AnyValue_StringValue
			if !UseProtoPooling.IsEnabled() {
				ov = &AnyValue_StringValue{}
			} else {
				ov = ProtoPoolAnyValue_StringValue.Get().(*AnyValue_StringValue)
			}
			ov.StringValue = string(buf[startPos:pos])
			orig.Value = ov

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			var ov *AnyValue_BoolValue
			if !UseProtoPooling.IsEnabled() {
				ov = &AnyValue_BoolValue{}
			} else {
				ov = ProtoPoolAnyValue_BoolValue.Get().(*AnyValue_BoolValue)
			}
			ov.BoolValue = num != 0
			orig.Value = ov

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field IntValue", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			var ov *AnyValue_IntValue
			if !UseProtoPooling.IsEnabled() {
				ov = &AnyValue_IntValue{}
			} else {
				ov = ProtoPoolAnyValue_IntValue.Get().(*AnyValue_IntValue)
			}
			ov.IntValue = int64(num)
			orig.Value = ov

		case 4:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *AnyValue_DoubleValue
			if !UseProtoPooling.IsEnabled() {
				ov = &AnyValue_DoubleValue{}
			} else {
				ov = ProtoPoolAnyValue_DoubleValue.Get().(*AnyValue_DoubleValue)
			}
			ov.DoubleValue = math.Float64frombits(num)
			orig.Value = ov

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ArrayValue", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *AnyValue_ArrayValue
			if !UseProtoPooling.IsEnabled() {
				ov = &AnyValue_ArrayValue{}
			} else {
				ov = ProtoPoolAnyValue_ArrayValue.Get().(*AnyValue_ArrayValue)
			}
			ov.ArrayValue = NewArrayValue()
			err = ov.ArrayValue.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.Value = ov

		case 6:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field KvlistValue", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *AnyValue_KvlistValue
			if !UseProtoPooling.IsEnabled() {
				ov = &AnyValue_KvlistValue{}
			} else {
				ov = ProtoPoolAnyValue_KvlistValue.Get().(*AnyValue_KvlistValue)
			}
			ov.KvlistValue = NewKeyValueList()
			err = ov.KvlistValue.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
			orig.Value = ov

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesValue", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var ov *AnyValue_BytesValue
			if !UseProtoPooling.IsEnabled() {
				ov = &AnyValue_BytesValue{}
			} else {
				ov = ProtoPoolAnyValue_BytesValue.Get().(*AnyValue_BytesValue)
			}
			if length != 0 {
				ov.BytesValue = make([]byte, length)
				copy(ov.BytesValue, buf[startPos:pos])
			}
			orig.Value = ov

		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestAnyValue() *AnyValue {
	orig := NewAnyValue()
	orig.Value = &AnyValue_StringValue{StringValue: "test_stringvalue"}
	return orig
}

func GenTestAnyValuePtrSlice() []*AnyValue {
	orig := make([]*AnyValue, 5)
	orig[0] = NewAnyValue()
	orig[1] = GenTestAnyValue()
	orig[2] = NewAnyValue()
	orig[3] = GenTestAnyValue()
	orig[4] = NewAnyValue()
	return orig
}

func GenTestAnyValueSlice() []AnyValue {
	orig := make([]AnyValue, 5)
	orig[1] = *GenTestAnyValue()
	orig[3] = *GenTestAnyValue()
	return orig
}
