<!-- THIS PART OF THIS FILE IS AUTOGENERATED. DO NOT MODIFY IT. See scripts/generate-docs.sh -->
# search

```text
usage: search [-h] [-t {byte,short,word,dword,qword,pointer,string,bytes,asm}]
              [-1] [-2] [-4] [-8] [-p] [--asm]
              [--arch {powerpc64,aarch64,powerpc,riscv32,riscv64,sparc64,mips64,msp430,alpha,amd64,sparc,thumb,cris,i386,ia64,m68k,mips,s390,none,avr,arm,vax}]
              [--asmbp] [-x] [-e] [-w] [-s STEP] [-l LIMIT] [-a ALIGNED]
              [--save] [--no-save] [-n] [--trunc-out]
              value [mapping_name]

```

Search memory for byte sequences, strings, pointers, and integer values.

By default search results are cached. If you want to cache all results, but only print a subset, use --trunc-out. If you want to cache only a subset of results, and print the results immediately, use --limit. The latter is specially useful if you're searching a huge section of memory.
### Positional arguments

|Positional Argument|Help|
| :--- | :--- |
|value|Value to search for|
|mapping_name|Mapping to search [e.g. libc]|

### Optional arguments

|Short|Long|Help|
| :--- | :--- | :--- |
|-h|--help|show this help message and exit|
|-t|--type|Size of search target (default: 'bytes')|
|-1|--byte|Search for a 1-byte integer|
|-2|--short|Search for a 2-byte integer|
|-4|--dword|Search for a 4-byte integer|
|-8|--qword|Search for an 8-byte integer|
|-p|--pointer|Search for a pointer-width integer|
||--asm|Search for an assembly instruction|
||--arch|Target architecture|
||--asmbp|Set breakpoint for found assembly instruction|
|-x|--hex|Target is a hex-encoded (for bytes/strings)|
|-e|--executable|Search executable segments only|
|-w|--writable|Search writable segments only|
|-s|--step|Step search address forward to next alignment after each hit (ex: 0x1000)|
|-l|--limit|Max results before quitting the search. Differs from --trunc-out in that it will not save all search results before quitting|
|-a|--aligned|Result must be aligned to this byte boundary|
||--save|Save results for further searches with --next. Default comes from config 'auto-save-search'|
||--no-save|Invert --save|
|-n|--next|Search only locations returned by previous search with --save|
||--trunc-out|Truncate the output to 20 results. Differs from --limit in that it will first save all search results|

<!-- END OF AUTOGENERATED PART. Do not modify this line or the line below, they mark the end of the auto-generated part of the file. If you want to extend the documentation in a way which cannot easily be done by adding to the command help description, write below the following line. -->
<!-- ------------\>8---- ----\>8---- ----\>8------------ -->
