<?php
/**
 * Aliases for Special:Nuke
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'Nuke' => [ 'Nuke' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'Nuke' => [ 'حذف_كمي' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'Nuke' => [ 'مسح_كامل' ],
];

/** Avaric (авар) */
$specialPageAliases['av'] = [
	'Nuke' => [ 'Множественное_удаление' ],
];

/** Bashkir (башҡортса) */
$specialPageAliases['ba'] = [
	'Nuke' => [ 'Nuke' ],
];

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)) */
$specialPageAliases['be-tarask'] = [
	'Nuke' => [ 'Масавае_выдаленьне' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'Nuke' => [ 'دسته_جمین_پاک_کورتین' ],
];

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = [
	'Nuke' => [ 'Nuklir' ],
];

/** Bengali (বাংলা) */
$specialPageAliases['bn'] = [
	'Nuke' => [ 'গণ_অপসারণ' ],
];

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = [
	'Nuke' => [ 'Дуккха_дӀаяхар' ],
];

/** Czech (česky) */
$specialPageAliases['cs'] = [
	'Nuke' => [ 'Hromadné_mazání', 'Zničit', 'Zničení' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'Nuke' => [ 'Massenlöschung' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'Nuke' => [ 'Pıperne' ],
];

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = [
	'Nuke' => [ 'Wulašowanje_z_kopicami' ],
];

/** Spanish (español) */
$specialPageAliases['es'] = [
	'Nuke' => [ 'BorradoMasivo', 'Borrado_en_masa', 'Borrado_masivo' ],
];

/** Estonian (eesti) */
$specialPageAliases['et'] = [
	'Nuke' => [ 'Lauskustutamine' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'Nuke' => [ 'حذف_دسته‌جمعی' ],
];

/** Finnish (suomi) */
$specialPageAliases['fi'] = [
	'Nuke' => [ 'Massapoista' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'Nuke' => [ 'Eliminar_en_masa' ],
];

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = [
	'Nuke' => [ 'Masseleschig' ],
];

/** Hawaiian (Hawai`i) */
$specialPageAliases['haw'] = [
	'Nuke' => [ 'Luku' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'Nuke' => [ 'מחיקה_מרובה' ],
];

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = [
	'Nuke' => [ 'कई_पृष्ठ_हटाएँ', 'कई_पृष्ठ_हटायें', 'न्यूक' ],
];

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = [
	'Nuke' => [ 'Masowe_wušmórnjenje' ],
];

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = [
	'Nuke' => [ 'Dechouke' ],
];

/** Hungarian (magyar) */
$specialPageAliases['hu'] = [
	'Nuke' => [ 'Kiirtás' ],
];

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = [
	'Nuke' => [ 'Deler_in_massa' ],
];

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = [
	'Nuke' => [ 'Nuklir' ],
];

/** Icelandic (íslenska) */
$specialPageAliases['is'] = [
	'Nuke' => [ 'Fjöldaeyða' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'Nuke' => [ 'CancellazioneMassiva' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'Nuke' => [ 'まとめて削除' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'Nuke' => [ '문서대량삭제' ],
];

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = [
	'Nuke' => [ 'Maßesch_Sigge_Fottschmiiße' ],
];

/** Ladino (Ladino) */
$specialPageAliases['lad'] = [
	'Nuke' => [ 'Bombardea' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'Nuke' => [ 'Masseläschung' ],
];

/** Northern Luri (لۊری شومالی) */
$specialPageAliases['lrc'] = [
	'Nuke' => [ 'أتومی' ],
];

/** Literary Chinese (文言) */
$specialPageAliases['lzh'] = [
	'Nuke' => [ '量刪' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'Nuke' => [ 'Нукирање' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'Nuke' => [ 'സർവ്വനാശം' ],
];

/** Malay (Bahasa Melayu) */
$specialPageAliases['ms'] = [
	'Nuke' => [ 'Hapus_pukal' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'Nuke' => [ 'Massesletting' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = [
	'Nuke' => [ 'Massaal_vortdoon' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'Nuke' => [ 'MassaalVerwijderen' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = [
	'Nuke' => [ 'Massesletting', 'Masseslett' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'Nuke' => [ 'Masowe_usuwanie' ],
];

/** Portuguese (português) */
$specialPageAliases['pt'] = [
	'Nuke' => [ 'Eliminar_em_massa' ],
];

/** Brazilian Portuguese (português do Brasil) */
$specialPageAliases['pt-br'] = [
	'Nuke' => [ 'Eliminar_em_massa' ],
];

/** Russian (русский) */
$specialPageAliases['ru'] = [
	'Nuke' => [ 'Множественное_удаление' ],
];

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = [
	'Nuke' => [ 'न्यूक' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'Nuke' => [ 'CancellazioneMassiva' ],
];

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = [
	'Nuke' => [ 'Zničenie' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)) */
$specialPageAliases['sr-ec'] = [
	'Nuke' => [ 'МасовноБрисање', 'Масовно_брисање' ],
];

/** Serbian (Latin script) (srpski (latinica)) */
$specialPageAliases['sr-el'] = [
	'Nuke' => [ 'MasovnoBrisanje', 'Masovno_brisanje' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'Nuke' => [ 'Massradering' ],
];

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = [
	'Nuke' => [ 'Malawakang_pagbura' ],
];

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = [
	'Nuke' => [ 'Uçur' ],
];

/** Ukrainian (українська) */
$specialPageAliases['uk'] = [
	'Nuke' => [ 'Масове_вилучення', 'Множественное_удаление' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'Nuke' => [ 'اجتماعی_حذف_شدگی' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'Nuke' => [ 'Xóa_hàng_loạt', 'Xoá_hàng_loạt' ],
];

/** Chinese (中文) */
$specialPageAliases['zh'] = [
	'Nuke' => [ '大量删除', '大量刪除' ],
];

/** Simplified Chinese (中文（简体）) */
$specialPageAliases['zh-hans'] = [
	'Nuke' => [ '大量删除' ],
];

/** Traditional Chinese (中文（繁體）) */
$specialPageAliases['zh-hant'] = [
	'Nuke' => [ '大量刪除' ],
];
