//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-image")]
#[cfg(target_vendor = "apple")]
use objc2_core_image::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(target_vendor = "apple")]
use objc2_quartz_core::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsautoresizingmaskoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSAutoresizingMaskOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSAutoresizingMaskOptions: NSUInteger {
        #[doc(alias = "NSViewNotSizable")]
        const ViewNotSizable = 0;
        #[doc(alias = "NSViewMinXMargin")]
        const ViewMinXMargin = 1;
        #[doc(alias = "NSViewWidthSizable")]
        const ViewWidthSizable = 2;
        #[doc(alias = "NSViewMaxXMargin")]
        const ViewMaxXMargin = 4;
        #[doc(alias = "NSViewMinYMargin")]
        const ViewMinYMargin = 8;
        #[doc(alias = "NSViewHeightSizable")]
        const ViewHeightSizable = 16;
        #[doc(alias = "NSViewMaxYMargin")]
        const ViewMaxYMargin = 32;
    }
}

unsafe impl Encode for NSAutoresizingMaskOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSAutoresizingMaskOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbordertype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSBorderType(pub NSUInteger);
impl NSBorderType {
    #[doc(alias = "NSNoBorder")]
    pub const NoBorder: Self = Self(0);
    #[doc(alias = "NSLineBorder")]
    pub const LineBorder: Self = Self(1);
    #[doc(alias = "NSBezelBorder")]
    pub const BezelBorder: Self = Self(2);
    #[doc(alias = "NSGrooveBorder")]
    pub const GrooveBorder: Self = Self(3);
}

unsafe impl Encode for NSBorderType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSBorderType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewlayercontentsredrawpolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSViewLayerContentsRedrawPolicy(pub NSInteger);
impl NSViewLayerContentsRedrawPolicy {
    #[doc(alias = "NSViewLayerContentsRedrawNever")]
    pub const Never: Self = Self(0);
    #[doc(alias = "NSViewLayerContentsRedrawOnSetNeedsDisplay")]
    pub const OnSetNeedsDisplay: Self = Self(1);
    #[doc(alias = "NSViewLayerContentsRedrawDuringViewResize")]
    pub const DuringViewResize: Self = Self(2);
    #[doc(alias = "NSViewLayerContentsRedrawBeforeViewResize")]
    pub const BeforeViewResize: Self = Self(3);
    #[doc(alias = "NSViewLayerContentsRedrawCrossfade")]
    pub const Crossfade: Self = Self(4);
}

unsafe impl Encode for NSViewLayerContentsRedrawPolicy {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSViewLayerContentsRedrawPolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewlayercontentsplacement?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSViewLayerContentsPlacement(pub NSInteger);
impl NSViewLayerContentsPlacement {
    #[doc(alias = "NSViewLayerContentsPlacementScaleAxesIndependently")]
    pub const ScaleAxesIndependently: Self = Self(0);
    #[doc(alias = "NSViewLayerContentsPlacementScaleProportionallyToFit")]
    pub const ScaleProportionallyToFit: Self = Self(1);
    #[doc(alias = "NSViewLayerContentsPlacementScaleProportionallyToFill")]
    pub const ScaleProportionallyToFill: Self = Self(2);
    #[doc(alias = "NSViewLayerContentsPlacementCenter")]
    pub const Center: Self = Self(3);
    #[doc(alias = "NSViewLayerContentsPlacementTop")]
    pub const Top: Self = Self(4);
    #[doc(alias = "NSViewLayerContentsPlacementTopRight")]
    pub const TopRight: Self = Self(5);
    #[doc(alias = "NSViewLayerContentsPlacementRight")]
    pub const Right: Self = Self(6);
    #[doc(alias = "NSViewLayerContentsPlacementBottomRight")]
    pub const BottomRight: Self = Self(7);
    #[doc(alias = "NSViewLayerContentsPlacementBottom")]
    pub const Bottom: Self = Self(8);
    #[doc(alias = "NSViewLayerContentsPlacementBottomLeft")]
    pub const BottomLeft: Self = Self(9);
    #[doc(alias = "NSViewLayerContentsPlacementLeft")]
    pub const Left: Self = Self(10);
    #[doc(alias = "NSViewLayerContentsPlacementTopLeft")]
    pub const TopLeft: Self = Self(11);
}

unsafe impl Encode for NSViewLayerContentsPlacement {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSViewLayerContentsPlacement {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstrackingrecttag?language=objc)
pub type NSTrackingRectTag = NSInteger;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstooltiptag?language=objc)
pub type NSToolTipTag = NSInteger;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsview?language=objc)
    #[unsafe(super(NSResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSResponder")]
    pub struct NSView;
);

#[cfg(all(feature = "NSAccessibilityProtocols", feature = "NSResponder"))]
extern_conformance!(
    unsafe impl NSAccessibility for NSView {}
);

#[cfg(all(feature = "NSAccessibilityProtocols", feature = "NSResponder"))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSView {}
);

#[cfg(all(feature = "NSAnimation", feature = "NSResponder"))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSView {}
);

#[cfg(all(feature = "NSAppearance", feature = "NSResponder"))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSView {}
);

#[cfg(feature = "NSResponder")]
extern_conformance!(
    unsafe impl NSCoding for NSView {}
);

#[cfg(all(feature = "NSDragging", feature = "NSResponder"))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSView {}
);

#[cfg(feature = "NSResponder")]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSUserInterfaceItemIdentification"))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSView {}
);

#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSWindow")]
        #[unsafe(method(window))]
        #[unsafe(method_family = none)]
        pub fn window(&self) -> Option<Retained<NSWindow>>;

        #[unsafe(method(superview))]
        #[unsafe(method_family = none)]
        pub unsafe fn superview(&self) -> Option<Retained<NSView>>;

        #[unsafe(method(subviews))]
        #[unsafe(method_family = none)]
        pub unsafe fn subviews(&self) -> Retained<NSArray<NSView>>;

        /// Setter for [`subviews`][Self::subviews].
        #[unsafe(method(setSubviews:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSubviews(&self, subviews: &NSArray<NSView>);

        #[unsafe(method(isDescendantOf:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDescendantOf(&self, view: &NSView) -> bool;

        #[unsafe(method(ancestorSharedWithView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn ancestorSharedWithView(&self, view: &NSView) -> Option<Retained<NSView>>;

        #[unsafe(method(opaqueAncestor))]
        #[unsafe(method_family = none)]
        pub unsafe fn opaqueAncestor(&self) -> Option<Retained<NSView>>;

        #[unsafe(method(isHidden))]
        #[unsafe(method_family = none)]
        pub unsafe fn isHidden(&self) -> bool;

        /// Setter for [`isHidden`][Self::isHidden].
        #[unsafe(method(setHidden:))]
        #[unsafe(method_family = none)]
        pub fn setHidden(&self, hidden: bool);

        #[unsafe(method(isHiddenOrHasHiddenAncestor))]
        #[unsafe(method_family = none)]
        pub unsafe fn isHiddenOrHasHiddenAncestor(&self) -> bool;

        #[unsafe(method(getRectsBeingDrawn:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getRectsBeingDrawn_count(
            &self,
            rects: *mut *const NSRect,
            count: *mut NSInteger,
        );

        #[unsafe(method(needsToDrawRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn needsToDrawRect(&self, rect: NSRect) -> bool;

        #[unsafe(method(wantsDefaultClipping))]
        #[unsafe(method_family = none)]
        pub unsafe fn wantsDefaultClipping(&self) -> bool;

        #[unsafe(method(viewDidHide))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidHide(&self);

        #[unsafe(method(viewDidUnhide))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidUnhide(&self);

        #[unsafe(method(addSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addSubview(&self, view: &NSView);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(addSubview:positioned:relativeTo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addSubview_positioned_relativeTo(
            &self,
            view: &NSView,
            place: NSWindowOrderingMode,
            other_view: Option<&NSView>,
        );

        #[unsafe(method(sortSubviewsUsingFunction:context:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sortSubviewsUsingFunction_context(
            &self,
            compare: unsafe extern "C-unwind" fn(
                NonNull<NSView>,
                NonNull<NSView>,
                *mut c_void,
            ) -> NSComparisonResult,
            context: *mut c_void,
        );

        #[cfg(feature = "NSWindow")]
        #[unsafe(method(viewWillMoveToWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWillMoveToWindow(&self, new_window: Option<&NSWindow>);

        #[unsafe(method(viewDidMoveToWindow))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidMoveToWindow(&self);

        #[unsafe(method(viewWillMoveToSuperview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWillMoveToSuperview(&self, new_superview: Option<&NSView>);

        #[unsafe(method(viewDidMoveToSuperview))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidMoveToSuperview(&self);

        #[unsafe(method(didAddSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didAddSubview(&self, subview: &NSView);

        #[unsafe(method(willRemoveSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willRemoveSubview(&self, subview: &NSView);

        #[unsafe(method(removeFromSuperview))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeFromSuperview(&self);

        #[unsafe(method(replaceSubview:with:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceSubview_with(&self, old_view: &NSView, new_view: &NSView);

        #[unsafe(method(removeFromSuperviewWithoutNeedingDisplay))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeFromSuperviewWithoutNeedingDisplay(&self);

        #[unsafe(method(viewDidChangeBackingProperties))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidChangeBackingProperties(&self);

        #[unsafe(method(postsFrameChangedNotifications))]
        #[unsafe(method_family = none)]
        pub unsafe fn postsFrameChangedNotifications(&self) -> bool;

        /// Setter for [`postsFrameChangedNotifications`][Self::postsFrameChangedNotifications].
        #[unsafe(method(setPostsFrameChangedNotifications:))]
        #[unsafe(method_family = none)]
        pub fn setPostsFrameChangedNotifications(&self, posts_frame_changed_notifications: bool);

        #[unsafe(method(resizeSubviewsWithOldSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resizeSubviewsWithOldSize(&self, old_size: NSSize);

        #[unsafe(method(resizeWithOldSuperviewSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resizeWithOldSuperviewSize(&self, old_size: NSSize);

        #[unsafe(method(autoresizesSubviews))]
        #[unsafe(method_family = none)]
        pub unsafe fn autoresizesSubviews(&self) -> bool;

        /// Setter for [`autoresizesSubviews`][Self::autoresizesSubviews].
        #[unsafe(method(setAutoresizesSubviews:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutoresizesSubviews(&self, autoresizes_subviews: bool);

        #[unsafe(method(autoresizingMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn autoresizingMask(&self) -> NSAutoresizingMaskOptions;

        /// Setter for [`autoresizingMask`][Self::autoresizingMask].
        #[unsafe(method(setAutoresizingMask:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutoresizingMask(&self, autoresizing_mask: NSAutoresizingMaskOptions);

        #[unsafe(method(setFrameOrigin:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFrameOrigin(&self, new_origin: NSPoint);

        #[unsafe(method(setFrameSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFrameSize(&self, new_size: NSSize);

        #[unsafe(method(frame))]
        #[unsafe(method_family = none)]
        pub fn frame(&self) -> NSRect;

        /// Setter for [`frame`][Self::frame].
        #[unsafe(method(setFrame:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFrame(&self, frame: NSRect);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(frameRotation))]
        #[unsafe(method_family = none)]
        pub unsafe fn frameRotation(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`frameRotation`][Self::frameRotation].
        #[unsafe(method(setFrameRotation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFrameRotation(&self, frame_rotation: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(frameCenterRotation))]
        #[unsafe(method_family = none)]
        pub unsafe fn frameCenterRotation(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`frameCenterRotation`][Self::frameCenterRotation].
        #[unsafe(method(setFrameCenterRotation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFrameCenterRotation(&self, frame_center_rotation: CGFloat);

        #[unsafe(method(setBoundsOrigin:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBoundsOrigin(&self, new_origin: NSPoint);

        #[unsafe(method(setBoundsSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBoundsSize(&self, new_size: NSSize);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(boundsRotation))]
        #[unsafe(method_family = none)]
        pub unsafe fn boundsRotation(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`boundsRotation`][Self::boundsRotation].
        #[unsafe(method(setBoundsRotation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBoundsRotation(&self, bounds_rotation: CGFloat);

        #[unsafe(method(translateOriginToPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn translateOriginToPoint(&self, translation: NSPoint);

        #[unsafe(method(scaleUnitSquareToSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn scaleUnitSquareToSize(&self, new_unit_size: NSSize);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(rotateByAngle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rotateByAngle(&self, angle: CGFloat);

        #[unsafe(method(bounds))]
        #[unsafe(method_family = none)]
        pub fn bounds(&self) -> NSRect;

        /// Setter for [`bounds`][Self::bounds].
        #[unsafe(method(setBounds:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBounds(&self, bounds: NSRect);

        #[unsafe(method(isFlipped))]
        #[unsafe(method_family = none)]
        pub fn isFlipped(&self) -> bool;

        #[unsafe(method(isRotatedFromBase))]
        #[unsafe(method_family = none)]
        pub unsafe fn isRotatedFromBase(&self) -> bool;

        #[unsafe(method(isRotatedOrScaledFromBase))]
        #[unsafe(method_family = none)]
        pub unsafe fn isRotatedOrScaledFromBase(&self) -> bool;

        #[unsafe(method(isOpaque))]
        #[unsafe(method_family = none)]
        pub unsafe fn isOpaque(&self) -> bool;

        #[unsafe(method(convertPoint:fromView:))]
        #[unsafe(method_family = none)]
        pub fn convertPoint_fromView(&self, point: NSPoint, view: Option<&NSView>) -> NSPoint;

        #[unsafe(method(convertPoint:toView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertPoint_toView(&self, point: NSPoint, view: Option<&NSView>) -> NSPoint;

        #[unsafe(method(convertSize:fromView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertSize_fromView(&self, size: NSSize, view: Option<&NSView>) -> NSSize;

        #[unsafe(method(convertSize:toView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertSize_toView(&self, size: NSSize, view: Option<&NSView>) -> NSSize;

        #[unsafe(method(convertRect:fromView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertRect_fromView(&self, rect: NSRect, view: Option<&NSView>) -> NSRect;

        #[unsafe(method(convertRect:toView:))]
        #[unsafe(method_family = none)]
        pub fn convertRect_toView(&self, rect: NSRect, view: Option<&NSView>) -> NSRect;

        #[unsafe(method(backingAlignedRect:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn backingAlignedRect_options(
            &self,
            rect: NSRect,
            options: NSAlignmentOptions,
        ) -> NSRect;

        #[unsafe(method(centerScanRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn centerScanRect(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(convertPointToBacking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertPointToBacking(&self, point: NSPoint) -> NSPoint;

        #[unsafe(method(convertPointFromBacking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertPointFromBacking(&self, point: NSPoint) -> NSPoint;

        #[unsafe(method(convertSizeToBacking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertSizeToBacking(&self, size: NSSize) -> NSSize;

        #[unsafe(method(convertSizeFromBacking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertSizeFromBacking(&self, size: NSSize) -> NSSize;

        #[unsafe(method(convertRectToBacking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertRectToBacking(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(convertRectFromBacking:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertRectFromBacking(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(convertPointToLayer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertPointToLayer(&self, point: NSPoint) -> NSPoint;

        #[unsafe(method(convertPointFromLayer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertPointFromLayer(&self, point: NSPoint) -> NSPoint;

        #[unsafe(method(convertSizeToLayer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertSizeToLayer(&self, size: NSSize) -> NSSize;

        #[unsafe(method(convertSizeFromLayer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertSizeFromLayer(&self, size: NSSize) -> NSSize;

        #[unsafe(method(convertRectToLayer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertRectToLayer(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(convertRectFromLayer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertRectFromLayer(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(canDrawConcurrently))]
        #[unsafe(method_family = none)]
        pub unsafe fn canDrawConcurrently(&self) -> bool;

        /// Setter for [`canDrawConcurrently`][Self::canDrawConcurrently].
        #[unsafe(method(setCanDrawConcurrently:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCanDrawConcurrently(&self, can_draw_concurrently: bool);

        #[deprecated = "If a view needs display, -drawRect: or -updateLayer will be called automatically when the view is able to draw.  To check whether a view is in a window, call -window.  To check whether a view is hidden, call -isHiddenOrHasHiddenAncestor."]
        #[unsafe(method(canDraw))]
        #[unsafe(method_family = none)]
        pub unsafe fn canDraw(&self) -> bool;

        #[unsafe(method(setNeedsDisplayInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsDisplayInRect(&self, invalid_rect: NSRect);

        #[unsafe(method(needsDisplay))]
        #[unsafe(method_family = none)]
        pub unsafe fn needsDisplay(&self) -> bool;

        /// Setter for [`needsDisplay`][Self::needsDisplay].
        #[unsafe(method(setNeedsDisplay:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsDisplay(&self, needs_display: bool);

        #[deprecated = "To draw, subclass NSView and implement -drawRect:; AppKit's automatic deferred display mechanism will call -drawRect: as necessary to display the view."]
        #[unsafe(method(lockFocus))]
        #[unsafe(method_family = none)]
        pub unsafe fn lockFocus(&self);

        #[deprecated = "To draw, subclass NSView and implement -drawRect:; AppKit's automatic deferred display mechanism will call -drawRect: as necessary to display the view."]
        #[unsafe(method(unlockFocus))]
        #[unsafe(method_family = none)]
        pub unsafe fn unlockFocus(&self);

        #[deprecated = "To draw, subclass NSView and implement -drawRect:; AppKit's automatic deferred display mechanism will call -drawRect: as necessary to display the view."]
        #[unsafe(method(lockFocusIfCanDraw))]
        #[unsafe(method_family = none)]
        pub unsafe fn lockFocusIfCanDraw(&self) -> bool;

        #[cfg(feature = "NSGraphicsContext")]
        #[deprecated = "Use -[NSView displayRectIgnoringOpacity:inContext:] to draw a view subtree into a graphics context."]
        #[unsafe(method(lockFocusIfCanDrawInContext:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lockFocusIfCanDrawInContext(&self, context: &NSGraphicsContext) -> bool;

        #[unsafe(method(focusView))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusView(mtm: MainThreadMarker) -> Option<Retained<NSView>>;

        /// The portion of the view that isn’t clipped by its superviews.
        ///
        /// Visibility, as reflected by this property, doesn’t account for whether other view or window objects overlap the current view or whether the current view is installed in a window at all. This value of this property is `NSZeroRect` if the current view is effectively hidden.
        ///
        /// During a printing operation, the visible rectangle is further clipped to the page being imaged.
        #[unsafe(method(visibleRect))]
        #[unsafe(method_family = none)]
        pub fn visibleRect(&self) -> NSRect;

        #[unsafe(method(display))]
        #[unsafe(method_family = none)]
        pub unsafe fn display(&self);

        #[unsafe(method(displayIfNeeded))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayIfNeeded(&self);

        #[unsafe(method(displayIfNeededIgnoringOpacity))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayIfNeededIgnoringOpacity(&self);

        #[unsafe(method(displayRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayRect(&self, rect: NSRect);

        #[unsafe(method(displayIfNeededInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayIfNeededInRect(&self, rect: NSRect);

        #[unsafe(method(displayRectIgnoringOpacity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayRectIgnoringOpacity(&self, rect: NSRect);

        #[unsafe(method(displayIfNeededInRectIgnoringOpacity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayIfNeededInRectIgnoringOpacity(&self, rect: NSRect);

        #[unsafe(method(drawRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawRect(&self, dirty_rect: NSRect);

        #[cfg(feature = "NSGraphicsContext")]
        #[unsafe(method(displayRectIgnoringOpacity:inContext:))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayRectIgnoringOpacity_inContext(
            &self,
            rect: NSRect,
            context: &NSGraphicsContext,
        );

        #[cfg(all(feature = "NSBitmapImageRep", feature = "NSImageRep"))]
        #[unsafe(method(bitmapImageRepForCachingDisplayInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn bitmapImageRepForCachingDisplayInRect(
            &self,
            rect: NSRect,
        ) -> Option<Retained<NSBitmapImageRep>>;

        #[cfg(all(feature = "NSBitmapImageRep", feature = "NSImageRep"))]
        #[unsafe(method(cacheDisplayInRect:toBitmapImageRep:))]
        #[unsafe(method_family = none)]
        pub unsafe fn cacheDisplayInRect_toBitmapImageRep(
            &self,
            rect: NSRect,
            bitmap_image_rep: &NSBitmapImageRep,
        );

        #[unsafe(method(viewWillDraw))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWillDraw(&self);

        #[unsafe(method(scrollPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollPoint(&self, point: NSPoint);

        #[unsafe(method(scrollRectToVisible:))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollRectToVisible(&self, rect: NSRect) -> bool;

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(autoscroll:))]
        #[unsafe(method_family = none)]
        pub unsafe fn autoscroll(&self, event: &NSEvent) -> bool;

        #[unsafe(method(adjustScroll:))]
        #[unsafe(method_family = none)]
        pub unsafe fn adjustScroll(&self, new_visible: NSRect) -> NSRect;

        #[deprecated = "Use NSScrollView to achieve scrolling views."]
        #[unsafe(method(scrollRect:by:))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollRect_by(&self, rect: NSRect, delta: NSSize);

        #[unsafe(method(translateRectsNeedingDisplayInRect:by:))]
        #[unsafe(method_family = none)]
        pub unsafe fn translateRectsNeedingDisplayInRect_by(
            &self,
            clip_rect: NSRect,
            delta: NSSize,
        );

        #[unsafe(method(hitTest:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hitTest(&self, point: NSPoint) -> Option<Retained<NSView>>;

        #[unsafe(method(mouse:inRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn mouse_inRect(&self, point: NSPoint, rect: NSRect) -> bool;

        #[unsafe(method(viewWithTag:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWithTag(&self, tag: NSInteger) -> Option<Retained<NSView>>;

        #[unsafe(method(tag))]
        #[unsafe(method_family = none)]
        pub unsafe fn tag(&self) -> NSInteger;

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(performKeyEquivalent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performKeyEquivalent(&self, event: &NSEvent) -> bool;

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(acceptsFirstMouse:))]
        #[unsafe(method_family = none)]
        pub unsafe fn acceptsFirstMouse(&self, event: Option<&NSEvent>) -> bool;

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(shouldDelayWindowOrderingForEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldDelayWindowOrderingForEvent(&self, event: &NSEvent) -> bool;

        #[unsafe(method(needsPanelToBecomeKey))]
        #[unsafe(method_family = none)]
        pub unsafe fn needsPanelToBecomeKey(&self) -> bool;

        #[unsafe(method(mouseDownCanMoveWindow))]
        #[unsafe(method_family = none)]
        pub unsafe fn mouseDownCanMoveWindow(&self) -> bool;

        #[deprecated = "Use allowedTouchTypes instead"]
        #[unsafe(method(acceptsTouchEvents))]
        #[unsafe(method_family = none)]
        pub unsafe fn acceptsTouchEvents(&self) -> bool;

        /// Setter for [`acceptsTouchEvents`][Self::acceptsTouchEvents].
        #[deprecated = "Use allowedTouchTypes instead"]
        #[unsafe(method(setAcceptsTouchEvents:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAcceptsTouchEvents(&self, accepts_touch_events: bool);

        #[unsafe(method(wantsRestingTouches))]
        #[unsafe(method_family = none)]
        pub unsafe fn wantsRestingTouches(&self) -> bool;

        /// Setter for [`wantsRestingTouches`][Self::wantsRestingTouches].
        #[unsafe(method(setWantsRestingTouches:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWantsRestingTouches(&self, wants_resting_touches: bool);

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(makeBackingLayer))]
        #[unsafe(method_family = none)]
        pub unsafe fn makeBackingLayer(&self) -> Retained<CALayer>;

        #[unsafe(method(layerContentsRedrawPolicy))]
        #[unsafe(method_family = none)]
        pub unsafe fn layerContentsRedrawPolicy(&self) -> NSViewLayerContentsRedrawPolicy;

        /// Setter for [`layerContentsRedrawPolicy`][Self::layerContentsRedrawPolicy].
        #[unsafe(method(setLayerContentsRedrawPolicy:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLayerContentsRedrawPolicy(
            &self,
            layer_contents_redraw_policy: NSViewLayerContentsRedrawPolicy,
        );

        #[unsafe(method(layerContentsPlacement))]
        #[unsafe(method_family = none)]
        pub unsafe fn layerContentsPlacement(&self) -> NSViewLayerContentsPlacement;

        /// Setter for [`layerContentsPlacement`][Self::layerContentsPlacement].
        #[unsafe(method(setLayerContentsPlacement:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLayerContentsPlacement(
            &self,
            layer_contents_placement: NSViewLayerContentsPlacement,
        );

        #[unsafe(method(wantsLayer))]
        #[unsafe(method_family = none)]
        pub unsafe fn wantsLayer(&self) -> bool;

        /// Setter for [`wantsLayer`][Self::wantsLayer].
        #[unsafe(method(setWantsLayer:))]
        #[unsafe(method_family = none)]
        pub fn setWantsLayer(&self, wants_layer: bool);

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(layer))]
        #[unsafe(method_family = none)]
        pub unsafe fn layer(&self) -> Option<Retained<CALayer>>;

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(target_vendor = "apple")]
        /// Setter for [`layer`][Self::layer].
        #[unsafe(method(setLayer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLayer(&self, layer: Option<&CALayer>);

        #[unsafe(method(wantsUpdateLayer))]
        #[unsafe(method_family = none)]
        pub unsafe fn wantsUpdateLayer(&self) -> bool;

        #[unsafe(method(updateLayer))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateLayer(&self);

        #[unsafe(method(canDrawSubviewsIntoLayer))]
        #[unsafe(method_family = none)]
        pub unsafe fn canDrawSubviewsIntoLayer(&self) -> bool;

        /// Setter for [`canDrawSubviewsIntoLayer`][Self::canDrawSubviewsIntoLayer].
        #[unsafe(method(setCanDrawSubviewsIntoLayer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCanDrawSubviewsIntoLayer(&self, can_draw_subviews_into_layer: bool);

        #[unsafe(method(layoutSubtreeIfNeeded))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutSubtreeIfNeeded(&self);

        #[unsafe(method(layout))]
        #[unsafe(method_family = none)]
        pub unsafe fn layout(&self);

        #[unsafe(method(needsLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn needsLayout(&self) -> bool;

        /// Setter for [`needsLayout`][Self::needsLayout].
        #[unsafe(method(setNeedsLayout:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsLayout(&self, needs_layout: bool);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(alphaValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn alphaValue(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`alphaValue`][Self::alphaValue].
        #[unsafe(method(setAlphaValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlphaValue(&self, alpha_value: CGFloat);

        #[unsafe(method(layerUsesCoreImageFilters))]
        #[unsafe(method_family = none)]
        pub unsafe fn layerUsesCoreImageFilters(&self) -> bool;

        /// Setter for [`layerUsesCoreImageFilters`][Self::layerUsesCoreImageFilters].
        #[unsafe(method(setLayerUsesCoreImageFilters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLayerUsesCoreImageFilters(&self, layer_uses_core_image_filters: bool);

        #[cfg(feature = "objc2-core-image")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(backgroundFilters))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundFilters(&self) -> Retained<NSArray<CIFilter>>;

        #[cfg(feature = "objc2-core-image")]
        #[cfg(target_vendor = "apple")]
        /// Setter for [`backgroundFilters`][Self::backgroundFilters].
        #[unsafe(method(setBackgroundFilters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundFilters(&self, background_filters: &NSArray<CIFilter>);

        #[cfg(feature = "objc2-core-image")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(compositingFilter))]
        #[unsafe(method_family = none)]
        pub unsafe fn compositingFilter(&self) -> Option<Retained<CIFilter>>;

        #[cfg(feature = "objc2-core-image")]
        #[cfg(target_vendor = "apple")]
        /// Setter for [`compositingFilter`][Self::compositingFilter].
        #[unsafe(method(setCompositingFilter:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCompositingFilter(&self, compositing_filter: Option<&CIFilter>);

        #[cfg(feature = "objc2-core-image")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(contentFilters))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentFilters(&self) -> Retained<NSArray<CIFilter>>;

        #[cfg(feature = "objc2-core-image")]
        #[cfg(target_vendor = "apple")]
        /// Setter for [`contentFilters`][Self::contentFilters].
        #[unsafe(method(setContentFilters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentFilters(&self, content_filters: &NSArray<CIFilter>);

        #[cfg(feature = "NSShadow")]
        #[unsafe(method(shadow))]
        #[unsafe(method_family = none)]
        pub unsafe fn shadow(&self) -> Option<Retained<NSShadow>>;

        #[cfg(feature = "NSShadow")]
        /// Setter for [`shadow`][Self::shadow].
        #[unsafe(method(setShadow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShadow(&self, shadow: Option<&NSShadow>);

        #[unsafe(method(clipsToBounds))]
        #[unsafe(method_family = none)]
        pub unsafe fn clipsToBounds(&self) -> bool;

        /// Setter for [`clipsToBounds`][Self::clipsToBounds].
        #[unsafe(method(setClipsToBounds:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClipsToBounds(&self, clips_to_bounds: bool);

        #[unsafe(method(postsBoundsChangedNotifications))]
        #[unsafe(method_family = none)]
        pub unsafe fn postsBoundsChangedNotifications(&self) -> bool;

        /// Setter for [`postsBoundsChangedNotifications`][Self::postsBoundsChangedNotifications].
        #[unsafe(method(setPostsBoundsChangedNotifications:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPostsBoundsChangedNotifications(
            &self,
            posts_bounds_changed_notifications: bool,
        );

        #[cfg(feature = "NSScrollView")]
        #[unsafe(method(enclosingScrollView))]
        #[unsafe(method_family = none)]
        pub unsafe fn enclosingScrollView(&self) -> Option<Retained<NSScrollView>>;

        #[cfg(all(feature = "NSEvent", feature = "NSMenu"))]
        #[unsafe(method(menuForEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn menuForEvent(&self, event: &NSEvent) -> Option<Retained<NSMenu>>;

        #[cfg(feature = "NSMenu")]
        #[unsafe(method(defaultMenu))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultMenu(mtm: MainThreadMarker) -> Option<Retained<NSMenu>>;

        #[cfg(all(feature = "NSEvent", feature = "NSMenu"))]
        /// A contextual menu is being opened from the receiving view.
        /// The view should update any visual state in response — such as making a selection.
        ///
        /// Parameter `menu`: The contextual menu that is being opened on the view
        ///
        /// Parameter `event`: The event that caused the menu to open.
        #[unsafe(method(willOpenMenu:withEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willOpenMenu_withEvent(&self, menu: &NSMenu, event: &NSEvent);

        #[cfg(all(feature = "NSEvent", feature = "NSMenu"))]
        /// A contextual menu shown from the receiving view has been closed. This is only called if the menu had been opened and the view previously received
        /// `-willOpenMenu:withEvent:.`The view should update any visual state in response — such as removing a temporary selection.
        ///
        /// Parameter `menu`: The contextual menu that was open on the view
        ///
        /// Parameter `event`: The event that caused the menu to close. This may be nil if there is no specific event that triggered the closing.
        #[unsafe(method(didCloseMenu:withEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didCloseMenu_withEvent(&self, menu: &NSMenu, event: Option<&NSEvent>);

        #[unsafe(method(toolTip))]
        #[unsafe(method_family = none)]
        pub unsafe fn toolTip(&self) -> Option<Retained<NSString>>;

        /// Setter for [`toolTip`][Self::toolTip].
        #[unsafe(method(setToolTip:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setToolTip(&self, tool_tip: Option<&NSString>);

        #[unsafe(method(addToolTipRect:owner:userData:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addToolTipRect_owner_userData(
            &self,
            rect: NSRect,
            owner: &AnyObject,
            data: *mut c_void,
        ) -> NSToolTipTag;

        #[unsafe(method(removeToolTip:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeToolTip(&self, tag: NSToolTipTag);

        #[unsafe(method(removeAllToolTips))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllToolTips(&self);

        #[unsafe(method(viewWillStartLiveResize))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWillStartLiveResize(&self);

        #[unsafe(method(viewDidEndLiveResize))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidEndLiveResize(&self);

        #[unsafe(method(inLiveResize))]
        #[unsafe(method_family = none)]
        pub unsafe fn inLiveResize(&self) -> bool;

        #[unsafe(method(preservesContentDuringLiveResize))]
        #[unsafe(method_family = none)]
        pub unsafe fn preservesContentDuringLiveResize(&self) -> bool;

        #[unsafe(method(rectPreservedDuringLiveResize))]
        #[unsafe(method_family = none)]
        pub unsafe fn rectPreservedDuringLiveResize(&self) -> NSRect;

        #[cfg(feature = "NSTextInputContext")]
        #[unsafe(method(inputContext))]
        #[unsafe(method_family = none)]
        pub fn inputContext(&self) -> Option<Retained<NSTextInputContext>>;

        #[unsafe(method(rectForSmartMagnificationAtPoint:inRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rectForSmartMagnificationAtPoint_inRect(
            &self,
            location: NSPoint,
            visible_rect: NSRect,
        ) -> NSRect;

        #[cfg(feature = "NSUserInterfaceLayout")]
        #[unsafe(method(userInterfaceLayoutDirection))]
        #[unsafe(method_family = none)]
        pub unsafe fn userInterfaceLayoutDirection(&self) -> NSUserInterfaceLayoutDirection;

        #[cfg(feature = "NSUserInterfaceLayout")]
        /// Setter for [`userInterfaceLayoutDirection`][Self::userInterfaceLayoutDirection].
        #[unsafe(method(setUserInterfaceLayoutDirection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserInterfaceLayoutDirection(
            &self,
            user_interface_layout_direction: NSUserInterfaceLayoutDirection,
        );

        #[unsafe(method(prepareForReuse))]
        #[unsafe(method_family = none)]
        pub unsafe fn prepareForReuse(&self);

        #[unsafe(method(isCompatibleWithResponsiveScrolling))]
        #[unsafe(method_family = none)]
        pub unsafe fn isCompatibleWithResponsiveScrolling(mtm: MainThreadMarker) -> bool;

        #[unsafe(method(prepareContentInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn prepareContentInRect(&self, rect: NSRect);

        #[unsafe(method(preparedContentRect))]
        #[unsafe(method_family = none)]
        pub unsafe fn preparedContentRect(&self) -> NSRect;

        /// Setter for [`preparedContentRect`][Self::preparedContentRect].
        #[unsafe(method(setPreparedContentRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreparedContentRect(&self, prepared_content_rect: NSRect);

        #[unsafe(method(allowsVibrancy))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsVibrancy(&self) -> bool;

        /// Override point for reacting to the effective appearance of the receiver changing. At this point `effectiveAppearance` property reflects the new appearance.
        #[unsafe(method(viewDidChangeEffectiveAppearance))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidChangeEffectiveAppearance(&self);
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewlayercontentscaledelegate?language=objc)
    pub unsafe trait NSViewLayerContentScaleDelegate: NSObjectProtocol {
        #[cfg(all(
            feature = "NSResponder",
            feature = "NSWindow",
            feature = "objc2-core-foundation",
            feature = "objc2-quartz-core"
        ))]
        #[cfg(target_vendor = "apple")]
        #[optional]
        #[unsafe(method(layer:shouldInheritContentsScale:fromWindow:))]
        #[unsafe(method_family = none)]
        unsafe fn layer_shouldInheritContentsScale_fromWindow(
            &self,
            layer: &CALayer,
            new_scale: CGFloat,
            window: &NSWindow,
        ) -> bool;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewtooltipowner?language=objc)
    pub unsafe trait NSViewToolTipOwner: NSObjectProtocol + MainThreadOnly {
        #[cfg(feature = "NSResponder")]
        #[unsafe(method(view:stringForToolTip:point:userData:))]
        #[unsafe(method_family = none)]
        unsafe fn view_stringForToolTip_point_userData(
            &self,
            view: &NSView,
            tag: NSToolTipTag,
            point: NSPoint,
            data: *mut c_void,
        ) -> Retained<NSString>;
    }
);

extern_protocol!(
    /// A protocol to request information from NSView subclasses about the selected content in the view.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewcontentselectioninfo?language=objc)
    pub unsafe trait NSViewContentSelectionInfo: NSObjectProtocol {
        #[optional]
        #[unsafe(method(selectionAnchorRect))]
        #[unsafe(method_family = none)]
        unsafe fn selectionAnchorRect(&self) -> NSRect;
    }
);

/// NSKeyboardUI.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[unsafe(method(nextKeyView))]
        #[unsafe(method_family = none)]
        pub unsafe fn nextKeyView(&self) -> Option<Retained<NSView>>;

        /// Setter for [`nextKeyView`][Self::nextKeyView].
        #[unsafe(method(setNextKeyView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNextKeyView(&self, next_key_view: Option<&NSView>);

        #[unsafe(method(previousKeyView))]
        #[unsafe(method_family = none)]
        pub unsafe fn previousKeyView(&self) -> Option<Retained<NSView>>;

        #[unsafe(method(nextValidKeyView))]
        #[unsafe(method_family = none)]
        pub unsafe fn nextValidKeyView(&self) -> Option<Retained<NSView>>;

        #[unsafe(method(previousValidKeyView))]
        #[unsafe(method_family = none)]
        pub unsafe fn previousValidKeyView(&self) -> Option<Retained<NSView>>;

        #[unsafe(method(canBecomeKeyView))]
        #[unsafe(method_family = none)]
        pub unsafe fn canBecomeKeyView(&self) -> bool;

        #[unsafe(method(setKeyboardFocusRingNeedsDisplayInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setKeyboardFocusRingNeedsDisplayInRect(&self, rect: NSRect);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(focusRingType))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusRingType(&self) -> NSFocusRingType;

        #[cfg(feature = "NSGraphics")]
        /// Setter for [`focusRingType`][Self::focusRingType].
        #[unsafe(method(setFocusRingType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFocusRingType(&self, focus_ring_type: NSFocusRingType);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(defaultFocusRingType))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultFocusRingType(mtm: MainThreadMarker) -> NSFocusRingType;

        #[unsafe(method(drawFocusRingMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawFocusRingMask(&self);

        #[unsafe(method(focusRingMaskBounds))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusRingMaskBounds(&self) -> NSRect;

        #[unsafe(method(noteFocusRingMaskChanged))]
        #[unsafe(method_family = none)]
        pub unsafe fn noteFocusRingMaskChanged(&self);
    );
}

/// NSPrinting.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(writeEPSInsideRect:toPasteboard:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeEPSInsideRect_toPasteboard(
            &self,
            rect: NSRect,
            pasteboard: &NSPasteboard,
        );

        #[unsafe(method(dataWithEPSInsideRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataWithEPSInsideRect(&self, rect: NSRect) -> Retained<NSData>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(writePDFInsideRect:toPasteboard:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writePDFInsideRect_toPasteboard(
            &self,
            rect: NSRect,
            pasteboard: &NSPasteboard,
        );

        #[unsafe(method(dataWithPDFInsideRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataWithPDFInsideRect(&self, rect: NSRect) -> Retained<NSData>;

        #[unsafe(method(print:))]
        #[unsafe(method_family = none)]
        pub unsafe fn print(&self, sender: Option<&AnyObject>);

        #[unsafe(method(knowsPageRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn knowsPageRange(&self, range: NSRangePointer) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(heightAdjustLimit))]
        #[unsafe(method_family = none)]
        pub unsafe fn heightAdjustLimit(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(widthAdjustLimit))]
        #[unsafe(method_family = none)]
        pub unsafe fn widthAdjustLimit(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(adjustPageWidthNew:left:right:limit:))]
        #[unsafe(method_family = none)]
        pub unsafe fn adjustPageWidthNew_left_right_limit(
            &self,
            new_right: NonNull<CGFloat>,
            old_left: CGFloat,
            old_right: CGFloat,
            right_limit: CGFloat,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(adjustPageHeightNew:top:bottom:limit:))]
        #[unsafe(method_family = none)]
        pub unsafe fn adjustPageHeightNew_top_bottom_limit(
            &self,
            new_bottom: NonNull<CGFloat>,
            old_top: CGFloat,
            old_bottom: CGFloat,
            bottom_limit: CGFloat,
        );

        #[unsafe(method(rectForPage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rectForPage(&self, page: NSInteger) -> NSRect;

        #[unsafe(method(locationOfPrintRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn locationOfPrintRect(&self, rect: NSRect) -> NSPoint;

        #[unsafe(method(drawPageBorderWithSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawPageBorderWithSize(&self, border_size: NSSize);

        #[unsafe(method(pageHeader))]
        #[unsafe(method_family = none)]
        pub unsafe fn pageHeader(&self) -> Retained<NSAttributedString>;

        #[unsafe(method(pageFooter))]
        #[unsafe(method_family = none)]
        pub unsafe fn pageFooter(&self) -> Retained<NSAttributedString>;

        /// * This method is obsolete.  It will never be invoked from within AppKit, and NSView's implementation of it does nothing. **
        #[deprecated = "This is never invoked and the NSView implementation does nothing"]
        #[unsafe(method(drawSheetBorderWithSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawSheetBorderWithSize(&self, border_size: NSSize);

        #[unsafe(method(printJobTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn printJobTitle(&self) -> Retained<NSString>;

        #[unsafe(method(beginDocument))]
        #[unsafe(method_family = none)]
        pub unsafe fn beginDocument(&self);

        #[unsafe(method(endDocument))]
        #[unsafe(method_family = none)]
        pub unsafe fn endDocument(&self);

        #[unsafe(method(beginPageInRect:atPlacement:))]
        #[unsafe(method_family = none)]
        pub unsafe fn beginPageInRect_atPlacement(&self, rect: NSRect, location: NSPoint);

        #[unsafe(method(endPage))]
        #[unsafe(method_family = none)]
        pub unsafe fn endPage(&self);
    );
}

/// NSDrag.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[cfg(all(
            feature = "NSDragging",
            feature = "NSDraggingItem",
            feature = "NSDraggingSession",
            feature = "NSEvent"
        ))]
        #[unsafe(method(beginDraggingSessionWithItems:event:source:))]
        #[unsafe(method_family = none)]
        pub unsafe fn beginDraggingSessionWithItems_event_source(
            &self,
            items: &NSArray<NSDraggingItem>,
            event: &NSEvent,
            source: &ProtocolObject<dyn NSDraggingSource>,
        ) -> Retained<NSDraggingSession>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(registeredDraggedTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn registeredDraggedTypes(&self) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(registerForDraggedTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerForDraggedTypes(&self, new_types: &NSArray<NSPasteboardType>);

        #[unsafe(method(unregisterDraggedTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn unregisterDraggedTypes(&self);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewfullscreenmodeoptionkey?language=objc)
// NS_TYPED_ENUM
pub type NSViewFullScreenModeOptionKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfullscreenmodeallscreens?language=objc)
    pub static NSFullScreenModeAllScreens: &'static NSViewFullScreenModeOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfullscreenmodesetting?language=objc)
    pub static NSFullScreenModeSetting: &'static NSViewFullScreenModeOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfullscreenmodewindowlevel?language=objc)
    pub static NSFullScreenModeWindowLevel: &'static NSViewFullScreenModeOptionKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfullscreenmodeapplicationpresentationoptions?language=objc)
    pub static NSFullScreenModeApplicationPresentationOptions:
        &'static NSViewFullScreenModeOptionKey;
}

/// NSFullScreenMode.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[cfg(feature = "NSScreen")]
        #[unsafe(method(enterFullScreenMode:withOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn enterFullScreenMode_withOptions(
            &self,
            screen: &NSScreen,
            options: Option<&NSDictionary<NSViewFullScreenModeOptionKey, AnyObject>>,
        ) -> bool;

        #[unsafe(method(exitFullScreenModeWithOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn exitFullScreenModeWithOptions(
            &self,
            options: Option<&NSDictionary<NSViewFullScreenModeOptionKey, AnyObject>>,
        );

        #[unsafe(method(isInFullScreenMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn isInFullScreenMode(&self) -> bool;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdefinitionoptionkey?language=objc)
// NS_TYPED_ENUM
pub type NSDefinitionOptionKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdefinitionpresentationtypekey?language=objc)
    pub static NSDefinitionPresentationTypeKey: &'static NSDefinitionOptionKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdefinitionpresentationtype?language=objc)
// NS_TYPED_ENUM
pub type NSDefinitionPresentationType = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdefinitionpresentationtypeoverlay?language=objc)
    pub static NSDefinitionPresentationTypeOverlay: &'static NSDefinitionPresentationType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdefinitionpresentationtypedictionaryapplication?language=objc)
    pub static NSDefinitionPresentationTypeDictionaryApplication:
        &'static NSDefinitionPresentationType;
}

/// NSDefinition.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[unsafe(method(showDefinitionForAttributedString:atPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn showDefinitionForAttributedString_atPoint(
            &self,
            attr_string: Option<&NSAttributedString>,
            text_baseline_origin: NSPoint,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(showDefinitionForAttributedString:range:options:baselineOriginProvider:))]
        #[unsafe(method_family = none)]
        pub unsafe fn showDefinitionForAttributedString_range_options_baselineOriginProvider(
            &self,
            attr_string: Option<&NSAttributedString>,
            target_range: NSRange,
            options: Option<&NSDictionary<NSDefinitionOptionKey, AnyObject>>,
            origin_provider: Option<&block2::DynBlock<dyn Fn(NSRange) -> NSPoint>>,
        );
    );
}

/// NSFindIndicator.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[unsafe(method(isDrawingFindIndicator))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDrawingFindIndicator(&self) -> bool;
    );
}

/// NSGestureRecognizer.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[cfg(feature = "NSGestureRecognizer")]
        #[unsafe(method(gestureRecognizers))]
        #[unsafe(method_family = none)]
        pub unsafe fn gestureRecognizers(&self) -> Retained<NSArray<NSGestureRecognizer>>;

        #[cfg(feature = "NSGestureRecognizer")]
        /// Setter for [`gestureRecognizers`][Self::gestureRecognizers].
        #[unsafe(method(setGestureRecognizers:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setGestureRecognizers(
            &self,
            gesture_recognizers: &NSArray<NSGestureRecognizer>,
        );

        #[cfg(feature = "NSGestureRecognizer")]
        #[unsafe(method(addGestureRecognizer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addGestureRecognizer(&self, gesture_recognizer: &NSGestureRecognizer);

        #[cfg(feature = "NSGestureRecognizer")]
        #[unsafe(method(removeGestureRecognizer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeGestureRecognizer(&self, gesture_recognizer: &NSGestureRecognizer);
    );
}

/// NSTouchBar.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[cfg(feature = "NSTouch")]
        #[unsafe(method(allowedTouchTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowedTouchTypes(&self) -> NSTouchTypeMask;

        #[cfg(feature = "NSTouch")]
        /// Setter for [`allowedTouchTypes`][Self::allowedTouchTypes].
        #[unsafe(method(setAllowedTouchTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowedTouchTypes(&self, allowed_touch_types: NSTouchTypeMask);
    );
}

/// NSSafeAreas.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[unsafe(method(safeAreaInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn safeAreaInsets(&self) -> NSEdgeInsets;

        #[unsafe(method(additionalSafeAreaInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn additionalSafeAreaInsets(&self) -> NSEdgeInsets;

        /// Setter for [`additionalSafeAreaInsets`][Self::additionalSafeAreaInsets].
        #[unsafe(method(setAdditionalSafeAreaInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAdditionalSafeAreaInsets(&self, additional_safe_area_insets: NSEdgeInsets);

        #[cfg(feature = "NSLayoutGuide")]
        #[unsafe(method(safeAreaLayoutGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn safeAreaLayoutGuide(&self) -> Retained<NSLayoutGuide>;

        #[unsafe(method(safeAreaRect))]
        #[unsafe(method_family = none)]
        pub unsafe fn safeAreaRect(&self) -> NSRect;

        #[cfg(feature = "NSLayoutGuide")]
        #[unsafe(method(layoutMarginsGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutMarginsGuide(&self) -> Retained<NSLayoutGuide>;
    );
}

/// NSTrackingArea.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[cfg(feature = "NSTrackingArea")]
        #[unsafe(method(addTrackingArea:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addTrackingArea(&self, tracking_area: &NSTrackingArea);

        #[cfg(feature = "NSTrackingArea")]
        #[unsafe(method(removeTrackingArea:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeTrackingArea(&self, tracking_area: &NSTrackingArea);

        #[cfg(feature = "NSTrackingArea")]
        #[unsafe(method(trackingAreas))]
        #[unsafe(method_family = none)]
        pub unsafe fn trackingAreas(&self) -> Retained<NSArray<NSTrackingArea>>;

        #[unsafe(method(updateTrackingAreas))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateTrackingAreas(&self);

        #[cfg(feature = "NSCursor")]
        #[unsafe(method(addCursorRect:cursor:))]
        #[unsafe(method_family = none)]
        pub fn addCursorRect_cursor(&self, rect: NSRect, object: &NSCursor);

        #[cfg(feature = "NSCursor")]
        #[unsafe(method(removeCursorRect:cursor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeCursorRect_cursor(&self, rect: NSRect, object: &NSCursor);

        #[unsafe(method(discardCursorRects))]
        #[unsafe(method_family = none)]
        pub unsafe fn discardCursorRects(&self);

        #[unsafe(method(resetCursorRects))]
        #[unsafe(method_family = none)]
        pub unsafe fn resetCursorRects(&self);

        #[unsafe(method(addTrackingRect:owner:userData:assumeInside:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addTrackingRect_owner_userData_assumeInside(
            &self,
            rect: NSRect,
            owner: &AnyObject,
            data: *mut c_void,
            flag: bool,
        ) -> NSTrackingRectTag;

        #[unsafe(method(removeTrackingRect:))]
        #[unsafe(method_family = none)]
        pub fn removeTrackingRect(&self, tag: NSTrackingRectTag);
    );
}

/// NSDisplayLink.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(displayLinkWithTarget:selector:))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayLinkWithTarget_selector(
            &self,
            target: &AnyObject,
            selector: Sel,
        ) -> Retained<CADisplayLink>;
    );
}

/// NSDeprecated.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[cfg(all(feature = "NSEvent", feature = "NSImage", feature = "NSPasteboard"))]
        #[deprecated = "Use -beginDraggingSessionWithItems:event:source: instead"]
        #[unsafe(method(dragImage:at:offset:event:pasteboard:source:slideBack:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dragImage_at_offset_event_pasteboard_source_slideBack(
            &self,
            image: &NSImage,
            view_location: NSPoint,
            initial_offset: NSSize,
            event: &NSEvent,
            pboard: &NSPasteboard,
            source_obj: &AnyObject,
            slide_flag: bool,
        );

        #[cfg(feature = "NSEvent")]
        #[deprecated = "Use -beginDraggingSessionWithItems:event:source: instead"]
        #[unsafe(method(dragFile:fromRect:slideBack:event:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dragFile_fromRect_slideBack_event(
            &self,
            filename: &NSString,
            rect: NSRect,
            flag: bool,
            event: &NSEvent,
        ) -> bool;

        #[cfg(feature = "NSEvent")]
        #[deprecated = "Use -beginDraggingSessionWithItems:event:source: with an NSFilePromiseProvider instead"]
        #[unsafe(method(dragPromisedFilesOfTypes:fromRect:source:slideBack:event:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dragPromisedFilesOfTypes_fromRect_source_slideBack_event(
            &self,
            type_array: &NSArray<NSString>,
            rect: NSRect,
            source_object: &AnyObject,
            flag: bool,
            event: &NSEvent,
        ) -> bool;

        #[deprecated]
        #[unsafe(method(convertPointToBase:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertPointToBase(&self, point: NSPoint) -> NSPoint;

        #[deprecated]
        #[unsafe(method(convertPointFromBase:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertPointFromBase(&self, point: NSPoint) -> NSPoint;

        #[deprecated]
        #[unsafe(method(convertSizeToBase:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertSizeToBase(&self, size: NSSize) -> NSSize;

        #[deprecated]
        #[unsafe(method(convertSizeFromBase:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertSizeFromBase(&self, size: NSSize) -> NSSize;

        #[deprecated]
        #[unsafe(method(convertRectToBase:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertRectToBase(&self, rect: NSRect) -> NSRect;

        #[deprecated]
        #[unsafe(method(convertRectFromBase:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertRectFromBase(&self, rect: NSRect) -> NSRect;

        #[deprecated = "This has always returned NO and had no effect on macOS"]
        #[unsafe(method(performMnemonic:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performMnemonic(&self, string: &NSString) -> bool;

        #[deprecated = "This method no longer does anything"]
        #[unsafe(method(shouldDrawColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldDrawColor(&self) -> bool;

        #[deprecated]
        #[unsafe(method(gState))]
        #[unsafe(method_family = none)]
        pub unsafe fn gState(&self) -> NSInteger;

        #[deprecated]
        #[unsafe(method(allocateGState))]
        #[unsafe(method_family = none)]
        pub unsafe fn allocateGState(&self);

        #[deprecated]
        #[unsafe(method(setUpGState))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUpGState(&self);

        #[deprecated]
        #[unsafe(method(renewGState))]
        #[unsafe(method_family = none)]
        pub unsafe fn renewGState(&self);
    );
}

/// NSWritingToolsCoordinator.
#[cfg(feature = "NSResponder")]
impl NSView {
    extern_methods!(
        #[cfg(feature = "NSWritingToolsCoordinator")]
        #[unsafe(method(writingToolsCoordinator))]
        #[unsafe(method_family = none)]
        pub unsafe fn writingToolsCoordinator(&self)
            -> Option<Retained<NSWritingToolsCoordinator>>;

        #[cfg(feature = "NSWritingToolsCoordinator")]
        /// Setter for [`writingToolsCoordinator`][Self::writingToolsCoordinator].
        #[unsafe(method(setWritingToolsCoordinator:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWritingToolsCoordinator(
            &self,
            writing_tools_coordinator: Option<&NSWritingToolsCoordinator>,
        );
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewframedidchangenotification?language=objc)
    pub static NSViewFrameDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewfocusdidchangenotification?language=objc)
    pub static NSViewFocusDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewboundsdidchangenotification?language=objc)
    pub static NSViewBoundsDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewglobalframedidchangenotification?language=objc)
    pub static NSViewGlobalFrameDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewdidupdatetrackingareasnotification?language=objc)
    pub static NSViewDidUpdateTrackingAreasNotification: &'static NSNotificationName;
}
