#### Note: this error code is no longer emitted by the compiler.

The `not` cfg-predicate was malformed.

Erroneous code example (using `cargo doc`):

```ignore, E0536 (only triggers on cargo doc)
#![feature(doc_cfg)]
#[doc(cfg(not()))]
pub fn main() {

}
```

The `not` predicate expects one cfg-pattern. Example:

```
#![feature(doc_cfg)]
#[doc(cfg(not(target_os = "linux")))] // ok!
pub fn main() {

}
```

For more information about the `cfg` macro, read the section on
[Conditional Compilation][conditional-compilation] in the Reference.

[conditional-compilation]: https://doc.rust-lang.org/reference/conditional-compilation.html
