An externally implementable item is not compatible with its declaration.

Erroneous code example:

```rust,edition2021,compile_fail,E0806
#![feature(extern_item_impls)]

#[eii(foo)]
fn x();

#[foo]
fn y(a: u64) -> u64 {
//~^ ERROR E0806
    a
}


fn main() {}
```

The error here is caused by the fact that `y` implements the
externally implementable item `foo`.
It can only do so if the signature of the implementation `y` matches
that of the declaration of `foo`.
So, to fix this, `y`'s signature must be changed to match that of `x`:

```rust,edition2021
#![feature(extern_item_impls)]

#[eii(foo)]
fn x();

#[foo]
fn y() {}


fn main() {}
```

One common way this can be triggered is by using the wrong
signature for `#[panic_handler]`.
The signature is provided by `core`.

```rust,edition2021,ignore
#![no_std]

#[panic_handler]
fn on_panic() -> ! {
//~^ ERROR E0806

    loop {}
}

fn main() {}
```

Should be:

```rust,edition2021,ignore
#![no_std]

#[panic_handler]
fn on_panic(info: &core::panic::PanicInfo<'_>) -> ! {
    loop {}
}

fn main() {}
```
