//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstackviewgravity?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStackViewGravity(pub NSInteger);
impl NSStackViewGravity {
    #[doc(alias = "NSStackViewGravityTop")]
    pub const Top: Self = Self(1);
    #[doc(alias = "NSStackViewGravityLeading")]
    pub const Leading: Self = Self(1);
    #[doc(alias = "NSStackViewGravityCenter")]
    pub const Center: Self = Self(2);
    #[doc(alias = "NSStackViewGravityBottom")]
    pub const Bottom: Self = Self(3);
    #[doc(alias = "NSStackViewGravityTrailing")]
    pub const Trailing: Self = Self(3);
}

unsafe impl Encode for NSStackViewGravity {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSStackViewGravity {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstackviewdistribution?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStackViewDistribution(pub NSInteger);
impl NSStackViewDistribution {
    /// Default value. NSStackView will not have any special distribution behavior, relying on behavior described by gravity areas and set hugging priorities along the stacking axis.
    #[doc(alias = "NSStackViewDistributionGravityAreas")]
    pub const GravityAreas: Self = Self(-1);
    /// The effective hugging priority in the stacking axis is NSLayoutPriorityRequired, causing the stacked views to tightly fill the container along the stacking axis.
    #[doc(alias = "NSStackViewDistributionFill")]
    pub const Fill: Self = Self(0);
    /// Stacked views will have sizes maintained to be equal as much as possible along the stacking axis. The effective hugging priority in the stacking axis is NSLayoutPriorityRequired.
    #[doc(alias = "NSStackViewDistributionFillEqually")]
    pub const FillEqually: Self = Self(1);
    /// Stacked views will have sizes maintained to be equal, proportionally to their intrinsicContentSizes, as much as possible. The effective hugging priority in the stacking axis is NSLayoutPriorityRequired.
    #[doc(alias = "NSStackViewDistributionFillProportionally")]
    pub const FillProportionally: Self = Self(2);
    /// The space separating stacked views along the stacking axis are maintained to be equal as much as possible while still maintaining the minimum spacing.
    #[doc(alias = "NSStackViewDistributionEqualSpacing")]
    pub const EqualSpacing: Self = Self(3);
    /// Equal center-to-center spacing of the items is maintained as much as possible while still maintaining the minimum spacing between each view.
    #[doc(alias = "NSStackViewDistributionEqualCentering")]
    pub const EqualCentering: Self = Self(4);
}

unsafe impl Encode for NSStackViewDistribution {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSStackViewDistribution {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstackviewvisibilitypriority?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSStackViewVisibilityPriority = c_float;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstackviewvisibilityprioritymusthold?language=objc)
pub static NSStackViewVisibilityPriorityMustHold: NSStackViewVisibilityPriority = 1000 as _;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstackviewvisibilityprioritydetachonlyifnecessary?language=objc)
pub static NSStackViewVisibilityPriorityDetachOnlyIfNecessary: NSStackViewVisibilityPriority =
    900 as _;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstackviewvisibilityprioritynotvisible?language=objc)
pub static NSStackViewVisibilityPriorityNotVisible: NSStackViewVisibilityPriority = 0 as _;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstackviewspacingusedefault?language=objc)
#[cfg(feature = "objc2-core-foundation")]
pub static NSStackViewSpacingUseDefault: CGFloat = c_float::MAX as _;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstackview?language=objc)
    #[unsafe(super(NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSView"))]
    pub struct NSStackView;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSStackView {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSStackView {}
);

#[cfg(all(feature = "NSAnimation", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSStackView {}
);

#[cfg(all(feature = "NSAppearance", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSStackView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSStackView {}
);

#[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSStackView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSStackView {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSStackView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSStackView {
    extern_methods!(
        #[unsafe(method(stackViewWithViews:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stackViewWithViews(
            views: &NSArray<NSView>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSStackViewDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSStackViewDelegate>>,
        );

        #[cfg(feature = "NSUserInterfaceLayout")]
        /// Orientation of the StackView, defaults to NSUserInterfaceLayoutOrientationHorizontal
        #[unsafe(method(orientation))]
        #[unsafe(method_family = none)]
        pub unsafe fn orientation(&self) -> NSUserInterfaceLayoutOrientation;

        #[cfg(feature = "NSUserInterfaceLayout")]
        /// Setter for [`orientation`][Self::orientation].
        #[unsafe(method(setOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOrientation(&self, orientation: NSUserInterfaceLayoutOrientation);

        #[cfg(feature = "NSLayoutConstraint")]
        /// Describes how subviews are aligned within the StackView, defaults to `NSLayoutAttributeCenterY` for horizontal stacks, `NSLayoutAttributeCenterX` for vertical stacks. Setting `NSLayoutAttributeNotAnAttribute` will cause the internal alignment constraints to not be created, and could result in an ambiguous layout. Setting an inapplicable attribute for the set orientation will result in the alignment being ignored (similar to its handling with NSLayoutAttributeNotAnAttribute). The alignment constraints are established at a priority of `NSLayoutPriorityDefaultLow` and are overridable for individual views using external constraints.
        #[unsafe(method(alignment))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignment(&self) -> NSLayoutAttribute;

        #[cfg(feature = "NSLayoutConstraint")]
        /// Setter for [`alignment`][Self::alignment].
        #[unsafe(method(setAlignment:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlignment(&self, alignment: NSLayoutAttribute);

        /// Default padding inside the StackView, around all of the subviews.
        #[unsafe(method(edgeInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn edgeInsets(&self) -> NSEdgeInsets;

        /// Setter for [`edgeInsets`][Self::edgeInsets].
        #[unsafe(method(setEdgeInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEdgeInsets(&self, edge_insets: NSEdgeInsets);

        /// The spacing and sizing distribution of stacked views along the primary axis. Defaults to GravityAreas.
        #[unsafe(method(distribution))]
        #[unsafe(method_family = none)]
        pub unsafe fn distribution(&self) -> NSStackViewDistribution;

        /// Setter for [`distribution`][Self::distribution].
        #[unsafe(method(setDistribution:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDistribution(&self, distribution: NSStackViewDistribution);

        #[cfg(feature = "objc2-core-foundation")]
        /// Default (minimum) spacing between each view
        #[unsafe(method(spacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn spacing(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`spacing`][Self::spacing].
        #[unsafe(method(setSpacing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSpacing(&self, spacing: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setCustomSpacing:afterView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCustomSpacing_afterView(&self, spacing: CGFloat, view: &NSView);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(customSpacingAfterView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn customSpacingAfterView(&self, view: &NSView) -> CGFloat;

        /// If YES, when a stacked view's `hidden` property is set to YES, the view will be detached from the stack and reattached when set to NO. Similarly, if the view has a lowered visibility priority and is detached from the stack view, it will be set as `hidden` rather than removed from the view hierarchy. Defaults to YES for apps linked on the 10.11 SDK or later.
        #[unsafe(method(detachesHiddenViews))]
        #[unsafe(method_family = none)]
        pub unsafe fn detachesHiddenViews(&self) -> bool;

        /// Setter for [`detachesHiddenViews`][Self::detachesHiddenViews].
        #[unsafe(method(setDetachesHiddenViews:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDetachesHiddenViews(&self, detaches_hidden_views: bool);

        /// The list of views that are arranged in a stack by the receiver. They are a subset of
        /// `-subviews,`with potential difference in ordering.
        #[unsafe(method(arrangedSubviews))]
        #[unsafe(method_family = none)]
        pub unsafe fn arrangedSubviews(&self) -> Retained<NSArray<NSView>>;

        /// Adds a view to the end of the arrangedSubviews list. If the view is not a subview of the receiver, it will be added as one.
        #[unsafe(method(addArrangedSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addArrangedSubview(&self, view: &NSView);

        /// Adds a view to the arrangedSubviews list at a specific index.
        /// If the view is already in the arrangedSubviews list, it will move the view to the specified index (but not change the subview index).
        /// If the view is not a subview of the receiver, it will be added as one (not necessarily at the same index).
        #[unsafe(method(insertArrangedSubview:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertArrangedSubview_atIndex(&self, view: &NSView, index: NSInteger);

        /// Removes a subview from the list of arranged subviews without removing it as a subview of the receiver.
        /// Removing the view as a subview (either by -[view removeFromSuperview] or setting the receiver's subviews) will automatically remove it as an arranged subview.
        #[unsafe(method(removeArrangedSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeArrangedSubview(&self, view: &NSView);

        /// The arrangedSubviews that are currently detached/hidden.
        #[unsafe(method(detachedViews))]
        #[unsafe(method_family = none)]
        pub unsafe fn detachedViews(&self) -> Retained<NSArray<NSView>>;

        #[unsafe(method(setVisibilityPriority:forView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setVisibilityPriority_forView(
            &self,
            priority: NSStackViewVisibilityPriority,
            view: &NSView,
        );

        #[unsafe(method(visibilityPriorityForView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn visibilityPriorityForView(
            &self,
            view: &NSView,
        ) -> NSStackViewVisibilityPriority;

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(clippingResistancePriorityForOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn clippingResistancePriorityForOrientation(
            &self,
            orientation: NSLayoutConstraintOrientation,
        ) -> NSLayoutPriority;

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(setClippingResistancePriority:forOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClippingResistancePriority_forOrientation(
            &self,
            clipping_resistance_priority: NSLayoutPriority,
            orientation: NSLayoutConstraintOrientation,
        );

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(huggingPriorityForOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn huggingPriorityForOrientation(
            &self,
            orientation: NSLayoutConstraintOrientation,
        ) -> NSLayoutPriority;

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(setHuggingPriority:forOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHuggingPriority_forOrientation(
            &self,
            hugging_priority: NSLayoutPriority,
            orientation: NSLayoutConstraintOrientation,
        );
    );
}

/// Methods declared on superclass `NSView`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSStackView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSStackView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSStackView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsstackviewdelegate?language=objc)
    pub unsafe trait NSStackViewDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(stackView:willDetachViews:))]
        #[unsafe(method_family = none)]
        unsafe fn stackView_willDetachViews(
            &self,
            stack_view: &NSStackView,
            views: &NSArray<NSView>,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(stackView:didReattachViews:))]
        #[unsafe(method_family = none)]
        unsafe fn stackView_didReattachViews(
            &self,
            stack_view: &NSStackView,
            views: &NSArray<NSView>,
        );
    }
);

/// NSStackViewGravityAreas.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSStackView {
    extern_methods!(
        #[unsafe(method(addView:inGravity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addView_inGravity(&self, view: &NSView, gravity: NSStackViewGravity);

        #[unsafe(method(insertView:atIndex:inGravity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertView_atIndex_inGravity(
            &self,
            view: &NSView,
            index: NSUInteger,
            gravity: NSStackViewGravity,
        );

        #[unsafe(method(removeView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeView(&self, view: &NSView);

        #[unsafe(method(viewsInGravity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewsInGravity(
            &self,
            gravity: NSStackViewGravity,
        ) -> Retained<NSArray<NSView>>;

        #[unsafe(method(setViews:inGravity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setViews_inGravity(
            &self,
            views: &NSArray<NSView>,
            gravity: NSStackViewGravity,
        );

        #[unsafe(method(views))]
        #[unsafe(method_family = none)]
        pub unsafe fn views(&self) -> Retained<NSArray<NSView>>;
    );
}

/// NSStackViewDeprecated.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSStackView {
    extern_methods!(
        #[deprecated = "Set -distribution to NSStackViewDistributionEqualSpacing instead."]
        #[unsafe(method(hasEqualSpacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasEqualSpacing(&self) -> bool;

        /// Setter for [`hasEqualSpacing`][Self::hasEqualSpacing].
        #[deprecated = "Set -distribution to NSStackViewDistributionEqualSpacing instead."]
        #[unsafe(method(setHasEqualSpacing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHasEqualSpacing(&self, has_equal_spacing: bool);
    );
}
