//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uilistcontentconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIListContentConfiguration;
);

extern_conformance!(
    unsafe impl NSCoding for UIListContentConfiguration {}
);

extern_conformance!(
    unsafe impl NSCopying for UIListContentConfiguration {}
);

unsafe impl CopyingHelper for UIListContentConfiguration {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIListContentConfiguration {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UIListContentConfiguration {}
);

#[cfg(feature = "UIContentConfiguration")]
extern_conformance!(
    unsafe impl UIContentConfiguration for UIListContentConfiguration {}
);

impl UIListContentConfiguration {
    extern_methods!(
        /// Returns the default configuration for a list cell.
        /// From iOS 18 onwards, the configuration will automatically adopt the appropriate style for a list when updating for a
        /// new configuration state, by reading the `listEnvironment` trait from the state's trait collection.
        /// Defaults to a cell in a plain-style list.
        #[unsafe(method(cellConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn cellConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns the default configuration for a list cell with subtitle text.
        /// From iOS 18 onwards, the configuration will automatically adopt the appropriate style for a list when updating for a
        /// new configuration state, by reading the `listEnvironment` trait from the state's trait collection.
        /// Defaults to a subtitle cell in a plain-style list.
        #[unsafe(method(subtitleCellConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn subtitleCellConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns the default configuration for a list cell with side-by-side value text.
        /// From iOS 18 onwards, the configuration will automatically adopt the appropriate style for a list when updating for a
        /// new configuration state, by reading the `listEnvironment` trait from the state's trait collection.
        /// Defaults to the appearance of a value cell in a plain-style list.
        #[unsafe(method(valueCellConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn valueCellConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Represents a generic header configuration that automatically adopts the style of a containing list when updating for a
        /// new configuration state, by reading the `listEnvironment` trait from the state's trait collection.
        /// Defaults to the header configuration for a plain-style list.
        #[unsafe(method(headerConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn headerConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Represents a generic footer configuration that automatically adopts the style of a containing list when updating for a
        /// new configuration state, by reading the `listEnvironment` trait from the state's trait collection.
        /// Defaults to the footer configuration for a plain-style list.
        #[unsafe(method(footerConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn footerConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns the default configuration for a prominent inset grouped list header.
        #[unsafe(method(prominentInsetGroupedHeaderConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn prominentInsetGroupedHeaderConfiguration(
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Returns the default configuration for an extra prominent inset grouped list header.
        #[unsafe(method(extraProminentInsetGroupedHeaderConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn extraProminentInsetGroupedHeaderConfiguration(
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Returns the default configuration for an accompanied sidebar list cell.
        #[unsafe(method(accompaniedSidebarCellConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn accompaniedSidebarCellConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns the default configuration for an accompanied sidebar list cell with subtitle text.
        #[unsafe(method(accompaniedSidebarSubtitleCellConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn accompaniedSidebarSubtitleCellConfiguration(
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "UIImage")]
        /// The image to display.
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub unsafe fn image(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`image`][Self::image].
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImage(&self, image: Option<&UIImage>);

        #[cfg(feature = "UIListContentImageProperties")]
        /// Additional properties to configure the image.
        #[unsafe(method(imageProperties))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageProperties(&self) -> Retained<UIListContentImageProperties>;

        /// The primary text.
        #[unsafe(method(text))]
        #[unsafe(method_family = none)]
        pub unsafe fn text(&self) -> Option<Retained<NSString>>;

        /// Setter for [`text`][Self::text].
        #[unsafe(method(setText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setText(&self, text: Option<&NSString>);

        /// An attributed variant of the primary text, which supersedes the `text` and some properties of the `textProperties` if set.
        #[unsafe(method(attributedText))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributedText(&self) -> Option<Retained<NSAttributedString>>;

        /// Setter for [`attributedText`][Self::attributedText].
        #[unsafe(method(setAttributedText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributedText(&self, attributed_text: Option<&NSAttributedString>);

        #[cfg(feature = "UIListContentTextProperties")]
        /// Additional properties to configure the primary text.
        #[unsafe(method(textProperties))]
        #[unsafe(method_family = none)]
        pub unsafe fn textProperties(&self) -> Retained<UIListContentTextProperties>;

        /// The secondary text.
        #[unsafe(method(secondaryText))]
        #[unsafe(method_family = none)]
        pub unsafe fn secondaryText(&self) -> Option<Retained<NSString>>;

        /// Setter for [`secondaryText`][Self::secondaryText].
        #[unsafe(method(setSecondaryText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSecondaryText(&self, secondary_text: Option<&NSString>);

        /// An attributed variant of the secondary text, which supersedes the `secondaryText` and some properties of the `secondaryTextProperties` if set.
        #[unsafe(method(secondaryAttributedText))]
        #[unsafe(method_family = none)]
        pub unsafe fn secondaryAttributedText(&self) -> Option<Retained<NSAttributedString>>;

        /// Setter for [`secondaryAttributedText`][Self::secondaryAttributedText].
        #[unsafe(method(setSecondaryAttributedText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSecondaryAttributedText(
            &self,
            secondary_attributed_text: Option<&NSAttributedString>,
        );

        #[cfg(feature = "UIListContentTextProperties")]
        /// Additional properties to configure the secondary text.
        #[unsafe(method(secondaryTextProperties))]
        #[unsafe(method_family = none)]
        pub unsafe fn secondaryTextProperties(&self) -> Retained<UIListContentTextProperties>;

        #[cfg(feature = "UIGeometry")]
        /// Whether the content view will preserve inherited layout margins from its superview on the horizontal and/or vertical axes.
        #[unsafe(method(axesPreservingSuperviewLayoutMargins))]
        #[unsafe(method_family = none)]
        pub unsafe fn axesPreservingSuperviewLayoutMargins(&self) -> UIAxis;

        #[cfg(feature = "UIGeometry")]
        /// Setter for [`axesPreservingSuperviewLayoutMargins`][Self::axesPreservingSuperviewLayoutMargins].
        #[unsafe(method(setAxesPreservingSuperviewLayoutMargins:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAxesPreservingSuperviewLayoutMargins(
            &self,
            axes_preserving_superview_layout_margins: UIAxis,
        );

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// The margins for the content to the edges of the content view. (When preserving superview layout margins on one or both axes, these are just minimum margins, as inherited margins may be larger.)
        #[unsafe(method(directionalLayoutMargins))]
        #[unsafe(method_family = none)]
        pub unsafe fn directionalLayoutMargins(&self) -> NSDirectionalEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`directionalLayoutMargins`][Self::directionalLayoutMargins].
        #[unsafe(method(setDirectionalLayoutMargins:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDirectionalLayoutMargins(
            &self,
            directional_layout_margins: NSDirectionalEdgeInsets,
        );

        /// When YES, the text and secondary text will be positioned side-by-side if there is sufficient space. Otherwise, the text will be stacked in a vertical layout.
        #[unsafe(method(prefersSideBySideTextAndSecondaryText))]
        #[unsafe(method_family = none)]
        pub unsafe fn prefersSideBySideTextAndSecondaryText(&self) -> bool;

        /// Setter for [`prefersSideBySideTextAndSecondaryText`][Self::prefersSideBySideTextAndSecondaryText].
        #[unsafe(method(setPrefersSideBySideTextAndSecondaryText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPrefersSideBySideTextAndSecondaryText(
            &self,
            prefers_side_by_side_text_and_secondary_text: bool,
        );

        #[cfg(feature = "objc2-core-foundation")]
        /// Padding between the image and text. Only applies when there is both an image and text.
        #[unsafe(method(imageToTextPadding))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageToTextPadding(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`imageToTextPadding`][Self::imageToTextPadding].
        #[unsafe(method(setImageToTextPadding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImageToTextPadding(&self, image_to_text_padding: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        /// Horizontal (minimum) padding between the text and secondary text. Only applies when there is both text and secondary text, and they are in a side-by-side layout.
        #[unsafe(method(textToSecondaryTextHorizontalPadding))]
        #[unsafe(method_family = none)]
        pub unsafe fn textToSecondaryTextHorizontalPadding(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`textToSecondaryTextHorizontalPadding`][Self::textToSecondaryTextHorizontalPadding].
        #[unsafe(method(setTextToSecondaryTextHorizontalPadding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTextToSecondaryTextHorizontalPadding(
            &self,
            text_to_secondary_text_horizontal_padding: CGFloat,
        );

        #[cfg(feature = "objc2-core-foundation")]
        /// Vertical padding between the text and secondary text. Only applies when there is both text and secondary text, and they are in a stacked layout.
        #[unsafe(method(textToSecondaryTextVerticalPadding))]
        #[unsafe(method_family = none)]
        pub unsafe fn textToSecondaryTextVerticalPadding(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`textToSecondaryTextVerticalPadding`][Self::textToSecondaryTextVerticalPadding].
        #[unsafe(method(setTextToSecondaryTextVerticalPadding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTextToSecondaryTextVerticalPadding(
            &self,
            text_to_secondary_text_vertical_padding: CGFloat,
        );

        #[cfg(feature = "objc2-core-foundation")]
        /// The alpha to apply to the entire content view. Defaults to 1.0.
        #[unsafe(method(alpha))]
        #[unsafe(method_family = none)]
        pub unsafe fn alpha(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`alpha`][Self::alpha].
        #[unsafe(method(setAlpha:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlpha(&self, alpha: CGFloat);

        /// Returns the default configuration for a sidebar list cell.
        #[deprecated]
        #[unsafe(method(sidebarCellConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn sidebarCellConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns the default configuration for a sidebar list cell with subtitle text.
        #[deprecated]
        #[unsafe(method(sidebarSubtitleCellConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn sidebarSubtitleCellConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns the default configuration for a plain list header.
        #[deprecated]
        #[unsafe(method(plainHeaderConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn plainHeaderConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns the default configuration for a plain list footer.
        #[deprecated]
        #[unsafe(method(plainFooterConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn plainFooterConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns the default configuration for a grouped list header.
        #[deprecated]
        #[unsafe(method(groupedHeaderConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn groupedHeaderConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns the default configuration for a grouped list footer.
        #[deprecated]
        #[unsafe(method(groupedFooterConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn groupedFooterConfiguration(mtm: MainThreadMarker) -> Retained<Self>;

        /// Returns the default configuration for a sidebar list header.
        #[deprecated]
        #[unsafe(method(sidebarHeaderConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn sidebarHeaderConfiguration(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uilistcontentview?language=objc)
    #[unsafe(super(UIView, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "UIResponder", feature = "UIView"))]
    pub struct UIListContentView;
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIView",
    feature = "objc2-quartz-core"
))]
#[cfg(not(target_os = "watchos"))]
extern_conformance!(
    unsafe impl CALayerDelegate for UIListContentView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSCoding for UIListContentView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIListContentView {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIAppearance for UIListContentView {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UIListContentView {}
);

#[cfg(all(
    feature = "UIContentConfiguration",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIContentView for UIListContentView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UICoordinateSpace for UIListContentView {}
);

#[cfg(all(
    feature = "UIDynamicBehavior",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIDynamicItem for UIListContentView {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UIListContentView {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIFocusItem for UIListContentView {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIFocusItemContainer for UIListContentView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UIListContentView {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UITraitCollection",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UIListContentView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
impl UIListContentView {
    extern_methods!(
        #[unsafe(method(initWithConfiguration:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithConfiguration(
            this: Allocated<Self>,
            configuration: &UIListContentConfiguration,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame: CGRect) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(configuration))]
        #[unsafe(method_family = none)]
        pub unsafe fn configuration(&self) -> Retained<UIListContentConfiguration>;

        /// Setter for [`configuration`][Self::configuration].
        #[unsafe(method(setConfiguration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setConfiguration(&self, configuration: &UIListContentConfiguration);

        #[cfg(feature = "UILayoutGuide")]
        /// This guide reflects the positioning of the primary text rendered by this content view, if specified by the configuration.
        ///
        /// Returns nil if there is no primary text. If a new configuration is applied that does not contain primary text, then this layout
        /// guide is removed from the view, and any constraints associated with it will be deactivated.
        #[unsafe(method(textLayoutGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn textLayoutGuide(&self) -> Option<Retained<UILayoutGuide>>;

        #[cfg(feature = "UILayoutGuide")]
        /// This guide reflects the positioning of the secondary text rendered by this content view, if specified by the configuration.
        ///
        /// Returns nil if there is no secondary text. If a new configuration is applied that does not contain secondary text, then this layout
        /// guide is removed from the view, and any constraints associated with it will be deactivated.
        #[unsafe(method(secondaryTextLayoutGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn secondaryTextLayoutGuide(&self) -> Option<Retained<UILayoutGuide>>;

        #[cfg(feature = "UILayoutGuide")]
        /// This guide reflects the positioning of the image rendered by this content view, if specified by the configuration.
        ///
        /// Returns nil if there is no image. If a new configuration is applied that does contain an image, then this layout
        /// guide is removed from the view, and any constraints associated with it will be deactivated.
        #[unsafe(method(imageLayoutGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageLayoutGuide(&self) -> Option<Retained<UILayoutGuide>>;
    );
}
