<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# bimap

```go
import "github.com/zyedidia/generic/bimap"
```

Package bimap provides an implementation of a bi\-directional map.

It is implemented by using two Go maps, which keeps the lookup speed identical for both forward and reverse lookups, however it also doubles the memory usage of the map.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"

	"github.com/zyedidia/generic/bimap"
)

func main() {
	var bimap bimap.Bimap[int, string]

	bimap.Add(1, "foo")
	bimap.Add(2, "bar")
	bimap.Add(3, "moo")
	bimap.Add(4, "doo")

	fmt.Println(bimap.GetForward(4))
	fmt.Println(bimap.GetReverse("moo"))
	fmt.Println(bimap.GetReverse("unknown"))
}
```

#### Output

```
doo true
3 true
0 false
```

</p>
</details>

## Index

- [type Bimap](<#type-bimap>)
  - [func Of[K, V comparable](m map[K]V) Bimap[K, V]](<#func-of>)
  - [func (b *Bimap[K, V]) Add(key K, value V)](<#func-bimapk-v-add>)
  - [func (b *Bimap[K, V]) Clear()](<#func-bimapk-v-clear>)
  - [func (b *Bimap[K, V]) ContainsForward(key K) bool](<#func-bimapk-v-containsforward>)
  - [func (b *Bimap[K, V]) ContainsReverse(value V) bool](<#func-bimapk-v-containsreverse>)
  - [func (b *Bimap[K, V]) Copy() Bimap[K, V]](<#func-bimapk-v-copy>)
  - [func (b *Bimap[K, V]) Each(f func(key K, value V))](<#func-bimapk-v-each>)
  - [func (b *Bimap[K, V]) GetForward(key K) (V, bool)](<#func-bimapk-v-getforward>)
  - [func (b *Bimap[K, V]) GetReverse(value V) (K, bool)](<#func-bimapk-v-getreverse>)
  - [func (b *Bimap[K, V]) Len() int](<#func-bimapk-v-len>)
  - [func (b *Bimap[K, V]) RemoveForward(key K)](<#func-bimapk-v-removeforward>)
  - [func (b *Bimap[K, V]) RemoveReverse(value V)](<#func-bimapk-v-removereverse>)


## type [Bimap](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L21-L24>)

Bimap is a bi\-directional map where both the keys and values are indexed against each other, allowing performant lookup on both keys and values, at the cost of double the memory usage.

```go
type Bimap[K, V comparable] struct {
    // contains filtered or unexported fields
}
```

### func [Of](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L10>)

```go
func Of[K, V comparable](m map[K]V) Bimap[K, V]
```

Of returns a new \[Bimap\] initiated with the keys and values from the given map.

### func \(\*Bimap\[K, V\]\) [Add](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L38>)

```go
func (b *Bimap[K, V]) Add(key K, value V)
```

Add another key\-value pair to be indexed inside this map. Both the key and the value is indexed, to allow performant lookups on both key and value.

On collisions, the old values will be overwritten.

### func \(\*Bimap\[K, V\]\) [Clear](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L101>)

```go
func (b *Bimap[K, V]) Clear()
```

Clear empties this bidirectional map, removing all items.

### func \(\*Bimap\[K, V\]\) [ContainsForward](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L77>)

```go
func (b *Bimap[K, V]) ContainsForward(key K) bool
```

ContainsForward checks if the given key exists.

### func \(\*Bimap\[K, V\]\) [ContainsReverse](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L89>)

```go
func (b *Bimap[K, V]) ContainsReverse(value V) bool
```

ContainsReverse checks if the given value exists.

### func \(\*Bimap\[K, V\]\) [Copy](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L107>)

```go
func (b *Bimap[K, V]) Copy() Bimap[K, V]
```

Copy creates a shallow copy of this bidirectional map.

### func \(\*Bimap\[K, V\]\) [Each](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L70>)

```go
func (b *Bimap[K, V]) Each(f func(key K, value V))
```

Each loops over all the values in this map.

### func \(\*Bimap\[K, V\]\) [GetForward](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L83>)

```go
func (b *Bimap[K, V]) GetForward(key K) (V, bool)
```

GetForward performs a lookup on the key to get the value.

### func \(\*Bimap\[K, V\]\) [GetReverse](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L95>)

```go
func (b *Bimap[K, V]) GetReverse(value V) (K, bool)
```

GetReverse performs a lookup on the value to get the key.

### func \(\*Bimap\[K, V\]\) [Len](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L27>)

```go
func (b *Bimap[K, V]) Len() int
```

Len returns the number of key\-value pairs in this map.

### func \(\*Bimap\[K, V\]\) [RemoveForward](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L54>)

```go
func (b *Bimap[K, V]) RemoveForward(key K)
```

RemoveForward removes a key\-value pair from this map based on the key.

### func \(\*Bimap\[K, V\]\) [RemoveReverse](<https://github.com/zyedidia/generic/blob/master/bimap/bimap.go#L62>)

```go
func (b *Bimap[K, V]) RemoveReverse(value V)
```

RemoveReverse removes a key\-value pair from this map based on the value.



Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
