/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.linux.s390x;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum RLIMIT implements Constant
{
    RLIMIT_AS(9L),
    RLIMIT_CORE(4L),
    RLIMIT_CPU(0L),
    RLIMIT_DATA(2L),
    RLIMIT_FSIZE(1L),
    RLIMIT_LOCKS(10L),
    RLIMIT_MEMLOCK(8L),
    RLIMIT_MSGQUEUE(12L),
    RLIMIT_NICE(13L),
    RLIMIT_NLIMITS(16L),
    RLIMIT_NOFILE(7L),
    RLIMIT_NPROC(6L),
    RLIMIT_OFILE(7L),
    RLIMIT_RSS(5L),
    RLIMIT_RTPRIO(14L),
    RLIMIT_RTTIME(15L),
    RLIMIT_SIGPENDING(11L),
    RLIMIT_STACK(3L);

    private final long value;
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 16L;

    private RLIMIT(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<RLIMIT, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<RLIMIT, String> generateTable() {
            EnumMap<RLIMIT, String> map2 = new EnumMap<RLIMIT, String>(RLIMIT.class);
            map2.put(RLIMIT_AS, "RLIMIT_AS");
            map2.put(RLIMIT_CORE, "RLIMIT_CORE");
            map2.put(RLIMIT_CPU, "RLIMIT_CPU");
            map2.put(RLIMIT_DATA, "RLIMIT_DATA");
            map2.put(RLIMIT_FSIZE, "RLIMIT_FSIZE");
            map2.put(RLIMIT_LOCKS, "RLIMIT_LOCKS");
            map2.put(RLIMIT_MEMLOCK, "RLIMIT_MEMLOCK");
            map2.put(RLIMIT_MSGQUEUE, "RLIMIT_MSGQUEUE");
            map2.put(RLIMIT_NICE, "RLIMIT_NICE");
            map2.put(RLIMIT_NLIMITS, "RLIMIT_NLIMITS");
            map2.put(RLIMIT_NOFILE, "RLIMIT_NOFILE");
            map2.put(RLIMIT_NPROC, "RLIMIT_NPROC");
            map2.put(RLIMIT_OFILE, "RLIMIT_OFILE");
            map2.put(RLIMIT_RSS, "RLIMIT_RSS");
            map2.put(RLIMIT_RTPRIO, "RLIMIT_RTPRIO");
            map2.put(RLIMIT_RTTIME, "RLIMIT_RTTIME");
            map2.put(RLIMIT_SIGPENDING, "RLIMIT_SIGPENDING");
            map2.put(RLIMIT_STACK, "RLIMIT_STACK");
            return map2;
        }
    }
}

