'use strict';

module.exports = function() {
  const kPlaintext =
    Buffer.from('546869732073706563696669636174696f6e206465736372696265' +
                '732061204a6176615363726970742041504920666f722070657266' +
                '6f726d696e672062617369632063727970746f6772617068696320' +
                '6f7065726174696f6e7320696e20776562206170706c6963617469' +
                '6f6e732c20737563682061732068617368696e672c207369676e61' +
                '747572652067656e65726174696f6e20616e642076657269666963' +
                '6174696f6e2c20616e6420656e6372797074696f6e20616e642064' +
                '656372797074696f6e2e204164646974696f6e616c6c792c206974' +
                '2064657363726962657320616e2041504920666f72206170706c69' +
                '636174696f6e7320746f2067656e657261746520616e642f6f7220' +
                '6d616e61676520746865206b6579696e67206d6174657269616c20' +
                '6e656365737361727920746f20706572666f726d20746865736520' +
                '6f7065726174696f6e732e205573657320666f7220746869732041' +
                '50492072616e67652066726f6d2075736572206f72207365727669' +
                '63652061757468656e7469636174696f6e2c20646f63756d656e74' +
                '206f7220636f6465207369676e696e672c20616e64207468652063' +
                '6f6e666964656e7469616c69747920616e6420696e746567726974' +
                '79206f6620636f6d6d756e69636174696f6e732e', 'hex');

  const kKeyBytes = {
    '128': Buffer.from('dec0d4fcbf3c4741c892dabd1cd4c04e', 'hex'),
    '256': Buffer.from('67693823fb1d58073f91ece9cc3af910e5532616a4d27b1' +
                       '3eb7b74d8000bbf30', 'hex')
  }

  const iv = Buffer.from('3a92732aa6ea39bf3986e0c73fa920', 'hex');

  const additionalData = Buffer.from(
    '5468657265206172652037206675727468657220656469746f72696' +
    '16c206e6f74657320696e2074686520646f63756d656e742e', 'hex');

  const vectorData = {
    '128': {
      '64': {
        ciphertext: Buffer.from('4680d176c2fa66ef4376bc013ca5435ebd27b260c1236ae0148eb84eb24869ec1f1ebba2ba5356a2ee36944e717f668ab180c94817058216930d0192f403652bd2b0f3adac6466a74a69a8676d8460e2d81811de0cf8c0ec0c1aea48d470d0b6818fffb30dcdba67ffcf4bcf62e241e853c04370014cbea9cd68de4b90f8e52b5d40e972df70104fb70a78ddff9e7eb6e0c528c52aca9738030a6ad253d042697de254a059d06606ce718e8c95afd35767d05640b11367c5de4be405dd0c0bbbff54c8adfdae259b6588a44af382b3c5a2dec4c91bc8c3c156ae4859bd95e1a12f13fd292e0e80de25267941b8c5974e53dcff3741211d9c9e312919283f625201b201bb208f341b792d50c26b3c5769107e28c694ee55396a92b8ef18f6aa5849e44f63da4ab7d6d27d0b7c0869be21c650049dba5c3691de3fdc0dc9cd9676857d35d924372487e87c5ce4d656f69ee0cd62edbd949db134f9850eb6f017d5ba1933e8a39e56822fbe6a35eb9590e28bd1bbd46217c2db14264518caad1929885c143d28f4274fb4a655de0e24b2f37f1351c4820cb5c4fe49e9433f28bc1a0ac63a52200ac0876471c4db9a7ef1852b679f8a1d9bd54e739ce642bdfca700ed162516a33798733b52b726376e10f840714109150c7afeb71c652970ea86', 'hex'),
        tagWithAD: Buffer.from('cd1d3fa016ffebf8', 'hex'),
        tagWithoutAD: Buffer.from('85917be096f12614', 'hex')
      },
      '96': {
        ciphertext: Buffer.from('165e7cb1789fc9cb1e9b81e48d2c30d22a019bce5ff79d45ea7adbcf585b7bfc015a5959c9c1478714f4621ee0675f785a1689f1a9254b76580d368cc4a02b18b3f2a8abb5173e2b9f27042af4c0daeae44d88679e7bb79cab48a8f100804c0dad11547c68f2ac0e9a74f1abdeaa7c95e12b97361c4217905f25a03d9a5f8982af979b7756768cd9b044cc928d25ccd56e4fc494e4f62d96aabf3a4bd4889478990e58dcc180c4a81aceaf93afbbcf866a47030d579a981e42d78fae1907df32fd6c8cb37e1bd12e9ac7e81636e411e1717dac7836cf35b2683dd055fd0032a37d048835ef977b381d282ebb4c743eb09126d37764bd177af48d40f0c50534484dfd23ca9d046be673f493a83f705bd3a7d6579814690ee936095f1d80175271f33832ce9d93fff24d4c4ac3fbfa5e12b57109a56fdd5fa302391fe561095dafa4e41ce8e6dc5aac6091aefd7ca3b694ff6301ffdbe02c0c2ce438101ee92a08f85f3b153aa3116a80bc7778040ed9ee8b408909fc6d86004f23798ae85d9b1957435c9f74becdc53b38a7f0b9ac3d515e17d0ca9f5874096db5fb234d0d45e8149f6d15e2d7d3138622fa6fa7eded639fb6929fcaacf03060ec9db0106e58a3fa45d9ab2f6a2b56eee39cfc8cb305901c8f612e24da4cd3b07d4cf966cdf1', 'hex'),
        tagWithAD: Buffer.from('80b55f5111770c4fd51ae2a1', 'hex'),
        tagWithoutAD: Buffer.from('c8391b119179c1a3c534f03b', 'hex')
      },
      '128': {
        ciphertext: Buffer.from('0e33334c6fd3cf8c371d06875f342d239832a94c43b2f721d8bd70b6d62e7ac34bfd2041b214cd77624e0330e0892abfd696577144205882a24a1f4f0234602503222558c8c0e7dd033c3888d7f747107d3b11ad3f4d2c6088a80413d12a83587503a7393022ec541b284b358fa1fe3236ae706cd49fb8e2d4216318e8659275d80616940d2f3762e672a19ece3f2ee918c4e99b173c544dfb3300a867564790a436967563fa2bd3240dbb4d370d9153110411d772ff7542651db8c38672cc0f0ceae4f24065dfc996dd8b8d915f1bce206878ac54fad4df8a8157af6f1a8dc0344f526cd6cc398e1f049af3af9334204c5025a653292c0db11985ab83acf1bce2879754c0684a40d7e64e1f062a5d586a7c8702f326119dec9b1d0d316f8ba93f63d07546ee796db70fa66738499126c3a4bdada811dfc698b96569fbfcb935059c9b80349ce2b5caf6def0f2f6ba0d8ebf3395bb1766cddbc93a946d9706342bc378cda55eaee8edb411314c73bb2c480dea05e2eab5f83d089624bc9884dd14ba714d62e15767f730782e37c519b608d8d4ccee98e6d4ba28171417753f72a3b476403ccd5f0bbc4d7021170c751f8d844ee58ce6d2558270333d26e14e184d07e46a22d9270258517c7d6fa55875642d07a74ae0056c41e2931ef08d3f', 'hex'),
        tagWithAD: Buffer.from('cdee14358fba08d170fe5906ab34a56f', 'hex'),
        tagWithoutAD: Buffer.from('856250750fb4c53d60d04b9cb18534ba', 'hex')
      }
    },
    '256': {
      '64': {
        ciphertext: Buffer.from('188ee89ebee501f6a1dd111aa09b00eb67e1b2c6e1f205737d7f47e2cca0b80c9408daccfe820ebeab75f290589dc2175039d60c891002dea5214237393a5672bf91403d69fe41122b666fdd4b796ca18eb84a219895a58ca91689758dfc578079f89f27016a3b3080d0d8177a5ed8fc4b6e0af40604eaf4d91125aeac6656277a429c120bd9a2fa73086eb93302e3cc4d31dd2433d2f07cfbf604e60e380b7f94fb9de182f9752664c57dcb5c9797a952cc8a27b88a582342747c84bdcaae7ddfce460ab681856432429c6cc6e3658929f5669d5088a123a9158b680a8601960b068ea5a7b8f9bac98c3b7399c8fb8067ecbf6313606afdc3d1528d048b6803e12bdb44b119a2107463d01db4bc2791df8f3d0761ce5b401f8e0383f279fe7b1af335b10b48bef05d0e91bdab9631fa79a67a03a4790b4b1d325be028f6beda26d68958811670c86050d05b745f399ac77ff97be3b91cff64fd15e5047b1698c2dffe6d3d7c6cb0c8b5956cee43e8ecf7bc22199bfd7d61178843f9554bc0db539e7a59001ba3c963f299a1d838b8629bddc7c5646145a86ce52077af7785d213c787640b2010424b73b7b786ac7ca946fff501fecd6793ac00e9fb10ce7fb3a6d7b277b7096c83c94a421747f63c43723dd098b144549edbaeda4536ded1', 'hex'),
        tagWithAD: Buffer.from('dd2a37097d430860', 'hex'),
        tagWithoutAD: Buffer.from('4aefbda08fd14436', 'hex')
      },
      '96': {
        ciphertext: Buffer.from('18da5c8e77a1fa3cbe6c510c594b905f027ba3b56e446f23bbc17d12f265f260799ec5531792b8ec5cfec2b660bef94760ff5e7a714947cb342a7e9a1e0f3085e7c1608ea9dd1c71507cf09a7683e855b664615702cb556553319b5bd0fcb600d5c3a3bb8c36d8014f30b85a2d26ac36e83cfe8cebb6f7118c3e5875597fa39efd269f5ea237edd60036a906ea592fbe2868455503e9b1928396a894fefe2321138e8f5df4fcc932f4f05f3c15cd16cd5da9d54399dd0a90448f12c54a288b1724b60dfb7a434e72e357ddb631c1038efe9331a5037eb98e61f2a69df51d17de14799df035b5e468782d95d58d0cfd68d69c1b1529b4ad191bbf6f4c10f8a85e2c4ac7c525b3ef258de9a2f9b6193d74ca6e0180333167de426039cf8490d15e7f8ea86bfd143f98f2bb8e5c32a17e19aa0370cc7cbad8cfaeb69be29b6a6a7c27354a9a0dae13258578c681d182855c917c300e96912d24a80db1824e719fd5bddafd839f67fe18f632a892e69e46e0bef56aa94ff26ab7943a4b7de052f5d24302feb3add1c481b019d0d97bd442bd7c0021721d13b9e471686409c7c69551b3977ed3505eff8213e5564d1afe6042dc1ea572aca30cd1b7540e954b2e6c0498ebd2526fb0fb5ffcf48c6ef23b385e99649fd49290e0ce4de6d0a57498b7', 'hex'),
        tagWithAD: Buffer.from('06a22a5a7776797981c5ee6d', 'hex'),
        tagWithoutAD: Buffer.from('9167a0f385e4352f4c97aa94', 'hex')
      },
      '128': {
        ciphertext: Buffer.from('4604fafe03ab3897dd54e41c5884cac385d575768a2eb1c4c21c8470636a62565309605c8a556c4f3837be13df6f02de9b5a1ebbedba07e34a1fe0cd037eefc5c324ddfd95a9d16eaebecafd5b93d3c8d9a2deadb079497437d120c1fb0ae4b4d60b9fe220486c54f49c23c00fc3ffb1d57022761315c51f609fb28d70e4de2479325851af9c71671b6507c81fdecc5e5b8335b9d78320b0a4dfdff2f4a0dc86401128fdbe5601491acc6b0876d72fa842e95b75626dde15e602593b82874ed9233ddc64b06c41ea25dcccd678eb720d10d1c85f17635aceef2f102706f6de89b6d0fe6dcd686677d0a682fa3bf781a1fdb13c506be5b1c46ead578c54161129dbe0763d897fde4bfaf87ba61c5cf6884bd1e75678c086aeb2fcf057faf14ec38492ecba850595fa5b84d66c07576486da9cff68dbd961872985b1094d23f9dc31dda35cbe68ee570323843374cb89e07d2f11adf3476e6bdc2b2525cffdffcb7ee58190b19d8601b73d175bd8ebda079c97ed36e77c09a7c1c5e48f57c1881b91e2b17b6a737c79a1528c90ffbc1504914677593b9f6eca64fad08cdd4d318cd7f163cdf325667e949d829bebcccd932481ef132b49ac156eef34947924c165ce64b9e1e1461bd8d3d1e4e928411b448faa5d7db7f8bddc4fdce1ea035d60', 'hex'),
        tagWithAD: Buffer.from('a36db50a9235d475609287268818792c', 'hex'),
        tagWithoutAD: Buffer.from('34a83fa360a79823adc0c3dfc8e64d20', 'hex')
      }
    }
  };

  const kKeyLengths = [128, 256];
  const kTagLengths = [64, 96, 128];

  const passing = [];
  kKeyLengths.forEach((keyLength) => {
    kTagLengths.forEach((tagLength) => {
      const byteCount = tagLength / 8;
      const data = vectorData[keyLength][tagLength];

      // With additional data
      const result = new Uint8Array(data.ciphertext.byteLength + byteCount);
      result.set(data.ciphertext, 0);
      result.set(data.tagWithAD.slice(0, byteCount), data.ciphertext.byteLength);
      passing.push({
        keyBuffer: kKeyBytes[keyLength],
        algorithm: { name: 'AES-OCB', iv, additionalData, tagLength },
        plaintext: kPlaintext,
        result
      });

      // Without additional data
      const noadresult = new Uint8Array(data.ciphertext.byteLength + byteCount);
      noadresult.set(data.ciphertext, 0);
      noadresult.set(data.tagWithoutAD.slice(0, byteCount), data.ciphertext.byteLength);
      passing.push({
        keyBuffer: kKeyBytes[keyLength],
        algorithm: { name: 'AES-OCB', iv, tagLength },
        plaintext: kPlaintext,
        result: noadresult
      });
    });
  });

  const failing = [];
  kKeyLengths.forEach((keyLength) => {
    [24, 48, 72, 95, 129].forEach((badTagLength) => {
      failing.push({
        keyBuffer: kKeyBytes[keyLength],
        algorithm: {
          name: 'AES-OCB',
          iv,
          additionalData,
          tagLength: badTagLength
        },
        plaintext: kPlaintext,
        result: vectorData[keyLength]['128'].ciphertext,
      });
    });
  });

  return { passing, failing, decryptionFailing: [] };
};
