// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package accesscontextmanager aliases all exported identifiers in package
// "cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb".
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package accesscontextmanager

import (
	src "cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
const (
	BasicLevel_AND                                   = src.BasicLevel_AND
	BasicLevel_OR                                    = src.BasicLevel_OR
	LevelFormat_AS_DEFINED                           = src.LevelFormat_AS_DEFINED
	LevelFormat_CEL                                  = src.LevelFormat_CEL
	LevelFormat_LEVEL_FORMAT_UNSPECIFIED             = src.LevelFormat_LEVEL_FORMAT_UNSPECIFIED
	ServicePerimeterConfig_ANY_IDENTITY              = src.ServicePerimeterConfig_ANY_IDENTITY
	ServicePerimeterConfig_ANY_SERVICE_ACCOUNT       = src.ServicePerimeterConfig_ANY_SERVICE_ACCOUNT
	ServicePerimeterConfig_ANY_USER_ACCOUNT          = src.ServicePerimeterConfig_ANY_USER_ACCOUNT
	ServicePerimeterConfig_IDENTITY_TYPE_UNSPECIFIED = src.ServicePerimeterConfig_IDENTITY_TYPE_UNSPECIFIED
	ServicePerimeter_PERIMETER_TYPE_BRIDGE           = src.ServicePerimeter_PERIMETER_TYPE_BRIDGE
	ServicePerimeter_PERIMETER_TYPE_REGULAR          = src.ServicePerimeter_PERIMETER_TYPE_REGULAR
)

// Deprecated: Please use vars in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
var (
	BasicLevel_ConditionCombiningFunction_name                                 = src.BasicLevel_ConditionCombiningFunction_name
	BasicLevel_ConditionCombiningFunction_value                                = src.BasicLevel_ConditionCombiningFunction_value
	File_google_identity_accesscontextmanager_v1_access_context_manager_proto  = src.File_google_identity_accesscontextmanager_v1_access_context_manager_proto
	File_google_identity_accesscontextmanager_v1_access_level_proto            = src.File_google_identity_accesscontextmanager_v1_access_level_proto
	File_google_identity_accesscontextmanager_v1_access_policy_proto           = src.File_google_identity_accesscontextmanager_v1_access_policy_proto
	File_google_identity_accesscontextmanager_v1_gcp_user_access_binding_proto = src.File_google_identity_accesscontextmanager_v1_gcp_user_access_binding_proto
	File_google_identity_accesscontextmanager_v1_service_perimeter_proto       = src.File_google_identity_accesscontextmanager_v1_service_perimeter_proto
	LevelFormat_name                                                           = src.LevelFormat_name
	LevelFormat_value                                                          = src.LevelFormat_value
	ServicePerimeterConfig_IdentityType_name                                   = src.ServicePerimeterConfig_IdentityType_name
	ServicePerimeterConfig_IdentityType_value                                  = src.ServicePerimeterConfig_IdentityType_value
	ServicePerimeter_PerimeterType_name                                        = src.ServicePerimeter_PerimeterType_name
	ServicePerimeter_PerimeterType_value                                       = src.ServicePerimeter_PerimeterType_value
)

// AccessContextManagerClient is the client API for AccessContextManager
// service. For semantics around ctx use and closing/ending streaming RPCs,
// please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type AccessContextManagerClient = src.AccessContextManagerClient

// Metadata of Access Context Manager's Long Running Operations.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type AccessContextManagerOperationMetadata = src.AccessContextManagerOperationMetadata

// AccessContextManagerServer is the server API for AccessContextManager
// service.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type AccessContextManagerServer = src.AccessContextManagerServer

// An `AccessLevel` is a label that can be applied to requests to Google Cloud
// services, along with a list of requirements necessary for the label to be
// applied.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type AccessLevel = src.AccessLevel
type AccessLevel_Basic = src.AccessLevel_Basic
type AccessLevel_Custom = src.AccessLevel_Custom

// `AccessPolicy` is a container for `AccessLevels` (which define the
// necessary attributes to use Google Cloud services) and `ServicePerimeters`
// (which define regions of services able to freely pass data within a
// perimeter). An access policy is globally visible within an organization, and
// the restrictions it specifies apply to all projects within an organization.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type AccessPolicy = src.AccessPolicy

// `BasicLevel` is an `AccessLevel` using a set of recommended features.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type BasicLevel = src.BasicLevel

// Options for how the `conditions` list should be combined to determine if
// this `AccessLevel` is applied. Default is AND.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type BasicLevel_ConditionCombiningFunction = src.BasicLevel_ConditionCombiningFunction

// A request to commit dry-run specs in all [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] belonging to an
// [Access Policy][google.identity.accesscontextmanager.v1.AccessPolicy].
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type CommitServicePerimetersRequest = src.CommitServicePerimetersRequest

// A response to CommitServicePerimetersRequest. This will be put inside of
// Operation.response field.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type CommitServicePerimetersResponse = src.CommitServicePerimetersResponse

// A condition necessary for an `AccessLevel` to be granted. The Condition is
// an AND over its fields. So a Condition is true if: 1) the request IP is from
// one of the listed subnetworks AND 2) the originating device complies with
// the listed device policy AND 3) all listed access levels are granted AND 4)
// the request was sent at a time allowed by the DateTimeRestriction.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type Condition = src.Condition

// A request to create an `AccessLevel`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type CreateAccessLevelRequest = src.CreateAccessLevelRequest

// Request of [CreateGcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.AccessContextManager.CreateGcpUserAccessBinding].
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type CreateGcpUserAccessBindingRequest = src.CreateGcpUserAccessBindingRequest

// A request to create a `ServicePerimeter`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type CreateServicePerimeterRequest = src.CreateServicePerimeterRequest

// `CustomLevel` is an `AccessLevel` using the Cloud Common Expression
// Language to represent the necessary conditions for the level to apply to a
// request. See CEL spec at: https://github.com/google/cel-spec
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type CustomLevel = src.CustomLevel

// A request to delete an `AccessLevel`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type DeleteAccessLevelRequest = src.DeleteAccessLevelRequest

// A request to delete an `AccessPolicy`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type DeleteAccessPolicyRequest = src.DeleteAccessPolicyRequest

// Request of [DeleteGcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.AccessContextManager.DeleteGcpUserAccessBinding].
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type DeleteGcpUserAccessBindingRequest = src.DeleteGcpUserAccessBindingRequest

// A request to delete a `ServicePerimeter`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type DeleteServicePerimeterRequest = src.DeleteServicePerimeterRequest

// `DevicePolicy` specifies device specific restrictions necessary to acquire
// a given access level. A `DevicePolicy` specifies requirements for requests
// from devices to be granted access levels, it does not do any enforcement on
// the device. `DevicePolicy` acts as an AND over all specified fields, and
// each repeated field is an OR over its elements. Any unset fields are
// ignored. For example, if the proto is { os_type : DESKTOP_WINDOWS, os_type :
// DESKTOP_LINUX, encryption_status: ENCRYPTED}, then the DevicePolicy will be
// true for requests originating from encrypted Linux desktops and encrypted
// Windows desktops.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type DevicePolicy = src.DevicePolicy

// Restricts access to Cloud Console and Google Cloud APIs for a set of users
// using Context-Aware Access.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type GcpUserAccessBinding = src.GcpUserAccessBinding

// Currently, a completed operation means nothing. In the future, this
// metadata and a completed operation may indicate that the binding has taken
// effect and is affecting access decisions for all users.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type GcpUserAccessBindingOperationMetadata = src.GcpUserAccessBindingOperationMetadata

// A request to get a particular `AccessLevel`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type GetAccessLevelRequest = src.GetAccessLevelRequest

// A request to get a particular `AccessPolicy`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type GetAccessPolicyRequest = src.GetAccessPolicyRequest

// Request of [GetGcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.AccessContextManager.GetGcpUserAccessBinding].
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type GetGcpUserAccessBindingRequest = src.GetGcpUserAccessBindingRequest

// A request to get a particular `ServicePerimeter`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type GetServicePerimeterRequest = src.GetServicePerimeterRequest

// The format used in an `AccessLevel`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type LevelFormat = src.LevelFormat

// A request to list all `AccessLevels` in an `AccessPolicy`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ListAccessLevelsRequest = src.ListAccessLevelsRequest

// A response to `ListAccessLevelsRequest`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ListAccessLevelsResponse = src.ListAccessLevelsResponse

// A request to list all `AccessPolicies` for a container.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ListAccessPoliciesRequest = src.ListAccessPoliciesRequest

// A response to `ListAccessPoliciesRequest`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ListAccessPoliciesResponse = src.ListAccessPoliciesResponse

// Request of [ListGcpUserAccessBindings]
// [google.identity.accesscontextmanager.v1.AccessContextManager.ListGcpUserAccessBindings].
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ListGcpUserAccessBindingsRequest = src.ListGcpUserAccessBindingsRequest

// Response of [ListGcpUserAccessBindings]
// [google.identity.accesscontextmanager.v1.AccessContextManager.ListGcpUserAccessBindings].
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ListGcpUserAccessBindingsResponse = src.ListGcpUserAccessBindingsResponse

// A request to list all `ServicePerimeters` in an `AccessPolicy`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ListServicePerimetersRequest = src.ListServicePerimetersRequest

// A response to `ListServicePerimetersRequest`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ListServicePerimetersResponse = src.ListServicePerimetersResponse

// A restriction on the OS type and version of devices making requests.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type OsConstraint = src.OsConstraint

// A request to replace all existing Access Levels in an Access Policy with
// the Access Levels provided. This is done atomically.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ReplaceAccessLevelsRequest = src.ReplaceAccessLevelsRequest

// A response to ReplaceAccessLevelsRequest. This will be put inside of
// Operation.response field.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ReplaceAccessLevelsResponse = src.ReplaceAccessLevelsResponse

// A request to replace all existing Service Perimeters in an Access Policy
// with the Service Perimeters provided. This is done atomically.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ReplaceServicePerimetersRequest = src.ReplaceServicePerimetersRequest

// A response to ReplaceServicePerimetersRequest. This will be put inside of
// Operation.response field.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ReplaceServicePerimetersResponse = src.ReplaceServicePerimetersResponse

// `ServicePerimeter` describes a set of Google Cloud resources which can
// freely import and export data amongst themselves, but not export outside of
// the `ServicePerimeter`. If a request with a source within this
// `ServicePerimeter` has a target outside of the `ServicePerimeter`, the
// request will be blocked. Otherwise the request is allowed. There are two
// types of Service Perimeter - Regular and Bridge. Regular Service Perimeters
// cannot overlap, a single Google Cloud project can only belong to a single
// regular Service Perimeter. Service Perimeter Bridges can contain only Google
// Cloud projects as members, a single Google Cloud project may belong to
// multiple Service Perimeter Bridges.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeter = src.ServicePerimeter

// `ServicePerimeterConfig` specifies a set of Google Cloud resources that
// describe specific Service Perimeter configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig = src.ServicePerimeterConfig

// Identification for an API Operation.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_ApiOperation = src.ServicePerimeterConfig_ApiOperation

// Defines the conditions under which an [EgressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// matches a request. Conditions based on information about the source of the
// request. Note that if the destination of the request is also protected by a
// [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter], then that
// [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] must have an
// [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// which allows access in order for this request to succeed.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_EgressFrom = src.ServicePerimeterConfig_EgressFrom

// Policy for egress from perimeter. [EgressPolicies]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// match requests based on `egress_from` and `egress_to` stanzas. For an
// [EgressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// to match, both `egress_from` and `egress_to` stanzas must be matched. If an
// [EgressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// matches a request, the request is allowed to span the [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] boundary. For
// example, an [EgressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// can be used to allow VMs on networks within the [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] to access a
// defined set of projects outside the perimeter in certain contexts (e.g. to
// read data from a Cloud Storage bucket or query against a BigQuery dataset).
// [EgressPolicies]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// are concerned with the *resources* that a request relates as well as the API
// services and API actions being used. They do not related to the direction of
// data movement. More detailed documentation for this concept can be found in
// the descriptions of [EgressFrom]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom]
// and [EgressTo]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo].
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_EgressPolicy = src.ServicePerimeterConfig_EgressPolicy

// Defines the conditions under which an [EgressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// matches a request. Conditions are based on information about the
// [ApiOperation]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation]
// intended to be performed on the `resources` specified. Note that if the
// destination of the request is also protected by a [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter], then that
// [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] must have an
// [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// which allows access in order for this request to succeed. The request must
// match `operations` AND `resources` fields in order to be allowed egress out
// of the perimeter.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_EgressTo = src.ServicePerimeterConfig_EgressTo

// Specifies the types of identities that are allowed access in either
// [IngressFrom]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom]
// or [EgressFrom]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom]
// rules.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_IdentityType = src.ServicePerimeterConfig_IdentityType

// Defines the conditions under which an [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// matches a request. Conditions are based on information about the source of
// the request. The request must satisfy what is defined in `sources` AND
// identity related fields in order to match.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_IngressFrom = src.ServicePerimeterConfig_IngressFrom

// Policy for ingress into [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter].
// [IngressPolicies]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// match requests based on `ingress_from` and `ingress_to` stanzas. For an
// ingress policy to match, both the `ingress_from` and `ingress_to` stanzas
// must be matched. If an [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// matches a request, the request is allowed through the perimeter boundary
// from outside the perimeter. For example, access from the internet can be
// allowed either based on an [AccessLevel]
// [google.identity.accesscontextmanager.v1.AccessLevel] or, for traffic hosted
// on Google Cloud, the project of the source network. For access from private
// networks, using the project of the hosting network is required. Individual
// ingress policies can be limited by restricting which services and/or actions
// they match using the `ingress_to` field.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_IngressPolicy = src.ServicePerimeterConfig_IngressPolicy

// The source that [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// authorizes access from.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_IngressSource = src.ServicePerimeterConfig_IngressSource
type ServicePerimeterConfig_IngressSource_AccessLevel = src.ServicePerimeterConfig_IngressSource_AccessLevel
type ServicePerimeterConfig_IngressSource_Resource = src.ServicePerimeterConfig_IngressSource_Resource

// Defines the conditions under which an [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// matches a request. Conditions are based on information about the
// [ApiOperation]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation]
// intended to be performed on the target resource of the request. The request
// must satisfy what is defined in `operations` AND `resources` in order to
// match.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_IngressTo = src.ServicePerimeterConfig_IngressTo

// An allowed method or permission of a service specified in [ApiOperation]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation].
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_MethodSelector = src.ServicePerimeterConfig_MethodSelector
type ServicePerimeterConfig_MethodSelector_Method = src.ServicePerimeterConfig_MethodSelector_Method
type ServicePerimeterConfig_MethodSelector_Permission = src.ServicePerimeterConfig_MethodSelector_Permission

// Specifies how APIs are allowed to communicate within the Service Perimeter.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeterConfig_VpcAccessibleServices = src.ServicePerimeterConfig_VpcAccessibleServices

// Specifies the type of the Perimeter. There are two types: regular and
// bridge. Regular Service Perimeter contains resources, access levels, and
// restricted services. Every resource can be in at most ONE regular Service
// Perimeter. In addition to being in a regular service perimeter, a resource
// can also be in zero or more perimeter bridges. A perimeter bridge only
// contains resources. Cross project operations are permitted if all effected
// resources share some perimeter (whether bridge or regular). Perimeter Bridge
// does not contain access levels or services: those are governed entirely by
// the regular perimeter that resource is in. Perimeter Bridges are typically
// useful when building more complex toplogies with many independent perimeters
// that need to share some data with a common perimeter, but should not be able
// to share data among themselves.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type ServicePerimeter_PerimeterType = src.ServicePerimeter_PerimeterType

// UnimplementedAccessContextManagerServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type UnimplementedAccessContextManagerServer = src.UnimplementedAccessContextManagerServer

// A request to update an `AccessLevel`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type UpdateAccessLevelRequest = src.UpdateAccessLevelRequest

// A request to update an `AccessPolicy`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type UpdateAccessPolicyRequest = src.UpdateAccessPolicyRequest

// Request of [UpdateGcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.AccessContextManager.UpdateGcpUserAccessBinding].
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type UpdateGcpUserAccessBindingRequest = src.UpdateGcpUserAccessBindingRequest

// A request to update a `ServicePerimeter`.
//
// Deprecated: Please use types in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
type UpdateServicePerimeterRequest = src.UpdateServicePerimeterRequest

// Deprecated: Please use funcs in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
func NewAccessContextManagerClient(cc grpc.ClientConnInterface) AccessContextManagerClient {
	return src.NewAccessContextManagerClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/accesscontextmanager/apiv1/accesscontextmanagerpb
func RegisterAccessContextManagerServer(s *grpc.Server, srv AccessContextManagerServer) {
	src.RegisterAccessContextManagerServer(s, srv)
}
