/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import com.hierynomus.sshj.secg.SecgUtils;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ECDSACurve;
import net.schmizz.sshj.common.ECDSAKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ECDSAVariationsAdapter {
    private static final String BASE_ALGORITHM_NAME = "ecdsa-sha2-nistp";
    private static final Logger log = LoggerFactory.getLogger(ECDSAVariationsAdapter.class);
    public static final Map<String, String> SUPPORTED_CURVES = new HashMap<String, String>();
    public static final Map<String, ECDSACurve> NIST_CURVES = new HashMap<String, ECDSACurve>();

    ECDSAVariationsAdapter() {
    }

    static PublicKey readPubKeyFromBuffer(Buffer<?> buf, String variation) throws GeneralSecurityException {
        String algorithm = BASE_ALGORITHM_NAME + variation;
        try {
            String curveName = buf.readString();
            int keyLen = buf.readUInt32AsInt();
            byte x04 = buf.readByte();
            byte[] x = new byte[(keyLen - 1) / 2];
            byte[] y = new byte[(keyLen - 1) / 2];
            buf.readRawBytes(x);
            buf.readRawBytes(y);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Key algo: %s, Key curve: %s, Key Len: %s, 0x04: %s\nx: %s\ny: %s", algorithm, curveName, keyLen, x04, Arrays.toString(x), Arrays.toString(y)));
            }
            if (!SUPPORTED_CURVES.containsValue(curveName)) {
                throw new GeneralSecurityException(String.format("Unknown curve %s", curveName));
            }
            BigInteger bigX = new BigInteger(1, x);
            BigInteger bigY = new BigInteger(1, y);
            ECPoint point = new ECPoint(bigX, bigY);
            ECDSACurve ecdsaCurve = NIST_CURVES.get(variation);
            return ECDSAKeyFactory.getPublicKey(point, ecdsaCurve);
        }
        catch (Exception ex) {
            throw new GeneralSecurityException(ex);
        }
    }

    static void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
        ECPublicKey ecdsa = (ECPublicKey)pk;
        byte[] encoded = SecgUtils.getEncoded(ecdsa.getW(), ecdsa.getParams().getCurve());
        ((Buffer)buf.putString("nistp" + ECDSAVariationsAdapter.fieldSizeFromKey(ecdsa))).putBytes(encoded);
    }

    static boolean isECKeyWithFieldSize(Key key, int fieldSize) {
        return ("ECDSA".equals(key.getAlgorithm()) || "EC".equals(key.getAlgorithm())) && key instanceof ECKey && ECDSAVariationsAdapter.fieldSizeFromKey((ECKey)((Object)key)) == fieldSize;
    }

    private static int fieldSizeFromKey(ECKey ecPublicKey) {
        return ecPublicKey.getParams().getCurve().getField().getFieldSize();
    }

    static {
        NIST_CURVES.put("256", ECDSACurve.SECP256R1);
        NIST_CURVES.put("384", ECDSACurve.SECP384R1);
        NIST_CURVES.put("521", ECDSACurve.SECP521R1);
        SUPPORTED_CURVES.put("256", "nistp256");
        SUPPORTED_CURVES.put("384", "nistp384");
        SUPPORTED_CURVES.put("521", "nistp521");
    }
}

