/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.expression;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.vcs.github.ultimate.features.expression.GithubExpressionElementType;
import com.intellij.vcs.github.ultimate.features.expression.GithubExpressionTokenType;
import com.intellij.vcs.github.ultimate.features.expression.impl.GAEBinaryAndExpressionImpl;
import com.intellij.vcs.github.ultimate.features.expression.impl.GAEBinaryOrExpressionImpl;
import com.intellij.vcs.github.ultimate.features.expression.impl.GAECompareExpressionImpl;
import com.intellij.vcs.github.ultimate.features.expression.impl.GAEFunctionCallExpressionImpl;
import com.intellij.vcs.github.ultimate.features.expression.impl.GAEParenthesizedExpressionImpl;
import com.intellij.vcs.github.ultimate.features.expression.impl.GAEPrimitiveExpressionImpl;
import com.intellij.vcs.github.ultimate.features.expression.impl.GAESelectorExpressionImpl;
import com.intellij.vcs.github.ultimate.features.expression.impl.GAESelectorSegmentImpl;
import com.intellij.vcs.github.ultimate.features.expression.impl.GAEUnaryNotExpressionImpl;

public interface GithubExpressionTokens {
    public static final IElementType BINARY_AND_EXPRESSION = new GithubExpressionElementType("BINARY_AND_EXPRESSION");
    public static final IElementType BINARY_OR_EXPRESSION = new GithubExpressionElementType("BINARY_OR_EXPRESSION");
    public static final IElementType COMPARE_EXPRESSION = new GithubExpressionElementType("COMPARE_EXPRESSION");
    public static final IElementType EXPRESSION = new GithubExpressionElementType("EXPRESSION");
    public static final IElementType FUNCTION_CALL_EXPRESSION = new GithubExpressionElementType("FUNCTION_CALL_EXPRESSION");
    public static final IElementType PARENTHESIZED_EXPRESSION = new GithubExpressionElementType("PARENTHESIZED_EXPRESSION");
    public static final IElementType PRIMITIVE_EXPRESSION = new GithubExpressionElementType("PRIMITIVE_EXPRESSION");
    public static final IElementType SELECTOR_EXPRESSION = new GithubExpressionElementType("SELECTOR_EXPRESSION");
    public static final IElementType SELECTOR_SEGMENT = new GithubExpressionElementType("SELECTOR_SEGMENT");
    public static final IElementType UNARY_NOT_EXPRESSION = new GithubExpressionElementType("UNARY_NOT_EXPRESSION");
    public static final IElementType ANY_NODE = new GithubExpressionTokenType("*");
    public static final IElementType BINARY_AND = new GithubExpressionTokenType("&&");
    public static final IElementType BINARY_EQUAL = new GithubExpressionTokenType("==");
    public static final IElementType BINARY_GREATER = new GithubExpressionTokenType(">");
    public static final IElementType BINARY_GREATER_OR_EQUAL = new GithubExpressionTokenType(">=");
    public static final IElementType BINARY_LESS = new GithubExpressionTokenType("<");
    public static final IElementType BINARY_LESS_OR_EQUAL = new GithubExpressionTokenType("<=");
    public static final IElementType BINARY_NOT_EQUAL = new GithubExpressionTokenType("!=");
    public static final IElementType BINARY_OR = new GithubExpressionTokenType("||");
    public static final IElementType COMMA = new GithubExpressionTokenType(",");
    public static final IElementType DOT = new GithubExpressionTokenType(".");
    public static final IElementType EXPRESSION_END_MARKER = new GithubExpressionTokenType("}}");
    public static final IElementType EXPRESSION_START_MARKER = new GithubExpressionTokenType("${{");
    public static final IElementType FALSE = new GithubExpressionTokenType("false");
    public static final IElementType IDENTIFIER = new GithubExpressionTokenType("IDENTIFIER");
    public static final IElementType LEFT_GROUPING_PARENTHESIS = new GithubExpressionTokenType("(");
    public static final IElementType LEFT_INDEX_BRACE = new GithubExpressionTokenType("[");
    public static final IElementType NULL = new GithubExpressionTokenType("null");
    public static final IElementType NUMBER = new GithubExpressionTokenType("NUMBER");
    public static final IElementType RIGHT_GROUPING_PARENTHESIS = new GithubExpressionTokenType(")");
    public static final IElementType RIGHT_INDEX_BRACE = new GithubExpressionTokenType("]");
    public static final IElementType SINGLE_QUOTED_STRING = new GithubExpressionTokenType("SINGLE_QUOTED_STRING");
    public static final IElementType TRUE = new GithubExpressionTokenType("true");
    public static final IElementType UNARY_NOT = new GithubExpressionTokenType("!");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == BINARY_AND_EXPRESSION) {
                return new GAEBinaryAndExpressionImpl(node);
            }
            if (type == BINARY_OR_EXPRESSION) {
                return new GAEBinaryOrExpressionImpl(node);
            }
            if (type == COMPARE_EXPRESSION) {
                return new GAECompareExpressionImpl(node);
            }
            if (type == FUNCTION_CALL_EXPRESSION) {
                return new GAEFunctionCallExpressionImpl(node);
            }
            if (type == PARENTHESIZED_EXPRESSION) {
                return new GAEParenthesizedExpressionImpl(node);
            }
            if (type == PRIMITIVE_EXPRESSION) {
                return new GAEPrimitiveExpressionImpl(node);
            }
            if (type == SELECTOR_EXPRESSION) {
                return new GAESelectorExpressionImpl(node);
            }
            if (type == SELECTOR_SEGMENT) {
                return new GAESelectorSegmentImpl(node);
            }
            if (type == UNARY_NOT_EXPRESSION) {
                return new GAEUnaryNotExpressionImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

