/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalInstantPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalRoundDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalInstantNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.math.BigInteger;
import java.util.EnumSet;

public class TemporalInstantPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalInstantPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalInstantPrototypeBuiltins();

    protected TemporalInstantPrototypeBuiltins() {
        super(JSTemporalInstant.PROTOTYPE_NAME, TemporalInstantPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalInstantPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantGetterNodeGen.create(context, builtin, builtinEnum, TemporalInstantPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 4: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantAddSubNodeGen.create(context, builtin, 1, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 5: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantAddSubNodeGen.create(context, builtin, -1, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 6: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantUntilSinceNodeGen.create(context, builtin, true, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 7: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantUntilSinceNodeGen.create(context, builtin, false, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 8: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantRoundNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 9: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantEqualsNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 10: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToStringNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 11: 
            case 12: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToLocaleStringNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 13: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantValueOfNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 14: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToZonedDateTimeNodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 15: {
                return TemporalInstantPrototypeBuiltinsFactory.JSTemporalInstantToZonedDateTimeISONodeGen.create(context, builtin, TemporalInstantPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalInstantPrototype implements BuiltinEnum<TemporalInstantPrototype>
    {
        epochSeconds(0),
        epochMilliseconds(0),
        epochMicroseconds(0),
        epochNanoseconds(0),
        add(1),
        subtract(1),
        until(1),
        since(1),
        round(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0),
        toZonedDateTime(1),
        toZonedDateTimeISO(1);

        private final int length;

        private TemporalInstantPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(epochSeconds, epochMilliseconds, epochMicroseconds, epochNanoseconds).contains(this);
        }
    }

    public static abstract class JSTemporalInstantGetterNode
    extends JSBuiltinNode {
        protected final TemporalInstantPrototype property;

        protected JSTemporalInstantGetterNode(JSContext context, JSBuiltin builtin, TemporalInstantPrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object instantGetter(JSTemporalInstantObject instant) {
            BigInteger ns = instant.getNanoseconds().bigIntegerValue();
            switch (this.property.ordinal()) {
                case 0: {
                    return ns.divide(TemporalUtil.BI_10_POW_9).doubleValue();
                }
                case 1: {
                    return ns.divide(TemporalUtil.BI_10_POW_6).doubleValue();
                }
                case 2: {
                    return new BigInt(ns.divide(TemporalUtil.BI_1000));
                }
                case 3: {
                    return instant.getNanoseconds();
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalInstantAddSubNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected JSTemporalInstantObject addDurationToOrSubtractDurationFromInstant(JSTemporalInstantObject instant, Object temporalDurationLike, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached InlinedBranchProfile errorBranch) {
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            if (duration.getDays() != 0.0 || duration.getMonths() != 0.0 || duration.getWeeks() != 0.0 || duration.getYears() != 0.0) {
                errorBranch.enter(this);
                throw Errors.createRangeError("Temporal.Instant does not support adding or subtracting a Duration with non-zero days, months, weeks, or years.");
            }
            BigInt ns = TemporalUtil.addInstant(instant.getNanoseconds(), (double)this.sign * duration.getHours(), (double)this.sign * duration.getMinutes(), (double)this.sign * duration.getSeconds(), (double)this.sign * duration.getMilliseconds(), (double)this.sign * duration.getMicroseconds(), (double)this.sign * duration.getNanoseconds());
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), ns);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDurationLike) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final boolean isUntil;

        protected JSTemporalInstantUntilSinceNode(JSContext context, JSBuiltin builtin, boolean isUntil) {
            super(context, builtin);
            this.isUntil = isUntil;
        }

        @Specialization
        protected JSTemporalDurationObject differenceTemporalInstant(JSTemporalInstantObject instant, Object otherObj, Object optionsParam, @Cached JSToNumberNode toNumber, @Cached TruffleString.EqualNode equalNode, @Cached ToTemporalInstantNode toTemporalInstantNode, @Cached TemporalGetOptionNode getOptionNode, @Cached TemporalRoundDurationNode roundDurationNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalInstantObject other = toTemporalInstantNode.execute(otherObj);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Unit smallestUnit = JSTemporalInstantUntilSinceNode.toSmallestTemporalUnit(options, TemporalUtil.listYMWD, TemporalConstants.NANOSECOND, equalNode, getOptionNode, this, errorBranch);
            TemporalUtil.Unit defaultLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(TemporalUtil.Unit.SECOND, smallestUnit);
            TemporalUtil.Unit largestUnit = JSTemporalInstantUntilSinceNode.toLargestTemporalUnit(options, TemporalUtil.listYMWD, TemporalConstants.AUTO, defaultLargestUnit, equalNode, getOptionNode, this, errorBranch);
            TemporalUtil.validateTemporalUnitRange(largestUnit, smallestUnit);
            TemporalUtil.RoundingMode roundingMode = JSTemporalInstantUntilSinceNode.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            Double maximum = TemporalUtil.maximumTemporalDurationRoundingIncrement(smallestUnit);
            double roundingIncrement = TemporalUtil.toTemporalRoundingIncrement(options, maximum, false, this.isObjectNode, toNumber);
            BigInt one = this.isUntil ? instant.getNanoseconds() : other.getNanoseconds();
            BigInt two = this.isUntil ? other.getNanoseconds() : instant.getNanoseconds();
            TimeDurationRecord result = TemporalUtil.differenceInstant(one, two, roundingIncrement, smallestUnit, largestUnit, roundingMode, roundDurationNode);
            JSRealm realm = this.getRealm();
            return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, 0.0, 0.0, 0.0, 0.0, result.hours(), result.minutes(), result.seconds(), result.milliseconds(), result.microseconds(), result.nanoseconds(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantRound
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantRound(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalInstantObject round(JSTemporalInstantObject instant, Object roundToParam, @Cached JSToNumberNode toNumber, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            double maximum;
            JSDynamicObject roundTo;
            if (roundToParam == Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            if (Strings.isTString(roundToParam)) {
                roundTo = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(roundTo, TemporalConstants.SMALLEST_UNIT, JSRuntime.toStringIsString(roundToParam));
            } else {
                roundTo = this.getOptionsObject(roundToParam, this, errorBranch, optionUndefined);
            }
            TemporalUtil.Unit smallestUnit = JSTemporalInstantRound.toSmallestTemporalUnit(roundTo, TemporalUtil.listYMWD, null, equalNode, getOptionNode, this, errorBranch);
            if (smallestUnit == TemporalUtil.Unit.EMPTY) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorSmallestUnitExpected();
            }
            TemporalUtil.RoundingMode roundingMode = JSTemporalInstantRound.toTemporalRoundingMode(roundTo, TemporalConstants.HALF_EXPAND, equalNode, getOptionNode);
            if (TemporalUtil.Unit.HOUR == smallestUnit) {
                maximum = 24.0;
            } else if (TemporalUtil.Unit.MINUTE == smallestUnit) {
                maximum = 1440.0;
            } else if (TemporalUtil.Unit.SECOND == smallestUnit) {
                maximum = 86400.0;
            } else if (TemporalUtil.Unit.MILLISECOND == smallestUnit) {
                maximum = 8.64E7;
            } else if (TemporalUtil.Unit.MICROSECOND == smallestUnit) {
                maximum = 8.64E10;
            } else {
                assert (TemporalUtil.Unit.NANOSECOND == smallestUnit);
                maximum = 8.64E13;
            }
            double roundingIncrement = TemporalUtil.toTemporalRoundingIncrement(roundTo, maximum, true, this.isObjectNode, toNumber);
            BigInt roundedNs = TemporalUtil.roundTemporalInstant(instant.getNanoseconds(), (long)roundingIncrement, smallestUnit, roundingMode);
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), roundedNs);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object roundToParam) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantEquals
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantEquals(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equals(JSTemporalInstantObject instant, Object otherObj, @Cached ToTemporalInstantNode toTemporalInstantNode) {
            JSTemporalInstantObject other = toTemporalInstantNode.execute(otherObj);
            return instant.getNanoseconds().compareTo(other.getNanoseconds()) == 0;
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherObj) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalInstantObject instant, Object optionsParam, @Cached ToTemporalTimeZoneNode toTemporalTimeZone, @Cached JSToStringNode toStringNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            Object timeZoneRaw = JSObject.get(options, TemporalConstants.TIME_ZONE);
            JSDynamicObject timeZone = Undefined.instance;
            if (timeZoneRaw != Undefined.instance) {
                timeZone = toTemporalTimeZone.execute(timeZoneRaw);
            }
            JSTemporalPrecisionRecord precision = TemporalUtil.toSecondsStringPrecision(options, toStringNode, getOptionNode, equalNode);
            TemporalUtil.RoundingMode roundingMode = JSTemporalInstantToString.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            BigInt ns = instant.getNanoseconds();
            BigInt roundedNs = TemporalUtil.roundTemporalInstant(ns, (long)precision.getIncrement(), precision.getUnit(), roundingMode);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject roundedInstant = JSTemporalInstant.create(this.getContext(), realm, roundedNs);
            return TemporalUtil.temporalInstantToString(this.getContext(), realm, roundedInstant, timeZone, precision.getPrecision());
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toLocaleString(JSTemporalInstantObject instant) {
            return TemporalUtil.temporalInstantToString(this.getContext(), this.getRealm(), instant, Undefined.instance, TemporalConstants.AUTO);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantValueOf
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantValueOf(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object valueOf(Object thisObj) {
            throw Errors.createTypeError("Not supported.");
        }
    }

    public static abstract class JSTemporalInstantToZonedDateTimeNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToZonedDateTimeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalZonedDateTimeObject toZonedDateTime(JSTemporalInstantObject instant, Object item, @Cached ToTemporalCalendarNode toTemporalCalendar, @Cached ToTemporalTimeZoneNode toTemporalTimeZone, @Cached InlinedBranchProfile errorBranch) {
            if (!this.isObject(item)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("object expected");
            }
            JSDynamicObject itemObj = TemporalUtil.toJSDynamicObject(item, this, errorBranch);
            Object calendarLike = JSObject.get(itemObj, TemporalConstants.CALENDAR);
            if (calendarLike == Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
            }
            JSDynamicObject calendar = toTemporalCalendar.execute(calendarLike);
            Object timeZoneLike = JSObject.get(itemObj, TemporalConstants.TIME_ZONE);
            if (timeZoneLike == Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
            }
            JSDynamicObject timeZone = toTemporalTimeZone.execute(timeZoneLike);
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), instant.getNanoseconds(), timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }

    public static abstract class JSTemporalInstantToZonedDateTimeISONode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalInstantToZonedDateTimeISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalZonedDateTimeObject toZonedDateTimeISO(JSTemporalInstantObject instant, Object itemParam, @Cached ToTemporalTimeZoneNode toTemporalTimeZone, @Cached InlinedBranchProfile errorBranch) {
            JSDynamicObject itemObj;
            Object timeZoneProperty;
            Object item = itemParam;
            if (this.isObject(item) && (timeZoneProperty = JSObject.get(itemObj = TemporalUtil.toJSDynamicObject(item, this, errorBranch), TemporalConstants.TIME_ZONE)) != Undefined.instance) {
                item = timeZoneProperty;
            }
            JSDynamicObject timeZone = toTemporalTimeZone.execute(item);
            JSRealm realm = this.getRealm();
            JSTemporalCalendarObject calendar = TemporalUtil.getISO8601Calendar(this.getContext(), realm);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, instant.getNanoseconds(), timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalInstant(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalInstantExpected();
        }
    }
}

