/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.AbstractFunctionRootNode;
import com.oracle.truffle.js.nodes.function.FunctionBodyNode;
import com.oracle.truffle.js.nodes.function.SpecializedNewObjectNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSGenerator;
import com.oracle.truffle.js.runtime.builtins.JSGeneratorObject;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Objects;
import java.util.Set;

public final class GeneratorBodyNode
extends JavaScriptNode {
    @Node.Child
    private SpecializedNewObjectNode createGeneratorObject;
    private final GeneratorRootNode generatorRootNode;
    private final JSContext context;

    private GeneratorBodyNode(JSContext context, GeneratorRootNode generatorRootNode) {
        this.context = context;
        this.createGeneratorObject = SpecializedNewObjectNode.create(context, false, true, true, false, JSGenerator.INSTANCE);
        this.generatorRootNode = generatorRootNode;
    }

    public static GeneratorBodyNode create(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode writeYieldValue, JSReadFrameSlotNode readYieldResult, SourceSection functionSourceSection, TruffleString functionName, ScriptOrModule activeScriptOrModule) {
        GeneratorRootNode resumptionRootNode = new GeneratorRootNode(context, body, writeYieldValue, readYieldResult, functionSourceSection, functionName, activeScriptOrModule);
        return new GeneratorBodyNode(context, resumptionRootNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        JSGeneratorObject generatorObject = (JSGeneratorObject)this.createGeneratorObject.execute(frame, JSFrameUtil.getFunctionObject(frame));
        this.generatorStart(frame, generatorObject);
        return generatorObject;
    }

    private void generatorStart(VirtualFrame frame, JSGeneratorObject generatorObject) {
        generatorObject.setGeneratorState(JSFunction.GeneratorState.SuspendedStart);
        generatorObject.setGeneratorContext(frame.materialize());
        generatorObject.setGeneratorTarget(this.generatorRootNode.getCallTarget());
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new GeneratorBodyNode(this.context, this.generatorRootNode);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (!materializedTags.isEmpty()) {
            this.generatorRootNode.getCallTarget();
        }
        return this;
    }

    private static final class GeneratorRootNode
    extends AbstractFunctionRootNode {
        @Node.Child
        private CreateIterResultObjectNode createIterResultObject;
        @Node.Child
        private JavaScriptNode functionBody;
        @Node.Child
        private JSWriteFrameSlotNode writeYieldValue;
        @Node.Child
        private JSReadFrameSlotNode readYieldResult;
        private final BranchProfile errorBranch = BranchProfile.create();
        private final ConditionProfile returnOrExceptionProfile = ConditionProfile.create();
        private final TruffleString functionName;

        GeneratorRootNode(JSContext context, JavaScriptNode functionBody, JSWriteFrameSlotNode writeYieldValueNode, JSReadFrameSlotNode readYieldResultNode, SourceSection functionSourceSection, TruffleString functionName, ScriptOrModule activeScriptOrModule) {
            super(context.getLanguage(), functionSourceSection, null, activeScriptOrModule);
            this.createIterResultObject = CreateIterResultObjectNode.create(context);
            this.functionBody = new FunctionBodyNode(functionBody);
            this.writeYieldValue = Objects.requireNonNull(writeYieldValueNode);
            this.readYieldResult = Objects.requireNonNull(readYieldResultNode);
            this.functionName = functionName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object executeInRealm(VirtualFrame frame) {
            Object[] arguments = frame.getArguments();
            MaterializedFrame generatorFrame = JSArguments.getResumeExecutionContext(arguments);
            JSGeneratorObject generatorObject = (JSGeneratorObject)JSArguments.getResumeGeneratorOrPromiseCapability(arguments);
            Completion.Type completionType = JSArguments.getResumeCompletionType(arguments);
            Object value = JSArguments.getResumeCompletionValue(arguments);
            JSFunction.GeneratorState generatorState = this.generatorValidate(generatorObject);
            if (completionType == Completion.Type.Normal) {
                if (JSFunction.GeneratorState.Completed.equals((Object)generatorState)) {
                    return this.createIterResultObject.execute(frame, Undefined.instance, true);
                }
                assert (JSFunction.GeneratorState.SuspendedStart.equals((Object)generatorState) || JSFunction.GeneratorState.SuspendedYield.equals((Object)generatorState));
            } else {
                Completion completion = Completion.create(completionType, value);
                assert (completion.isThrow() || completion.isReturn());
                if (JSFunction.GeneratorState.SuspendedStart.equals((Object)generatorState)) {
                    generatorState = JSFunction.GeneratorState.Completed;
                    generatorObject.setGeneratorState(generatorState);
                }
                if (JSFunction.GeneratorState.Completed.equals((Object)generatorState)) {
                    if (this.returnOrExceptionProfile.profile(completion.isReturn())) {
                        return this.createIterResultObject.execute(frame, completion.getValue(), true);
                    }
                    assert (completion.isThrow());
                    throw UserScriptException.create(completion.getValue(), this, this.getLanguage().getJSContext().getLanguageOptions().stackTraceLimit());
                }
                assert (JSFunction.GeneratorState.SuspendedYield.equals((Object)generatorState));
                value = completion;
            }
            generatorState = JSFunction.GeneratorState.Executing;
            generatorObject.setGeneratorState(generatorState);
            this.writeYieldValue.executeWrite(generatorFrame, value);
            try {
                Object result = this.functionBody.execute(generatorFrame);
                JSObject jSObject = this.createIterResultObject.execute(frame, result, true);
                return jSObject;
            }
            catch (YieldException e) {
                generatorState = JSFunction.GeneratorState.SuspendedYield;
                Object object = this.readYieldResult == null ? e.getResult() : this.readYieldResult.execute(generatorFrame);
                return object;
            }
            finally {
                if (JSFunction.GeneratorState.Executing.equals((Object)generatorState)) {
                    generatorState = JSFunction.GeneratorState.Completed;
                }
                generatorObject.setGeneratorState(generatorState);
            }
        }

        private JSFunction.GeneratorState generatorValidate(JSGeneratorObject generatorObject) {
            JSFunction.GeneratorState generatorState = generatorObject.getGeneratorState();
            if (JSFunction.GeneratorState.Executing.equals((Object)generatorState)) {
                this.errorBranch.enter();
                throw Errors.createTypeError("generator is already executing");
            }
            return generatorState;
        }

        @Override
        public boolean isResumption() {
            return true;
        }

        @Override
        public String getName() {
            if (this.functionName != null && !this.functionName.isEmpty()) {
                return Strings.toJavaString(this.functionName);
            }
            return ":generator";
        }
    }
}

