/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.control.GeneratorNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.runtime.Errors;
import java.util.Set;

public final class GeneratorWrapperNode
extends JavaScriptNode
implements RepeatingNode,
GeneratorNode {
    @Node.Child
    private JavaScriptNode childNode;
    private final int stateSlot;

    private GeneratorWrapperNode(JavaScriptNode childNode, int stateSlot) {
        assert (childNode instanceof ResumableNode) : childNode;
        this.childNode = childNode;
        this.stateSlot = stateSlot;
    }

    public static JavaScriptNode createWrapper(JavaScriptNode child, int stateSlot) {
        return new GeneratorWrapperNode(child, stateSlot);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        JavaScriptNode child;
        Node node = child = this.childNode instanceof InstrumentableNode.WrapperNode ? ((InstrumentableNode.WrapperNode)((Object)this.childNode)).getDelegateNode() : this.childNode;
        if (child instanceof JavaScriptNode) {
            return child.hasTag(tag);
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        JavaScriptNode child;
        Node node = child = this.childNode instanceof InstrumentableNode.WrapperNode ? ((InstrumentableNode.WrapperNode)((Object)this.childNode)).getDelegateNode() : this.childNode;
        if (child instanceof JavaScriptNode) {
            return child.getNodeObject();
        }
        return null;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Node child = this.childNode;
        if (child instanceof InstrumentableNode.WrapperNode) {
            child = ((InstrumentableNode.WrapperNode)((Object)child)).getDelegateNode();
        }
        if (child instanceof ResumableNode) {
            return ((ResumableNode)((Object)child)).resume(frame, this.stateSlot);
        }
        assert (false) : child.getClass();
        throw Errors.shouldNotReachHere();
    }

    @Override
    public boolean executeRepeating(VirtualFrame frame) {
        assert (this.childNode instanceof ResumableNode && this.childNode instanceof RepeatingNode) : this.childNode.getClass();
        return (Boolean)this.execute(frame);
    }

    public JavaScriptNode getResumableNode() {
        return this.childNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new GeneratorWrapperNode(GeneratorWrapperNode.cloneUninitialized(this.childNode, materializedTags), this.stateSlot);
    }
}

