/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.ast.AtomicGroup;
import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.SubexpressionCall;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.ArrayList;
import java.util.List;
import java.util.PrimitiveIterator;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class CalcASTPropsVisitor
extends DepthFirstTraversalRegexASTVisitor {
    private static final int AND_FLAGS = 50;
    private static final int OR_FLAGS = 2064396;
    private static final int CHANGED_FLAGS = 2064446;
    private final RegexAST ast;
    private final CompilationBuffer compilationBuffer;
    private final EconomicMap<Integer, List<Group>> conditionalBackReferences;
    private final EconomicMap<Integer, List<Group>> conditionGroups;

    public CalcASTPropsVisitor(RegexAST ast, CompilationBuffer compilationBuffer) {
        this.ast = ast;
        this.compilationBuffer = compilationBuffer;
        this.conditionalBackReferences = EconomicMap.create(ast.getConditionGroups().numberOfSetBits());
        this.conditionGroups = EconomicMap.create(ast.getConditionGroups().numberOfSetBits());
    }

    public static void run(RegexAST ast, CompilationBuffer compilationBuffer) {
        CalcASTPropsVisitor visitor = new CalcASTPropsVisitor(ast, compilationBuffer);
        visitor.runReverse(ast.getRoot());
        visitor.run(ast.getRoot());
        visitor.checkConditionalBackReferences();
        visitor.registerConditionGroupsInLookAheadAssertions();
    }

    @Override
    protected void init(RegexASTNode runRoot) {
        runRoot.setMinPath(0);
        runRoot.setMaxPath(0);
    }

    @Override
    protected void visit(BackReference backReference) {
        this.ast.getProperties().setBackReferences();
        if (backReference.isNestedBackReference() && this.ast.getOptions().getFlavor().supportsRecursiveBackreferences()) {
            this.ast.getProperties().setRecursiveBackReferences();
        }
        backReference.setHasBackReferences();
        backReference.getParent().setHasBackReferences();
        if (backReference.hasQuantifier()) {
            this.setZeroWidthQuantifierIndex(backReference);
        }
        if (backReference.hasNotUnrolledQuantifier()) {
            backReference.getParent().setHasQuantifiers();
            this.setQuantifierIndex(backReference);
        }
        backReference.setMinPath(backReference.getParent().getMinPath());
        backReference.setMaxPath(backReference.getParent().getMaxPath());
    }

    @Override
    protected void visit(Group group) {
        if (group.getParent().isSequence() || group.getParent().isAtomicGroup()) {
            group.setMinPath(group.getParent().getMinPath());
            group.setMaxPath(group.getParent().getMaxPath());
        } else {
            assert (group.getParent().isLookAroundAssertion() || group.getParent().isRoot());
            group.setMinPath(0);
            group.setMaxPath(0);
        }
    }

    @Override
    protected void leave(Group group) {
        if (group.size() > 1) {
            this.ast.getProperties().setAlternations();
        }
        if (group.isConditionalBackReferenceGroup()) {
            assert (group.size() == 2);
            this.ast.getProperties().setConditionalBackReferences();
        }
        if (group.getGroupNumber() > 0) {
            this.ast.getProperties().setCaptureGroups();
        }
        if (this.isForward()) {
            int groupNumber = group.getGroupNumber();
            if (groupNumber > 0 && this.ast.getConditionGroups().get(groupNumber)) {
                if (!this.conditionGroups.containsKey(groupNumber)) {
                    this.conditionGroups.put(groupNumber, new ArrayList());
                }
                ((List)this.conditionGroups.get(groupNumber)).add(group);
            }
            if (group.isConditionalBackReferenceGroup()) {
                int referencedGroupNumber = group.asConditionalBackReferenceGroup().getReferencedGroupNumber();
                if (!this.conditionalBackReferences.containsKey(referencedGroupNumber)) {
                    this.conditionalBackReferences.put(referencedGroupNumber, new ArrayList());
                }
                ((List)this.conditionalBackReferences.get(referencedGroupNumber)).add(group);
            }
        }
        if (group.isDead()) {
            if (group.getParent() != null) {
                group.getParent().markAsDead();
            }
            return;
        }
        int minPath = Integer.MAX_VALUE;
        int maxPath = 0;
        int prefixLengthMin = 0;
        int prefixLengthMax = 0;
        int flags = (group.isLoop() ? 32768 : 0) | 0x32;
        for (Sequence s : group.getAlternatives()) {
            if (s.isDead()) continue;
            flags = flags & (s.getFlags(50) | 0xFFFFFFCD) | s.getFlags(2064396);
            minPath = Math.min(minPath, s.getMinPath());
            maxPath = Math.max(maxPath, s.getMaxPath());
            if (!this.isForward()) continue;
            prefixLengthMin = Math.min(prefixLengthMin, s.getPrefixLengthMin());
            prefixLengthMax = Math.max(prefixLengthMax, s.getPrefixLengthMax());
        }
        if (group.hasQuantifier()) {
            if (!group.isExpandedQuantifier()) {
                flags |= 0x20000;
                this.setQuantifierIndex(group);
                if (group.getQuantifier().getMin() == 0) {
                    flags &= 0xFFFFFFCF;
                }
                minPath = group.getMinPath() + (minPath - group.getMinPath()) * group.getQuantifier().getMin();
                if (group.getQuantifier().isInfiniteLoop()) {
                    flags |= 0x8000;
                } else {
                    maxPath = group.getMaxPath() + (maxPath - group.getMaxPath()) * group.getQuantifier().getMax();
                }
            }
            if (this.ast.getOptions().getFlavor().canHaveEmptyLoopIterations() || (flags & 0x1C0000) != 0) {
                if (group.getFirstAlternative().isExpandedQuantifier()) {
                    assert (group.size() == 2);
                    if (group.getLastAlternative().getMinPath() - group.getMinPath() == 0) {
                        this.setZeroWidthQuantifierIndex(group);
                    }
                } else if (group.getLastAlternative().isExpandedQuantifier()) {
                    assert (group.size() == 2);
                    if (group.getFirstAlternative().getMinPath() - group.getMinPath() == 0) {
                        this.setZeroWidthQuantifierIndex(group);
                    }
                } else if (minPath - group.getMinPath() == 0) {
                    this.setZeroWidthQuantifierIndex(group);
                }
            }
        }
        if (group.isCapturing()) {
            flags |= 0x10000;
            if (group.getMinPath() == minPath && group.getMaxPath() == maxPath) {
                this.ast.getProperties().setEmptyCaptureGroups();
            }
        }
        group.setFlags(flags, 2064446);
        group.setMinPath(minPath);
        group.setMaxPath(maxPath);
        if (this.isForward()) {
            group.setPrefixLengthMin(prefixLengthMin);
            group.setPrefixLengthMax(prefixLengthMax);
        }
        if (group.getParent().isSequence() || group.getParent().isAtomicGroup()) {
            group.getParent().setMinPath(minPath);
            group.getParent().setMaxPath(maxPath);
        }
        if (group.getParent() != null) {
            group.getParent().setFlags(group.getParent().getFlags(2064446) | flags, 2064446);
            if (this.isForward()) {
                group.getParent().setPrefixLengthMin(prefixLengthMin);
                group.getParent().setPrefixLengthMax(prefixLengthMax);
            }
        }
    }

    @Override
    protected void visit(Sequence sequence) {
        sequence.setMinPath(sequence.getParent().getMinPath());
        sequence.setMaxPath(sequence.getParent().getMaxPath());
    }

    @Override
    protected void leave(Sequence sequence) {
        int i = 0;
        int prefixLengthMin = 0;
        int prefixLengthMax = 0;
        while (i < sequence.size()) {
            LookAroundAssertion lookAround;
            Term term = sequence.get(i);
            if (term.isLookAroundAssertion() && (lookAround = term.asLookAroundAssertion()).isNegated() && lookAround.isDead()) {
                sequence.removeTerm(i, this.compilationBuffer);
                continue;
            }
            if (this.isForward()) {
                prefixLengthMin = Math.max(prefixLengthMin, term.getPrefixLengthMin());
                prefixLengthMax = Math.max(prefixLengthMax, term.getPrefixLengthMax());
            }
            ++i;
        }
        if (this.isForward()) {
            sequence.setPrefixLengthMin(prefixLengthMin);
            sequence.setPrefixLengthMax(prefixLengthMax);
        }
    }

    @Override
    protected void visit(PositionAssertion assertion) {
        switch (assertion.type) {
            case CARET: {
                if (!this.isForward()) break;
                assertion.getParent().setHasCaret();
                if (assertion.getParent().getMinPath() > 0) {
                    assertion.markAsDead();
                    assertion.getParent().markAsDead();
                    break;
                }
                assertion.getParent().setStartsWithCaret();
                break;
            }
            case DOLLAR: {
                if (!this.isReverse()) break;
                assertion.getParent().setHasDollar();
                if (assertion.getParent().getMinPath() > 0) {
                    assertion.markAsDead();
                    assertion.getParent().markAsDead();
                    break;
                }
                assertion.getParent().setEndsWithDollar();
            }
        }
        assertion.setMinPath(assertion.getParent().getMinPath());
        assertion.setMaxPath(assertion.getParent().getMaxPath());
    }

    @Override
    protected void visit(LookBehindAssertion assertion) {
        assertion.getParent().setHasLookBehinds();
        assertion.setMinPath(assertion.getParent().getMinPath());
        assertion.setMaxPath(assertion.getParent().getMaxPath());
    }

    @Override
    protected void leave(LookBehindAssertion assertion) {
        if (this.isForward() && !assertion.isDead()) {
            if (assertion.isNegated()) {
                this.ast.getProperties().setNegativeLookBehindAssertions();
            } else {
                this.ast.getProperties().setLookBehindAssertions();
            }
            if (!assertion.isLiteral()) {
                this.ast.getProperties().setNonLiteralLookBehindAssertions();
            }
            int minPath = assertion.getMinPath();
            int maxPath = assertion.getMaxPath();
            RegexASTSubtreeRootNode laParent = assertion.getSubTreeParent();
            while (!(laParent instanceof RegexASTRootNode)) {
                if (laParent instanceof LookBehindAssertion) {
                    this.ast.getProperties().setNestedLookBehindAssertions();
                }
                minPath += laParent.getMinPath();
                maxPath += laParent.getMaxPath();
                laParent = laParent.getSubTreeParent();
            }
            if (assertion.isLiteral()) {
                assertion.setPrefixLengthMin(Math.max(0, assertion.getLiteralLength() - maxPath));
                assertion.setPrefixLengthMax(Math.max(0, assertion.getLiteralLength() - minPath));
            }
        }
        this.leaveLookAroundAssertion(assertion);
    }

    @Override
    protected void visit(LookAheadAssertion assertion) {
        assertion.getParent().setHasLookAheads();
        assertion.setMinPath(assertion.getParent().getMinPath());
        assertion.setMaxPath(assertion.getParent().getMaxPath());
    }

    @Override
    protected void leave(LookAheadAssertion assertion) {
        if (this.isForward() && !assertion.isDead()) {
            if (assertion.isNegated()) {
                this.ast.getProperties().setNegativeLookAheadAssertions();
            } else {
                this.ast.getProperties().setLookAheadAssertions();
            }
        }
        this.leaveLookAroundAssertion(assertion);
    }

    @Override
    protected void visit(AtomicGroup atomicGroup) {
        atomicGroup.setMinPath(atomicGroup.getParent().getMinPath());
        atomicGroup.setMaxPath(atomicGroup.getParent().getMaxPath());
    }

    @Override
    protected void leave(AtomicGroup atomicGroup) {
        if (this.isForward() && !atomicGroup.isDead()) {
            this.ast.getProperties().setAtomicGroups();
        }
        CalcASTPropsVisitor.leaveSubtreeRootNode(atomicGroup, 2064446);
        atomicGroup.getParent().setMinPath(atomicGroup.getMinPath());
        atomicGroup.getParent().setMaxPath(atomicGroup.getMaxPath());
    }

    private void leaveLookAroundAssertion(LookAroundAssertion assertion) {
        if (assertion.hasCaptureGroups()) {
            this.ast.getProperties().setCaptureGroupsInLookAroundAssertions();
        }
        CalcASTPropsVisitor.leaveSubtreeRootNode(assertion, assertion.isNegated() ? 2064396 : (assertion.isLookBehindAssertion() ? 2064398 : 2064446));
    }

    private static void leaveSubtreeRootNode(RegexASTSubtreeRootNode subtreeRootNode, int flagMask) {
        subtreeRootNode.getParent().setFlags(subtreeRootNode.getFlags(flagMask) | subtreeRootNode.getParent().getFlags(flagMask), flagMask);
    }

    @Override
    protected void visit(CharacterClass characterClass) {
        if (this.isForward()) {
            if (!characterClass.getCharSet().matchesSingleChar()) {
                if (!characterClass.getCharSet().matches2CharsWith1BitDifference()) {
                    this.ast.getProperties().unsetCharClassesCanBeMatchedWithMask();
                }
                if (!this.ast.getEncoding().isFixedCodePointWidth(characterClass.getCharSet())) {
                    this.ast.getProperties().unsetFixedCodePointWidth();
                }
                this.ast.getProperties().setCharClasses();
            }
            if (this.ast.getEncoding() == Encodings.UTF_16 && Constants.SURROGATES.intersects(characterClass.getCharSet())) {
                this.ast.getProperties().setLoneSurrogates();
            }
        }
        if (characterClass.hasNotUnrolledQuantifier()) {
            characterClass.getParent().setHasQuantifiers();
            this.setQuantifierIndex(characterClass);
            characterClass.getParent().incMinPath(characterClass.getQuantifier().getMin());
            if (characterClass.getQuantifier().isInfiniteLoop()) {
                characterClass.setHasLoops();
                characterClass.getParent().setHasLoops();
            } else {
                characterClass.getParent().incMaxPath(characterClass.getQuantifier().getMax());
            }
        } else {
            characterClass.getParent().incMinPath();
            characterClass.getParent().incMaxPath();
        }
        characterClass.setMinPath(characterClass.getParent().getMinPath());
        characterClass.setMaxPath(characterClass.getParent().getMaxPath());
        if (characterClass.getCharSet().matchesNothing()) {
            characterClass.markAsDead();
            characterClass.getParent().markAsDead();
        }
    }

    private void setQuantifierIndex(QuantifiableTerm term) {
        assert (term.hasQuantifier());
        if (this.isForward() && term.getQuantifier().getIndex() < 0) {
            term.getQuantifier().setIndex(this.ast.getQuantifierCount().inc());
        }
    }

    private void setZeroWidthQuantifierIndex(QuantifiableTerm term) {
        if (this.isForward() && term.getQuantifier().getZeroWidthIndex() < 0) {
            this.ast.registerZeroWidthQuantifiable(term);
        }
    }

    @Override
    protected void visit(SubexpressionCall subexpressionCall) {
        throw CompilerDirectives.shouldNotReachHere("subexpression calls should be expanded by the parser");
    }

    private void checkConditionalBackReferences() {
        PrimitiveIterator.OfInt ofInt = this.ast.getConditionGroups().iterator();
        while (ofInt.hasNext()) {
            int conditionGroupNumber = (Integer)ofInt.next();
            if (!this.conditionalBackReferences.containsKey(conditionGroupNumber)) continue;
            List references = (List)this.conditionalBackReferences.get(conditionGroupNumber);
            assert (this.conditionGroups.containsKey(conditionGroupNumber));
            List groups = (List)this.conditionGroups.get(conditionGroupNumber);
            RegexASTSubtreeRootNode referencesAncestor = CalcASTPropsVisitor.lowestCommonAncestor(references);
            for (Group conditionGroup : groups) {
                RegexASTSubtreeRootNode parent;
                RegexASTSubtreeRootNode commonAncestor = CalcASTPropsVisitor.lowestCommonAncestor(parent, referencesAncestor);
                for (parent = conditionGroup.getSubTreeParent(); parent != commonAncestor; parent = parent.getSubTreeParent()) {
                    if (!parent.isLookAheadAssertion()) continue;
                    this.ast.getProperties().setConditionalReferencesIntoLookAheads();
                    return;
                }
            }
        }
    }

    private static RegexASTSubtreeRootNode lowestCommonAncestor(List<? extends RegexASTNode> nodes) {
        if (nodes.size() == 1) {
            return nodes.get(0).getSubTreeParent();
        }
        if (nodes.size() >= 2) {
            RegexASTSubtreeRootNode ancestor = CalcASTPropsVisitor.lowestCommonAncestor(nodes.get(0).getSubTreeParent(), nodes.get(1).getSubTreeParent());
            for (int i = 2; i < nodes.size(); ++i) {
                ancestor = CalcASTPropsVisitor.lowestCommonAncestor(ancestor, nodes.get(i).getSubTreeParent());
            }
            return ancestor;
        }
        throw CompilerDirectives.shouldNotReachHere("lowestCommonAncestor called with empty list");
    }

    private static RegexASTSubtreeRootNode lowestCommonAncestor(RegexASTSubtreeRootNode argA, RegexASTSubtreeRootNode argB) {
        EconomicSet<RegexASTSubtreeRootNode> ancestorsOfA = EconomicSet.create(Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        for (RegexASTSubtreeRootNode a = argA; a != null; a = a.getSubTreeParent()) {
            ancestorsOfA.add(a);
        }
        for (RegexASTSubtreeRootNode b = argB; b != null; b = b.getSubTreeParent()) {
            if (!ancestorsOfA.contains(b)) continue;
            return b;
        }
        return null;
    }

    private void registerConditionGroupsInLookAheadAssertions() {
        PrimitiveIterator.OfInt ofInt = this.ast.getConditionGroups().iterator();
        while (ofInt.hasNext()) {
            int conditionGroupNumber = (Integer)ofInt.next();
            List references = (List)this.conditionalBackReferences.get(conditionGroupNumber);
            if (references == null) continue;
            for (Group reference : references) {
                for (RegexASTSubtreeRootNode subtreeParent = reference.getSubTreeParent(); subtreeParent != null; subtreeParent = subtreeParent.getSubTreeParent()) {
                    if (!subtreeParent.isLookAheadAssertion()) continue;
                    subtreeParent.asLookAheadAssertion().registerReferencedConditionGroup(reference.asConditionalBackReferenceGroup().getReferencedGroupNumber());
                }
            }
        }
    }
}

