/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.clientConfiguration;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.mcpserver.McpServerBundle;
import com.intellij.mcpserver.clientConfiguration.ClaudeCodeSSEConfig;
import com.intellij.mcpserver.clientConfiguration.MCPClientNames;
import com.intellij.mcpserver.clientConfiguration.McpClient;
import com.intellij.mcpserver.clientConfiguration.ServerConfig;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/mcpserver/clientConfiguration/ClaudeCodeMcpClient;", "Lcom/intellij/mcpserver/clientConfiguration/McpClient;", "configPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "isConfigured", "", "()Ljava/lang/Boolean;", "configure", "", "getSSEConfig", "Lcom/intellij/mcpserver/clientConfiguration/ServerConfig;", "intellij.mcpserver"})
public final class ClaudeCodeMcpClient
extends McpClient {
    public ClaudeCodeMcpClient(@NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        super(MCPClientNames.CLAUDE_CODE_GLOBAL, configPath);
    }

    @Override
    @Nullable
    public Boolean isConfigured() {
        Boolean bl = this.isStdIOConfigured();
        if (bl == null) {
            return null;
        }
        boolean stdio = bl;
        Boolean bl2 = this.isSSEConfigured();
        if (bl2 == null) {
            return null;
        }
        boolean sse = bl2;
        return stdio || sse;
    }

    @Override
    public void configure() {
        ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
        Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
        TasksKt.runWithModalProgressBlocking((ModalTaskOwner)modalTaskOwner, (String)McpServerBundle.INSTANCE.message("autoconfigure.progress.title", new Object[0]), (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.nonCancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ClaudeCodeMcpClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String[] stringArray = new String[]{"mcp", "add", "--scope", "user", "--transport", "sse", "jetbrains", this.this$0.getSseUrl()};
                        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withExePath("claude").withParameters(stringArray);
                        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
                        GeneralCommandLine claudeAddMCP = generalCommandLine;
                        ProcessOutput execAndGetOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)claudeAddMCP, (int)1000);
                        if (execAndGetOutput.getExitCode() != 0) {
                            throw new Exception("Claude failed with exit code " + execAndGetOutput.getExitCode() + ": " + execAndGetOutput.getStderr());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @NotNull
    protected ServerConfig getSSEConfig() {
        String string = this.getSseUrl();
        return new ClaudeCodeSSEConfig(string, "sse");
    }
}

