/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.parsing.parser;

import com.intellij.jinja.Jinja2Bundle;
import com.intellij.jinja.Jinja2TemplateUtil;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.jinja.template.parsing.parser.Jinja2TagParser;
import com.intellij.jinja.template.parsing.parser.Parsing;
import com.intellij.jinja.template.parsing.parser.TagParserRegistry;
import com.intellij.jinja.template.psi.Jinja2TemplateElementTypes;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;

public class DjangoTemplateParsing
extends Parsing
implements DjangoTemplateTokenTypes {
    private final TagParserRegistry<DjangoTemplateParsing> myTagParserRegistry;

    public DjangoTemplateParsing(PsiBuilder builder, TagParserRegistry<DjangoTemplateParsing> tagParserRegistry) {
        super(builder);
        this.myTagParserRegistry = tagParserRegistry;
    }

    public void parse() {
        PsiBuilder.Marker doc = this.mark();
        while (!this.eof()) {
            this.parseInjection();
        }
        doc.done(XmlElementType.HTML_DOCUMENT);
    }

    public void parseInjection() {
        if (this.isTagInjectionStart()) {
            this.parseTagInjection();
        } else if (this.isExpressionInjectionStart()) {
            this.parseExpressionInjection();
        } else if (this.isInjectionEnd()) {
            this.consumeErrorToken(Jinja2Bundle.message("django.parsing.error.braces.or.brace.percent.expected", new Object[0]));
        } else if (this.hasTokenType(TokenType.BAD_CHARACTER, new IElementType[0])) {
            this.errorToken(Jinja2Bundle.message("django.parsing.error.unexpected.symbols", new Object[0]));
        } else {
            this.advance();
        }
    }

    private void parseTagInjection() {
        PsiBuilder.Marker tag = this.mark();
        this.advance();
        this.parseTagNameParams();
        if (!this.isTagInjectionEnd()) {
            this.error(Jinja2Bundle.message("django.parsing.error.expected.brace.percent", new Object[0]));
        }
        while (!this.tagEnded()) {
            this.advance();
        }
        if (this.isTagInjectionEnd()) {
            this.advance();
        }
        tag.done(Jinja2TemplateElementTypes.XML_TAG);
    }

    private void parseExpressionInjection() {
        PsiBuilder.Marker tag = this.mark();
        this.advance();
        this.parseMemberLiteral();
        if (this.isExpressionInjectionEnd()) {
            this.advance();
        } else {
            this.error(Jinja2Bundle.message("django.parsing.error.expected.double.brace", new Object[0]));
        }
        tag.done(Jinja2TemplateElementTypes.XML_TAG);
    }

    private void parseTagNameParams() {
        Jinja2TagParser<DjangoTemplateParsing> tagParser;
        PsiBuilder.Marker tagStartMarker = this.mark();
        if (!this.hasTokenType(DJANGO_TAG_NAME, new IElementType[0])) {
            tagStartMarker.drop();
            this.error(Jinja2Bundle.message("django.parsing.error.tag.name.expected", new Object[0]));
            return;
        }
        String tagName = this.myPsiBuilder.getTokenText();
        this.createTokenElement(Jinja2TemplateElementTypes.TAG_NAME);
        if (this.myPsiBuilder.getTokenType() == WHITESPACE_ERROR) {
            this.myPsiBuilder.error(Jinja2Bundle.message("django.parse.error.whitespace.expected.before.a.string", new Object[0]));
        }
        if ((tagParser = this.myTagParserRegistry.find(tagName)) != null) {
            tagParser.parse(this.myPsiBuilder, tagStartMarker, this);
            return;
        }
        tagStartMarker.drop();
        if (this.isTagInjectionEnd()) {
            return;
        }
        while (this.hasTokenType(COMMA, new IElementType[0]) || this.hasTokenType(AS, new IElementType[0]) || this.hasTokenType(AND, new IElementType[0]) || this.hasTokenType(ASSIGN, new IElementType[0]) || this.isExpressionStart()) {
            if (this.hasTokenType(AND, new IElementType[0])) {
                this.advance();
            }
            if (this.hasTokenType(ASSIGN, new IElementType[0])) {
                this.advance();
                this.parseAssignmentValue();
                continue;
            }
            if (this.hasTokenType(AS, new IElementType[0])) {
                PsiBuilder.Marker marker = this.myPsiBuilder.mark();
                this.advance();
                if (this.isStringLiteral() || this.isId()) {
                    this.parseNamedExpr();
                    marker.done(Jinja2TemplateElementTypes.AS_ID);
                    continue;
                }
                this.error(Jinja2Bundle.message("django.parsing.error.id.or.literal.expected", new Object[0]));
                marker.drop();
                continue;
            }
            if (this.hasTokenType(COMMA, new IElementType[0])) {
                this.advance();
            }
            if (this.parseMemberLiteral()) continue;
        }
        if (this.hasTokenType(NOT, new IElementType[0])) {
            this.createTokenElement(Jinja2TemplateElementTypes.NOT);
        }
        if (this.hasTokenType(IN, new IElementType[0])) {
            this.createTokenElement(Jinja2TemplateElementTypes.IN);
            if (!this.parseMemberExpr()) {
                // empty if block
            }
        }
        while (!this.tagEnded()) {
            this.advance();
        }
    }

    public boolean parseAssignmentValue() {
        if (!this.parseExpression()) {
            this.error(Jinja2Bundle.message("django.parse.error.value.expected", new Object[0]));
            return false;
        }
        return true;
    }

    public boolean parseNamedExpr() {
        if (this.isId()) {
            this.createTokenElement(Jinja2TemplateElementTypes.NAMED_EXPR);
            return true;
        }
        return false;
    }

    public boolean parseLogical() {
        PsiBuilder.Marker expr = this.mark();
        if (!this.parseUnary()) {
            expr.drop();
            return false;
        }
        while (this.hasTokenType(AND, OR)) {
            this.advance();
            if (!this.parseUnary()) {
                this.error(Jinja2Bundle.message("django.parsing.error.expression.expected", new Object[0]));
            }
            expr.done(Jinja2TemplateElementTypes.LOGICAL);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseUnary() {
        if (!this.isExpressionStart()) {
            this.error(Jinja2Bundle.message("django.parsing.error.expression.expected", new Object[0]));
            return false;
        }
        if (this.hasTokenType(NOT, new IElementType[0])) {
            PsiBuilder.Marker expr = this.mark();
            this.advance();
            boolean result = this.isExpressionStart() ? this.parseLogical() : this.parseMemberLiteral();
            expr.done(Jinja2TemplateElementTypes.NOT);
            return result;
        }
        return this.parseFactor();
    }

    protected boolean parseFactor() {
        return this.parseMemberLiteral();
    }

    public boolean parseMemberLiteral() {
        return this.parseMemberLiteral(true);
    }

    public boolean parseMemberLiteral(boolean raiseError) {
        if (!this.isAtExpression()) {
            if (raiseError) {
                this.error(Jinja2Bundle.message("django.parsing.error.id.or.literal.expected", new Object[0]));
            }
            return false;
        }
        PsiBuilder.Marker filters = this.mark();
        this.parseExpression();
        if (this.parseFilters()) {
            filters.done(Jinja2TemplateElementTypes.FILTERS);
        } else {
            filters.drop();
        }
        return true;
    }

    protected boolean parseExpression() {
        if (!this.parseIdOrLiteral()) {
            return false;
        }
        if (this.hasTokenType(IN, new IElementType[0])) {
            this.advance();
            if (!this.parseIdOrLiteral()) {
                this.error(Jinja2Bundle.message("django.parsing.error.expression.expected.after.in", new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected boolean isAtExpression() {
        return this.isId() || this.isLiteral();
    }

    public boolean parseId() {
        if (this.isId()) {
            this.parseMemberExpr();
            return true;
        }
        return false;
    }

    public boolean parseIdOrLiteral() {
        if (this.isId()) {
            this.parseMemberExpr();
            return true;
        }
        if (this.isLiteral()) {
            this.parseLiteral();
            return true;
        }
        return false;
    }

    public boolean parseMemberExpr() {
        return this.parseMemberExpr(Jinja2TemplateElementTypes.VAR);
    }

    public boolean parseMemberExpr(IElementType elementType) {
        return this.parseMemberExpr(elementType, false);
    }

    public boolean parseMemberExpr(IElementType elementType, boolean wrapByMemberAnyway) {
        if (!this.isId()) {
            this.error(Jinja2Bundle.message("django.parsing.error.identifier.expected", new Object[0]));
            return false;
        }
        PsiBuilder.Marker filters = this.mark();
        PsiBuilder.Marker expr = this.mark();
        this.createTokenElement(elementType);
        boolean memberCreated = false;
        boolean prevWasIntLiteral = false;
        boolean afterDot = false;
        while (this.hasTokenType(DOT, new IElementType[0]) || this.hasTokenType(INT_LITERAL, new IElementType[0]) || prevWasIntLiteral) {
            if (this.hasTokenType(DOT, new IElementType[0])) {
                this.advance();
                afterDot = true;
            }
            if (afterDot && this.isId()) {
                if (!this.checkId()) {
                    this.myPsiBuilder.error(Jinja2Bundle.message("django.parse.error.wrong.identifier", new Object[0]));
                }
                this.createTokenElement(Jinja2TemplateElementTypes.MEMBER_NAME);
                expr.done(Jinja2TemplateElementTypes.MEMBER);
                memberCreated = true;
                expr = expr.precede();
                prevWasIntLiteral = false;
                afterDot = false;
                continue;
            }
            if (afterDot && this.hasTokenType(INT_LITERAL, new IElementType[0])) {
                String token = this.myPsiBuilder.getTokenText();
                afterDot = token != null && token.endsWith(".");
                this.createTokenElement(Jinja2TemplateElementTypes.NUMBER);
                expr.done(Jinja2TemplateElementTypes.MEMBER);
                memberCreated = true;
                expr = expr.precede();
                prevWasIntLiteral = true;
                continue;
            }
            if (this.hasTokenType(INT_LITERAL, new IElementType[0]) && this.myPsiBuilder.getTokenText().startsWith(".")) {
                this.createTokenElement(Jinja2TemplateElementTypes.NUMBER);
                continue;
            }
            if (!afterDot) break;
            this.error(Jinja2Bundle.message("django.parsing.error.id.or.literal.expected", new Object[0]));
            break;
        }
        if (wrapByMemberAnyway && !memberCreated) {
            expr.done(Jinja2TemplateElementTypes.MEMBER);
        } else {
            expr.drop();
        }
        if (this.parseFilters()) {
            filters.done(Jinja2TemplateElementTypes.FILTERS);
        } else {
            filters.drop();
        }
        return true;
    }

    private boolean checkId() {
        String tokenText = this.myPsiBuilder.getTokenText();
        if (tokenText == null) {
            return false;
        }
        return Jinja2TemplateUtil.isIdentifierString(tokenText);
    }

    public boolean parseFilters() {
        boolean hasFilters = false;
        while (this.hasTokenType(FILTER, new IElementType[0])) {
            this.parseFilter();
            hasFilters = true;
        }
        return hasFilters;
    }

    private void parseFilter() {
        if (!this.hasTokenType(FILTER, new IElementType[0])) {
            return;
        }
        this.advance();
        this.parseFilterExpression();
    }

    public boolean parseFilterExpression() {
        PsiBuilder.Marker expr = this.mark();
        if (!this.isId()) {
            this.error(Jinja2Bundle.message("django.parsing.error.filter.name.expected", new Object[0]));
            expr.drop();
            return false;
        }
        this.createTokenElement(Jinja2TemplateElementTypes.FILTER_NAME);
        if (!this.parseFilterArguments()) {
            expr.drop();
            return false;
        }
        expr.done(Jinja2TemplateElementTypes.FILTER);
        return true;
    }

    public boolean parseFilterArguments() {
        if (this.hasTokenType(COLON, new IElementType[0])) {
            this.advance();
            if (this.isLiteral() || this.isId()) {
                this.parseIdOrLiteral();
            } else {
                this.error(Jinja2Bundle.message("django.parsing.error.expected.filter.argument", new Object[0]));
                return false;
            }
        }
        return true;
    }

    public boolean parseStringLiteral() {
        if (this.isStringLiteral()) {
            this.createTokenElement(Jinja2TemplateElementTypes.STRING);
            if (this.myPsiBuilder.getTokenType() == WHITESPACE_ERROR) {
                this.myPsiBuilder.error(Jinja2Bundle.message("django.parse.error.whitespace.expected", new Object[0]));
                this.advance();
            }
            return true;
        }
        return false;
    }

    public void parseLiteral() {
        if (this.isStringLiteral()) {
            this.parseStringLiteral();
        } else if (this.hasTokenType(INT_LITERAL, new IElementType[0])) {
            this.createTokenElement(Jinja2TemplateElementTypes.NUMBER);
        }
    }

    public boolean parseComma() {
        if (",".equals(this.myPsiBuilder.getTokenText())) {
            PsiBuilder.Marker deprecatedComma = this.myPsiBuilder.mark();
            this.myPsiBuilder.advanceLexer();
            deprecatedComma.done(COMMA);
            return true;
        }
        return false;
    }

    public boolean parseAsExpression(boolean isMandatory) {
        if (this.myPsiBuilder.getTokenType() != AS) {
            if (isMandatory) {
                this.myPsiBuilder.error(Jinja2Bundle.message("django.parse.error.as.keyword.expected", new Object[0]));
            }
            return false;
        }
        PsiBuilder.Marker marker = this.myPsiBuilder.mark();
        this.myPsiBuilder.advanceLexer();
        if (!this.parseNamedExpr()) {
            this.myPsiBuilder.error(Jinja2Bundle.message("django.parse.error.name.expected", new Object[0]));
            marker.drop();
            return false;
        }
        marker.done(Jinja2TemplateElementTypes.AS_ID);
        return true;
    }

    public boolean isExpressionStart() {
        return this.hasTokenType(ID, NOT) || this.isLiteral();
    }

    public boolean isLiteral() {
        return this.isStringLiteral() || this.hasTokenType(INT_LITERAL, new IElementType[0]);
    }

    public boolean isIdOrLiteral() {
        return this.isLiteral() || this.isId();
    }

    public boolean isId() {
        return this.hasTokenType(ID, new IElementType[0]);
    }

    public boolean isStringLiteral() {
        return this.hasTokenType(DOUBLE_QUOTED_STRING_LITERAL, SINGLE_QUOTED_STRING_LITERAL, I18N_STRING_LITERAL);
    }

    private boolean isInjectionEnd() {
        return this.hasTokenType(DJANGO_EXPRESSION_END, DJANGO_TAG_END);
    }

    protected boolean isTagInjectionStart() {
        return this.hasTokenType(DJANGO_TAG_START, new IElementType[0]);
    }

    protected boolean isTagInjectionEnd() {
        return this.hasTokenType(DJANGO_TAG_END, new IElementType[0]);
    }

    protected boolean isExpressionInjectionStart() {
        return this.hasTokenType(DJANGO_EXPRESSION_START, new IElementType[0]);
    }

    protected boolean isExpressionInjectionEnd() {
        return this.hasTokenType(DJANGO_EXPRESSION_END, new IElementType[0]);
    }

    public void parseNameList() {
        while (true) {
            if (!this.hasTokenType(ID, new IElementType[0])) {
                this.error(Jinja2Bundle.message("django.parsing.error.identifier.expected", new Object[0]));
            } else {
                PsiBuilder.Marker namedExpression = this.mark();
                this.advance();
                namedExpression.done(Jinja2TemplateElementTypes.NAMED_EXPR);
            }
            if (this.tagEnded() || !this.hasTokenType(COMMA, new IElementType[0])) break;
            this.advance();
        }
    }

    public boolean tagEnded() {
        return this.myPsiBuilder.getTokenType() == null || this.isTagInjectionEnd() || this.isTagInjectionStart() || this.isExpressionInjectionStart() || this.isLineEnded();
    }

    public TagParserRegistry<DjangoTemplateParsing> getTagParserRegistry() {
        return this.myTagParserRegistry;
    }

    private boolean isLineEnded() {
        return this.hasTokenType(DJANGO_LINE_END_INSIDE_TAG, new IElementType[0]);
    }
}

