/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.tags;

import com.intellij.jinja.Jinja2Bundle;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.jinja.template.parsing.parser.DjangoTemplateParsing;
import com.intellij.jinja.template.parsing.parser.Jinja2TagParser;
import com.intellij.jinja.template.parsing.parser.Parsing;
import com.intellij.jinja.template.psi.Jinja2TemplateElementTypes;
import com.intellij.lang.PsiBuilder;
import org.jetbrains.annotations.Nullable;

public class Jinja2BlockTagParser<T extends DjangoTemplateParsing>
extends Jinja2TagParser<T> {
    private final String myAcceptSuffix;

    public Jinja2BlockTagParser(@Nullable String acceptSuffix) {
        this.myAcceptSuffix = acceptSuffix;
    }

    @Override
    public void parse(PsiBuilder builder, PsiBuilder.Marker tagStartMarker, T templateParser) {
        if (!Jinja2BlockTagParser.parseName(builder)) {
            builder.error(Jinja2Bundle.message("django.parse.error.block.identifier.expected", new Object[0]));
        }
        if (this.myAcceptSuffix != null && ((Parsing)templateParser).hasTokenText(this.myAcceptSuffix)) {
            builder.advanceLexer();
        }
        tagStartMarker.done(Jinja2TemplateElementTypes.BLOCK_TAG);
    }

    protected static boolean parseName(PsiBuilder builder) {
        PsiBuilder.Marker blockName = builder.mark();
        if (builder.getTokenType() != DjangoTemplateTokenTypes.ID) {
            blockName.drop();
            return false;
        }
        builder.advanceLexer();
        while (builder.getTokenType() == DjangoTemplateTokenTypes.DOT) {
            builder.advanceLexer();
            if (builder.getTokenType() != DjangoTemplateTokenTypes.ID) {
                builder.error(Jinja2Bundle.message("django.parse.error.identifier.expected.after", new Object[0]));
                break;
            }
            builder.advanceLexer();
        }
        blockName.done(Jinja2TemplateElementTypes.BLOCK_NAME);
        return true;
    }
}

