/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker;

import com.intellij.execution.process.ProcessIOExecutorService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class LineWiseStreamConsumer
implements Runnable {
    @NotNull
    private final CountDownLatch myCountDownLatch;
    @NotNull
    private final InputStream myInputStream;
    @NotNull
    private final Consumer<String> myLineConsumer;
    private IOException myException;

    private LineWiseStreamConsumer(@NotNull InputStream stream, @NotNull Consumer<String> lineConsumer) {
        if (stream == null) {
            LineWiseStreamConsumer.$$$reportNull$$$0(0);
        }
        if (lineConsumer == null) {
            LineWiseStreamConsumer.$$$reportNull$$$0(1);
        }
        this.myCountDownLatch = new CountDownLatch(1);
        this.myInputStream = stream;
        this.myLineConsumer = lineConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.myInputStream, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                this.myLineConsumer.accept(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            this.myException = e;
        }
        finally {
            this.myCountDownLatch.countDown();
        }
    }

    public void await() throws IOException {
        try {
            this.myCountDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (this.myException != null) {
            throw this.myException;
        }
    }

    @NotNull
    public static LineWiseStreamConsumer consume(@NotNull InputStream stream, @NotNull Consumer<String> lineConsumer) {
        if (stream == null) {
            LineWiseStreamConsumer.$$$reportNull$$$0(2);
        }
        if (lineConsumer == null) {
            LineWiseStreamConsumer.$$$reportNull$$$0(3);
        }
        LineWiseStreamConsumer streamConsumer = new LineWiseStreamConsumer(stream, lineConsumer);
        ProcessIOExecutorService.INSTANCE.execute(streamConsumer);
        LineWiseStreamConsumer lineWiseStreamConsumer = streamConsumer;
        if (lineWiseStreamConsumer == null) {
            LineWiseStreamConsumer.$$$reportNull$$$0(4);
        }
        return lineWiseStreamConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/docker/LineWiseStreamConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/docker/LineWiseStreamConsumer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "consume";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

