/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker.console;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.docker.utils.DockerNetworkUtil;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.python.docker.PyDockerProcessConnectionData;
import com.intellij.python.docker.PyDockerProcessUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteProcess;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationClient;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/intellij/python/docker/console/PythonConsoleDockerProcessCreator;", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "Lcom/intellij/docker/remote/DockerCredentialsHolder;", "<init>", "()V", "credentialsType", "Lcom/intellij/remote/CredentialsType;", "getCredentialsType", "()Lcom/intellij/remote/CredentialsType;", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "createPythonConsolePortBindings", "", "Lcom/intellij/docker/agent/settings/DockerPortBindingImpl;", "pythonConsolePort", "", "createDefaultVolumeBindings", "Ljava/util/ArrayList;", "Lcom/intellij/docker/agent/settings/DockerVolumeBindingImpl;", "Lkotlin/collections/ArrayList;", "Companion", "intellij.python.docker"})
public final class PythonConsoleDockerProcessCreator
implements PythonConsoleRemoteProcessCreator<DockerCredentialsHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public CredentialsType<DockerCredentialsHolder> getCredentialsType() {
        DockerCredentialsType dockerCredentialsType = DockerCredentialsType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dockerCredentialsType, (String)"getInstance(...)");
        return (CredentialsType)dockerCredentialsType;
    }

    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, @NotNull DockerCredentialsHolder credentials) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        int clientPort = NetUtils.findAvailableSocketPort();
        PydevConsoleCli.setupPythonConsoleScriptInServerMode((GeneralCommandLine)commandLine, (SdkAdditionalData)((SdkAdditionalData)data), (Integer)clientPort);
        String[] stringArray = commandLine.getParametersList().getArray();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getArray(...)");
        String[] command = stringArray;
        Map map = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
        Map env = map;
        File workDirectory = commandLine.getWorkDirectory();
        GeneralCommandLine patchedCommandLine = new GeneralCommandLine();
        patchedCommandLine.setWorkDirectory(workDirectory);
        patchedCommandLine.withParameters(Arrays.copyOf(command, command.length));
        patchedCommandLine.getEnvironment().putAll(env);
        patchedCommandLine.getParametersList().set(0, PythonRemoteInterpreterManager.toSystemDependent((String)new File(data.getHelpersPath(), runnerFileFromHelpers).getPath(), (boolean)PySourcePosition.isWindowsPath((String)data.getInterpreterPath())));
        try {
            String dockerHost;
            DockerCloudConfiguration configuration = DockerUtils.getDockerCloudConfiguration((String)credentials.getAccountName());
            DockerContainerSettings dockerContainerSettings = new DockerContainerSettings();
            dockerContainerSettings.setVolumeBindings((List)this.createDefaultVolumeBindings(project));
            dockerContainerSettings.setPortBindings(this.createPythonConsolePortBindings(clientPort));
            patchedCommandLine.putUserData(DockerContainerSettings.KEY, (Object)dockerContainerSettings);
            PyDockerProcessConnectionData pyDockerProcessConnectionData = PyDockerProcessUtil.getPyDockerProcessConnectionData(data);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)pyDockerProcessConnectionData), (String)"getPyDockerProcessConnectionData(...)");
            PyDockerProcessConnectionData connectionData = pyDockerProcessConnectionData;
            PyRemoteProcessHandler remoteProcessHandlerBase = PyDockerProcessUtil.startDockerProcess(project, connectionData, patchedCommandLine, pathMapper);
            Process process = remoteProcessHandlerBase.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
            RemoteProcess remoteProcess = (RemoteProcess)process;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using communication for Python console: port " + clientPort + " on pydevconsole.py side");
            }
            PydevConsoleCli.waitForPythonConsoleServerToBeStarted((Process)((Process)remoteProcess));
            String string = DockerNetworkUtil.getDockerEngineAddress((DockerCloudConfiguration)configuration);
            if (string == null) {
                string = dockerHost = "localhost";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + dockerHost + " address to connect to pydevconsole.py side");
            }
            PydevConsoleCommunicationClient pydevConsoleCommunication = new PydevConsoleCommunicationClient(project, dockerHost, clientPort, (Process)remoteProcess);
            pydevConsoleCommunication.connect();
            PydevConsoleCommunication pydevConsoleCommunication2 = (PydevConsoleCommunication)pydevConsoleCommunication;
            String string2 = remoteProcessHandlerBase.getCommandLine();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCommandLine(...)");
            Process process2 = remoteProcessHandlerBase.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"getProcess(...)");
            PyRemoteSocketToLocalHostProvider pyRemoteSocketToLocalHostProvider = remoteProcessHandlerBase.getRemoteSocketToLocalHostProvider();
            Intrinsics.checkNotNullExpressionValue((Object)pyRemoteSocketToLocalHostProvider, (String)"getRemoteSocketToLocalHostProvider(...)");
            return new RemoteConsoleProcessData(pydevConsoleCommunication2, string2, process2, pyRemoteSocketToLocalHostProvider);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private final List<DockerPortBindingImpl> createPythonConsolePortBindings(int pythonConsolePort) {
        DockerPortBindingImpl portBinding = new DockerPortBindingImpl();
        portBinding.setHostIp("0.0.0.0");
        portBinding.setHostPort(Integer.valueOf(pythonConsolePort));
        portBinding.setContainerPort(pythonConsolePort);
        Object[] objectArray = new DockerPortBindingImpl[]{portBinding};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    private final ArrayList<DockerVolumeBindingImpl> createDefaultVolumeBindings(Project project) {
        Object[] objectArray = new DockerVolumeBindingImpl[]{new DockerVolumeBindingImpl("/opt/project", project.getBasePath(), false)};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    static {
        Logger logger = Logger.getInstance((String)PythonConsoleDockerProcessCreator.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/python/docker/console/PythonConsoleDockerProcessCreator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.python.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

