/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.devmode;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import org.jetbrains.annotations.NotNull;

public class AnalyzeTypeParserAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AnalyzeTypeParserAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeTypeParserAction.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabledAndVisible(psiFile != null && psiFile.getFileType() instanceof PythonFileType);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile vFile;
        Project project;
        PsiFileSystemItem fsItem;
        if (e == null) {
            AnalyzeTypeParserAction.$$$reportNull$$$0(2);
        }
        if ((fsItem = PsiUtilCore.findFileSystemItem((Project)(project = (Project)e.getData(CommonDataKeys.PROJECT)), (VirtualFile)(vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)))) != null) {
            TypeParserVisitor visitor = new TypeParserVisitor();
            fsItem.accept((PsiElementVisitor)visitor);
            visitor.dumpStats();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/devmode/AnalyzeTypeParserAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/devmode/AnalyzeTypeParserAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class TypeParserVisitor
    extends PyRecursiveElementVisitor {
        private int myTotal = 0;
        private int mySuccessful = 0;

        private TypeParserVisitor() {
        }

        public void visitDirectory(@NotNull PsiDirectory dir) {
            if (dir == null) {
                TypeParserVisitor.$$$reportNull$$$0(0);
            }
            super.visitDirectory(dir);
            System.out.println(dir.getName());
        }

        public void visitPyFile(@NotNull PyFile node) {
            if (node == null) {
                TypeParserVisitor.$$$reportNull$$$0(1);
            }
            System.out.println(node.getName());
            super.visitPyFile(node);
        }

        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                TypeParserVisitor.$$$reportNull$$$0(2);
            }
            super.visitPyFunction(node);
            StructuredDocString structuredDocString = node.getStructuredDocString();
            if (structuredDocString != null) {
                for (PyParameter parameter : node.getParameterList().getParameters()) {
                    if (!(parameter instanceof PyNamedParameter)) continue;
                    String type = structuredDocString.getParamType(parameter.getName());
                    this.visitType((PsiElement)parameter, type);
                }
                this.visitType((PsiElement)node, structuredDocString.getReturnType());
            }
        }

        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            if (node == null) {
                TypeParserVisitor.$$$reportNull$$$0(3);
            }
            super.visitPyTargetExpression(node);
            StructuredDocString docString = node.getStructuredDocString();
            if (docString != null) {
                this.visitType((PsiElement)node, docString.getParamType(null));
            }
        }

        private void visitType(PsiElement element, String type) {
            if (type == null) {
                return;
            }
            PyType pyType = PyTypeParser.getTypeByName((PsiElement)element, (String)type);
            ++this.myTotal;
            if (pyType != null) {
                ++this.mySuccessful;
            } else {
                System.out.println("Failed to parse type: " + type);
            }
        }

        public void dumpStats() {
            System.out.println("Total type declarations: " + this.myTotal);
            System.out.println("Successfully parsed type declarations: " + this.mySuccessful);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/python/pro/devmode/AnalyzeTypeParserAction$TypeParserVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDirectory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

