/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures.image;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.python.scientific.figures.base.FigureUtil;
import com.intellij.testFramework.BinaryLightVirtualFile;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\u0011R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/python/scientific/figures/image/ImageVirtualFile;", "Lcom/intellij/testFramework/BinaryLightVirtualFile;", "simpleFilename", "", "image", "Ljava/awt/image/BufferedImage;", "<init>", "(Ljava/lang/String;Ljava/awt/image/BufferedImage;)V", "value", "getImage", "()Ljava/awt/image/BufferedImage;", "runSetBinaryContentAction", "", "bytes", "", "clearImage", "getIcon", "Ljavax/swing/ImageIcon;", "Companion", "intellij.python.scientific"})
public final class ImageVirtualFile
extends BinaryLightVirtualFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BufferedImage image;

    public ImageVirtualFile(@Nullable String simpleFilename, @NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super(simpleFilename);
        BufferedImage bufferedImage = this.image = image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        this.runSetBinaryContentAction(FigureUtil.toByteArray(bufferedImage));
    }

    @Nullable
    public final BufferedImage getImage() {
        return this.image;
    }

    private final void runSetBinaryContentAction(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> ImageVirtualFile.runSetBinaryContentAction$lambda$1(this, bytes));
    }

    public final void clearImage() {
        this.image = null;
    }

    @NotNull
    public final ImageIcon getIcon() {
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        Image image = FigureUtil.fit(bufferedImage, 64, 48);
        Intrinsics.checkNotNullExpressionValue((Object)image, (String)"fit(...)");
        Image after = image;
        return new ImageIcon(after);
    }

    private static final void runSetBinaryContentAction$lambda$1$lambda$0(ImageVirtualFile this$0, byte[] $bytes) {
        try {
            this$0.setBinaryContent($bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final void runSetBinaryContentAction$lambda$1(ImageVirtualFile this$0, byte[] $bytes) {
        ApplicationManager.getApplication().runWriteAction(() -> ImageVirtualFile.runSetBinaryContentAction$lambda$1$lambda$0(this$0, $bytes));
    }

    @JvmStatic
    @NotNull
    public static final ImageVirtualFile makeCopy(@NotNull ImageVirtualFile virtualFile) {
        return Companion.makeCopy(virtualFile);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/python/scientific/figures/image/ImageVirtualFile$Companion;", "", "<init>", "()V", "makeCopy", "Lcom/intellij/python/scientific/figures/image/ImageVirtualFile;", "virtualFile", "intellij.python.scientific"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ImageVirtualFile makeCopy(@NotNull ImageVirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)((Object)virtualFile), (String)"virtualFile");
            String string = virtualFile.getName();
            BufferedImage bufferedImage = virtualFile.getImage();
            Intrinsics.checkNotNull((Object)bufferedImage);
            return new ImageVirtualFile(string, bufferedImage);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

