/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.templateLanguages;

import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.template.lang.core.templateLanguages.PyTemplatesBundle;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.module.PyContentEntriesEditor;
import com.jetbrains.python.module.PyRootTypeProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTemplateRootProvider
extends PyRootTypeProvider {
    private static final Color PROJECT_STRUCTURE_GROUP_COLOR = new JBColor(13852339, 13852339);
    private final MultiMap<ContentEntry, VirtualFilePointer> myTemplateRoots = new MultiMap();
    @Nullable
    private Runnable myListener;

    public void reset(@NotNull Disposable disposable, PyContentEntriesEditor editor, final @NotNull Module module) {
        if (disposable == null) {
            PyTemplateRootProvider.$$$reportNull$$$0(0);
        }
        if (module == null) {
            PyTemplateRootProvider.$$$reportNull$$$0(1);
        }
        this.myTemplateRoots.clear();
        TemplatesService instance = TemplatesService.getInstance(module);
        if (instance != null) {
            List<VirtualFile> folders = instance.getTemplateFolders();
            for (VirtualFile folder : folders) {
                ContentEntry contentEntry = PyTemplateRootProvider.findContentEntryForFile((VirtualFile)folder, (PyContentEntriesEditor)editor);
                if (contentEntry == null) continue;
                this.myTemplateRoots.putValue((Object)contentEntry, (Object)VirtualFilePointerManager.getInstance().create(folder, disposable, this.DUMMY_LISTENER));
            }
        }
        FacetErrorPanel panel = editor.getWarningPanel();
        panel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                boolean isTemplateLangConfigured = TemplatesService.getInstance(module).getTemplateLanguage() == null && !PyTemplateRootProvider.this.myTemplateRoots.isEmpty();
                ValidationResult validationResult = isTemplateLangConfigured ? new ValidationResult(PyTemplatesBundle.message("no_selected_template_language_settings", new Object[0])) : ValidationResult.OK;
                if (validationResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/templateLanguages/PyTemplateRootProvider$1", "check"));
            }
        }, new JComponent[0]);
        this.myListener = () -> panel.getValidatorsManager().validate();
        TemplatesService.getInstance(module).addLanguageSelectedListener(this.myListener);
        panel.getValidatorsManager().validate();
    }

    public void apply(Module module) {
        List<VirtualFile> templateRoots = this.getCurrentTemplateRoots();
        TemplatesService instance = TemplatesService.getInstance(module);
        if (instance != null) {
            instance.setTemplateFolders(templateRoots.toArray(VirtualFile.EMPTY_ARRAY));
        }
    }

    public boolean isModified(Module module) {
        List<VirtualFile> current;
        List<VirtualFile> original;
        TemplatesService templatesService = TemplatesService.getInstance(module);
        return templatesService != null && !Comparing.haveEqualElements(original = templatesService.getTemplateFolders(), current = this.getCurrentTemplateRoots());
    }

    public MultiMap<ContentEntry, VirtualFilePointer> getRoots() {
        return this.myTemplateRoots;
    }

    private List<VirtualFile> getCurrentTemplateRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ContentEntry entry : this.myTemplateRoots.keySet()) {
            for (VirtualFilePointer filePointer : this.myTemplateRoots.get((Object)entry)) {
                result.add(filePointer.getFile());
            }
        }
        return result;
    }

    public Icon getIcon() {
        return PythonIcons.Python.TemplateRoot;
    }

    @NotNull
    public String getName() {
        String string = PythonProBundle.message((String)"python.templates.name");
        if (string == null) {
            PyTemplateRootProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = PythonProBundle.message((String)"python.templates.description");
        if (string == null) {
            PyTemplateRootProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getRootsGroupTitle() {
        String string = PythonProBundle.message((String)"python.templates.group.title");
        if (string == null) {
            PyTemplateRootProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Color getRootsGroupColor() {
        Color color = PROJECT_STRUCTURE_GROUP_COLOR;
        if (color == null) {
            PyTemplateRootProvider.$$$reportNull$$$0(5);
        }
        return color;
    }

    public ContentEntryEditingAction createRootEntryEditingAction(JTree tree, Disposable disposable, PyContentEntriesEditor editor, ModifiableRootModel model) {
        return new PyRootTypeProvider.RootEntryEditingAction((PyRootTypeProvider)this, tree, disposable, editor, model);
    }

    @Nullable
    public CustomShortcutSet getShortcut() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(84, 8));
    }

    public void disposeUIResources(@NotNull Module module) {
        if (module == null) {
            PyTemplateRootProvider.$$$reportNull$$$0(6);
        }
        if (this.myListener != null) {
            TemplatesService.getInstance(module).removeLanguageSelectedListener(this.myListener);
            this.myListener = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/templateLanguages/PyTemplateRootProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/templateLanguages/PyTemplateRootProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsGroupTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsGroupColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "disposeUIResources";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

