/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.model.RawDataSource;
import com.intellij.database.util.AsyncTask;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class LoadingState<T extends RawDataSource> {
    private final AsyncPromise<Void> loading;
    private final Runnable cancel;
    private final Map<T, AsyncPromise<Void>> dataSourceStates;
    private volatile boolean outdated;

    public LoadingState(@NotNull Runnable cancel) {
        if (cancel == null) {
            LoadingState.$$$reportNull$$$0(0);
        }
        this.loading = new AsyncPromise();
        this.dataSourceStates = new IdentityHashMap<T, AsyncPromise<Void>>();
        this.cancel = cancel;
    }

    public Promise<?> getLoadingPromise() {
        return this.loading;
    }

    private void outdatedBy(@NotNull LoadingState<T> newState) {
        if (newState == null) {
            LoadingState.$$$reportNull$$$0(1);
        }
        if (this.loading.getState() == Promise.State.PENDING) {
            this.outdated = true;
            this.cancel.run();
            newState.loading.processed(this.loading);
            this.cancelDataSourcePromises();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelDataSourcePromises() {
        ArrayList<AsyncPromise<Void>> promises;
        Map<T, AsyncPromise<Void>> map2 = this.dataSourceStates;
        synchronized (map2) {
            promises = new ArrayList<AsyncPromise<Void>>(this.dataSourceStates.values());
            this.dataSourceStates.clear();
        }
        ArrayList<Throwable> ex = new ArrayList<Throwable>();
        for (AsyncPromise asyncPromise : promises) {
            try {
                asyncPromise.cancel();
            }
            catch (Throwable th) {
                ex.add(th);
            }
        }
        if (ex.isEmpty()) {
            return;
        }
        if (ex.size() == 1) {
            ExceptionUtil.rethrow((Throwable)((Throwable)ex.get(0)));
        }
        RuntimeException res2 = new RuntimeException("Multiple failures on cancel");
        ex.forEach(res2::addSuppressed);
        throw res2;
    }

    private void finish() {
        if (!this.outdated) {
            this.loading.setResult(null);
            this.cancelDataSourcePromises();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markLoading(@NotNull T dataSource) {
        if (dataSource == null) {
            LoadingState.$$$reportNull$$$0(2);
        }
        Map<T, AsyncPromise<Void>> map2 = this.dataSourceStates;
        synchronized (map2) {
            this.dataSourceStates.put(dataSource, (AsyncPromise<Void>)new AsyncPromise());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markLoaded(@NotNull T dataSource) {
        AsyncPromise<Void> promise;
        if (dataSource == null) {
            LoadingState.$$$reportNull$$$0(3);
        }
        Map<T, AsyncPromise<Void>> map2 = this.dataSourceStates;
        synchronized (map2) {
            promise = this.dataSourceStates.remove(dataSource);
        }
        if (promise != null) {
            promise.setResult(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Promise<?> getLoadingPromise(@NotNull T dataSource) {
        if (dataSource == null) {
            LoadingState.$$$reportNull$$$0(4);
        }
        Map<T, AsyncPromise<Void>> map2 = this.dataSourceStates;
        // MONITORENTER : map2
        AsyncPromise<Void> res2 = this.dataSourceStates.get(dataSource);
        AsyncPromise<Void> asyncPromise = res2 == null ? Promises.resolvedPromise() : res2;
        // MONITOREXIT : map2
        if (asyncPromise != null) return asyncPromise;
        LoadingState.$$$reportNull$$$0(5);
        return asyncPromise;
    }

    public boolean isLoading(@NotNull T dataSource) {
        if (dataSource == null) {
            LoadingState.$$$reportNull$$$0(6);
        }
        return this.getLoadingPromise(dataSource).getState() == Promise.State.PENDING;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/LoadingState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/LoadingState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "outdatedBy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "markLoading";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "markLoaded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingPromise";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLoading";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class Holder<T extends RawDataSource> {
        private final AtomicReference<LoadingState<T>> myRef = new AtomicReference();

        @Nullable
        public LoadingState<T> get() {
            return this.myRef.get();
        }

        @NotNull
        public <R> AsyncTask<R> run(@NotNull AsyncTask.Frame frame, @NotNull Function<LoadingState<T>, AsyncTask<R>> load) {
            if (frame == null) {
                Holder.$$$reportNull$$$0(0);
            }
            if (load == null) {
                Holder.$$$reportNull$$$0(1);
            }
            AsyncTask.DelayedTask task = new AsyncTask.DelayedTask(frame);
            task.start(null, () -> {
                LoadingState<T> currentState = this.startNew(() -> task.getTask().cancel());
                return ((AsyncTask)load.fun(currentState)).whenComplete(null, (r, th) -> this.finish(currentState));
            });
            AsyncTask asyncTask = task.getTask();
            if (asyncTask == null) {
                Holder.$$$reportNull$$$0(2);
            }
            return asyncTask;
        }

        @NotNull
        private LoadingState<T> startNew(@NotNull Runnable cancel) {
            LoadingState currentState;
            LoadingState prevState;
            if (cancel == null) {
                Holder.$$$reportNull$$$0(3);
            }
            if ((prevState = this.myRef.getAndSet(currentState = new LoadingState(cancel))) != null) {
                prevState.outdatedBy(currentState);
            }
            LoadingState loadingState = currentState;
            if (loadingState == null) {
                Holder.$$$reportNull$$$0(4);
            }
            return loadingState;
        }

        private void finish(@NotNull LoadingState<T> state) {
            if (state == null) {
                Holder.$$$reportNull$$$0(5);
            }
            state.finish();
            this.myRef.compareAndSet(state, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "load";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/LoadingState$Holder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cancel";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/LoadingState$Holder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "run";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startNew";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "startNew";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "finish";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
}

