/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.credentialStore.CredentialStoreUiService;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ObjectUtils;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasswordStorageComponent {
    @Nls
    private final String myPasswordItem = DatabaseBundle.message((String)"ide.passwords.settings", (Object[])new Object[0]);
    private final ComboBoxWithWidePopup<Object> myComboBox = new ComboBoxWithWidePopup<Object>((ComboBoxModel)new DefaultComboBoxModel<Object>(new Object[]{LocalDataSource.Storage.NO, LocalDataSource.Storage.MEMORY, LocalDataSource.Storage.SESSION, LocalDataSource.Storage.PERSIST, this.myPasswordItem}){

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject == PasswordStorageComponent.this.myPasswordItem) {
                PasswordStorageComponent.openPasswordSettings();
            } else {
                super.setSelectedItem(anObject);
            }
        }
    }){

        public int getMinimumPopupWidth() {
            Object proto2 = this.getPrototypeDisplayValue();
            this.setPrototypeDisplayValue(null);
            int width = this.getPreferredSize().width;
            this.setPrototypeDisplayValue(proto2);
            return width;
        }
    };

    public PasswordStorageComponent() {
        this.myComboBox.setPrototypeDisplayValue((Object)LocalDataSource.Storage.MEMORY);
        this.myComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            label.setText(PasswordStorageComponent.getText(value));
            boolean unavailable = PasswordStorageComponent.isUnavailable(value);
            label.setToolTipText(this.getTooltip(value, unavailable));
            label.setIcon(PasswordStorageComponent.getIcon(value, unavailable));
        }));
        this.myComboBox.addItemListener(e -> this.myComboBox.setToolTipText(this.getTooltip(e.getItem(), PasswordStorageComponent.isUnavailable(e.getItem()))));
    }

    @Nullable
    private static Icon getIcon(Object value, boolean unavailable) {
        return unavailable ? AllIcons.General.Error : (value instanceof LocalDataSource.Storage ? null : AllIcons.General.Gear);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    private String getTooltip(Object value, boolean unavailable) {
        Object tip = this.getToolTip(value);
        if (unavailable) {
            tip = (String)tip + "\n" + String.valueOf(HtmlChunk.br()) + DatabaseBundle.message((String)"unavailable.due.to.ide.password.storage.settings", (Object[])new Object[0]);
        }
        return tip;
    }

    private static boolean isUnavailable(Object value) {
        return value instanceof LocalDataSource.Storage && ((LocalDataSource.Storage)value).isPersisted() && PasswordStorageComponent.isNonPersistentStorage();
    }

    private static void openPasswordSettings() {
        CredentialStoreUiService.Companion.getInstance().openSettings(null);
    }

    public static boolean isNonPersistentStorage() {
        PasswordSafeSettings settings = (PasswordSafeSettings)ApplicationManager.getApplication().getService(PasswordSafeSettings.class);
        ProviderType type = settings.getProviderType();
        return type == ProviderType.MEMORY_ONLY || type == ProviderType.DO_NOT_STORE;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private String getToolTip(Object v) {
        return v instanceof LocalDataSource.Storage ? PasswordStorageComponent.getToolTip((LocalDataSource.Storage)v) : (v == this.myPasswordItem ? DatabaseBundle.message((String)"open.ide.passwords.settings", (Object[])new Object[0]) : null);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static String getToolTip(LocalDataSource.Storage v) {
        if (v == LocalDataSource.Storage.NO) {
            return DatabaseBundle.message((String)"data.source.setting.password.storage.tooltip.never", (Object[])new Object[0]);
        }
        if (v == LocalDataSource.Storage.MEMORY) {
            return DatabaseBundle.message((String)"data.source.setting.password.storage.tooltip.memory", (Object[])new Object[0]);
        }
        if (v == LocalDataSource.Storage.SESSION) {
            return DatabaseBundle.message((String)"data.source.setting.password.storage.tooltip.session", (Object[])new Object[0]);
        }
        if (v == LocalDataSource.Storage.PERSIST) {
            return DatabaseBundle.message((String)"data.source.setting.password.storage.tooltip.forever", (Object[])new Object[0]);
        }
        return "";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static String getText(Object v) {
        return v instanceof LocalDataSource.Storage ? PasswordStorageComponent.getText((LocalDataSource.Storage)v) : v.toString();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static String getText(LocalDataSource.Storage v) {
        if (v == LocalDataSource.Storage.NO) {
            return DatabaseBundle.message((String)"data.source.setting.password.storage.never", (Object[])new Object[0]);
        }
        if (v == LocalDataSource.Storage.MEMORY) {
            return DatabaseBundle.message((String)"data.source.setting.password.storage.memory", (Object[])new Object[0]);
        }
        if (v == LocalDataSource.Storage.SESSION) {
            return DatabaseBundle.message((String)"data.source.setting.password.storage.session", (Object[])new Object[0]);
        }
        if (v == LocalDataSource.Storage.PERSIST) {
            return DatabaseBundle.message((String)"data.source.setting.password.storage.forever", (Object[])new Object[0]);
        }
        return "";
    }

    @NotNull
    public JComboBox<?> getComponent() {
        ComboBoxWithWidePopup<Object> comboBoxWithWidePopup = this.myComboBox;
        if (comboBoxWithWidePopup == null) {
            PasswordStorageComponent.$$$reportNull$$$0(0);
        }
        return comboBoxWithWidePopup;
    }

    public LocalDataSource.Storage getStorage() {
        return (LocalDataSource.Storage)ObjectUtils.notNull((Object)((LocalDataSource.Storage)ObjectUtils.tryCast((Object)this.myComboBox.getSelectedItem(), LocalDataSource.Storage.class)), (Object)LocalDataSource.Storage.NO);
    }

    public void setPasswordStorage(LocalDataSource.Storage storage) {
        this.myComboBox.setSelectedItem((Object)storage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/PasswordStorageComponent", "getComponent"));
    }
}

