/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.CoreDatabaseGridDataHookUp;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseMutator;
import com.intellij.database.datagrid.DatabaseMutatorImpl;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HookUpHelper;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.datagrid.TypesMutationsStorage;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.basic.VmView;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.SelectUsingKeys;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GridTablesModel;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseGridDataHookUp
extends DataBusGridDataHookUp
implements DataRequest.TxIsolationOwner,
DataRequest.DepartmentHolder,
CoreDatabaseGridDataHookUp {
    private final DatabaseMutator<Domain> myMutator;
    private final DatabaseDepartment myDepartment;
    protected volatile DatabaseSession mySession;
    private GridTablesModel myGridTablesModel;
    private SqlTableType myTableType;
    private boolean myReadOnly;

    public DatabaseGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session, @NotNull DatabaseDepartment department, @NotNull TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean> valuesEqual, @Nullable Function<GridModel<GridRow, GridColumn>, MutationsStorage> storageProvider) {
        if (project == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (session == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (department == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(2);
        }
        if (valuesEqual == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(3);
        }
        super(project, session.getMessageBus(), valuesEqual, storageProvider);
        this.mySession = session;
        this.myDepartment = department;
        TypesMutationsStorage typesMutationsStorage = (TypesMutationsStorage)ObjectUtils.tryCast((Object)this.myStorage, TypesMutationsStorage.class);
        this.myMutator = new DatabaseMutatorImpl<Domain>((GridListModelBase<GridRow, GridColumn>)this.myModel, this.getMutationModel(), this, this.myStorage, typesMutationsStorage, valuesEqual);
    }

    public void setSession(@NotNull DatabaseSession session) {
        if (session == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(4);
        }
        this.mySession = session;
        this.setDataBus(session.getMessageBus());
    }

    public boolean isChildOf(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(5);
        }
        return this == owner || this.getSession().isChildOf(owner);
    }

    @NotNull
    public DatabaseDepartment getDepartment() {
        DatabaseDepartment databaseDepartment = this.myDepartment;
        if (databaseDepartment == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(6);
        }
        return databaseDepartment;
    }

    @Nullable
    public DatabaseMutator getMutator() {
        return this.myMutator;
    }

    @Override
    @NotNull
    protected DatabaseLoader createLoader() {
        return new DatabaseLoader();
    }

    public boolean isReadOnly() {
        if (this.myReadOnly) {
            return true;
        }
        DbDataSource dataSource = this.getDataSource();
        if (!dataSource.isWritable()) {
            return true;
        }
        return !this.isEditableTable();
    }

    public boolean isEditableTable() {
        if (this.myGridTablesModel == null || this.myGridTablesModel.isTablesEmpty()) {
            return false;
        }
        if (this.myGridTablesModel.isNotEditable()) {
            return false;
        }
        boolean result = true;
        for (DasTable table : this.myGridTablesModel.getDasTables()) {
            result &= DmlUtilKt.dmlGenerator((Dbms)this.getDbms()).isEditableTable((DasObject)table, this.myDataProperties);
        }
        return result;
    }

    public void setTxIsolation(int isolation) {
        this.mySession.setTxIsolation(isolation);
    }

    public int getTxIsolation() {
        return this.mySession.getTxIsolation();
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.mySession.getCurrentTx();
        if (txMarker == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(7);
        }
        return txMarker;
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker txMarker) {
        if (txMarker == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(8);
        }
        this.mySession.setCurrentTx(txMarker);
    }

    @Nullable
    public DasObject getDatabaseTable() {
        if (this.myGridTablesModel != null && !this.myGridTablesModel.isTablesEmpty()) {
            DbElement dbElement;
            DasTable dasTable = this.myGridTablesModel.getFirstTable();
            if (dasTable instanceof DbElement && (dbElement = (DbElement)dasTable).isValid()) {
                return dbElement;
            }
            return this.myGridTablesModel.getFirstTable();
        }
        return null;
    }

    public GridTablesModel getGridTablesModel() {
        return this.myGridTablesModel;
    }

    public boolean isForSingleSource() {
        return this.myGridTablesModel.isForSingleTable() || this.myGridTablesModel.hasSingleTable();
    }

    public void setGridTablesModel(@Nullable GridTablesModel gridTablesModel) {
        this.myGridTablesModel = gridTablesModel;
    }

    @NotNull
    public DatabaseSession getSession() {
        DatabaseSession databaseSession = this.mySession;
        if (databaseSession == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(9);
        }
        return databaseSession;
    }

    @Override
    @NotNull
    public DbDataSource getDataSource() {
        DatabaseConnectionPoint target = (DatabaseConnectionPoint)this.mySession.getTarget();
        DbDataSource dbDataSource = Objects.requireNonNull(DbImplUtilCore.getDbDataSource((Project)this.getProject(), (DasDataSource)target.getDataSource()));
        if (dbDataSource == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(10);
        }
        return dbDataSource;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = ((DatabaseConnectionPoint)this.mySession.getTarget()).getDbms();
        if (dbms == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(11);
        }
        return dbms;
    }

    @Nullable
    public DasColumn getDatabaseColumn(@Nullable GridColumn column2) {
        if (column2 == null) {
            return null;
        }
        DasObject dasTable = this.getDatabaseTable();
        return dasTable != null ? (DasColumn)JBIterable.from((Iterable)DasUtil.getColumns((DasObject)dasTable)).filter(DasUtil.byName((String)column2.getName())).first() : null;
    }

    @Nullable
    public SqlTableType getTableType() {
        if (this.myTableType == null || this.myTableType.getColumnCount() != this.myModel.getColumnCount()) {
            return null;
        }
        List columns = this.myModel.getColumns();
        for (GridColumn column2 : columns) {
            String nameFromColumn;
            String nameFromType = StringUtil.nullize((String)this.myTableType.getColumnName(column2.getColumnNumber()));
            if (StringUtil.equals((CharSequence)nameFromType, (CharSequence)(nameFromColumn = StringUtil.nullize((String)column2.getName())))) continue;
            return null;
        }
        return this.myTableType;
    }

    @Nullable
    protected static VmView getVirtualView(DasObject dbTable) {
        BasicObjectNode v = (BasicObjectNode)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap((DasObject)dbTable), BasicObjectNode.class);
        return v == null ? null : (VmView)ObjectUtils.tryCast((Object)v.extractObject(), VmView.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesEqual";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseGridDataHookUp";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseGridDataHookUp";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepartment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSession";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isChildOf";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentTx";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    public class DatabaseLoader
    extends DataBusGridDataHookUp.DataBusLoader {
        private Integer myRowIdIdx;
        private List<Integer> myColumnsToHide;

        @Override
        public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                DatabaseLoader.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                DatabaseLoader.$$$reportNull$$$0(1);
            }
            DataRequest.Context c2 = (DataRequest.Context)ObjectUtils.tryCast((Object)context, DataRequest.Context.class);
            boolean sameQuery = Objects.equals(this.getQueryText(), c2 == null ? null : c2.getQuery());
            ConsoleDataRequest request2 = c2 == null ? null : (ConsoleDataRequest)((Object)ObjectUtils.tryCast((Object)c2.request, ConsoleDataRequest.class));
            ConsoleDataRequest.ResultSetSubQuery resultSetSubQuery = request2 == null ? null : request2.getResultSetSubquery(subQueryIndex);
            SqlTableType sqlTableType = DatabaseGridDataHookUp.this.myTableType = resultSetSubQuery == null ? null : resultSetSubQuery.resultType;
            DatabaseGridDataHookUp.this.myReadOnly = sameQuery ? DatabaseGridDataHookUp.this.myReadOnly : c2 != null && !DbSqlUtil.isResultEditable((GridDataRequest)c2.request, DatabaseGridDataHookUp.this.myTableType, DatabaseGridDataHookUp.this.myGridTablesModel);
            DatabaseGridDataHookUp.this.myMutator.pageReloaded();
            super.setColumns(context, subQueryIndex, resultSetIndex, columns, firstRowNum);
        }

        @Override
        protected GridColumn[] prepareColumns(GridColumn @NotNull [] columns) {
            if (columns == null) {
                DatabaseLoader.$$$reportNull$$$0(2);
            }
            HookUpHelper helper = HookUpHelper.get((Dbms)DatabaseGridDataHookUp.this.getDbms());
            DasObject dasTable = DatabaseGridDataHookUp.this.getDatabaseTable();
            Map nameToDasColumn = CollectionFactory.createCaseInsensitiveStringMap();
            if (dasTable != null) {
                for (DasColumn dasColumn : DasUtil.getColumns((DasObject)dasTable)) {
                    nameToDasColumn.put(dasColumn.getName(), dasColumn);
                }
            }
            Set virtualColumns = ModelExternalData.getExtraColumns((DasDataSource)DatabaseGridDataHookUp.this.getDataSource(), (boolean)false, (DasObject)dasTable).map(c2 -> c2.name).toSet();
            for (int i = 0; i < columns.length; ++i) {
                GridColumn column2 = columns[i];
                SizeProvider sizeProvider = (SizeProvider)ObjectUtils.tryCast((Object)column2, SizeProvider.class);
                JdbcGridColumn c3 = (JdbcGridColumn)ObjectUtils.tryCast((Object)column2, JdbcGridColumn.class);
                DasColumn databaseColumn = (DasColumn)nameToDasColumn.get(column2.getName());
                EnumSet<ColumnDescriptor.Attribute> attributes = EnumSet.noneOf(ColumnDescriptor.Attribute.class);
                if (c3 != null) {
                    attributes.addAll(c3.getAttributes());
                }
                if (databaseColumn != null) {
                    attributes.addAll(helper.getAttributes(databaseColumn));
                }
                int type = column2.getType();
                if (databaseColumn != null && (column2.getType() == 0 || column2.getType() == 1111)) {
                    type = DatabaseLoader.getJdbcType(databaseColumn);
                }
                if (this.myColumnsToHide != null && (this.myColumnsToHide.contains(i) || this.myColumnsToHide.contains(i - columns.length))) {
                    attributes.add(ColumnDescriptor.Attribute.HIDDEN);
                }
                if (this.myRowIdIdx != null && (this.myRowIdIdx == i || this.myRowIdIdx == i - columns.length)) {
                    attributes.add(ColumnDescriptor.Attribute.ROW_ID);
                }
                if (virtualColumns.contains(column2.getName())) {
                    attributes.add(ColumnDescriptor.Attribute.VIRTUAL);
                }
                if (type == column2.getType() && (c3 == null || attributes.equals(c3.getAttributes()))) continue;
                String className = column2 instanceof JdbcColumnDescriptor ? ((JdbcColumnDescriptor)column2).getJavaClassName() : null;
                columns[i] = new DataConsumer.Column(column2.getColumnNumber(), column2.getName(), type, column2.getTypeName(), className, sizeProvider == null ? -1 : sizeProvider.getSize(), sizeProvider == null ? -1 : sizeProvider.getScale(), c3 == null ? null : c3.getCatalog(), c3 == null ? null : c3.getSchema(), c3 == null ? null : c3.getTable(), attributes);
            }
            return columns;
        }

        @Override
        protected void setQueryText(@Nullable String query) {
            super.setQueryText(query);
            DatabaseGridDataHookUp.this.myPageModel.setTotalRowCountUpdateable(this.canCountRows(query));
        }

        protected boolean canCountRows(@Nullable String query) {
            return StringUtil.isNotEmpty((String)query) && DmlUtilKt.dmlGenerator((Dbms)DatabaseGridDataHookUp.this.getDbms()).generate((DmlTask)DmlTaskKt.wrapInSelect((String)query, (Project)DatabaseGridDataHookUp.this.getProject()).countAll().build(DbImplUtil.createBuilderForUIExec((Dbms)DatabaseGridDataHookUp.this.getDbms(), null))) != null;
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource source) {
            if (source == null) {
                DatabaseLoader.$$$reportNull$$$0(3);
            }
            source.phase = GridRequestSource.Phase.COUNT;
            String unlimitedQuery = DatabaseGridDataHookUp.this.getUnlimitedQueryText(false);
            if (unlimitedQuery == null || !this.canCountRows(unlimitedQuery)) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateTotalRowCount(source, unlimitedQuery);
        }

        protected void updateTotalRowCount(@NotNull GridRequestSource source, @NotNull String unlimitedQuery) {
            if (source == null) {
                DatabaseLoader.$$$reportNull$$$0(4);
            }
            if (unlimitedQuery == null) {
                DatabaseLoader.$$$reportNull$$$0(5);
            }
            DbDataSource system = DatabaseGridDataHookUp.this.getDataSource();
            Dbms dbms = DatabaseGridDataHookUp.this.getDbms();
            Project project = DatabaseGridDataHookUp.this.getProject();
            Version version = system.getVersion();
            String alias = DbImplUtil.findFreeAlias(project, dbms, unlimitedQuery, "t");
            DdlBuilder builder = DbImplUtil.createBuilderForUIExec((DatabaseDialectEx)DbImplUtilCore.getDatabaseDialect((Dbms)dbms), (DasObject)system);
            WrapInSelectTask task = DmlTaskKt.wrapInSelect((String)unlimitedQuery, (Project)project).countAll().version(version).alias(alias).build(builder);
            final WrapInSelectResult result = (WrapInSelectResult)DmlUtilKt.dmlGenerator((Dbms)dbms).generate((DmlTask)task);
            DataRequest.RawRequest request2 = new DataRequest.RawRequest(DatabaseGridDataHookUp.this){

                public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) {
                    try {
                        long count = DbImplUtilCore.getRowCount((DatabaseConnectionCore)connection2, (String)Objects.requireNonNull(result).getStatement());
                        DatabaseGridDataHookUp.this.myPageModel.setTotalRowCount(count, true);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            };
            DatabaseGridDataHookUp.this.processRequest(source, (GridDataRequest)request2, DataBusGridDataHookUp.ReloadPolicy.DO_NOT_RELOAD);
        }

        @Override
        public boolean canUseOffset() {
            return ((DmlHelper)DmlHelper.Companion.getEP().forDbms(DatabaseGridDataHookUp.this.getDbms())).supportsOffset(DatabaseGridDataHookUp.this.getDatabaseTable()) && Registry.is((String)"database.grid.paging.offset");
        }

        @Override
        protected boolean canUpdateQueryText() {
            return DatabaseGridDataHookUp.this.getDatabaseTable() != null && (this.getQueryText() == null || this.isQueryInvalidated());
        }

        @Override
        @Nullable
        protected String createQueryText(@NotNull DataBusGridDataHookUp.QueryAttributes attributes, @Nullable GridRequestSource source) {
            SelectGenerationResult pure;
            if (attributes == null) {
                DatabaseLoader.$$$reportNull$$$0(6);
            }
            if ((pure = this.createQueryTextPure(attributes, source)) == null) {
                return null;
            }
            this.myColumnsToHide = pure.getColumnsToHide();
            this.myRowIdIdx = pure.getRowIdIdx();
            return pure.getStatement();
        }

        public boolean isQueryTextPureNull(@NotNull DataBusGridDataHookUp.QueryAttributes attributes, @Nullable GridRequestSource source) {
            DasObject dbTable;
            if (attributes == null) {
                DatabaseLoader.$$$reportNull$$$0(7);
            }
            return (dbTable = DatabaseGridDataHookUp.this.getDatabaseTable()) == null;
        }

        @Nullable
        public SelectGenerationResult createQueryTextPure(@NotNull DataBusGridDataHookUp.QueryAttributes attributes, @Nullable GridRequestSource source) {
            SelectUsingKeys task;
            boolean appendRowId;
            DasObject dbTable;
            if (attributes == null) {
                DatabaseLoader.$$$reportNull$$$0(8);
            }
            if ((dbTable = DatabaseGridDataHookUp.this.getDatabaseTable()) == null) {
                return null;
            }
            DatabaseDialectEx dbDialect = DatabaseGridDataHookUp.this.getDatabaseDialect();
            VmView vView = DatabaseGridDataHookUp.getVirtualView(dbTable);
            if (vView != null) {
                return DatabaseLoader.createVirtualViewQuery(dbDialect, vView);
            }
            DmlHelper helper = DmlUtilKt.dmlGenerator((Dbms)DatabaseGridDataHookUp.this.getDbms());
            boolean bl = appendRowId = !this.disableRowId() && dbTable instanceof DasTable && DatabaseLoader.needRowId((DasTable)dbTable);
            if (source != null && source.phase == GridRequestSource.Phase.LOAD_VALUES_USING_KEYS) {
                task = DmlTaskKt.selectUsingKeys((DasObject)dbTable).model(DatabaseGridDataHookUp.this.myModel).version(DatabaseGridDataHookUp.this.getDataSource().getVersion()).insertNewLines(true).appendRowId(appendRowId).build(DbImplUtil.createBuilderForUIExec((DatabaseDialectEx)dbDialect, (DasObject)dbTable));
            } else {
                CoreGrid<GridRow, GridColumn> grid = DatabaseLoader.getGrid(source);
                task = this.selectTask(dbTable).tableSamplingSize(grid == null ? null : DataGridUtilCore.getTableSamplingSize(grid)).limit(attributes.limit().orElse(-1)).offset(attributes.offset().orElse(0)).appendRowId(appendRowId).build(DbImplUtil.createBuilderForUIExec((DatabaseDialectEx)dbDialect, (DasObject)dbTable));
            }
            return (SelectGenerationResult)helper.generate((DmlTask)task);
        }

        @NotNull
        private static SelectGenerationResult createVirtualViewQuery(DatabaseDialectEx dbDialect, VmView vView) {
            DdlBuilder builder = new DdlBuilder().withDialect(dbDialect);
            builder.plain(StringUtil.notNullize((String)vView.getQuery()));
            return new SelectGenerationResult(builder, null, Collections.emptyList());
        }

        @Nullable
        private static CoreGrid<GridRow, GridColumn> getGrid(@Nullable GridRequestSource source) {
            if (source == null) {
                return null;
            }
            if (!(source.place instanceof GridRequestSource.GridRequestPlace)) {
                return null;
            }
            return ((GridRequestSource.GridRequestPlace)source.place).getGrid();
        }

        protected boolean disableRowId() {
            return false;
        }

        @NotNull
        protected SelectTask.Companion.Builder selectTask(@NotNull DasObject dbTable) {
            if (dbTable == null) {
                DatabaseLoader.$$$reportNull$$$0(9);
            }
            SelectTask.Companion.Builder builder = DmlTaskKt.allColumns((DasObject)dbTable).withVirtualColumns((DasDataSource)DatabaseGridDataHookUp.this.getDataSource()).version(DatabaseGridDataHookUp.this.getDataSource().getVersion()).whereClause(this.getWhereClause()).orderBy(this.getOrderBy()).insertNewLines(true);
            if (builder == null) {
                DatabaseLoader.$$$reportNull$$$0(10);
            }
            return builder;
        }

        private static int getJdbcType(@NotNull DasColumn column2) {
            BasicTypedElement element;
            if (column2 == null) {
                DatabaseLoader.$$$reportNull$$$0(11);
            }
            if ((element = (BasicTypedElement)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap((DasObject)column2), BasicTypedElement.class)) == null) {
                return column2.getDasType().toDataType().jdbcType;
            }
            return DbImplUtil.getModelHelper((BasicElement)element).getJdbcType(element);
        }

        private static boolean needRowId(@NotNull DasTable table) {
            if (table == null) {
                DatabaseLoader.$$$reportNull$$$0(12);
            }
            return table.getKind() == ObjectKind.TABLE && DasUtil.getPrimaryKey((DasTable)table) == null;
        }

        @Nullable
        protected OrderBy getOrderBy() {
            return null;
        }

        @Nullable
        protected WhereClause getWhereClause() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unlimitedQuery";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbTable";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "selectTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setColumns";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareColumns";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateTotalRowCount";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createQueryText";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isQueryTextPureNull";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createQueryTextPure";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "selectTask";
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getJdbcType";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "needRowId";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10 -> new IllegalStateException(string);
            };
        }
    }
}

