/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.dialects.sybase.plan.AseExplainPlanProvider;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteClob;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class AseRawPlanData
extends RawPlanData {
    public String xml;

    AseRawPlanData() {
    }

    public void load(final @NotNull DatabaseConnectionCore connection2, final @NotNull String statement2, final boolean run) {
        if (connection2 == null) {
            AseRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            AseRawPlanData.$$$reportNull$$$0(1);
        }
        this.xml = null;
        AseRawPlanData.useStatementWithPreserved((DatabaseConnectionCore)connection2, (RawPlanData.ResourceUser)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                String option = run ? "show_execio_xml" : "show_exec_xml";
                Set<String> activeFlags = AseExplainPlanProvider.collectActiveFlags(connection2, "statement_cache", "statistics io and time");
                SimpleSmartStatement ignoreErrors = SmartStatementFactoryService.getInstance().poweredBy(connection2).simple(Configuration.sourced((SmartStatementSource)SmartStatementSource.SYSTEM));
                try {
                    s.barren().execute((Object)("SET NOEXEC OFF\nSET PLAN FOR " + option + " OFF"));
                    if (activeFlags.contains("statement_cache")) {
                        ignoreErrors.execute((Object)"SET STATEMENT_CACHE OFF", (ExecutionMode)StandardExecutionMode.GENERIC);
                    }
                    AseRawPlanData.commit(connection2);
                    s.barren().execute((Object)("SET PLAN FOR " + option + " TO MESSAGE ON\n" + (run ? "" : "SET NOEXEC ON\n")));
                    s.barren().execute((Object)(statement2 + (run ? "" : "\nSET NOEXEC OFF")));
                    s.noisy().execute((Object)"SELECT showplan_in_xml(0)", AseRawPlanData.processing((ThrowableConsumer)rs -> {
                        String xml;
                        if (!rs.next()) {
                            AseRawPlanData.failWithEmptyResultSetError();
                        }
                        if (rs.getMetaData().getColumnCount() != 1) {
                            throw new PlanRetrievalException("Database returned data in unknown format");
                        }
                        RemoteClob res2 = rs.getClob(1);
                        if (res2 == null) {
                            throw new PlanRetrievalException("Database returned null plan");
                        }
                        try {
                            xml = res2.getSubString(1L, (int)res2.length());
                            if (!xml.startsWith("<?xml") || !xml.endsWith(run ? "</query>\n" : "</Emit>\n")) {
                                throw new PlanRetrievalException("Result is trimmed");
                            }
                        }
                        catch (Throwable throwable) {
                            JdbcNativeUtil.performRemote(() -> ((RemoteClob)res2).free());
                            throw throwable;
                        }
                        JdbcNativeUtil.performRemote(() -> ((RemoteClob)res2).free());
                        if (rs.next()) {
                            throw new PlanRetrievalException("Database returned too many data");
                        }
                        AseRawPlanData.this.xml = xml;
                    }));
                }
                finally {
                    try {
                        Either result = s.barren().quiet().execute((Object)("SET NOEXEC OFF\nSET SHOWPLAN OFF\nSET PLAN FOR " + option + " OFF"));
                        if (activeFlags.contains("statement_cache")) {
                            ignoreErrors.execute((Object)"SET STATEMENT_CACHE ON", (ExecutionMode)StandardExecutionMode.GENERIC);
                        }
                        if (result.isRight()) {
                            AseRawPlanData.commit(connection2);
                        }
                    }
                    catch (PlanRetrievalException planRetrievalException) {}
                }
            }
        }, (RawPlanData.StateSaver[])new RawPlanData.StateSaver[]{AseRawPlanData.setAutoCommit((boolean)false)});
    }

    public void load(@NotNull String dump2) {
        if (dump2 == null) {
            AseRawPlanData.$$$reportNull$$$0(2);
        }
        this.xml = dump2;
    }

    private static void commit(@NotNull DatabaseConnectionCore connection2) {
        if (connection2 == null) {
            AseRawPlanData.$$$reportNull$$$0(3);
        }
        try {
            connection2.commit();
        }
        catch (SQLException e) {
            throw new PlanRetrievalException("Failed to commit transaction", (Throwable)e);
        }
    }

    public String dump() {
        return this.xml;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/sybase/plan/AseRawPlanData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

