/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.actions.ConsoleSource;
import com.intellij.database.run.actions.DumpAction;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.view.ui.DbDumpDataDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class ShowDumpDialogAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(1);
        }
        DumpSource<?> source = DumpAction.getDumpSource(e);
        e.getPresentation().setEnabledAndVisible(source != null && e.getProject() != null);
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid != null) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(grid.isReady() && !grid.isEmpty());
            e.getPresentation().setText(DatabaseBundle.message((String)"action.Console.TableResult.ShowDumpDialogAction.text", (Object[])new Object[0]));
            return;
        }
        if (source == null || e.getProject() == null) {
            return;
        }
        if (source instanceof ConsoleSource) {
            ShowDumpDialogAction.updateConsolePresentation((ConsoleSource)source, e);
        } else {
            this.updatePresentation(source, e);
        }
    }

    private static void updateConsolePresentation(@NotNull ConsoleSource source, @NotNull AnActionEvent e) {
        if (source == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(3);
        }
        int size = source.estimateSize();
        e.getPresentation().setEnabledAndVisible(size != 0);
        if (size == 0) {
            return;
        }
        e.getPresentation().setText(DatabaseBundle.message((String)"action.Console.TableResult.ShowDumpDialogAction.ConsoleText", (Object[])new Object[]{size}));
        e.getPresentation().setIcon(AllIcons.Actions.Execute);
    }

    private void updatePresentation(@NotNull DumpSource<?> target, @NotNull AnActionEvent e) {
        if (target == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(5);
        }
        e.getPresentation().setText(DatabaseBundle.message((String)"action.Console.TableResult.ShowDumpDialogAction.DatabaseViewText", (Object[])new Object[]{DumpSource.getSize(target)}), true);
        e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDumpDialogAction.$$$reportNull$$$0(6);
        }
        Project project = e.getProject();
        DumpSource<?> source = DumpAction.getDumpSource(e);
        if (project != null && source != null) {
            DataGrid grid = GridUtil.getDataGrid((DataContext)e.getDataContext());
            if (grid != null) {
                GridUtil.activeGridListener().onExtractToFileAction(grid);
            }
            new DbDumpDataDialog(project, source, (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)).show();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ShowDumpDialogAction";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ShowDumpDialogAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateConsolePresentation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

