/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.meta.BasicMetaFunKt;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.meta.DefaultResolveAssistant;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\"\u0010\n\u001a\u00020\u000b\"\b\b\u0000\u0010\f*\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u0002H\f\u0018\u00010\u000fH\u0002J<\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\f0\u0011\"\b\b\u0000\u0010\f*\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\f0\u0016H\u0016J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JE\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\f0\u0011\"\b\b\u0000\u0010\f*\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u001c0\u001bH\u0016\u00a2\u0006\u0002\u0010\u001dJK\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\f0\u0011\"\b\b\u0000\u0010\f*\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\f0 2\u0014\u0010\u001a\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u001c0\u001bH\u0016\u00a2\u0006\u0002\u0010!J\u001c\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001c2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u0014\u0010$\u001a\u00020%2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J8\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0'0\u0011\"\b\b\u0000\u0010\f*\u00020\r2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\f0\u001cH\u0002J%\u0010)\u001a\u0002H*\"\u000e\b\u0000\u0010**\b\u0012\u0002\b\u0003\u0018\u00010+2\u0006\u0010,\u001a\u0002H*H\u0016\u00a2\u0006\u0002\u0010-J\u001c\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0016J\u0014\u0010.\u001a\u0004\u0018\u00010\r2\b\u0010/\u001a\u0004\u0018\u00010\rH\u0016J#\u00100\u001a\u0004\u0018\u0001H\f\"\b\b\u0000\u0010\f*\u00020\r2\b\u00101\u001a\u0004\u0018\u0001H\fH\u0002\u00a2\u0006\u0002\u00102J#\u00103\u001a\u0004\u0018\u0001H\f\"\b\b\u0000\u0010\f*\u00020\r2\b\u00101\u001a\u0004\u0018\u0001H\fH\u0002\u00a2\u0006\u0002\u00102J7\u00104\u001a\u0004\u0018\u0001H\f\"\b\b\u0000\u0010\f*\u00020\r2\b\u00105\u001a\u0004\u0018\u00010\u00032\b\u00106\u001a\u0004\u0018\u00010\u00032\b\u00101\u001a\u0004\u0018\u0001H\fH\u0002\u00a2\u0006\u0002\u00107R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00068"}, d2={"Lcom/intellij/database/schemaEditor/ElementOwnerResolveAssistant;", "Lcom/intellij/database/model/meta/DefaultResolveAssistant;", "owner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "<init>", "(Lcom/intellij/database/schemaEditor/ElementOwner;)V", "getOwner", "()Lcom/intellij/database/schemaEditor/ElementOwner;", "getOriginalAssistant", "Lcom/intellij/database/model/meta/BasicResolveAssistant;", "pullIn", "", "T", "Lcom/intellij/database/model/basic/BasicElement;", "originals", "", "findAllById", "Lcom/intellij/util/containers/JBIterable;", "root", "objectId", "", "meta", "Lcom/intellij/database/model/meta/BasicMetaReferenceDesc;", "findAllByNameInScope", "name", "", "targets", "", "Lcom/intellij/database/model/meta/BasicMetaObject;", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/String;[Lcom/intellij/database/model/meta/BasicMetaObject;)Lcom/intellij/util/containers/JBIterable;", "findAllInScope", "condition", "Ljava/util/function/Predicate;", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/util/function/Predicate;[Lcom/intellij/database/model/meta/BasicMetaObject;)Lcom/intellij/util/containers/JBIterable;", "getRoot", "Lcom/intellij/database/model/basic/BasicRoot;", "isOutsideModel", "", "findChildren", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "target", "access", "F", "Lcom/intellij/database/model/families/Family;", "f", "(Lcom/intellij/database/model/families/Family;)Lcom/intellij/database/model/families/Family;", "getParent", "e", "toOriginal", "element", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/basic/BasicElement;", "fromOriginal", "convert", "from", "to", "(Lcom/intellij/database/schemaEditor/ElementOwner;Lcom/intellij/database/schemaEditor/ElementOwner;Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/basic/BasicElement;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nElementOwnerResolveAssistant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementOwnerResolveAssistant.kt\ncom/intellij/database/schemaEditor/ElementOwnerResolveAssistant\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1869#2,2:127\n*S KotlinDebug\n*F\n+ 1 ElementOwnerResolveAssistant.kt\ncom/intellij/database/schemaEditor/ElementOwnerResolveAssistant\n*L\n21#1:127,2\n*E\n"})
public final class ElementOwnerResolveAssistant
extends DefaultResolveAssistant {
    @NotNull
    private final ElementOwner owner;

    public ElementOwnerResolveAssistant(@NotNull ElementOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.owner = owner;
    }

    @NotNull
    public final ElementOwner getOwner() {
        return this.owner;
    }

    private final BasicResolveAssistant getOriginalAssistant() {
        ElementOwner elementOwner = this.owner.getOriginal();
        return elementOwner != null ? elementOwner.getResolveAssistant() : null;
    }

    private final <T extends BasicElement> void pullIn(Iterable<? extends T> originals) {
        block1: {
            Iterable<T> iterable = originals;
            if (iterable == null) break block1;
            Iterable<T> $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                BasicElement it = (BasicElement)element$iv;
                boolean bl = false;
                this.fromOriginal(it);
            }
        }
    }

    @NotNull
    public <T extends BasicElement> JBIterable<T> findAllById(@Nullable BasicElement root, long objectId, @NotNull BasicMetaReferenceDesc<?, T> meta) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        BasicResolveAssistant basicResolveAssistant = this.getOriginalAssistant();
        this.pullIn((Iterable)(basicResolveAssistant != null ? basicResolveAssistant.findAllById(this.toOriginal(root), objectId, meta) : null));
        JBIterable jBIterable = super.findAllById(root, objectId, meta);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"findAllById(...)");
        return jBIterable;
    }

    @NotNull
    public JBIterable<BasicElement> findAllById(@Nullable BasicElement root, long objectId) {
        BasicResolveAssistant basicResolveAssistant = this.getOriginalAssistant();
        this.pullIn((Iterable)(basicResolveAssistant != null ? basicResolveAssistant.findAllById(this.toOriginal(root), objectId) : null));
        JBIterable jBIterable = super.findAllById(root, objectId);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"findAllById(...)");
        return jBIterable;
    }

    @NotNull
    public <T extends BasicElement> JBIterable<T> findAllByNameInScope(@Nullable BasicElement root, @NotNull String name2, @NotNull BasicMetaObject<? extends T>[] targets) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        BasicResolveAssistant basicResolveAssistant = this.getOriginalAssistant();
        this.pullIn((Iterable)(basicResolveAssistant != null ? basicResolveAssistant.findAllByNameInScope(this.toOriginal(root), name2, targets) : null));
        if (root instanceof BasicDataObject) {
            Condition condition = DasUtil.byName((String)name2);
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"byName(...)");
            Condition byName = condition;
            Set set = JBIterable.of((Object[])Arrays.copyOf(targets, targets.length)).filter(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$2(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$1(this, arg_0), arg_0)).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
            Set outsideTargets = set;
            ElementIdentity elementIdentity = this.owner.identify(root);
            Intrinsics.checkNotNullExpressionValue((Object)elementIdentity, (String)"identify(...)");
            ElementIdentity rootId2 = elementIdentity;
            JBIterable jBIterable = JBIterable.from((Iterable)outsideTargets).flatten(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$4(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$3(this, rootId2, arg_0), arg_0)).filterMap(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$6(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$5(this, arg_0), arg_0)).filter(byName).collect();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"collect(...)");
            JBIterable outsideElements = jBIterable;
            JBIterable jBIterable2 = JBIterable.of((Object[])Arrays.copyOf(targets, targets.length)).filter(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$8(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$7(outsideTargets, arg_0), arg_0)).filterMap(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$10(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$9(this, arg_0), arg_0)).flatten(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$12(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$11(this, rootId2, arg_0), arg_0)).filterMap(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$14(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$13(this, arg_0), arg_0)).flatten(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$16(arg_0 -> ElementOwnerResolveAssistant.findAllByNameInScope$lambda$15(this, name2, targets, arg_0), arg_0)).collect();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"collect(...)");
            JBIterable modelElements = jBIterable2;
            JBIterable jBIterable3 = modelElements.append((Iterable)outsideElements);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"append(...)");
            return jBIterable3;
        }
        JBIterable jBIterable = super.findAllByNameInScope(root, name2, targets);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"findAllByNameInScope(...)");
        return jBIterable;
    }

    @NotNull
    public <T extends BasicElement> JBIterable<T> findAllInScope(@Nullable BasicElement root, @NotNull Predicate<T> condition, @NotNull BasicMetaObject<? extends T>[] targets) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        BasicResolveAssistant basicResolveAssistant = this.getOriginalAssistant();
        this.pullIn((Iterable)(basicResolveAssistant != null ? basicResolveAssistant.findAllInScope(this.toOriginal(root), condition, targets) : null));
        JBIterable jBIterable = super.findAllInScope(root, condition, targets);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"findAllInScope(...)");
        return jBIterable;
    }

    private final BasicMetaObject<BasicRoot> getRoot(BasicMetaObject<?> meta) {
        BasicMetaObject<?> parent;
        BasicMetaObject root = meta.tryCast(BasicRoot.class);
        if (root != null) {
            return root;
        }
        BasicMetaObject<?> basicMetaObject = parent = this.getParent(meta);
        return basicMetaObject == null ? null : this.getRoot(basicMetaObject);
    }

    private final boolean isOutsideModel(BasicMetaObject<?> meta) {
        if (meta.kind == ObjectKind.ROOT) {
            return false;
        }
        BasicMetaObject<?> parent = this.getParent(meta);
        if (parent == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)parent.children, (String)"children");
        return ArraysKt.indexOf((Object[])parent.children, meta) == -1 || this.isOutsideModel(parent);
    }

    private final <T extends BasicElement> JBIterable<ElementIdentity<T>> findChildren(ElementIdentity<?> root, BasicMetaObject<T> target) {
        JBIterable jBIterable;
        if (Intrinsics.areEqual((Object)root.getMetaObject(), target)) {
            JBIterable jBIterable2 = JBIterable.of((Object)ElementIdentity.tryCast(root, target));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
            return jBIterable2;
        }
        BasicMetaObject<?> parent = this.getParent(target);
        if (parent == null) {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        } else {
            JBIterable jBIterable4 = this.findChildren(root, parent).flatten(arg_0 -> ElementOwnerResolveAssistant.findChildren$lambda$17(new Function1(this, target){
                final /* synthetic */ ElementOwnerResolveAssistant this$0;
                final /* synthetic */ BasicMetaObject<T> $target;
                {
                    this.this$0 = $receiver;
                    this.$target = $target;
                }

                public final Iterable<ElementIdentity<T>> invoke(ElementIdentity<? extends BasicElement> it) {
                    return (Iterable)this.this$0.getOwner().getChildren(it, this.$target);
                }
            }, arg_0));
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"flatten(...)");
        }
        return jBIterable;
    }

    public <F extends Family<?>> F access(F f) {
        BasicElement basicElement;
        BasicResolveAssistant oa;
        block6: {
            block5: {
                BasicResolveAssistant basicResolveAssistant = this.getOriginalAssistant();
                if (basicResolveAssistant == null) {
                    return f;
                }
                oa = basicResolveAssistant;
                HostFamily hostFamily = f instanceof HostFamily ? (HostFamily)f : null;
                if (hostFamily == null) {
                    return f;
                }
                HostFamily hostFamily2 = hostFamily;
                BasicElement orig = this.toOriginal(hostFamily2.getHost());
                basicElement = orig;
                if (basicElement == null) break block5;
                BasicMetaObject basicMetaObject = ((HostFamily)f).getMetaObject();
                Intrinsics.checkNotNullExpressionValue((Object)basicMetaObject, (String)"getMetaObject(...)");
                if ((basicElement = BasicMetaFunKt.getFamily((BasicElement)basicElement, (BasicMetaObject)basicMetaObject)) != null) break block6;
            }
            return f;
        }
        BasicElement oFamily = basicElement;
        this.pullIn((Iterable)oa.access((Family)oFamily));
        return f;
    }

    @Nullable
    public BasicMetaObject<?> getParent(@Nullable BasicMetaObject<?> meta) {
        return this.owner.getMatcher().getMetaParent(meta);
    }

    @Nullable
    public BasicElement getParent(@Nullable BasicElement e) {
        BasicElement parent = super.getParent(e);
        if (parent != null || e == null) {
            return parent;
        }
        ElementIdentity elementIdentity = this.owner.identify(e);
        Intrinsics.checkNotNullExpressionValue((Object)elementIdentity, (String)"identify(...)");
        ElementIdentity id = elementIdentity;
        ElementIdentity pId = this.owner.getParent(id);
        return pId == null ? null : this.owner.find(pId);
    }

    private final <T extends BasicElement> T toOriginal(T element) {
        return this.convert(this.owner, this.owner.getOriginal(), element);
    }

    private final <T extends BasicElement> T fromOriginal(T element) {
        return this.convert(this.owner.getOriginal(), this.owner, element);
    }

    private final <T extends BasicElement> T convert(ElementOwner from, ElementOwner to, T element) {
        return (T)(from == null || to == null || element == null ? null : to.find(from.identify(element)));
    }

    private static final boolean findAllByNameInScope$lambda$1(ElementOwnerResolveAssistant this$0, BasicMetaObject it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.isOutsideModel(it);
    }

    private static final boolean findAllByNameInScope$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Iterable findAllByNameInScope$lambda$3(ElementOwnerResolveAssistant this$0, ElementIdentity $rootId, BasicMetaObject o) {
        Intrinsics.checkNotNull((Object)o);
        return (Iterable)this$0.findChildren($rootId, o);
    }

    private static final Iterable findAllByNameInScope$lambda$4(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final BasicElement findAllByNameInScope$lambda$5(ElementOwnerResolveAssistant this$0, ElementIdentity it) {
        return this$0.owner.find(it);
    }

    private static final BasicElement findAllByNameInScope$lambda$6(Function1 $tmp0, Object p0) {
        return (BasicElement)$tmp0.invoke(p0);
    }

    private static final boolean findAllByNameInScope$lambda$7(Set $outsideTargets, BasicMetaObject it) {
        return !$outsideTargets.contains(it);
    }

    private static final boolean findAllByNameInScope$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicMetaObject findAllByNameInScope$lambda$9(ElementOwnerResolveAssistant this$0, BasicMetaObject it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.getRoot(it);
    }

    private static final BasicMetaObject findAllByNameInScope$lambda$10(Function1 $tmp0, Object p0) {
        return (BasicMetaObject)$tmp0.invoke(p0);
    }

    private static final Iterable findAllByNameInScope$lambda$11(ElementOwnerResolveAssistant this$0, ElementIdentity $rootId, BasicMetaObject it) {
        Intrinsics.checkNotNull((Object)it);
        return (Iterable)this$0.findChildren($rootId, it);
    }

    private static final Iterable findAllByNameInScope$lambda$12(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final BasicRoot findAllByNameInScope$lambda$13(ElementOwnerResolveAssistant this$0, ElementIdentity it) {
        return (BasicRoot)this$0.owner.find(it);
    }

    private static final BasicRoot findAllByNameInScope$lambda$14(Function1 $tmp0, Object p0) {
        return (BasicRoot)$tmp0.invoke(p0);
    }

    private static final Iterable findAllByNameInScope$lambda$15(ElementOwnerResolveAssistant this$0, String $name, BasicMetaObject[] $targets, BasicRoot it) {
        return (Iterable)super.findAllByNameInScope((BasicElement)it, $name, $targets);
    }

    private static final Iterable findAllByNameInScope$lambda$16(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Iterable findChildren$lambda$17(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }
}

