/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.bigquery;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.bigquery.BigQueryDdlParsing;
import com.intellij.sql.dialects.bigquery.BigQueryDialect;
import com.intellij.sql.dialects.bigquery.BigQueryDmlParsing;
import com.intellij.sql.dialects.bigquery.BigQueryExpressionParsing;
import com.intellij.sql.dialects.bigquery.BigQueryGeneratedParser;
import com.intellij.sql.dialects.bigquery.BigQueryGeneratedParserUtil;
import com.intellij.sql.dialects.bigquery.BigQueryTokens;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlReferenceElementType;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigQueryParser
extends SqlParser {
    private static final Pattern EXP_TAIL = Pattern.compile("[e|E]\\d+");

    public BigQueryParser() {
        super((SqlLanguageDialectEx)BigQueryDialect.INSTANCE);
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return BigQueryGeneratedParser.statement(builder, level);
    }

    public boolean parseOdbcSequence(PsiBuilder builder) {
        return false;
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return BigQueryGeneratedParser.parse_root_(root, builder, level);
    }

    protected boolean parseArgumentListInner(PsiBuilder builder) {
        if (PsiTreeUtil.getParentOfType((PsiElement)SqlLazyElementTypeImpl.getContextElement((PsiBuilder)builder), SqlCreateIndexStatement.class) != null) {
            SqlGeneratedParserUtil.setOn((PsiBuilder)builder, (int)0, (String)"FORBID_QUALIFICATION");
        }
        return super.parseArgumentListInner(builder);
    }

    protected TokenSet[] getExtendsTokenSets() {
        return BigQueryGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return BigQueryDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, BigQueryDmlParsing::parenthesized_aliased_join_expression, BigQueryDmlParsing::top_query_expression, BigQueryParser::parseTopQueryExpressionTail, (b, l) -> BigQueryDmlParsing.join_expression(b, l, -1), (b, l) -> BigQueryDmlParsing.join_expression_0(b, l, -1));
    }

    private static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        BigQueryDmlParsing.query_expression_0(builder, level, -1);
        return BigQueryDmlParsing.left_inner_table_op_tail(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? BigQueryDdlParsing.type_element_ext(builder, level) : BigQueryDdlParsing.type_element(builder, level);
    }

    protected boolean parseIntervalLiteral(PsiBuilder builder, int level) {
        return BigQueryExpressionParsing.interval_literal(builder, level);
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, BigQueryExpressionParsing::evaluable_expression);
    }

    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result = super.consumeCustomParameterReference(builder);
        if (result != null) {
            return result;
        }
        if (!SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_DOLLAR)) {
            return null;
        }
        IElementType type = builder.rawLookup(1);
        if (!this.isIdentifierToken(builder, type, true, false)) {
            return null;
        }
        builder.advanceLexer();
        builder.advanceLexer();
        while (SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)SQL_COLON)) {
            SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_COLON);
            SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_IDENT);
        }
        if (SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)SQL_LEFT_PAREN)) {
            SqlParserUtil.consumeAllTokensUpTo((PsiBuilder)builder, (IElementType[])new IElementType[]{SQL_RIGHT_PAREN, SQL_SEMICOLON});
            SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SQL_RIGHT_PAREN);
        }
        return SQL_PARAMETER_REFERENCE;
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = BigQueryExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(SqlBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        boolean res2 = super.parseFunctionCallTail(builder, level);
        if (res2) {
            BigQueryGeneratedParser.analytic_clause(builder, level);
        }
        return res2;
    }

    @Nullable
    protected IElementType getVariableType(PsiBuilder builder) {
        IElementType paramToken = builder.getTokenType();
        if (this.getLanguage().isOperatorSupported(paramToken)) {
            return null;
        }
        String text = builder.getTokenText();
        if (paramToken == SQL_COLON || Objects.equals(text, "@")) {
            return SQL_PARAMETER_REFERENCE;
        }
        if (Objects.equals(text, "@@")) {
            return SQL_VARIABLE_REFERENCE;
        }
        return null;
    }

    protected void consumeParameterReferenceInner(PsiBuilder builder) {
        if (Objects.equals(builder.getTokenText(), "@@")) {
            builder.advanceLexer();
            boolean advance = this.isIdentifierToken(builder, builder.getTokenType(), true, false);
            if (advance) {
                PsiBuilder.Marker identifier = builder.mark();
                PsiBuilder.Marker ident = builder.mark();
                builder.advanceLexer();
                if (builder.getTokenType() == SQL_PERIOD && this.isIdentifierToken(builder, builder.lookAhead(1), true, false)) {
                    builder.advanceLexer();
                    builder.advanceLexer();
                    ident.collapse((IElementType)SQL_IDENT);
                } else {
                    ident.drop();
                }
                identifier.done((IElementType)SQL_IDENTIFIER);
            }
        } else {
            super.consumeParameterReferenceInner(builder);
        }
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return BigQueryGeneratedParser.table_opt_column_list(builder, level);
    }

    @NotNull
    public PsiBuilder adaptBuilder(IElementType root, PsiBuilder initialBuilder) {
        PsiBuilder psiBuilder = BigQueryGeneratedParserUtil.adapt_builder_(root, initialBuilder, (PsiParser)this, this.getExtendsTokenSets());
        if (psiBuilder == null) {
            BigQueryParser.$$$reportNull$$$0(0);
        }
        return psiBuilder;
    }

    public boolean allowIdentifierSplit(SqlReferenceElementType refType) {
        return refType == SQL_TABLE_REFERENCE;
    }

    public IElementType getSplitIdentifierStart() {
        return BigQueryTokens.BQ_DELIMITED_TOKEN_START;
    }

    public IElementType getSplitIdentifierEnd() {
        return BigQueryTokens.BQ_DELIMITED_TOKEN_END;
    }

    public boolean parseIdentifierInner(PsiBuilder builder, boolean optional, boolean allowKeywords, boolean allowCharSetSpec, SqlReferenceElementType refType) {
        return this.parsePossiblySplitIdentifier(builder, refType, BigQueryTokens.BQ_DELIMITED_TOKEN_START, BigQueryTokens.BQ_DELIMITED_TOKEN_END, (b, l) -> super.parseIdentifierInner(b, optional, allowKeywords, allowCharSetSpec, refType));
    }

    protected boolean consumeIdentifierInner(PsiBuilder builder, boolean allowKeywords, boolean allowString, @Nullable SqlReferenceElementType refType) {
        if (refType == SQL_TABLE_REFERENCE || refType == SQL_VIEW_REFERENCE || refType == SQL_MATERIALIZED_VIEW_REFERENCE) {
            if (builder.getTokenType() == SQL_IDENT_DELIMITED) {
                builder.advanceLexer();
                return true;
            }
            boolean advance = this.isIdentifierToken(builder, builder.getTokenType(), allowKeywords, allowString);
            if (!advance) {
                return false;
            }
            PsiBuilder.Marker mark = builder.mark();
            while (builder.rawLookup(1) == SQL_OP_MINUS || this.isIdentifierToken(builder, builder.rawLookup(1), allowKeywords, allowString) || builder.rawLookup(1) == SQL_INTEGER_TOKEN) {
                builder.advanceLexer();
            }
            builder.advanceLexer();
            mark.collapse((IElementType)SQL_IDENT);
            return true;
        }
        return super.consumeIdentifierInner(builder, allowKeywords, allowString, refType);
    }

    protected boolean consumeIntegerToken(PsiBuilder builder, boolean allowFloat) {
        boolean optional = SqlParserUtil.consumeOneOfTokens((PsiBuilder)builder, (boolean)true, (IElementType[])new IElementType[]{SQL_OP_PLUS, SQL_OP_MINUS}) == null;
        PsiBuilder.Marker mark = builder.mark();
        boolean isFloat = false;
        if (builder.getTokenType() == SQL_PERIOD && builder.rawLookup(1) == SQL_INTEGER_TOKEN || builder.getTokenType() == SQL_INTEGER_TOKEN && builder.rawLookup(1) == SQL_PERIOD) {
            if (builder.getTokenType() == SQL_INTEGER_TOKEN) {
                builder.advanceLexer();
            }
            builder.advanceLexer();
            if (builder.getTokenType() == SQL_INTEGER_TOKEN) {
                builder.advanceLexer();
            }
            isFloat = true;
        } else if (!SqlParserUtil.consumeToken((PsiBuilder)builder, (boolean)optional, (IElementType)SQL_INTEGER_TOKEN)) {
            mark.drop();
            return false;
        }
        if (builder.getTokenType() == SQL_IDENT && StringUtil.equalsIgnoreCase((CharSequence)"e", (CharSequence)builder.getTokenText()) && (builder.rawLookup(1) == SQL_OP_MINUS || builder.rawLookup(1) == SQL_OP_PLUS) && builder.rawLookup(2) == SQL_INTEGER_TOKEN) {
            builder.advanceLexer();
            builder.advanceLexer();
            builder.advanceLexer();
            isFloat = true;
        } else if (builder.getTokenType() == SQL_IDENT && EXP_TAIL.matcher(Objects.requireNonNull(builder.getTokenText())).matches()) {
            builder.advanceLexer();
            isFloat = true;
        }
        if (isFloat) {
            mark.collapse((IElementType)SQL_FLOAT_TOKEN);
        } else {
            mark.drop();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/bigquery/BigQueryParser", "adaptBuilder"));
    }
}

