/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.smartenter;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public class SqlSemicolonFixer
extends SmartEnterProcessorWithFixers.Fixer {
    public void apply(@NotNull Editor editor2, @NotNull SmartEnterProcessorWithFixers processor2, @NotNull PsiElement element) {
        Object insDelim;
        if (editor2 == null) {
            SqlSemicolonFixer.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            SqlSemicolonFixer.$$$reportNull$$$0(1);
        }
        if (element == null) {
            SqlSemicolonFixer.$$$reportNull$$$0(2);
        }
        if (!(element instanceof SqlStatement)) {
            return;
        }
        SqlStatement statement2 = (SqlStatement)element;
        String delim = DbSqlUtilCore.getDelimiterAt((PsiFile)element.getContainingFile(), (int)element.getTextOffset());
        Object object = insDelim = !DbSqlUtilCore.delimiterNeedsSpacing((String)delim) ? delim : " " + delim;
        if (PsiTreeUtil.hasErrorElements((PsiElement)statement2)) {
            int offset;
            int textLength = editor2.getDocument().getTextLength();
            int lineEnd = editor2.getCaretModel().getVisualLineEnd();
            int n = offset = lineEnd > 0 ? lineEnd - 1 : lineEnd;
            if (offset == 0 || !editor2.getDocument().getText(TextRange.from((int)(offset - delim.length()), (int)delim.length())).equals(delim)) {
                editor2.getDocument().insertString(lineEnd == textLength ? lineEnd : offset, (CharSequence)insDelim);
            }
        } else {
            PsiElement nonWsSiblingPsi = PsiTreeUtil.nextVisibleLeaf((PsiElement)statement2);
            ASTNode nonWhitespaceSibling = nonWsSiblingPsi == null ? null : nonWsSiblingPsi.getNode();
            PsiElement lastChild = statement2.getLastChild();
            TokenSet seps = SqlImplUtil.getSqlDialectSafe((PsiElement)element).getStatementSeparators();
            if (lastChild != null && seps.contains(lastChild.getNode().getElementType())) {
                return;
            }
            if (nonWhitespaceSibling == null || !seps.contains(nonWhitespaceSibling.getElementType())) {
                editor2.getDocument().insertString(statement2.getTextRange().getEndOffset(), (CharSequence)insDelim);
            }
        }
        SmartEnterProcessor.commitDocument((Editor)editor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/smartenter/SqlSemicolonFixer";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

