/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target;

import com.intellij.execution.target.BrowsableTargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.ui.unified.SshConfigComboBox;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfigurationBase;
import java.awt.Color;
import java.awt.Component;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0004;<=>B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010$\u001a\u00020%H\u0004J\u0018\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H%J\f\u0010+\u001a\u00020%*\u00020,H\u0004J\"\u0010+\u001a\u00020%2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010.H\u0002J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020%H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R'\u0010\u0012\u001a\u0015\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013\u00a2\u0006\u0002\b\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00020\u0019X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u00105\u001a\u000200X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u000e\u00108\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00109\u001a\u000200X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00107\u00a8\u0006?"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/execution/target/BrowsableTargetEnvironmentType$ConfigurableCurrentConfigurationProvider;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfigurationBase;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfigurationBase;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConfig", "()Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfigurationBase;", "comboBoxDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "getComboBoxDisposable", "()Lcom/intellij/openapi/Disposable;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$Listener;", "kotlin.jvm.PlatformType", "getEventDispatcher", "()Lcom/intellij/util/EventDispatcher;", "connectionStatus", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatus;", "getConnectionStatus", "()Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatus;", "setConnectionStatus", "(Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatus;)V", "sshConfigCombo", "Lcom/intellij/ssh/ui/unified/SshConfigComboBox;", "getSshConfigCombo", "()Lcom/intellij/ssh/ui/unified/SshConfigComboBox;", "setSshConfigCombo", "(Lcom/intellij/ssh/ui/unified/SshConfigComboBox;)V", "onTestConnectionButtonClicked", "", "doTestConnection", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "connectionStatusLabels", "Lcom/intellij/ui/dsl/builder/Row;", "label", "Lkotlin/Function2;", "", "Lcom/intellij/ui/layout/ComponentPredicate;", "Ljavax/swing/JLabel;", "getCurrentConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "disposeUIResources", "connectionInProgress", "getConnectionInProgress", "()Lcom/intellij/ui/layout/ComponentPredicate;", "connectionSuccessful", "connectionFailed", "getConnectionFailed", "ConnectionStatus", "Companion", "Listener", "ConnectionStatusPredicate", "intellij.remoteRun"})
public abstract class SshTargetConfigurableBase
extends BoundConfigurable
implements BrowsableTargetEnvironmentType.ConfigurableCurrentConfigurationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SshTargetEnvironmentConfigurationBase config;
    @NotNull
    private final Disposable comboBoxDisposable;
    @NotNull
    private final EventDispatcher<Listener> eventDispatcher;
    protected SshConfigComboBox sshConfigCombo;
    @NotNull
    private final ComponentPredicate connectionInProgress;
    @NotNull
    private final ComponentPredicate connectionSuccessful;
    @NotNull
    private final ComponentPredicate connectionFailed;
    @NotNull
    private static final JBColor SUCCESSFUL_CONNECTION_COLOR;

    public SshTargetConfigurableBase(@NotNull Project project, @NotNull SshTargetEnvironmentConfigurationBase config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super(SshTargetConfigurableBase.Companion.getDisplayName(config, project), TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)config).getHelpTopic());
        this.project = project;
        this.config = config;
        Disposable disposable = Disposer.newDisposable((String)(((Object)((Object)this)).getClass().getSimpleName() + ".comboBoxDisposable"));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.comboBoxDisposable = disposable;
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.connectionInProgress = new ConnectionStatusPredicate(ConnectionStatus.CONNECTING);
        this.connectionSuccessful = new ConnectionStatusPredicate(ConnectionStatus.SUCCESS);
        this.connectionFailed = new ConnectionStatusPredicate(ConnectionStatus.FAILURE);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    protected SshTargetEnvironmentConfigurationBase getConfig() {
        return this.config;
    }

    @NotNull
    protected final Disposable getComboBoxDisposable() {
        return this.comboBoxDisposable;
    }

    @NotNull
    protected final EventDispatcher<Listener> getEventDispatcher() {
        return this.eventDispatcher;
    }

    @NotNull
    protected abstract ConnectionStatus getConnectionStatus();

    protected abstract void setConnectionStatus(@NotNull ConnectionStatus var1);

    @NotNull
    protected final SshConfigComboBox getSshConfigCombo() {
        SshConfigComboBox sshConfigComboBox = this.sshConfigCombo;
        if (sshConfigComboBox != null) {
            return sshConfigComboBox;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sshConfigCombo");
        return null;
    }

    protected final void setSshConfigCombo(@NotNull SshConfigComboBox sshConfigComboBox) {
        Intrinsics.checkNotNullParameter((Object)sshConfigComboBox, (String)"<set-?>");
        this.sshConfigCombo = sshConfigComboBox;
    }

    protected final void onTestConnectionButtonClicked() {
        RemoteCredentials credentials;
        this.setConnectionStatus(ConnectionStatus.CONNECTING);
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        ModalityState modalityState2 = modalityState;
        Pair selected = this.getSshConfigCombo().getSelectedUiDataAndName();
        Pair pair = selected;
        RemoteCredentials remoteCredentials = pair != null && (pair = (SshUiData)pair.first) != null ? pair.copyToCredentials() : (credentials = null);
        if (credentials == null) {
            Messages.showWarningDialog((Component)((Component)this.getSshConfigCombo()), (String)RemoteSdkBundle.message("ssh.target.dialog.message.please.choose.ssh.server", new Object[0]), (String)RemoteSdkBundle.message("ssh.target.dialog.title.rsync.connection.check", new Object[0]));
            this.setConnectionStatus(ConnectionStatus.NON_REQUESTED);
            return;
        }
        ErrorMessageAndField errorMessageAndField = SshCredentialsVerifier.validateAuthDataProvided((RemoteCredentials)credentials, (long)500L, (SshBackendLibrary)SshBackendLibrary.Companion.get());
        if (errorMessageAndField != null) {
            Object[] objectArray = new Object[]{errorMessageAndField.errorMessage()};
            Messages.showWarningDialog((Component)((Component)this.getSshConfigCombo()), (String)RemoteSdkBundle.message("ssh.target.dialog.message.please.edit.ssh.server.0", objectArray), (String)RemoteSdkBundle.message("ssh.target.dialog.title.rsync.connection.check", new Object[0]));
            this.setConnectionStatus(ConnectionStatus.NON_REQUESTED);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> SshTargetConfigurableBase.onTestConnectionButtonClicked$lambda$0(this, credentials, modalityState2));
    }

    @RequiresBackgroundThread
    protected abstract void doTestConnection(@NotNull RemoteCredentials var1, @NotNull ModalityState var2);

    protected final void connectionStatusLabels(@NotNull Row $this$connectionStatusLabels) {
        Intrinsics.checkNotNullParameter((Object)$this$connectionStatusLabels, (String)"<this>");
        this.connectionStatusLabels((Function2<? super String, ? super ComponentPredicate, ? extends JLabel>)((Function2)(arg_0, arg_1) -> SshTargetConfigurableBase.connectionStatusLabels$lambda$1($this$connectionStatusLabels, arg_0, arg_1)));
    }

    private final void connectionStatusLabels(Function2<? super String, ? super ComponentPredicate, ? extends JLabel> label) {
        String string = RemoteSdkBundle.message("ssh.target.label.checking", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        JLabel checkingLabel = (JLabel)label.invoke((Object)string, (Object)this.connectionInProgress);
        checkingLabel.setForeground(UIUtil.getLabelDisabledForeground());
        checkingLabel.setIcon((Icon)new AnimatedIcon.Default());
        String string2 = RemoteSdkBundle.message("ssh.target.label.connected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        JLabel connectedLabel = (JLabel)label.invoke((Object)string2, (Object)this.connectionSuccessful);
        connectedLabel.setForeground((Color)SUCCESSFUL_CONNECTION_COLOR);
        connectedLabel.setIcon(AllIcons.Actions.Commit);
        String string3 = RemoteSdkBundle.message("ssh.target.label.error.occurred", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        JLabel errorLabel = (JLabel)label.invoke((Object)string3, (Object)this.connectionFailed);
        errorLabel.setIcon(AllIcons.General.Error);
    }

    @NotNull
    public TargetEnvironmentConfiguration getCurrentConfiguration() {
        Pair pair = this.getSshConfigCombo().getSelectedUiDataAndName();
        this.getConfig().setSshUiData((SshUiData)(pair != null ? (SshUiData)pair.first : null));
        return this.getConfig();
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        Disposer.dispose((Disposable)this.comboBoxDisposable);
    }

    @NotNull
    protected final ComponentPredicate getConnectionInProgress() {
        return this.connectionInProgress;
    }

    @NotNull
    protected final ComponentPredicate getConnectionFailed() {
        return this.connectionFailed;
    }

    private static final void onTestConnectionButtonClicked$lambda$0(SshTargetConfigurableBase this$0, RemoteCredentials $credentials, ModalityState $modalityState) {
        this$0.doTestConnection($credentials, $modalityState);
    }

    private static final JLabel connectionStatusLabels$lambda$1(Row $this_connectionStatusLabels, String text, ComponentPredicate predicate) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return (JLabel)$this_connectionStatusLabels.label(text).visibleIf(predicate).getComponent();
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"SshRemoteRun.successfulConnectionInfoLabel", (Color)((Color)new JBColor(Color.GREEN.darker().darker(), new Color(98, 150, 85))));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        SUCCESSFUL_CONNECTION_COLOR = jBColor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003R\u0016\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$Companion;", "", "<init>", "()V", "getDisplayName", "", "Lcom/intellij/openapi/util/NlsContexts$ConfigurableName;", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfigurationBase;", "project", "Lcom/intellij/openapi/project/Project;", "SUCCESSFUL_CONNECTION_COLOR", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "getSUCCESSFUL_CONNECTION_COLOR", "()Lcom/intellij/ui/JBColor;", "intellij.remoteRun"})
    @SourceDebugExtension(value={"SMAP\nSshTargetConfigurableBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshTargetConfigurableBase.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NlsContexts.ConfigurableName
        private final String getDisplayName(SshTargetEnvironmentConfigurationBase $this$getDisplayName, Project project) {
            Object object;
            block3: {
                block2: {
                    RemoteCredentials credentials = $this$getDisplayName.findRemoteCredentials(project);
                    object = credentials;
                    if (object == null) break block2;
                    RemoteCredentials it = object;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{it.getHost(), it.getPort()};
                    String string = RemoteSdkBundle.message("configurable.name.ssh.to.0.1", objectArray);
                    object = string;
                    if (string != null) break block3;
                }
                String string = RemoteSdkBundle.message("configurable.name.ssh.to.undefined.location", new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            return object;
        }

        @NotNull
        public final JBColor getSUCCESSFUL_CONNECTION_COLOR() {
            return SUCCESSFUL_CONNECTION_COLOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatus;", "", "<init>", "(Ljava/lang/String;I)V", "NON_REQUESTED", "CONNECTING", "SUCCESS", "FAILURE", "intellij.remoteRun"})
    protected static final class ConnectionStatus
    extends Enum<ConnectionStatus> {
        public static final /* enum */ ConnectionStatus NON_REQUESTED = new ConnectionStatus();
        public static final /* enum */ ConnectionStatus CONNECTING = new ConnectionStatus();
        public static final /* enum */ ConnectionStatus SUCCESS = new ConnectionStatus();
        public static final /* enum */ ConnectionStatus FAILURE = new ConnectionStatus();
        private static final /* synthetic */ ConnectionStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConnectionStatus[] values() {
            return (ConnectionStatus[])$VALUES.clone();
        }

        public static ConnectionStatus valueOf(String value) {
            return Enum.valueOf(ConnectionStatus.class, value);
        }

        @NotNull
        public static EnumEntries<ConnectionStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = connectionStatusArray = new ConnectionStatus[]{ConnectionStatus.NON_REQUESTED, ConnectionStatus.CONNECTING, ConnectionStatus.SUCCESS, ConnectionStatus.FAILURE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatusPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "status", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatus;", "<init>", "(Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase;Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatus;)V", "getStatus", "()Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$ConnectionStatus;", "invoke", "", "()Ljava/lang/Boolean;", "addListener", "", "listener", "Lkotlin/Function1;", "intellij.remoteRun"})
    private final class ConnectionStatusPredicate
    extends ComponentPredicate {
        @NotNull
        private final ConnectionStatus status;

        public ConnectionStatusPredicate(ConnectionStatus status) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.status = status;
        }

        @NotNull
        public final ConnectionStatus getStatus() {
            return this.status;
        }

        @NotNull
        public Boolean invoke() {
            return SshTargetConfigurableBase.this.getConnectionStatus() == this.status;
        }

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            SshTargetConfigurableBase.this.getEventDispatcher().addListener((EventListener)new Listener(listener, this){
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                final /* synthetic */ ConnectionStatusPredicate this$0;
                {
                    this.$listener = $listener;
                    this.this$0 = $receiver;
                }

                public void connectionCheckEvent() {
                    this.$listener.invoke((Object)this.this$0.invoke());
                }
            }, SshTargetConfigurableBase.this.getComboBoxDisposable());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetConfigurableBase$Listener;", "Ljava/util/EventListener;", "connectionCheckEvent", "", "intellij.remoteRun"})
    public static interface Listener
    extends EventListener {
        public void connectionCheckEvent();
    }
}

