/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.extensions;

import io.ktor.network.tls.OID;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.utils.io.core.ByteReadPacketKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u001a-\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t*\u00020\bH\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0015\u0010\f\u001a\u0004\u0018\u00010\u0005*\u00020\bH\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a#\u0010\u0011\u001a\u0004\u0018\u00010\u0005*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\"\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"", "hashValue", "signValue", "", "oidValue", "Lio/ktor/network/tls/extensions/HashAndSign;", "HashAndSign", "(BBLjava/lang/String;)Lio/ktor/network/tls/extensions/HashAndSign;", "Lkotlinx/io/Source;", "", "parseSignatureAlgorithms", "(Lkotlinx/io/Source;)Ljava/util/List;", "readHashAndSign", "(Lkotlinx/io/Source;)Lio/ktor/network/tls/extensions/HashAndSign;", "Lio/ktor/network/tls/extensions/HashAndSign$Companion;", "hash", "sign", "byCode", "(Lio/ktor/network/tls/extensions/HashAndSign$Companion;BB)Lio/ktor/network/tls/extensions/HashAndSign;", "SupportedSignatureAlgorithms", "Ljava/util/List;", "getSupportedSignatureAlgorithms", "()Ljava/util/List;", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nSignatureAlgorithm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureAlgorithm.kt\nio/ktor/network/tls/extensions/SignatureAlgorithmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class SignatureAlgorithmKt {
    @NotNull
    private static final List<HashAndSign> SupportedSignatureAlgorithms;

    @Nullable
    public static final HashAndSign HashAndSign(byte hashValue, byte signValue, @Nullable String oidValue) {
        OID oID;
        HashAlgorithm hash = HashAlgorithm.Companion.byCode(hashValue);
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.Companion.byCode(signValue);
        if (signatureAlgorithm == null) {
            return null;
        }
        SignatureAlgorithm sign = signatureAlgorithm;
        String string = oidValue;
        if (string != null) {
            String it = string;
            boolean bl = false;
            oID = new OID(it);
        } else {
            oID = null;
        }
        OID oid = oID;
        return new HashAndSign(hash, sign, oid);
    }

    public static /* synthetic */ HashAndSign HashAndSign$default(byte by, byte by2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return SignatureAlgorithmKt.HashAndSign(by, by2, string);
    }

    @NotNull
    public static final List<HashAndSign> getSupportedSignatureAlgorithms() {
        return SupportedSignatureAlgorithms;
    }

    @NotNull
    public static final List<HashAndSign> parseSignatureAlgorithms(@NotNull Source $this$parseSignatureAlgorithms) {
        Intrinsics.checkNotNullParameter((Object)$this$parseSignatureAlgorithms, (String)"<this>");
        int length = $this$parseSignatureAlgorithms.readShort() & 0xFFFF;
        List result2 = new ArrayList();
        while (ByteReadPacketKt.getRemaining($this$parseSignatureAlgorithms) > 0L) {
            Collection collection = result2;
            HashAndSign hashAndSign = SignatureAlgorithmKt.readHashAndSign($this$parseSignatureAlgorithms);
            if (hashAndSign == null) continue;
            collection.add(hashAndSign);
        }
        if ((int)ByteReadPacketKt.getRemaining($this$parseSignatureAlgorithms) != length) {
            throw new TLSException("Invalid hash and sign packet size: expected " + length + ", actual " + result2.size(), null, 2, null);
        }
        return result2;
    }

    @Nullable
    public static final HashAndSign readHashAndSign(@NotNull Source $this$readHashAndSign) {
        Intrinsics.checkNotNullParameter((Object)$this$readHashAndSign, (String)"<this>");
        byte hash = $this$readHashAndSign.readByte();
        byte sign = $this$readHashAndSign.readByte();
        return SignatureAlgorithmKt.byCode(HashAndSign.Companion, hash, sign);
    }

    @Nullable
    public static final HashAndSign byCode(@NotNull HashAndSign.Companion $this$byCode, byte hash, byte sign) {
        HashAndSign hashAndSign;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$byCode, (String)"<this>");
            if (!(sign != SignatureAlgorithm.ANON.getCode())) {
                boolean bl = false;
                String string = "Anonymous signature not allowed.";
                throw new IllegalStateException(string.toString());
            }
            Iterable iterable = SupportedSignatureAlgorithms;
            for (Object t : iterable) {
                HashAndSign it = (HashAndSign)t;
                boolean bl = false;
                if (!(it.getHash().getCode() == hash && it.getSign().getCode() == sign)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((hashAndSign = (HashAndSign)v0) == null) {
            hashAndSign = SignatureAlgorithmKt.HashAndSign$default(hash, sign, null, 4, null);
        }
        return hashAndSign;
    }

    static {
        Object[] objectArray = new HashAndSign[]{new HashAndSign(HashAlgorithm.SHA384, SignatureAlgorithm.ECDSA, OID.Companion.getECDSAwithSHA384Encryption()), new HashAndSign(HashAlgorithm.SHA256, SignatureAlgorithm.ECDSA, OID.Companion.getECDSAwithSHA256Encryption()), new HashAndSign(HashAlgorithm.SHA512, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA512Encryption()), new HashAndSign(HashAlgorithm.SHA384, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA384Encryption()), new HashAndSign(HashAlgorithm.SHA256, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA256Encryption()), new HashAndSign(HashAlgorithm.SHA1, SignatureAlgorithm.RSA, OID.Companion.getRSAwithSHA1Encryption())};
        SupportedSignatureAlgorithms = CollectionsKt.listOf((Object[])objectArray);
    }
}

