/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.httpClient.grpc.HttpClientGrpcIcons;
import com.intellij.httpClient.grpc.ProtoFileUtilsKt;
import com.intellij.httpClient.grpc.completion.GrpcReflectiveServiceNameCompletionProvider;
import com.intellij.httpClient.grpc.requests.GrpcReflectionService;
import com.intellij.httpClient.grpc.requests.GrpcRequestpsiUtilsKt;
import com.intellij.httpClient.grpc.requests.MethodsByServiceKey;
import com.intellij.httpClient.grpc.requests.ServicesKey;
import com.intellij.httpClient.grpc.restClient.execution.GrpcRequest;
import com.intellij.httpClient.grpc.restClient.url.GrpcMethodUrlReference;
import com.intellij.httpClient.grpc.restClient.url.GrpcRequestUtilsKt;
import com.intellij.httpClient.grpc.restClient.url.GrpcServiceUrlReference;
import com.intellij.httpClient.http.request.microservices.LastUrlSegmentInsertHandler;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.protobuf.lang.psi.PbServiceDefinition;
import com.intellij.protobuf.lang.psi.PbServiceMethod;
import com.intellij.protobuf.lang.stub.ProtoFileAccessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0018\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0013H\u0002J\b\u0010%\u001a\u00020&H\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/httpClient/grpc/completion/GrpcReflectiveServiceNameCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "servicesFromLocalProto", "Lkotlin/sequences/Sequence;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "project", "Lcom/intellij/openapi/project/Project;", "methodsFromLocalProto", "serviceFqn", "", "reflectedServices", "key", "Lcom/intellij/httpClient/grpc/requests/ServicesKey;", "reflectedMethods", "Lcom/intellij/httpClient/grpc/requests/MethodsByServiceKey;", "createLocalServiceLookup", "serviceDefinition", "Lcom/intellij/protobuf/lang/psi/PbServiceDefinition;", "createLocalMethodLookup", "serviceMethod", "Lcom/intellij/protobuf/lang/psi/PbServiceMethod;", "createRemoteServiceLookup", "createRemoteMethodLookup", "methodName", "serviceNameWrapper", "Lcom/intellij/codeInsight/completion/InsertHandler;", "fqnPrefix", "requestBodyInserter", "Lcom/intellij/httpClient/http/request/microservices/LastUrlSegmentInsertHandler;", "intellij.httpClient.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcHttpRequestCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcHttpRequestCompletionContributor.kt\ncom/intellij/httpClient/grpc/completion/GrpcReflectiveServiceNameCompletionProvider\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n67#2:157\n4135#3,11:158\n4135#3,11:169\n1321#4,2:180\n1321#4,2:182\n30#5,2:184\n30#5,2:186\n30#5,2:188\n30#5,2:190\n1#6:192\n*S KotlinDebug\n*F\n+ 1 GrpcHttpRequestCompletionContributor.kt\ncom/intellij/httpClient/grpc/completion/GrpcReflectiveServiceNameCompletionProvider\n*L\n43#1:157\n45#1:158,11\n46#1:169,11\n58#1:180,2\n67#1:182,2\n76#1:184,2\n82#1:186,2\n90#1:188,2\n99#1:190,2\n*E\n"})
public final class GrpcReflectiveServiceNameCompletionProvider
extends CompletionProvider<CompletionParameters> {
    /*
     * WARNING - void declaration
     */
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        block8: {
            boolean $i$f$forEach;
            int port;
            Object host;
            Object scheme;
            GrpcMethodUrlReference methodNameReference;
            GrpcServiceUrlReference serviceNameReference;
            HttpRequestTarget requestTarget;
            block7: {
                void $this$forEach$iv;
                Object object;
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstanceTo$iv$iv2;
                void $this$parentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                PsiElement psiElement = parameters.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
                PsiElement psiElement2 = psiElement;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType22 = false;
                HttpRequestTarget httpRequestTarget = (HttpRequestTarget)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, HttpRequestTarget.class, (boolean)true);
                if (httpRequestTarget == null) {
                    return;
                }
                requestTarget = httpRequestTarget;
                PsiReference[] psiReferenceArray = requestTarget.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                Object[] $this$filterIsInstance$iv = psiReferenceArray;
                boolean $i$f$filterIsInstance = false;
                Object[] $i$f$parentOfType22 = $this$filterIsInstance$iv;
                Object[] destination$iv$iv = (Object[])new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                int n = ((void)$this$filterIsInstanceTo$iv$iv2).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv = $this$filterIsInstanceTo$iv$iv2[i];
                    if (!(element$iv$iv instanceof GrpcServiceUrlReference)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                serviceNameReference = (GrpcServiceUrlReference)((Object)CollectionsKt.singleOrNull((List)((List)destination$iv$iv)));
                PsiReference[] psiReferenceArray2 = requestTarget.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray2, (String)"getReferences(...)");
                Object[] $this$filterIsInstance$iv2 = psiReferenceArray2;
                boolean $i$f$filterIsInstance2 = false;
                destination$iv$iv = $this$filterIsInstance$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo22 = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof GrpcMethodUrlReference)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                methodNameReference = (GrpcMethodUrlReference)((Object)CollectionsKt.singleOrNull((List)((List)destination$iv$iv2)));
                PsiElement psiElement3 = CompletionUtil.getOriginalOrSelf((PsiElement)((PsiElement)requestTarget));
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getOriginalOrSelf(...)");
                GrpcRequest grpcRequest = GrpcRequestpsiUtilsKt.getOrComputeGrpcRequest((HttpRequestTarget)psiElement3);
                Object object2 = grpcRequest;
                if (object2 == null || (object2 = ((GrpcRequest)object2).getScheme()) == null) {
                    object2 = scheme = "grpc";
                }
                if ((object = grpcRequest) == null || (object = ((GrpcRequest)object).getHost()) == null) {
                    object = "localhost";
                }
                host = object;
                GrpcRequest grpcRequest2 = grpcRequest;
                port = grpcRequest2 != null ? grpcRequest2.getPort() : 8080;
                if (serviceNameReference == null || !serviceNameReference.getAbsoluteRange().contains(parameters.getOffset())) break block7;
                Project project = requestTarget.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Sequence<LookupElement> sequence = this.servicesFromLocalProto(project);
                Project project2 = requestTarget.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                Sequence $i$f$filterIsInstanceTo22 = SequencesKt.distinctBy((Sequence)SequencesKt.plus(sequence, this.reflectedServices(project2, new ServicesKey((String)scheme, (String)host, port))), (Function1)addCompletions.1.INSTANCE);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LookupElement it = (LookupElement)element$iv;
                    boolean bl = false;
                    ProgressManager.checkCanceled();
                    result.consume(it);
                }
                break block8;
            }
            if (serviceNameReference == null || methodNameReference == null || !methodNameReference.getAbsoluteRange().contains(parameters.getOffset())) break block8;
            Project project = requestTarget.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String string = serviceNameReference.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            Sequence<LookupElement> sequence = this.methodsFromLocalProto(project, string);
            Project project3 = requestTarget.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            String string2 = serviceNameReference.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            Sequence $this$forEach$iv = SequencesKt.distinctBy((Sequence)SequencesKt.plus(sequence, this.reflectedMethods(project3, new MethodsByServiceKey((String)scheme, (String)host, port, string2))), (Function1)addCompletions.3.INSTANCE);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LookupElement it = (LookupElement)element$iv;
                boolean bl = false;
                ProgressManager.checkCanceled();
                result.consume(it);
            }
        }
    }

    private final Sequence<LookupElement> servicesFromLocalProto(Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ProtoFileAccessor> serviceClass$iv = ProtoFileAccessor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return SequencesKt.map((Sequence)((ProtoFileAccessor)object).findAllServices(), (Function1)((Function1)new Function1<PbServiceDefinition, LookupElement>((Object)this){

            public final LookupElement invoke(PbServiceDefinition p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GrpcReflectiveServiceNameCompletionProvider.access$createLocalServiceLookup((GrpcReflectiveServiceNameCompletionProvider)((Object)this.receiver), p0);
            }
        }));
    }

    private final Sequence<LookupElement> methodsFromLocalProto(Project project, String serviceFqn) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ProtoFileAccessor> serviceClass$iv = ProtoFileAccessor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((ProtoFileAccessor)object).findAllMethodsWithFqnPrefix(serviceFqn), GrpcReflectiveServiceNameCompletionProvider::methodsFromLocalProto$lambda$2), (Function1)((Function1)new Function1<PbServiceMethod, LookupElement>((Object)this){

            public final LookupElement invoke(PbServiceMethod p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GrpcReflectiveServiceNameCompletionProvider.access$createLocalMethodLookup((GrpcReflectiveServiceNameCompletionProvider)((Object)this.receiver), p0);
            }
        }));
    }

    private final Sequence<LookupElement> reflectedServices(Project project, ServicesKey key) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GrpcReflectionService> serviceClass$iv = GrpcReflectionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Future future = ((GrpcReflectionService)object).retrieveServicesFuture(key);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
        Object object2 = ApplicationUtil.runWithCheckCanceled((Future)future, (ProgressIndicator)progressIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"runWithCheckCanceled(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object2)), (Function1)((Function1)new Function1<String, LookupElement>((Object)this){

            public final LookupElement invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GrpcReflectiveServiceNameCompletionProvider.access$createRemoteServiceLookup((GrpcReflectiveServiceNameCompletionProvider)((Object)this.receiver), p0);
            }
        }));
    }

    private final Sequence<LookupElement> reflectedMethods(Project project, MethodsByServiceKey key) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GrpcReflectionService> serviceClass$iv = GrpcReflectionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Future future = ((GrpcReflectionService)object).retrieveMethodsForServiceFuture(key);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
        Object object2 = ApplicationUtil.runWithCheckCanceled((Future)future, (ProgressIndicator)progressIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"runWithCheckCanceled(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object2)), (Function1)((Function1)new Function1<String, LookupElement>((Object)this){

            public final LookupElement invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GrpcReflectiveServiceNameCompletionProvider.access$createRemoteMethodLookup((GrpcReflectiveServiceNameCompletionProvider)((Object)this.receiver), p0);
            }
        }));
    }

    private final LookupElement createLocalServiceLookup(PbServiceDefinition serviceDefinition) {
        String fqnPrefix = GrpcRequestUtilsKt.asFqnPrefix(String.valueOf(serviceDefinition.getQualifiedName()));
        String string = serviceDefinition.getName();
        if (string == null) {
            string = "";
        }
        Object[] objectArray = new String[2];
        objectArray[0] = serviceDefinition.getName();
        QualifiedName qualifiedName = serviceDefinition.getQualifiedName();
        objectArray[1] = qualifiedName != null ? qualifiedName.join(".") : null;
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)string).withIcon(HttpClientGrpcIcons.Procedure).withTypeText(fqnPrefix).withPsiElement((PsiElement)serviceDefinition).withInsertHandler(this.serviceNameWrapper(fqnPrefix)).withLookupStrings((Collection)CollectionsKt.listOfNotNull((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withLookupStrings(...)");
        return (LookupElement)lookupElementBuilder;
    }

    private final LookupElement createLocalMethodLookup(PbServiceMethod serviceMethod) {
        String string = serviceMethod.getName();
        if (string == null) {
            string = "";
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)string).withIcon(HttpClientGrpcIcons.Procedure).withPsiElement((PsiElement)serviceMethod).withInsertHandler((InsertHandler)this.requestBodyInserter());
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
        return (LookupElement)lookupElementBuilder;
    }

    private final LookupElement createRemoteServiceLookup(String serviceFqn) {
        String fqnPrefix = GrpcRequestUtilsKt.asFqnPrefix(serviceFqn);
        Object[] objectArray = new String[]{GrpcRequestUtilsKt.asShortName(serviceFqn), serviceFqn};
        LookupElementBuilder it = LookupElementBuilder.create((String)GrpcRequestUtilsKt.asShortName(serviceFqn)).withIcon(HttpClientGrpcIcons.Procedure).withTypeText(fqnPrefix).withInsertHandler(this.serviceNameWrapper(fqnPrefix)).withLookupStrings((Collection)CollectionsKt.listOfNotNull((Object[])objectArray));
        boolean bl = false;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)it), (double)10.0);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"let(...)");
        return lookupElement;
    }

    private final LookupElement createRemoteMethodLookup(String methodName) {
        LookupElementBuilder it = LookupElementBuilder.create((String)methodName).withIcon(HttpClientGrpcIcons.Procedure).withInsertHandler((InsertHandler)this.requestBodyInserter());
        boolean bl = false;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)it), (double)10.0);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"let(...)");
        return lookupElement;
    }

    private final InsertHandler<LookupElement> serviceNameWrapper(String fqnPrefix) {
        return !StringsKt.isBlank((CharSequence)fqnPrefix) ? (arg_0, arg_1) -> GrpcReflectiveServiceNameCompletionProvider.serviceNameWrapper$lambda$6(fqnPrefix, arg_0, arg_1) : null;
    }

    private final LastUrlSegmentInsertHandler requestBodyInserter() {
        return new LastUrlSegmentInsertHandler((Collection)CollectionsKt.listOf((Object)"application/json"), false);
    }

    private static final boolean methodsFromLocalProto$lambda$2(PbServiceMethod it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProtoFileUtilsKt.canExecuteRPC(it);
    }

    private static final void serviceNameWrapper$lambda$6(String $fqnPrefix, InsertionContext context, LookupElement lookupElement) {
        CaretModel caretModel;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
        context.getDocument().insertString(context.getSelectionEndOffset(), (CharSequence)"/");
        context.getDocument().insertString(context.getStartOffset(), (CharSequence)($fqnPrefix + "."));
        CaretModel $this$serviceNameWrapper_u24lambda_u246_u24lambda_u245 = caretModel = context.getEditor().getCaretModel();
        boolean bl = false;
        $this$serviceNameWrapper_u24lambda_u246_u24lambda_u245.moveToOffset($this$serviceNameWrapper_u24lambda_u246_u24lambda_u245.getOffset() + 1);
    }

    public static final /* synthetic */ LookupElement access$createLocalServiceLookup(GrpcReflectiveServiceNameCompletionProvider $this, PbServiceDefinition serviceDefinition) {
        return $this.createLocalServiceLookup(serviceDefinition);
    }

    public static final /* synthetic */ LookupElement access$createLocalMethodLookup(GrpcReflectiveServiceNameCompletionProvider $this, PbServiceMethod serviceMethod) {
        return $this.createLocalMethodLookup(serviceMethod);
    }

    public static final /* synthetic */ LookupElement access$createRemoteServiceLookup(GrpcReflectiveServiceNameCompletionProvider $this, String serviceFqn) {
        return $this.createRemoteServiceLookup(serviceFqn);
    }

    public static final /* synthetic */ LookupElement access$createRemoteMethodLookup(GrpcReflectiveServiceNameCompletionProvider $this, String methodName) {
        return $this.createRemoteMethodLookup(methodName);
    }
}

