/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.requests;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.httpClient.grpc.GrpcBundle;
import com.intellij.httpClient.grpc.requests.GrpcCommandLineUtilsKt;
import com.intellij.httpClient.grpc.requests.GrpcRequestManager;
import com.intellij.httpClient.grpc.requests.ProtocCliAccessor;
import com.intellij.httpClient.grpc.requests.RejectedRPCException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.io.DigestUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J(\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/httpClient/grpc/requests/ProtocBinaryBuilder;", "", "<init>", "()V", "buildAllRelatedBinaryProtoDescriptors", "Ljava/nio/file/Path;", "protoFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "substitutedImports", "", "", "suggestTempBinaryPath", "prepareCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "tempBinaryProto", "findProtocExecutablePath", "intellij.httpClient.grpc"})
@SourceDebugExtension(value={"SMAP\nProtocBinaryBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocBinaryBuilder.kt\ncom/intellij/httpClient/grpc/requests/ProtocBinaryBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,80:1\n1#2:81\n14#3:82\n24#3:83\n1563#4:84\n1634#4,3:85\n37#5:88\n36#5,3:89\n*S KotlinDebug\n*F\n+ 1 ProtocBinaryBuilder.kt\ncom/intellij/httpClient/grpc/requests/ProtocBinaryBuilder\n*L\n25#1:82\n47#1:83\n64#1:84\n64#1:85,3\n65#1:88\n65#1:89,3\n*E\n"})
public final class ProtocBinaryBuilder {
    @NotNull
    public static final ProtocBinaryBuilder INSTANCE = new ProtocBinaryBuilder();

    private ProtocBinaryBuilder() {
    }

    @NotNull
    public final Path buildAllRelatedBinaryProtoDescriptors(@NotNull VirtualFile protoFile, @NotNull Collection<String> substitutedImports) {
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        Intrinsics.checkNotNullParameter(substitutedImports, (String)"substitutedImports");
        Path binaryDescriptorPath = ProtocBinaryBuilder.suggestTempBinaryPath(protoFile);
        GeneralCommandLine generalCommandLine = this.prepareCommandLine(protoFile, substitutedImports, binaryDescriptorPath);
        if (generalCommandLine != null) {
            GeneralCommandLine p0 = generalCommandLine;
            boolean bl = false;
            GrpcCommandLineUtilsKt.executeCommandAndGetOutputAsString(p0);
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(binaryDescriptorPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ProtocBinaryBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Binary proto file representation is not available on the disk although an attempt to generate it with protoc compiler was performed");
            throw new RejectedRPCException(GrpcBundle.INSTANCE.message("unable.to.build.binary.proto.file.representation.to.execute.rpc", new Object[0]), null, 2, null);
        }
        return binaryDescriptorPath;
    }

    @JvmStatic
    @NotNull
    public static final Path suggestTempBinaryPath(@NotNull VirtualFile protoFile) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        MessageDigest $this$suggestTempBinaryPath_u24lambda_u240 = DigestUtil.md5();
        boolean bl = false;
        String string = PathUtil.toSystemIndependentName((String)protoFile.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $this$suggestTempBinaryPath_u24lambda_u240.update(byArray);
        String hash = DigestUtil.digestToHash((MessageDigest)$this$suggestTempBinaryPath_u24lambda_u240);
        Path it = path = GrpcRequestManager.Companion.getTEMP_BINARY_DESCRIPTOR_FOLDER().resolve(hash);
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectories(it, new FileAttribute[0]);
        }
        it = path = path.resolve("binaryDescriptor.bin");
        boolean bl3 = false;
        try {
            Intrinsics.checkNotNull((Object)it);
            Files.deleteIfExists(it);
        }
        catch (IOException exception) {
            ProtocBinaryBuilder $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ProtocBinaryBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)exception);
        }
        Path path2 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"also(...)");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    private final GeneralCommandLine prepareCommandLine(VirtualFile protoFile, Collection<String> substitutedImports, Path tempBinaryProto) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        String string = this.findProtocExecutablePath();
        if (string == null) {
            return null;
        }
        String executablePath = string;
        String protoPathFlag = "--proto_path";
        String includeImportsDirective = "--include_imports";
        String p0 = ((Object)tempBinaryProto.toAbsolutePath()).toString();
        boolean bl = false;
        String absolutePathString = PathUtil.toSystemDependentName((String)p0);
        String descriptorOutFile = "--descriptor_set_out=" + absolutePathString;
        Object p02 = protoFile.getParent().getPath();
        boolean bl2 = false;
        String protoDirectory = PathUtil.toSystemDependentName((String)p02);
        p02 = CollectionsKt.plus(substitutedImports, (Object)protoDirectory);
        boolean $i$f$map = false;
        void var13_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(protoPathFlag + "=" + (String)it);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] pathDirectives = thisCollection$iv.toArray(new String[0]);
        String p03 = protoFile.getPath();
        boolean bl4 = false;
        String protoFilePath = PathUtil.toSystemDependentName((String)p03);
        SpreadBuilder spreadBuilder = new SpreadBuilder(5);
        spreadBuilder.add((Object)executablePath);
        spreadBuilder.addSpread((Object)pathDirectives);
        spreadBuilder.add((Object)includeImportsDirective);
        spreadBuilder.add((Object)descriptorOutFile);
        spreadBuilder.add((Object)protoFilePath);
        return new GeneralCommandLine((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])).withWorkDirectory(protoDirectory);
    }

    private final String findProtocExecutablePath() {
        return ProtocCliAccessor.INSTANCE.findProtocExecutablePath();
    }
}

