/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.codeInsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassMembersProviderBase;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyOverridingClassMembersProvider;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DjangoOverridingClassMembersProvider
extends PyClassMembersProviderBase
implements PyOverridingClassMembersProvider {
    @NotNull
    public Collection<PyCustomMember> getMembers(PyClassType classType, PsiElement location, @NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoOverridingClassMembersProvider.$$$reportNull$$$0(0);
        }
        if (Registry.is((String)"django.enable.pyi.stubs")) {
            List<PyCustomMember> list = Collections.emptyList();
            if (list == null) {
                DjangoOverridingClassMembersProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (location != null && !DjangoFacet.isPresent((PsiElement)location)) {
            List<PyCustomMember> list = Collections.emptyList();
            if (list == null) {
                DjangoOverridingClassMembersProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        PyClass clazz = classType.getPyClass();
        PyPsiUtils.assertValid((PsiElement)clazz);
        if (!clazz.isValid() || !DjangoFacet.isInProject((PsiElement)clazz)) {
            List<PyCustomMember> list = Collections.emptyList();
            if (list == null) {
                DjangoOverridingClassMembersProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (DjangoOverridingClassMembersProvider.isDjangoHttpRequest(classType)) {
            Collection<PyCustomMember> collection = this.getDjangoHttpRequestProperties(location);
            if (collection == null) {
                DjangoOverridingClassMembersProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }
        List<PyCustomMember> list = Collections.emptyList();
        if (list == null) {
            DjangoOverridingClassMembersProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    public Collection<PyCustomMember> getDjangoHttpRequestProperties(PsiElement location) {
        ArrayList<PyCustomMember> requestProperties = new ArrayList<PyCustomMember>(Arrays.asList(DjangoOverridingClassMembersProvider.createQueryDictMember("GET"), DjangoOverridingClassMembersProvider.createQueryDictMember("POST"), DjangoOverridingClassMembersProvider.createQueryDictMember("REQUEST"), DjangoOverridingClassMembersProvider.createQueryDictMember("FILES")));
        if (location != null) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)location);
            List middleware = DjangoSettingsPy.getMiddleware((Module)module);
            if (middleware.contains("django.contrib.auth.middleware.AuthenticationMiddleware")) {
                requestProperties.add(new PyCustomMember("user", "django.contrib.auth.models.User", true).resolvesToClass("django.contrib.auth.middleware.AuthenticationMiddleware").toFunction("process_request").toAssignment("request.user"));
            }
            if (middleware.contains("django.contrib.sessions.middleware.SessionMiddleware")) {
                requestProperties.add(new PyCustomMember("session", "django.contrib.sessions.backends.base.SessionBase", true).resolvesToClass("django.contrib.sessions.middleware.SessionMiddleware").toFunction("process_request").toAssignment("request.session"));
            }
        }
        return requestProperties;
    }

    private static boolean isDjangoHttpRequest(PyClassType type) {
        return "django.http.request.HttpRequest".equals(type.getClassQName());
    }

    private static PyCustomMember createQueryDictMember(String name) {
        return new PyCustomMember(name, "django.http.request.QueryDict", false).resolvesToClass("django.core.handlers.wsgi.WSGIRequest").toClassAttribute(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/codeInsight/DjangoOverridingClassMembersProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/codeInsight/DjangoOverridingClassMembersProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMembers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

