/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.model.stubs.manager;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.django.model.stubs.manager.DjangoManagerStub;
import com.intellij.util.io.StringRef;
import com.jetbrains.django.codeInsight.DjangoTypeProvider;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.stubs.manager.DjangoManagerIndex;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoManagerStubType
extends CustomTargetExpressionStubType<DjangoManagerStub> {
    private static final Collection<String> MODEL_FIELDS = Collections2.transform(DjangoTypeProvider.FIELD_INSTANCE_TYPES.keySet(), (Function)new MyFieldShortNamesObtainer());

    @Nullable
    public DjangoManagerStub createStub(@NotNull PyTargetExpression psi) {
        if (psi == null) {
            DjangoManagerStubType.$$$reportNull$$$0(0);
        }
        if (!DjangoFacet.isInProject((PsiElement)psi)) {
            return null;
        }
        PyClass possibleModel = psi.getContainingClass();
        if (possibleModel == null) {
            return null;
        }
        boolean hasFields = false;
        String calleeName = null;
        for (PyTargetExpression modelAttribute : possibleModel.getClassAttributes()) {
            PyExpression callee;
            PyCallExpression modelAttributeValue = (PyCallExpression)PyUtil.as((Object)modelAttribute.findAssignedValue(), PyCallExpression.class);
            if (modelAttributeValue == null || (callee = modelAttributeValue.getCallee()) == null) continue;
            if (MODEL_FIELDS.contains(callee.getName())) {
                if (modelAttribute.equals(psi)) {
                    return null;
                }
                hasFields = true;
                continue;
            }
            if (!modelAttribute.equals(psi)) continue;
            calleeName = callee.getName();
        }
        if (!hasFields || calleeName == null) {
            return null;
        }
        return new DjangoManagerStub(StringRef.fromString(calleeName));
    }

    @NotNull
    public DjangoManagerStub deserializeStub(@NotNull StubInputStream stream) throws IOException {
        if (stream == null) {
            DjangoManagerStubType.$$$reportNull$$$0(1);
        }
        return new DjangoManagerStub(stream.readName());
    }

    public void indexStub(PyTargetExpressionStub stub, IndexSink sink) {
        DjangoManagerStub customStub = (DjangoManagerStub)stub.getCustomStub(DjangoManagerStub.class);
        if (customStub != null) {
            sink.occurrence(DjangoManagerIndex.KEY, (Object)customStub.getManagerNameRef().getString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/model/stubs/manager/DjangoManagerStubType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deserializeStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyFieldShortNamesObtainer
    implements Function<String, String> {
        private MyFieldShortNamesObtainer() {
        }

        public String apply(String input) {
            return QualifiedName.fromDottedString((String)input).getLastComponent();
        }
    }
}

