/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.celery.ref;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\r\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/django/packages/celery/ref/CeleryBeatScheduleNewTaskQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "intellij.python.django"})
public final class CeleryBeatScheduleNewTaskQuickFix
extends PsiUpdateModCommandQuickFix {
    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        block7: {
            Object codeToAdd;
            Object object;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            if (!Registry.Companion.is("django.celery.enabled")) {
                return;
            }
            PsiReference[] psiReferenceArray = element.getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            PsiReference[] refs = psiReferenceArray;
            if (refs.length < 2) {
                return;
            }
            PsiElement psiElement = refs[refs.length - 2].resolve();
            PsiFile psiFile = psiElement instanceof PsiFile ? (PsiFile)psiElement : null;
            if (psiFile == null) {
                return;
            }
            PsiFile fileToFix = psiFile;
            String string = refs[refs.length - 1].getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
            String taskName = string;
            PsiFile fileToFixWritable = (PsiFile)updater.getWritable((PsiElement)fileToFix);
            PyElementGenerator elementFactory = PyElementGenerator.getInstance((Project)project);
            if (Character.isLowerCase(StringsKt.first((CharSequence)taskName))) {
                code = StringsKt.trimIndent((String)("\n            @shared_task\n            def " + taskName + "(self):\n                pass\n        "));
                AddImportHelper.addOrUpdateFromImportStatement((PsiFile)fileToFixWritable, (String)"celery", (String)"shared_task", null, (AddImportHelper.ImportPriority)AddImportHelper.ImportPriority.THIRD_PARTY, null);
                object = elementFactory.createFromText(LanguageLevel.forElement((PsiElement)((PsiElement)fileToFixWritable)), PyFunction.class, code);
            } else if (Character.isUpperCase(StringsKt.first((CharSequence)taskName))) {
                code = StringsKt.trimIndent((String)("\n            class " + taskName + "(Task):\n                def run(self, *args, **kwargs):\n                    pass\n        "));
                AddImportHelper.addOrUpdateFromImportStatement((PsiFile)fileToFixWritable, (String)"celery", (String)"Task", null, (AddImportHelper.ImportPriority)AddImportHelper.ImportPriority.THIRD_PARTY, null);
                object = elementFactory.createFromText(LanguageLevel.forElement((PsiElement)((PsiElement)fileToFixWritable)), PyClass.class, code);
            } else {
                object = null;
            }
            Object object2 = codeToAdd = object;
            if (object2 == null) break block7;
            Object it = object2;
            boolean bl = false;
            PsiElement addedPsi = fileToFixWritable.add((PsiElement)it);
            updater.moveCaretTo(addedPsi);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = DjangoBundle.message((String)"celery.unresolved-task.quickfix", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

