/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.run;

import com.google.common.net.HostAndPort;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.openapi.util.text.StringUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlFilterWithRedirection
extends UrlFilter {
    @NotNull
    private final Map<HostAndPort, HostAndPort> myRedirections;

    public UrlFilterWithRedirection(@NotNull Map<HostAndPort, HostAndPort> redirections) {
        if (redirections == null) {
            UrlFilterWithRedirection.$$$reportNull$$$0(0);
        }
        this.myRedirections = new HashMap<HostAndPort, HostAndPort>();
        for (Map.Entry<HostAndPort, HostAndPort> entry : redirections.entrySet()) {
            this.myRedirections.put(UrlFilterWithRedirection.convertHostToLowerCase(entry.getKey()), entry.getValue());
        }
    }

    @NotNull
    protected HyperlinkInfo buildHyperlinkInfo(@NotNull String url) {
        if (url == null) {
            UrlFilterWithRedirection.$$$reportNull$$$0(1);
        }
        HyperlinkInfo hyperlinkInfo = super.buildHyperlinkInfo(this.redirect(url));
        if (hyperlinkInfo == null) {
            UrlFilterWithRedirection.$$$reportNull$$$0(2);
        }
        return hyperlinkInfo;
    }

    @NotNull
    private String redirect(@NotNull String urlString) {
        String string;
        HostAndPort redirection;
        URL url;
        block7: {
            if (urlString == null) {
                UrlFilterWithRedirection.$$$reportNull$$$0(3);
            }
            url = new URL(urlString);
            redirection = this.myRedirections.get(HostAndPort.fromParts((String)StringUtil.toLowerCase((String)url.getHost()), (int)url.getPort()));
            if (redirection != null) break block7;
            String string2 = urlString;
            if (string2 == null) {
                UrlFilterWithRedirection.$$$reportNull$$$0(4);
            }
            return string2;
        }
        try {
            String redirectedToHost = redirection.getHost();
            int redirectedToPort = redirection.hasPort() ? redirection.getPort() : url.getPort();
            string = new URL(url.getProtocol(), redirectedToHost, redirectedToPort, url.getFile()).toString();
        }
        catch (IllegalArgumentException | MalformedURLException ignored) {
            String string3 = urlString;
            if (string3 == null) {
                UrlFilterWithRedirection.$$$reportNull$$$0(6);
            }
            return string3;
        }
        if (string == null) {
            UrlFilterWithRedirection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static HostAndPort convertHostToLowerCase(@Nullable HostAndPort hostAndPort) {
        if (hostAndPort == null) {
            return null;
        }
        String host = StringUtil.toLowerCase((String)hostAndPort.getHost());
        if (hostAndPort.hasPort()) {
            return HostAndPort.fromParts((String)host, (int)hostAndPort.getPort());
        }
        return HostAndPort.fromHost((String)host);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redirections";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/run/UrlFilterWithRedirection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/run/UrlFilterWithRedirection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHyperlinkInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "redirect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildHyperlinkInfo";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "redirect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

