/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVariance;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.full.KTypes;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.annotations.ColumnName;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.ConstructorsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00f6\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0002\u0010\u000b\n\u0002\u0010\u0012\n\u0002\u0010\u0005\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\u0010\u0013\n\u0002\u0010\u0006\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\u0010\u0015\n\u0002\u0010\u0016\n\u0002\u0010\t\n\u0002\u0010\u0017\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0004\n\u0002\b\u0002\u001a#\u0010\u0011\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0013H\u0000\u00a2\u0006\u0002\u0010\u0014\u001a-\u0010\u0015\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u001aH\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\b\u0010\u001c\u001a\u00020\u001dH\u0001\u001a4\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0006\b\u0000\u0010 \u0018\u00012\u0006\u0010!\u001a\u0002H 2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u0002H 0\u001fH\u0081\b\u00a2\u0006\u0002\u0010#\u001a\u0018\u0010\u001e\u001a\u00020$2\u0006\u0010!\u001a\u00020%2\u0006\u0010\"\u001a\u00020$H\u0001\u001a\u0018\u0010\u001e\u001a\u00020&2\u0006\u0010!\u001a\u00020'2\u0006\u0010\"\u001a\u00020&H\u0001\u001a\u0018\u0010\u001e\u001a\u00020(2\u0006\u0010!\u001a\u00020)2\u0006\u0010\"\u001a\u00020(H\u0001\u001a\u0018\u0010\u001e\u001a\u00020*2\u0006\u0010!\u001a\u00020+2\u0006\u0010\"\u001a\u00020*H\u0001\u001a\u0018\u0010\u001e\u001a\u00020,2\u0006\u0010!\u001a\u00020-2\u0006\u0010\"\u001a\u00020,H\u0001\u001a\u0018\u0010\u001e\u001a\u00020.2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020.H\u0001\u001a\u0018\u0010\u001e\u001a\u00020/2\u0006\u0010!\u001a\u0002002\u0006\u0010\"\u001a\u00020/H\u0001\u001a\u0018\u0010\u001e\u001a\u0002012\u0006\u0010!\u001a\u0002022\u0006\u0010\"\u001a\u000201H\u0001\u001a2\u00103\u001a\b\u0012\u0004\u0012\u0002H 04\"\u0006\b\u0000\u0010 \u0018\u00012\u0006\u0010!\u001a\u0002H 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 04H\u0081\b\u00a2\u0006\u0002\u00105\u001a\u008e\u0001\u00106\u001a'\u0012\u0013\u0012\u0011H\u000b\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\u0004\u0012\u00020%07j\b\u0012\u0004\u0012\u0002H\u000b`;\"\u0004\b\u0000\u0010\u000b*+\u0012\u0013\u0012\u0011H\u000b\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\u0004\u0012\u00020%\u0018\u000107j\n\u0012\u0004\u0012\u0002H\u000b\u0018\u0001`;2+\u0010<\u001a'\u0012\u0013\u0012\u0011H\u000b\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\u0004\u0012\u00020%07j\b\u0012\u0004\u0012\u0002H\u000b`;H\u0080\u0004\u001a\u0018\u0010=\u001a\u00020%\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b04H\u0001\u001a\u001c\u0010>\u001a\b\u0012\u0004\u0012\u0002H\u000b0?\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b04\u001a\u0019\u0010@\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b*\u0002H\u000bH\u0000\u00a2\u0006\u0002\u0010A\u001a;\u0010B\u001a\u00020%\"\u000e\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0C*\u0002H\u000b2\u0006\u0010D\u001a\u0002H\u000b2\u0006\u0010E\u001a\u0002H\u000b2\b\b\u0002\u0010F\u001a\u00020%H\u0000\u00a2\u0006\u0002\u0010G\u001a\u001e\u0010H\u001a\u0002H\u000b\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\u0016*\u00020\u0018H\u0080\b\u00a2\u0006\u0002\u0010I\u001a*\u0010J\u001a\u00020K*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a042\u0006\u0010L\u001a\u00020%2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010KH\u0000\u001a\u001e\u0010J\u001a\u00020K*\n\u0012\u0006\u0012\u0004\u0018\u00010K042\b\b\u0002\u0010N\u001a\u00020%H\u0000\u001a\u0018\u0010O\u001a\u00020K*\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010L\u001a\u00020%H\u0000\u001a&\u0010P\u001a\u00020%\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b042\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H\u000b04H\u0000\u001a|\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001d0?\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010 *\b\u0012\u0004\u0012\u0002H\u000b0R2\u0006\u0010S\u001a\u00020T2N\u0010U\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0W\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u000b0W\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0X0Vj\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H `Y\u00a2\u0006\u0002\bZH\u0000\u001a\u0082\u0001\u0010[\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\\0?\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010 *\b\u0012\u0004\u0012\u0002H\u000b0R2\u0006\u0010S\u001a\u00020T2N\u0010U\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0W\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u000b0W\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0X0Vj\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H `Y\u00a2\u0006\u0002\bZH\u0000\u001a\u0082\u0001\u0010]\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0^0?\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010 *\b\u0012\u0004\u0012\u0002H\u000b0R2\u0006\u0010S\u001a\u00020T2N\u0010U\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0W\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u000b0W\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(:\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0X0Vj\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H `Y\u00a2\u0006\u0002\bZH\u0000\u001a\u0012\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00180?*\u00020$H\u0000\u001a\u0018\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00180?*\b\u0012\u0004\u0012\u00020%0?H\u0000\u001a$\u0010`\u001a\u00020\u0018\"\u000e\b\u0000\u0010 *\b\u0012\u0004\u0012\u0002H 0C*\n\u0012\u0006\u0012\u0004\u0018\u0001H 0aH\u0000\u001a$\u0010b\u001a\u00020\u0018\"\u000e\b\u0000\u0010 *\b\u0012\u0004\u0012\u0002H 0C*\n\u0012\u0006\u0012\u0004\u0018\u0001H 0aH\u0000\u001a\u0014\u0010c\u001a\u00020%*\u00020K2\u0006\u0010d\u001a\u00020KH\u0000\u001a\u0012\u0010e\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00070?H\u0000\u001a&\u0010f\u001a\b\u0012\u0004\u0012\u0002H\u000b0?\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0?2\u0006\u0010g\u001a\u00020\u0018H\u0000\u001a&\u0010h\u001a\b\u0012\u0004\u0012\u0002H\u000b0?\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0?2\u0006\u0010i\u001a\u00020\u0018H\u0000\u001a\u0018\u0010j\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b04H\u0000\u001a2\u0010k\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0?0a\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0?2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00180aH\u0000\u001a2\u0010k\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0R0a\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0R2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00180aH\u0000\u001a\u0012\u0010m\u001a\u00020\u0007*\u00020\u00072\u0006\u0010n\u001a\u00020\u0001\u001a3\u0010o\u001a\b\u0012\u0004\u0012\u0002H\u000b04\"\u0004\b\u0000\u0010\u000b*\u0002H\u000b2\u0014\u0010p\u001a\u0010\u0012\u0004\u0012\u0002H\u000b\u0012\u0006\u0012\u0004\u0018\u0001H\u000b07H\u0000\u00a2\u0006\u0002\u0010q\u001a\f\u0010r\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a!\u0010s\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020t*\b\u0012\u0004\u0012\u0002H\u000b0\u001aH\u0001\u00a2\u0006\u0002\u0010u\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"*\u0010\n\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0\f8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006v"}, d2={"CAMEL_REGEX", "Lkotlin/text/Regex;", "getCAMEL_REGEX", "()Lkotlin/text/Regex;", "DELIMITED_STRING_REGEX", "getDELIMITED_STRING_REGEX", "DELIMITERS", "", "DELIMITERS_REGEX", "getDELIMITERS_REGEX", "columnName", "T", "Lkotlin/reflect/KProperty;", "getColumnName$annotations", "(Lkotlin/reflect/KProperty;)V", "getColumnName", "(Lkotlin/reflect/KProperty;)Ljava/lang/String;", "catchSilent", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "convert", "", "src", "", "tartypeOf", "Lkotlin/reflect/KClass;", "(ILkotlin/reflect/KClass;)Ljava/lang/Object;", "emptyPath", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "headPlusArray", "", "C", "head", "cols", "(Ljava/lang/Object;[Ljava/lang/Object;)[Ljava/lang/Object;", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "headPlusIterable", "", "(Ljava/lang/Object;Ljava/lang/Iterable;)Ljava/lang/Iterable;", "and", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "it", "Lorg/jetbrains/kotlinx/dataframe/Predicate;", "other", "anyNull", "asList", "", "asNullable", "(Ljava/lang/Object;)Ljava/lang/Object;", "between", "", "left", "right", "includeBoundaries", "(Ljava/lang/Comparable;Ljava/lang/Comparable;Ljava/lang/Comparable;Z)Z", "cast", "(I)Ljava/lang/Object;", "commonType", "Lkotlin/reflect/KType;", "nullable", "upperBound", "useStar", "createStarProjectedType", "equalsByElement", "getColumnPaths", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "unresolvedColumnsPolicy", "Lorg/jetbrains/kotlinx/dataframe/columns/UnresolvedColumnsPolicy;", "selector", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "Lkotlin/ExtensionFunctionType;", "getColumnsImpl", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "getColumnsWithPaths", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "getTrueIndices", "indexOfMax", "Lkotlin/sequences/Sequence;", "indexOfMin", "isSubtypeWithNullabilityOf", "type", "joinToCamelCaseString", "last", "count", "removeAt", "index", "rollingHash", "splitByIndices", "startIndices", "toCamelCaseByDelimiters", "delimiters", "toIterable", "getNext", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Iterable;", "toSnakeCase", "zero", "", "(Lkotlin/reflect/KClass;)Ljava/lang/Number;", "core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlinx/dataframe/impl/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,342:1\n1747#2,3:343\n1747#2,3:346\n1549#2:349\n1620#2,3:350\n1549#2:353\n1620#2,3:354\n1726#2,3:357\n1549#2:360\n1620#2,3:361\n819#2:364\n847#2,2:365\n1549#2:367\n1620#2,3:368\n1549#2:371\n1620#2,3:372\n288#2,2:379\n1#3:375\n37#4,2:376\n20#5:378\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlinx/dataframe/impl/UtilsKt\n*L\n109#1:343,3\n147#1:346,3\n154#1:349\n154#1:350,3\n159#1:353\n159#1:354,3\n160#1:357,3\n166#1:360\n166#1:361,3\n167#1:364\n167#1:365,2\n196#1:367\n196#1:368,3\n206#1:371\n206#1:372,3\n341#1:379,2\n289#1:376,2\n341#1:378\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final String DELIMITERS = "[_\\s]";
    @NotNull
    private static final Regex DELIMITERS_REGEX = new Regex("[_\\s]");
    @NotNull
    private static final Regex DELIMITED_STRING_REGEX = new Regex(".+[_\\s].+");
    @NotNull
    private static final Regex CAMEL_REGEX = new Regex("(?<=[a-zA-Z])[A-Z]");

    @NotNull
    public static final <T> Function1<T, Boolean> and(@Nullable Function1<? super T, Boolean> $this$and, @NotNull Function1<? super T, Boolean> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return $this$and == null ? other : (Function1)new Function1<T, Boolean>($this$and, other){
            final /* synthetic */ Function1<T, Boolean> $this_and;
            final /* synthetic */ Function1<T, Boolean> $other;
            {
                this.$this_and = $receiver;
                this.$other = $other;
                super(1);
            }

            @NotNull
            public final Boolean invoke(T it) {
                return (Boolean)this.$this_and.invoke(it) != false && (Boolean)this.$other.invoke(it) != false;
            }
        };
    }

    @NotNull
    public static final <T> Iterable<T> toIterable(T $this$toIterable, @NotNull Function1<? super T, ? extends T> getNext) {
        Intrinsics.checkNotNullParameter(getNext, (String)"getNext");
        return new Iterable<T>(getNext, $this$toIterable){
            final /* synthetic */ Function1 $getNext$inlined;
            final /* synthetic */ Object $this_toIterable$inlined;
            {
                this.$getNext$inlined = function1;
                this.$this_toIterable$inlined = object;
            }

            @NotNull
            public Iterator<T> iterator() {
                boolean bl = false;
                return new Iterator<T>(this.$getNext$inlined, this.$this_toIterable$inlined){
                    @Nullable
                    private T current;
                    private boolean beforeStart;
                    @Nullable
                    private T next;
                    final /* synthetic */ Function1<T, T> $getNext;
                    final /* synthetic */ T $this_toIterable;
                    {
                        this.$getNext = $getNext;
                        this.$this_toIterable = $receiver;
                        this.beforeStart = true;
                    }

                    @Nullable
                    public final T getCurrent() {
                        return this.current;
                    }

                    public final void setCurrent(@Nullable T t) {
                        this.current = t;
                    }

                    public final boolean getBeforeStart() {
                        return this.beforeStart;
                    }

                    public final void setBeforeStart(boolean bl) {
                        this.beforeStart = bl;
                    }

                    @Nullable
                    public final T getNext() {
                        return this.next;
                    }

                    public final void setNext(@Nullable T t) {
                        this.next = t;
                    }

                    public boolean hasNext() {
                        if (this.beforeStart) {
                            return true;
                        }
                        if (this.next == null) {
                            T t = this.current;
                            Intrinsics.checkNotNull(t);
                            this.next = this.$getNext.invoke(t);
                        }
                        return this.next != null;
                    }

                    public T next() {
                        if (this.beforeStart) {
                            this.current = this.$this_toIterable;
                            this.beforeStart = false;
                            T t = this.current;
                            Intrinsics.checkNotNull(t);
                            return t;
                        }
                        Object object = this.next;
                        if (object == null) {
                            T t = this.current;
                            Intrinsics.checkNotNull(t);
                            object = this.$getNext.invoke(t);
                        }
                        this.current = object;
                        this.next = null;
                        T t = this.current;
                        Intrinsics.checkNotNull(t);
                        return t;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @NotNull
    public static final <T> List<T> removeAt(@NotNull List<? extends T> $this$removeAt, int index) {
        Intrinsics.checkNotNullParameter($this$removeAt, (String)"<this>");
        return CollectionsKt.plus((Collection)$this$removeAt.subList(0, index), (Iterable)$this$removeAt.subList(index + 1, $this$removeAt.size()));
    }

    public static final /* synthetic */ <T> T cast(int $this$cast) {
        boolean $i$f$cast = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return UtilsKt.convert($this$cast, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @NotNull
    public static final <T> T convert(int src, @NotNull KClass<T> tartypeOf) {
        Object object;
        Intrinsics.checkNotNullParameter(tartypeOf, (String)"tartypeOf");
        KClass<T> kClass = tartypeOf;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            object = (double)src;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = (long)src;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            object = Float.valueOf(src);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = BigDecimal.valueOf(src);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            Intrinsics.checkNotNull((Object)bigDecimal, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.impl.UtilsKt.convert");
            object = bigDecimal;
        } else {
            throw new NotImplementedError("Casting int to " + tartypeOf + " is not supported");
        }
        return (T)object;
    }

    @NotNull
    public static final List<Integer> getTrueIndices(@NotNull boolean[] $this$getTrueIndices) {
        Intrinsics.checkNotNullParameter((Object)$this$getTrueIndices, (String)"<this>");
        ArrayList<Integer> res2 = new ArrayList<Integer>($this$getTrueIndices.length);
        int n = $this$getTrueIndices.length;
        for (int i = 0; i < n; ++i) {
            if (!$this$getTrueIndices[i]) continue;
            res2.add(i);
        }
        return res2;
    }

    @NotNull
    public static final List<Integer> getTrueIndices(@NotNull List<Boolean> $this$getTrueIndices) {
        Intrinsics.checkNotNullParameter($this$getTrueIndices, (String)"<this>");
        ArrayList<Integer> res2 = new ArrayList<Integer>($this$getTrueIndices.size());
        int n = $this$getTrueIndices.size();
        for (int i = 0; i < n; ++i) {
            if (!$this$getTrueIndices.get(i).booleanValue()) continue;
            res2.add(i);
        }
        return res2;
    }

    public static final <T> boolean equalsByElement(@NotNull Iterable<? extends T> $this$equalsByElement, @NotNull Iterable<? extends T> other) {
        Intrinsics.checkNotNullParameter($this$equalsByElement, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Iterator<T> iterator1 = $this$equalsByElement.iterator();
        Iterator<T> iterator2 = other.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (Intrinsics.areEqual(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static final <T> int rollingHash(@NotNull Iterable<? extends T> $this$rollingHash) {
        Intrinsics.checkNotNullParameter($this$rollingHash, (String)"<this>");
        Iterator<T> i = $this$rollingHash.iterator();
        int hash = 0;
        while (i.hasNext()) {
            T t = i.next();
            hash = 31 * hash + (t != null ? t.hashCode() : 5);
        }
        return hash;
    }

    @NotNull
    public static final <T> List<T> asList(@NotNull Iterable<? extends T> $this$asList) {
        Intrinsics.checkNotNullParameter($this$asList, (String)"<this>");
        return $this$asList instanceof List ? (List)$this$asList : CollectionsKt.toList($this$asList);
    }

    @PublishedApi
    public static final <T> boolean anyNull(@NotNull Iterable<? extends T> $this$anyNull) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$anyNull, (String)"<this>");
            Iterable<T> $this$any$iv = $this$anyNull;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<T> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @PublishedApi
    @NotNull
    public static final ColumnPath emptyPath() {
        return new ColumnPath(CollectionsKt.emptyList());
    }

    @PublishedApi
    @NotNull
    public static final <T extends Number> T zero(@NotNull KClass<T> $this$zero) {
        Number number;
        Intrinsics.checkNotNullParameter($this$zero, (String)"<this>");
        KClass<T> kClass = $this$zero;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            number = 0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            number = (byte)0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            number = (short)0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            number = 0L;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            number = 0.0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            number = Float.valueOf(0.0f);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNull((Object)bigDecimal, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.impl.UtilsKt.zero");
            number = bigDecimal;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            BigInteger bigInteger = BigInteger.ZERO;
            Intrinsics.checkNotNull((Object)bigInteger, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.impl.UtilsKt.zero");
            number = bigInteger;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
            number = 0;
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return (T)number;
    }

    @Nullable
    public static final <T> T catchSilent(@NotNull Function0<? extends T> body) {
        Object object;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        try {
            object = body.invoke();
        }
        catch (Throwable _) {
            object = null;
        }
        return (T)object;
    }

    @NotNull
    public static final KType commonType(@NotNull Iterable<? extends KClass<?>> $this$commonType, boolean nullable, @Nullable KType upperBound) {
        Intrinsics.checkNotNullParameter($this$commonType, (String)"<this>");
        return TypeUtilsKt.createType((Iterable)TypeUtilsKt.commonParents($this$commonType), nullable, upperBound);
    }

    public static /* synthetic */ KType commonType$default(Iterable iterable, boolean bl, KType kType, int n, Object object) {
        if ((n & 2) != 0) {
            kType = null;
        }
        return UtilsKt.commonType(iterable, bl, kType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KType commonType(@NotNull Iterable<? extends KType> $this$commonType, boolean useStar) {
        KType kType;
        Object it;
        boolean bl;
        List distinct2;
        block17: {
            Intrinsics.checkNotNullParameter($this$commonType, (String)"<this>");
            distinct2 = CollectionsKt.distinct($this$commonType);
            Iterable $this$any$iv = distinct2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KType)element$iv;
                    boolean bl2 = false;
                    KType kType2 = it;
                    if (!(kType2 != null ? kType2.isMarkedNullable() : true)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        boolean nullable = bl;
        if (distinct2.isEmpty() || distinct2.contains(null)) {
            kType = KTypes.withNullability((KType)Reflection.typeOf(Object.class), (boolean)nullable);
        } else if (distinct2.size() == 1) {
            Object object = CollectionsKt.single((List)distinct2);
            Intrinsics.checkNotNull((Object)object);
            kType = (KType)object;
        } else {
            boolean bl3;
            List projections;
            KClass<?> kClass;
            Object object;
            block18: {
                KType it2;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = distinct2;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    KType kType3 = (KType)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl4 = false;
                    void v4 = it2;
                    Intrinsics.checkNotNull((Object)v4);
                    object.add(KTypesJvm.getJvmErasure((KType)v4));
                }
                KClass<?> kClass2 = TypeUtilsKt.commonParent((List)destination$iv$iv);
                if (kClass2 == null) {
                    return KTypes.withNullability((KType)Reflection.typeOf(Object.class), (boolean)nullable);
                }
                kClass = kClass2;
                $this$map$iv = distinct2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (KType)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl5 = false;
                    KType kType4 = it2;
                    Intrinsics.checkNotNull((Object)kType4);
                    object.add(TypeUtilsKt.replaceGenericTypeParametersWithUpperbound(TypeUtilsKt.projectUpTo(kType4, kClass)));
                }
                projections = (List)destination$iv$iv;
                Iterable $this$all$iv = projections;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KType it3 = (KType)element$iv;
                        boolean bl6 = false;
                        if (Intrinsics.areEqual((Object)KTypesJvm.getJvmErasure((KType)it3), kClass)) continue;
                        bl3 = false;
                        break block18;
                    }
                    bl3 = true;
                }
            }
            if (!bl3) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n = kClass.getTypeParameters().size();
            ArrayList arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                KType commonType;
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                KType it4;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void i2;
                int n2;
                int bl6 = n2 = i;
                object = arrayList;
                boolean bl7 = false;
                KTypeParameter typeParameter = (KTypeParameter)kClass.getTypeParameters().get((int)i2);
                Iterable bl5 = projections;
                boolean $i$f$map = false;
                void var16_28 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    KType kType5 = (KType)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl8 = false;
                    collection.add(((KTypeProjection)it4.getArguments().get((int)i2)).getType());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filterNot = false;
                $this$mapTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it4 = (KType)element$iv$iv;
                    boolean bl9 = false;
                    if (distinct2.contains(it4)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List projectionTypes = (List)destination$iv$iv;
                ((ArrayList)object).add(projectionTypes.isEmpty() && typeParameter.getVariance() == KVariance.IN ? (useStar ? KTypeProjection.Companion.getSTAR() : KTypeProjection.Companion.invariant(TypeUtilsKt.nothingType(false))) : (Intrinsics.areEqual((Object)(commonType = UtilsKt.commonType(projectionTypes, useStar)), (Object)Reflection.nullableTypeOf(Object.class)) && useStar ? KTypeProjection.Companion.getSTAR() : new KTypeProjection(typeParameter.getVariance(), commonType)));
            }
            List arguments2 = arrayList;
            kType = KClassifiers.createType$default((KClassifier)((KClassifier)kClass), (List)arguments2, (boolean)nullable, null, (int)4, null);
        }
        return kType;
    }

    public static /* synthetic */ KType commonType$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return UtilsKt.commonType(iterable, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> List<DataColumn<C>> getColumnsImpl(@NotNull DataFrame<? extends T> $this$getColumnsImpl, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getColumnsImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Iterable $this$map$iv = UtilsKt.getColumnsWithPaths($this$getColumnsImpl, unresolvedColumnsPolicy, selector);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnWithPath columnWithPath = (ColumnWithPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getData());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <T, C> List<ColumnWithPath<C>> getColumnsWithPaths(@NotNull DataFrame<? extends T> $this$getColumnsWithPaths, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        Intrinsics.checkNotNullParameter($this$getColumnsWithPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.resolve(ConstructorsKt.toColumnSet(selector), $this$getColumnsWithPaths, unresolvedColumnsPolicy);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> List<ColumnPath> getColumnPaths(@NotNull DataFrame<? extends T> $this$getColumnPaths, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getColumnPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Iterable $this$map$iv = UtilsKt.getColumnsWithPaths($this$getColumnPaths, unresolvedColumnsPolicy, selector);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnWithPath columnWithPath = (ColumnWithPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    public static final <C extends Comparable<? super C>> int indexOfMin(@NotNull Sequence<? extends C> $this$indexOfMin) {
        Intrinsics.checkNotNullParameter($this$indexOfMin, (String)"<this>");
        Iterator iterator2 = $this$indexOfMin.iterator();
        if (!iterator2.hasNext()) {
            return -1;
        }
        Comparable value = (Comparable)iterator2.next();
        int index = 0;
        while (value == null) {
            if (!iterator2.hasNext()) {
                return -1;
            }
            value = (Comparable)iterator2.next();
            ++index;
        }
        Comparable min2 = value;
        int minIndex = index;
        if (!iterator2.hasNext()) {
            return minIndex;
        }
        do {
            Comparable v = (Comparable)iterator2.next();
            ++index;
            if (v == null || min2.compareTo(v) <= 0) continue;
            min2 = v;
            minIndex = index;
        } while (iterator2.hasNext());
        return minIndex;
    }

    public static final <C extends Comparable<? super C>> int indexOfMax(@NotNull Sequence<? extends C> $this$indexOfMax) {
        Intrinsics.checkNotNullParameter($this$indexOfMax, (String)"<this>");
        Iterator iterator2 = $this$indexOfMax.iterator();
        if (!iterator2.hasNext()) {
            return -1;
        }
        Comparable value = (Comparable)iterator2.next();
        int index = 0;
        while (value == null) {
            if (!iterator2.hasNext()) {
                return -1;
            }
            value = (Comparable)iterator2.next();
            ++index;
        }
        Comparable max2 = value;
        int maxIndex = index;
        if (!iterator2.hasNext()) {
            return maxIndex;
        }
        do {
            Comparable v = (Comparable)iterator2.next();
            ++index;
            if (v == null || max2.compareTo(v) >= 0) continue;
            max2 = v;
            maxIndex = index;
        } while (iterator2.hasNext());
        return maxIndex;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KType createStarProjectedType(@NotNull KClass<?> $this$createStarProjectedType, boolean nullable) {
        Object object;
        Intrinsics.checkNotNullParameter($this$createStarProjectedType, (String)"<this>");
        if (Intrinsics.areEqual($this$createStarProjectedType, (Object)Reflection.getOrCreateKotlinClass(Void.class))) {
            object = TypeUtilsKt.nothingType(nullable);
        } else {
            void var2_2;
            KType it = KClassifiers.getStarProjectedType((KClassifier)((KClassifier)$this$createStarProjectedType));
            boolean bl = false;
            object = nullable ? KTypes.withNullability((KType)it, (boolean)true) : var2_2;
        }
        return object;
    }

    public static final boolean isSubtypeWithNullabilityOf(@NotNull KType $this$isSubtypeWithNullabilityOf, @NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeWithNullabilityOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return KTypes.isSubtypeOf((KType)$this$isSubtypeWithNullabilityOf, (KType)type) && (!$this$isSubtypeWithNullabilityOf.isMarkedNullable() || type.isMarkedNullable());
    }

    @PublishedApi
    @NotNull
    public static final byte[] headPlusArray(byte head, @NotNull byte[] cols2) {
        Intrinsics.checkNotNullParameter((Object)cols2, (String)"cols");
        byte[] byArray = new byte[]{head};
        return ArraysKt.plus((byte[])byArray, (byte[])cols2);
    }

    @PublishedApi
    @NotNull
    public static final short[] headPlusArray(short head, @NotNull short[] cols2) {
        Intrinsics.checkNotNullParameter((Object)cols2, (String)"cols");
        short[] sArray = new short[]{head};
        return ArraysKt.plus((short[])sArray, (short[])cols2);
    }

    @PublishedApi
    @NotNull
    public static final int[] headPlusArray(int head, @NotNull int[] cols2) {
        Intrinsics.checkNotNullParameter((Object)cols2, (String)"cols");
        int[] nArray = new int[]{head};
        return ArraysKt.plus((int[])nArray, (int[])cols2);
    }

    @PublishedApi
    @NotNull
    public static final long[] headPlusArray(long head, @NotNull long[] cols2) {
        Intrinsics.checkNotNullParameter((Object)cols2, (String)"cols");
        long[] lArray = new long[]{head};
        return ArraysKt.plus((long[])lArray, (long[])cols2);
    }

    @PublishedApi
    @NotNull
    public static final float[] headPlusArray(float head, @NotNull float[] cols2) {
        Intrinsics.checkNotNullParameter((Object)cols2, (String)"cols");
        float[] fArray = new float[]{head};
        return ArraysKt.plus((float[])fArray, (float[])cols2);
    }

    @PublishedApi
    @NotNull
    public static final double[] headPlusArray(double head, @NotNull double[] cols2) {
        Intrinsics.checkNotNullParameter((Object)cols2, (String)"cols");
        double[] dArray = new double[]{head};
        return ArraysKt.plus((double[])dArray, (double[])cols2);
    }

    @PublishedApi
    @NotNull
    public static final boolean[] headPlusArray(boolean head, @NotNull boolean[] cols2) {
        Intrinsics.checkNotNullParameter((Object)cols2, (String)"cols");
        boolean[] blArray = new boolean[]{head};
        return ArraysKt.plus((boolean[])blArray, (boolean[])cols2);
    }

    @PublishedApi
    @NotNull
    public static final char[] headPlusArray(char head, @NotNull char[] cols2) {
        Intrinsics.checkNotNullParameter((Object)cols2, (String)"cols");
        char[] cArray = new char[]{head};
        return ArraysKt.plus((char[])cArray, (char[])cols2);
    }

    @PublishedApi
    public static final /* synthetic */ <C> C[] headPlusArray(C head, C[] cols2) {
        Intrinsics.checkNotNullParameter(cols2, (String)"cols");
        boolean $i$f$headPlusArray = false;
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf(head), (Iterable)ArraysKt.toList((Object[])cols2));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"C?");
        return thisCollection$iv.toArray(new Object[0]);
    }

    @PublishedApi
    public static final /* synthetic */ <C> Iterable<C> headPlusIterable(C head, Iterable<? extends C> cols2) {
        Intrinsics.checkNotNullParameter(cols2, (String)"cols");
        boolean $i$f$headPlusIterable = false;
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(head), cols2);
    }

    @NotNull
    public static final <T> Sequence<DataFrame<T>> splitByIndices(@NotNull DataFrame<? extends T> $this$splitByIndices, @NotNull Sequence<Integer> startIndices2) {
        Intrinsics.checkNotNullParameter($this$splitByIndices, (String)"<this>");
        Intrinsics.checkNotNullParameter(startIndices2, (String)"startIndices");
        return SequencesKt.zipWithNext((Sequence)SequencesKt.plus(startIndices2, (Object)DataFrameKt.getNrow($this$splitByIndices)), (Function2)new Function2<Integer, Integer, DataFrame<? extends T>>($this$splitByIndices){
            final /* synthetic */ DataFrame<T> $this_splitByIndices;
            {
                this.$this_splitByIndices = $receiver;
                super(2);
            }

            @NotNull
            public final DataFrame<T> invoke(int start, int endExclusive) {
                return start == endExclusive ? CastKt.cast(DataFrame.Companion.empty$default(DataFrame.Companion, 0, 1, null)) : this.$this_splitByIndices.get(RangesKt.until((int)start, (int)endExclusive));
            }
        });
    }

    @NotNull
    public static final <T> Sequence<List<T>> splitByIndices(@NotNull List<? extends T> $this$splitByIndices, @NotNull Sequence<Integer> startIndices2) {
        Intrinsics.checkNotNullParameter($this$splitByIndices, (String)"<this>");
        Intrinsics.checkNotNullParameter(startIndices2, (String)"startIndices");
        return SequencesKt.zipWithNext((Sequence)SequencesKt.plus(startIndices2, (Object)$this$splitByIndices.size()), (Function2)new Function2<Integer, Integer, List<? extends T>>($this$splitByIndices){
            final /* synthetic */ List<T> $this_splitByIndices;
            {
                this.$this_splitByIndices = $receiver;
                super(2);
            }

            @NotNull
            public final List<T> invoke(int start, int endExclusive) {
                return this.$this_splitByIndices.subList(start, endExclusive);
            }
        });
    }

    @Nullable
    public static final <T> T asNullable(T $this$asNullable) {
        return $this$asNullable;
    }

    @NotNull
    public static final <T> List<T> last(@NotNull List<? extends T> $this$last, int count2) {
        Intrinsics.checkNotNullParameter($this$last, (String)"<this>");
        return $this$last.subList($this$last.size() - count2, $this$last.size());
    }

    public static final <T extends Comparable<? super T>> boolean between(@NotNull T $this$between, @NotNull T left, @NotNull T right, boolean includeBoundaries) {
        Intrinsics.checkNotNullParameter($this$between, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return includeBoundaries ? (0 <= $this$between.compareTo(left) ? $this$between.compareTo(right) <= 0 : false) : $this$between.compareTo(left) > 0 && $this$between.compareTo(right) < 0;
    }

    public static /* synthetic */ boolean between$default(Comparable comparable, Comparable comparable2, Comparable comparable3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilsKt.between(comparable, comparable2, comparable3, bl);
    }

    @NotNull
    public static final Regex getDELIMITERS_REGEX() {
        return DELIMITERS_REGEX;
    }

    @NotNull
    public static final Regex getDELIMITED_STRING_REGEX() {
        return DELIMITED_STRING_REGEX;
    }

    @NotNull
    public static final Regex getCAMEL_REGEX() {
        return CAMEL_REGEX;
    }

    @NotNull
    public static final String toCamelCaseByDelimiters(@NotNull String $this$toCamelCaseByDelimiters, @NotNull Regex delimiters) {
        Intrinsics.checkNotNullParameter((Object)$this$toCamelCaseByDelimiters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delimiters, (String)"delimiters");
        CharSequence charSequence = $this$toCamelCaseByDelimiters;
        int n = 0;
        return UtilsKt.joinToCamelCaseString(delimiters.split(charSequence, n));
    }

    @NotNull
    public static final String toSnakeCase(@NotNull String $this$toSnakeCase) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toSnakeCase, (String)"<this>");
        if (new Regex("[A-Z_]+").matches((CharSequence)$this$toSnakeCase)) {
            string = $this$toSnakeCase;
        } else {
            String string2 = StringsKt.replace$default((String)CAMEL_REGEX.replace((CharSequence)$this$toSnakeCase, (Function1)toSnakeCase.1.INSTANCE), (String)" ", (String)"_", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        }
        return string;
    }

    @NotNull
    public static final String joinToCamelCaseString(@NotNull List<String> $this$joinToCamelCaseString) {
        String string;
        Intrinsics.checkNotNullParameter($this$joinToCamelCaseString, (String)"<this>");
        String string2 = CollectionsKt.joinToString$default((Iterable)$this$joinToCamelCaseString, (CharSequence)"", null, null, (int)0, null, (Function1)joinToCamelCaseString.1.INSTANCE, (int)30, null);
        if (((CharSequence)string2).length() > 0) {
            char it = string2.charAt(0);
            boolean bl = false;
            char c = Character.toLowerCase(it);
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string3 = string4;
            string = c + string3;
        } else {
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final <T> String getColumnName(@NotNull KProperty<? extends T> $this$columnName) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter($this$columnName, (String)"<this>");
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)$this$columnName;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof ColumnName)) continue;
                v0 = element$iv$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (ColumnName)((Annotation)v0)) == null || (object = object.name()) == null) {
            object = $this$columnName.getName();
        }
        return object;
    }

    @PublishedApi
    public static /* synthetic */ void getColumnName$annotations(KProperty kProperty) {
    }
}

