/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.nodeJs.NodeChromeDebugProcess;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.heap.view.main.OpenSnapshotWorker;
import com.jetbrains.nodejs.run.profile.heap.view.main.SaveSnapshotDialog;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.wip.WipV8ProfilingHelper;
import org.jetbrains.wip.WipVm;

public class TakeHeapSnapshotAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(TakeHeapSnapshotAction.class);
    @NonNls
    public static final String SNAPSHOT = "snapshot";
    private final Project myProject;
    private final long myPort;
    @Nls
    private final String myConfigurationName;
    private volatile boolean myIsDisposed;
    private volatile boolean myIsInProgress;
    private volatile WipVm myWipVm;

    /*
     * WARNING - void declaration
     */
    public TakeHeapSnapshotAction(@NotNull Project project, long port, @Nls String string) {
        void configurationName;
        if (project == null) {
            TakeHeapSnapshotAction.$$$reportNull$$$0(0);
        }
        super(NodeJSBundle.message("node.js.v8.heap.take.snapshot.action.text", new Object[0]), NodeJSBundle.message("node.js.v8.heap.take.snapshot.action.description", new Object[0]), AllIcons.Actions.StartMemoryProfile);
        this.myProject = project;
        this.myPort = port;
        this.myConfigurationName = configurationName;
        this.myIsDisposed = false;
    }

    public void setDisposed() {
        this.myIsDisposed = true;
        this.myWipVm = null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            TakeHeapSnapshotAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TakeHeapSnapshotAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(!this.myIsDisposed && !this.myIsInProgress && (this.myPort != -1L || TakeHeapSnapshotAction.getNodeChromeDebugProcess(e) != null));
    }

    @Nullable
    private static NodeChromeDebugProcess getNodeChromeDebugProcess(AnActionEvent e) {
        XDebugSession session = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
        if (session == null) {
            return null;
        }
        NodeChromeDebugProcess process = (NodeChromeDebugProcess)ObjectUtils.tryCast((Object)session.getDebugProcess(), NodeChromeDebugProcess.class);
        return process == null || !process.canTakeHeapSnapshot() ? null : process;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        NodeChromeDebugProcess process;
        if (e == null) {
            TakeHeapSnapshotAction.$$$reportNull$$$0(3);
        }
        if ((process = TakeHeapSnapshotAction.getNodeChromeDebugProcess(e)) != null && process.canTakeHeapSnapshot() || this.myPort > 0L) {
            ApplicationManager.getApplication().invokeLater(() -> {
                FileSaverDescriptor descriptor = new FileSaverDescriptor(this.myConfigurationName, NodeJSBundle.message("label.select.location.to.save.v8.heap.snapshot.to", new Object[0]), "heapsnapshot");
                SaveSnapshotDialog dialog = new SaveSnapshotDialog(descriptor, this.myProject);
                VirtualFileWrapper wrapper = dialog.save(this.myProject.getBaseDir(), TakeHeapSnapshotAction.suggestFileName(this.myConfigurationName));
                if (wrapper == null) {
                    return;
                }
                if (!TakeHeapSnapshotAction.checkFilePath(this.myProject, wrapper)) {
                    return;
                }
                this.takeSnapshot(dialog.openCreatedSnapshot(), dialog.showHiddenData(), wrapper, process);
            });
        }
    }

    private void takeSnapshot(final boolean openSnapshot, final boolean showHiddenData, final @NotNull VirtualFileWrapper wrapper, final @Nullable NodeChromeDebugProcess process) {
        if (wrapper == null) {
            TakeHeapSnapshotAction.$$$reportNull$$$0(4);
        }
        this.myIsInProgress = true;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, NodeJSBundle.message("profile.heap.taking.snapshot.progress.title", new Object[0]), true, null){
            private boolean myErrorReported;
            {
                super(arg0, arg1, arg2, arg3);
                this.myErrorReported = false;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    this.initVm(process);
                    if (TakeHeapSnapshotAction.this.myWipVm == null) {
                        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.heap.taking_snapshot_failed.pass_inspect_brk.notification.content", new Object[0]), MessageType.ERROR).notify(this.myProject);
                        return;
                    }
                    String error = new WipV8ProfilingHelper(TakeHeapSnapshotAction.this.myWipVm).takeHeapSnapShot(wrapper.getFile());
                    if (!StringUtil.isEmptyOrSpaces((String)error)) {
                        this.myErrorReported = true;
                        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(error, MessageType.ERROR).notify(this.myProject);
                    }
                }
                catch (Exception e1) {
                    LOG.info((Throwable)e1);
                    this.myErrorReported = true;
                    NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.heap.taking_snapshot_failed_common.notification.content", e1.getMessage()), MessageType.ERROR).notify(this.myProject);
                }
            }

            public void onFinished() {
                TakeHeapSnapshotAction.this.myIsInProgress = false;
            }

            public void onSuccess() {
                if (!wrapper.getFile().exists() || wrapper.getVirtualFile() == null) {
                    if (!this.myErrorReported) {
                        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.heap.snapshot_not_saved.notification.content", new Object[0]), MessageType.ERROR).notify(this.myProject);
                    }
                    return;
                }
                NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.heap.snapshot_saved_to.notification.content", TakeHeapSnapshotAction.filePathText(wrapper)), MessageType.INFO).notify(this.myProject);
                if (openSnapshot) {
                    OpenSnapshotWorker.work(this.myProject, wrapper.getVirtualFile(), showHiddenData);
                }
            }

            private void initVm(@Nullable NodeChromeDebugProcess process2) throws ExecutionException {
                if (TakeHeapSnapshotAction.this.myWipVm != null) {
                    return;
                }
                if (process2 != null) {
                    TakeHeapSnapshotAction.this.myWipVm = process2.canTakeHeapSnapshot() ? (WipVm)process2.getConnection().getVm() : null;
                } else if (TakeHeapSnapshotAction.this.myPort > 0L) {
                    TakeHeapSnapshotAction.this.myWipVm = (WipVm)NodeCommandLineUtil.initRemoteVmConnectionSync((RemoteVmConnection)new WipRemoteVmConnection(), (int)((int)TakeHeapSnapshotAction.this.myPort));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/heap/TakeHeapSnapshotAction$1", "run"));
            }
        });
    }

    @NotNull
    private static String filePathText(VirtualFileWrapper wrapper) {
        File file = wrapper.getFile();
        String string = file.getName() + (String)(file.getParentFile() != null ? " (" + file.getParentFile().getAbsolutePath() + ")" : "");
        if (string == null) {
            TakeHeapSnapshotAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static String suggestFileName(String name) {
        String suggested = name.replace("\\", "/");
        if ((suggested = StringUtil.trimEnd((String)suggested, (String)"/")).isEmpty()) {
            return SNAPSHOT;
        }
        int idx = suggested.lastIndexOf(47);
        if (idx > 0 && (suggested = suggested.substring(idx + 1)).isEmpty()) {
            return SNAPSHOT;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < suggested.length(); ++i) {
            char c = suggested.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private static boolean checkFilePath(Project project, VirtualFileWrapper wrapper) {
        String message = null;
        try {
            if (wrapper.getFile().exists()) {
                return true;
            }
            if (wrapper.getFile().createNewFile()) {
                FileUtil.delete((File)wrapper.getFile());
                return true;
            }
        }
        catch (IOException e1) {
            message = e1.getMessage();
        }
        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.heap.cannot_create_file.notification.content", wrapper.getFile().getAbsolutePath(), StringUtil.notNullize((String)message)), MessageType.ERROR).notify(project);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/TakeHeapSnapshotAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/TakeHeapSnapshotAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filePathText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "takeSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

