/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.calculation.ReverseLinkIndexProcessor;
import com.jetbrains.nodejs.run.profile.heap.calculation.StringReverseIndexProcessor;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager;
import com.jetbrains.nodejs.run.profile.heap.data.LinkedByNameId;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ReverseIndexes
implements Closeable {
    private final ReverseLinkIndexProcessor myReverseLinkIndexProcessor;
    private final StringReverseIndexProcessor myReverseStringIndexProcessor;
    private final long myNodesCnt;

    /*
     * WARNING - void declaration
     */
    public ReverseIndexes(long nodesCnt, @NotNull IndexFiles<V8HeapIndexManager.Category> indexFiles, File file) throws IOException {
        void nodeIndex;
        if (indexFiles == null) {
            ReverseIndexes.$$$reportNull$$$0(0);
        }
        this.myNodesCnt = nodesCnt;
        this.myReverseLinkIndexProcessor = new ReverseLinkIndexProcessor(nodesCnt, indexFiles);
        this.myReverseStringIndexProcessor = new StringReverseIndexProcessor(indexFiles, (File)nodeIndex);
    }

    public void continueCalculation(@NotNull File edgeIndexFile, long numEdges) throws IOException {
        if (edgeIndexFile == null) {
            ReverseIndexes.$$$reportNull$$$0(1);
        }
        this.myReverseStringIndexProcessor.continueCalculation(edgeIndexFile, numEdges, this.myNodesCnt);
        this.myReverseStringIndexProcessor.close();
        this.myReverseLinkIndexProcessor.continueCalculation(edgeIndexFile, numEdges, this.myNodesCnt);
        this.myReverseLinkIndexProcessor.close();
    }

    public CloseableThrowableConsumer<V8HeapEntry, IOException> getNodesFirstStageCalculator() {
        return this.myReverseStringIndexProcessor.getNodesFirstStageCalculator();
    }

    public CloseableThrowableConsumer<V8HeapEdge, IOException> getEdgesFirstStageCalculator() {
        final CloseableThrowableConsumer<V8HeapEdge, IOException> edgeCalculator = this.myReverseLinkIndexProcessor.getFirstStageCalculator();
        final CloseableThrowableConsumer<V8HeapEdge, IOException> reverseStringCalculator = this.myReverseStringIndexProcessor.getFirstStageCalculator();
        return new CloseableThrowableConsumer<V8HeapEdge, IOException>(){

            @Override
            public void close() throws IOException {
                edgeCalculator.close();
                reverseStringCalculator.close();
            }

            public void consume(V8HeapEdge edge) throws IOException {
                edgeCalculator.consume(edge);
                reverseStringCalculator.consume(edge);
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.myReverseLinkIndexProcessor.close();
        this.myReverseStringIndexProcessor.close();
    }

    public void correctStringsSize(long cnt) {
        this.myReverseStringIndexProcessor.correctSize(cnt);
    }

    public LinksReaderFactory<LinkedByNameId> getReverseStringIndexProcessor() throws FileNotFoundException {
        return this.myReverseStringIndexProcessor.getLinksReaderFactory();
    }

    public LinksReaderFactory<V8HeapEdge> getReverseLinkIndexProcessor() throws FileNotFoundException {
        return this.myReverseLinkIndexProcessor.getLinksReaderFactory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeIndexFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/ReverseIndexes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "continueCalculation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

